import 'package:feelverapp/ui/home/home.dart';
import 'package:feelverapp/ui/menu/menu.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class ShopListDetail extends StatefulWidget {
  @override
  _ShopListDetailState createState() => _ShopListDetailState();
}

class _ShopListDetailState extends State<ShopListDetail> {
  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
      bottomNavigationBar: Container(
        color: Color.fromRGBO(69, 85, 79, 1),
        height: SizeConfig.getWidth(80),
        child: Row(
          children: <Widget>[
            Container(
              margin: EdgeInsets.only(left: SizeConfig.getPadding(16), top: 0),
              width: SizeConfig.getWidth(60),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_home.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
                      print("Pressed");
                      Navigator.push(
                        context,
                        MaterialPageRoute(builder: (context) => HomePage()),
                      );
                    },
                  ),
                  Text(
                    'หน้าแรก',
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(left: SizeConfig.getPadding(16), top: 0),
              width: SizeConfig.getWidth(100),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_list.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
//                      Navigator.push(
//                        context,
//                        MaterialPageRoute(builder: (context) => LoginPage()),
//                      );
                      print("Pressed");
                    },
                  ),
                  Text(
                    'การจองของฉัน',
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(left: SizeConfig.getPadding(16), top: 0),
              width: SizeConfig.getWidth(80),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_cart.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
//                      Navigator.push(
//                        context,
//                        MaterialPageRoute(builder: (context) => LoginPage()),
//                      );
                    },
                  ),
                  Text(
                    'รถเข็นของฉัน',
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  )
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(
                  left: SizeConfig.getPadding(16), top: 0, right: 0),
              width: SizeConfig.getWidth(60),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_nearme.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
//                      Navigator.push(
//                        context,
//                        MaterialPageRoute(builder: (context) => LoginPage()),
//                      );
                    },
                  ),
                  Text(
                    'ใกล้ฉัน',
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  )
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  _setupView() {
    return SingleChildScrollView(
      child: Column(
        children: <Widget>[
          Stack(
            children: <Widget>[
              Container(
                color: Color.fromRGBO(69, 85, 79, 1),
                height: SizeConfig.getHeight(200),
                width: MediaQuery.of(context).size.width,
              ),
              Positioned(
                top: SizeConfig.getPadding(50),
                left: SizeConfig.getPadding(
                    MediaQuery.of(context).size.width / 3.5),
                child: Container(
                  alignment: Alignment.topCenter,
                  child: Image.asset(
                    'assets/images/feelver_banner.png',
                    width: MediaQuery.of(context).size.width / 2.5,
                  ),
                ),
              ),
              Positioned(
                top: SizeConfig.getPadding(77),
                left: SizeConfig.getPadding(16),
                child: Container(
                  child: GestureDetector(
                    onTap: () {
                      showDialog(
                        context: context,
                        builder: (BuildContext context) {
                          return NavDrawer();
                        },
                      );
                    },
                    child: Image.asset(
                      'assets/images/ic_menu.png',
                      height: SizeConfig.getWidth(24),
                      width: SizeConfig.getWidth(30),
                      fit: BoxFit.cover,
                    ),
                  ),
                ),
              ),
              Positioned(
                top: SizeConfig.getPadding(77),
                right: SizeConfig.getPadding(60),
                child: Container(
                  child: Image.asset(
                    'assets/images/ic_noti.png',
                    height: SizeConfig.getWidth(30),
                    width: SizeConfig.getWidth(30),
                    fit: BoxFit.cover,
                  ),
                ),
              ),
              Positioned(
                top: SizeConfig.getPadding(77),
                right: SizeConfig.getPadding(20),
                child: InkWell(
//                onTap: () {
//                  Navigator.push(
//                    context,
//                    MaterialPageRoute(builder: (context) => LoginPage()),
//                  );
//                },
                  child: Container(
                    child: Image.asset(
                      'assets/images/ic_userimg.png',
                      height: SizeConfig.getWidth(30),
                      width: SizeConfig.getWidth(30),
                      fit: BoxFit.cover,
                    ),
                  ),
                ),
              ),
            ],
          ),
          Container(
            height: SizeConfig.getHeight(270),
            child: Stack(
              children: <Widget>[
                Image.network(
                  'https://image.freepik.com/free-photo/girl-massage-spa-salon_110955-422.jpg',
                  height: SizeConfig.getWidth(180),
                  width: MediaQuery.of(context).size.width,
                  fit: BoxFit.cover,
                ),
                Positioned(
                  right: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(16),
                  child: ImageIcon(
                    AssetImage('assets/images/ic_fav_list.png'),
                    color: Colors.white,
                    size: SizeConfig.getFontSize(30),
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(165),
                  child: Image.asset(
                    'assets/images/pin_list.png',
                    width: SizeConfig.getWidth(50),
                    height: SizeConfig.getWidth(50),
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(75),
                  top: SizeConfig.getPadding(190),
                  child: Text(
                    'Ivory Relax and Spa',
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(16),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ),
              ],
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                bottom: SizeConfig.getPadding(15)),
            alignment: Alignment.topLeft,
            child: Text(
              '4/18, 4/21 BTS Nana Exit4 Sukhumvit Soi 8 , KlongToey Bangkok, Thailand 10110',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.grey,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          Container(
            padding: EdgeInsets.only(
              left: SizeConfig.getPadding(20),
              right: SizeConfig.getPadding(20),
              top: SizeConfig.getPadding(20),
              bottom: SizeConfig.getPadding(20),
            ),
            height: SizeConfig.getHeight(1),
            width: MediaQuery.of(context).size.width - 40,
            color: Colors.grey,
          ),
          _dayOpen(),
          _rating(),
          _ratingMenu(),
          SizedBox(
            height: SizeConfig.getHeight(20),
          ),
          Container(
            padding: EdgeInsets.only(
              left: SizeConfig.getPadding(20),
              right: SizeConfig.getPadding(20),
              top: SizeConfig.getPadding(40),
              bottom: SizeConfig.getPadding(20),
            ),
            height: SizeConfig.getHeight(1),
            width: MediaQuery.of(context).size.width - 40,
            color: Colors.grey,
          ),
          SizedBox(
            height: SizeConfig.getHeight(20),
          ),
          _detail(),
        ],
      ),
    );
  }

  _dayOpen() {
    return Column(
      children: <Widget>[
        Container(
          padding: EdgeInsets.only(
            top: SizeConfig.getPadding(15),
            left: SizeConfig.getPadding(24),
            right: SizeConfig.getPadding(24),
            bottom: SizeConfig.getPadding(5),
          ),
          alignment: Alignment.topLeft,
          child: Text(
            'วันเปิดปิดทำการ',
            textAlign: TextAlign.left,
            style: TextStyle(
                color: Colors.black87,
                fontSize: SizeConfig.getFontSize(16),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w700),
          ),
        ),
        Container(
          padding: EdgeInsets.only(
            top: SizeConfig.getPadding(0),
            left: SizeConfig.getPadding(24),
            right: SizeConfig.getPadding(24),
            bottom: SizeConfig.getPadding(5),
          ),
          alignment: Alignment.topLeft,
          child: Text(
            'จันทร์ 10:00 AM - 10:00 PM',
            textAlign: TextAlign.left,
            style: TextStyle(
                color: Colors.black54,
                fontSize: SizeConfig.getFontSize(12),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w500),
          ),
        ),
        Container(
          padding: EdgeInsets.only(
            top: SizeConfig.getPadding(0),
            left: SizeConfig.getPadding(24),
            right: SizeConfig.getPadding(24),
            bottom: SizeConfig.getPadding(5),
          ),
          alignment: Alignment.topLeft,
          child: Text(
            'อังคาร 10:00 AM - 10:00 PM',
            textAlign: TextAlign.left,
            style: TextStyle(
                color: Colors.black54,
                fontSize: SizeConfig.getFontSize(12),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w500),
          ),
        ),
        Container(
          padding: EdgeInsets.only(
            top: SizeConfig.getPadding(0),
            left: SizeConfig.getPadding(24),
            right: SizeConfig.getPadding(24),
            bottom: SizeConfig.getPadding(5),
          ),
          alignment: Alignment.topLeft,
          child: Text(
            'พุธ 10:00 AM - 10:00 PM',
            textAlign: TextAlign.left,
            style: TextStyle(
                color: Colors.black54,
                fontSize: SizeConfig.getFontSize(12),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w500),
          ),
        ),
        Container(
          padding: EdgeInsets.only(
            top: SizeConfig.getPadding(0),
            left: SizeConfig.getPadding(24),
            right: SizeConfig.getPadding(24),
            bottom: SizeConfig.getPadding(5),
          ),
          alignment: Alignment.topLeft,
          child: Text(
            'พฤหัสบดี 10:00 AM - 10:00 PM',
            textAlign: TextAlign.left,
            style: TextStyle(
                color: Colors.black54,
                fontSize: SizeConfig.getFontSize(12),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w500),
          ),
        ),
        Container(
          padding: EdgeInsets.only(
            top: SizeConfig.getPadding(0),
            left: SizeConfig.getPadding(24),
            right: SizeConfig.getPadding(24),
            bottom: SizeConfig.getPadding(5),
          ),
          alignment: Alignment.topLeft,
          child: Text(
            'ศุกร์ 10:00 AM - 10:00 PM',
            textAlign: TextAlign.left,
            style: TextStyle(
                color: Colors.black54,
                fontSize: SizeConfig.getFontSize(12),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w500),
          ),
        ),
        Container(
          padding: EdgeInsets.only(
            top: SizeConfig.getPadding(0),
            left: SizeConfig.getPadding(24),
            right: SizeConfig.getPadding(24),
            bottom: SizeConfig.getPadding(5),
          ),
          alignment: Alignment.topLeft,
          child: Text(
            'เสาร์ 10:00 AM - 10:00 PM',
            textAlign: TextAlign.left,
            style: TextStyle(
                color: Colors.black54,
                fontSize: SizeConfig.getFontSize(12),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w500),
          ),
        ),
        Container(
          padding: EdgeInsets.only(
            top: SizeConfig.getPadding(0),
            left: SizeConfig.getPadding(24),
            right: SizeConfig.getPadding(24),
            bottom: SizeConfig.getPadding(20),
          ),
          alignment: Alignment.topLeft,
          child: Text(
            'อาทิตย์ 10:00 AM - 10:00 PM',
            textAlign: TextAlign.left,
            style: TextStyle(
                color: Colors.black54,
                fontSize: SizeConfig.getFontSize(12),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w500),
          ),
        ),
        Container(
          padding: EdgeInsets.only(
            left: SizeConfig.getPadding(20),
            right: SizeConfig.getPadding(20),
            top: SizeConfig.getPadding(40),
            bottom: SizeConfig.getPadding(20),
          ),
          height: SizeConfig.getHeight(1),
          width: MediaQuery.of(context).size.width - 40,
          color: Colors.grey,
        ),
      ],
    );
  }

  _rating() {
    return Container(
      height: SizeConfig.getHeight(100),
      child: Stack(
        children: <Widget>[
          Container(
            padding: EdgeInsets.only(
              top: SizeConfig.getPadding(15),
              left: SizeConfig.getPadding(24),
              bottom: SizeConfig.getPadding(5),
            ),
            alignment: Alignment.topLeft,
            child: Text(
              'คะแนนร้านค้าและการรีวิว',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black87,
                  fontSize: SizeConfig.getFontSize(16),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
          Positioned(
            right: SizeConfig.getPadding(15),
            top: SizeConfig.getPadding(20),
            child: Text(
              'ดูทั้งหมด',
              textAlign: TextAlign.right,
              style: TextStyle(
                  decoration: TextDecoration.underline,
                  color: Colors.black54,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(53),
            left: SizeConfig.getPadding(20),
            child: Image.asset(
              'assets/images/ic_star_active.png',
              width: SizeConfig.getWidth(16),
              height: SizeConfig.getWidth(16),
            ),
          ),
          Positioned(
            left: SizeConfig.getPadding(45),
            top: SizeConfig.getPadding(50),
            child: Text(
              '4.9',
              textAlign: TextAlign.right,
              style: TextStyle(
                  decoration: TextDecoration.underline,
                  color: Colors.black87,
                  fontSize: SizeConfig.getFontSize(16),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
          Positioned(
            left: SizeConfig.getPadding(80),
            top: SizeConfig.getPadding(52),
            child: Text(
              '267 รีวิว',
              textAlign: TextAlign.right,
              style: TextStyle(
//                  decoration: TextDecoration.underline,
                  color: Colors.black54,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          Positioned(
            right: SizeConfig.getPadding(20),
            top: SizeConfig.getPadding(52),
            child: Text(
              '',
              textAlign: TextAlign.right,
              style: TextStyle(
//                  decoration: TextDecoration.underline,
                  color: Colors.black87,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
        ],
      ),
    );
  }

  _ratingMenu() {
    final List<String> entries = <String>[
      'assets/images/ic_flower.png',
      'assets/images/ic_homee.png',
      'assets/images/ic_tagservice.png',
      'assets/images/ic_cash.png'
    ];
    final List<String> title = <String>[
      'บรรยากาศ',
      'ความสะอาด',
      'บริการ',
      'ความคุ้มค่า'
    ];
    return Container(
      height: 80,
      child: GridView.count(
        crossAxisCount: 4,
        physics: const NeverScrollableScrollPhysics(),
        children: List.generate(
          entries.length,
          (index) {
            return Center(
              child: Column(
                children: <Widget>[
                  Image.asset(
                    entries[index],
                    width: SizeConfig.getWidth(24),
                    height: SizeConfig.getWidth(24),
                  ),
                  SizedBox(
                    height: 10,
                  ),
                  Text(
                    title[index],
                    textAlign: TextAlign.right,
                    style: TextStyle(
//                  decoration: TextDecoration.underline,
                        color: Colors.black54,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  )
                ],
              ),
            );
          },
        ),
      ),
    );
  }

  _detail() {
    return Column(
      children: <Widget>[
        Container(
          alignment: Alignment.topLeft,
          padding: EdgeInsets.only(
            left: SizeConfig.getPadding(20),
          ),
          child: Text(
            'ข้อมูลร้านค้า',
            textAlign: TextAlign.left,
            style: TextStyle(
//                  decoration: TextDecoration.underline,
                color: Colors.black87,
                fontSize: SizeConfig.getFontSize(16),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w700),
          ),
        ),
        Container(
          alignment: Alignment.topLeft,
          padding: EdgeInsets.only(
            left: SizeConfig.getPadding(20),
            right: SizeConfig.getPadding(20),
            top: SizeConfig.getPadding(10),
          ),
          child: Text(
            'ไม่ว่าคุณจะมาเยี่ยมเยียนเมืองเพลิดเพลินไปกับการพักผ่อนหรือคุณเป็นคนกรุงเทพฯตลอดไปสปาธรรมชาติของเราเป็นทางเลือกที่สมบูรณ์แบบหากคุณกำลังมองหาการผ่อนคลายความรู้สึกทั้งหมดในขณะที่เราปรนเปรอคุณด้วยสปาธรรมชาติ 100% และ ผลิตภัณฑ์สปาออร์แกนิก ทุกสิ่งที่คุณสัมผัสกลิ่นความรู้สึกการได้ยินและประสบการณ์นั้นเป็นเรื่องจริงและเป็นธรรมชาติอย่างที่ได้รับการเดินทางครั้งใหญ่จากความเร่งรีบและวุ่นวายของกรุงเทพฯที่วุ่นวายและความวุ่นวายของชีวิตสมัยใหม่! ด้วยเสียงมลภาวะความวุ่นวายและสารเคมีที่กลายเป็นบรรทัดฐานในการใช้ชีวิตในเมืองข้อเสนอของสปาของเราจึงเป็นสิ่งที่ต้องการ ดังนั้นอย่าลืมที่จะได้รับ Plant Day Spa อันสดใหม่ของคุณ',
            textAlign: TextAlign.left,
            style: TextStyle(
//                  decoration: TextDecoration.underline,
                color: Colors.black54,
                fontSize: SizeConfig.getFontSize(14),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w500),
          ),
        ),
        SizedBox(
          height: SizeConfig.getHeight(20),
        ),
        Container(
          padding: EdgeInsets.only(
            left: SizeConfig.getPadding(20),
            right: SizeConfig.getPadding(20),
            top: SizeConfig.getPadding(40),
            bottom: SizeConfig.getPadding(20),
          ),
          height: SizeConfig.getHeight(1),
          width: MediaQuery.of(context).size.width - 40,
          color: Colors.grey,
        ),
      ],
    );
  }

  _getlist() {
    final List<String> entries = <String>[
      'Ivory Relax and Spa',
      'Sunshine Spa & Massage',
      'Mandarin Ginger Spa'
    ];
    return Expanded(
      child: Container(
        padding: EdgeInsets.only(
          top: SizeConfig.getPadding(16),
          left: SizeConfig.getPadding(16),
          right: SizeConfig.getPadding(16),
          bottom: SizeConfig.getPadding(10),
        ),
        child: ListView.builder(
          itemCount: entries.length,
          itemBuilder: (context, i) {
            return _shopItem(entries[i]);
          },
        ),
      ),
    );
  }

  Widget _shopItem(String title) {
    return Card(
      child: Column(
        children: <Widget>[
          Container(
            height: SizeConfig.getHeight(270),
            child: Stack(
              children: <Widget>[
                Image.network(
                  'https://image.freepik.com/free-photo/girl-massage-spa-salon_110955-422.jpg',
                  height: SizeConfig.getWidth(180),
                  width: MediaQuery.of(context).size.width,
                  fit: BoxFit.cover,
                ),
                Positioned(
                  right: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(16),
                  child: ImageIcon(
                    AssetImage('assets/images/ic_fav_list.png'),
                    color: Colors.white,
                    size: SizeConfig.getFontSize(30),
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(165),
                  child: Image.asset(
                    'assets/images/pin_list.png',
                    width: SizeConfig.getWidth(50),
                    height: SizeConfig.getWidth(50),
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(75),
                  top: SizeConfig.getPadding(190),
                  child: Text(
                    title,
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ),
              ],
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24)),
            alignment: Alignment.topLeft,
            child: Text(
              '4/18, 4/21 BTS Nana Exit4 Sukhumvit Soi 8 , KlongToey Bangkok, Thailand 10110',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.grey,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                top: SizeConfig.getPadding(10),
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                bottom: SizeConfig.getPadding(10)),
            alignment: Alignment.topLeft,
            child: Text(
              'Body Scrub',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
          Row(
            children: <Widget>[
              SizedBox(
                width: SizeConfig.getWidth(20),
              ),
              Image.asset(
                'assets/images/clock.png',
                width: SizeConfig.getWidth(20),
                height: SizeConfig.getWidth(20),
              ),
              SizedBox(
                width: SizeConfig.getWidth(10),
              ),
              Text(
                '90 นาที',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Colors.black87,
                    fontSize: SizeConfig.getFontSize(12),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
              SizedBox(
                width: SizeConfig.getWidth(30),
              ),
              Image.asset(
                'assets/images/sell.png',
                width: SizeConfig.getWidth(20),
                height: SizeConfig.getWidth(20),
              ),
              SizedBox(
                width: SizeConfig.getWidth(5),
              ),
              Text(
                '฿1,599.00 ',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Color.fromRGBO(238, 175, 183, 1),
                    fontSize: SizeConfig.getFontSize(12),
                    decoration: TextDecoration.lineThrough,
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
              SizedBox(
                width: SizeConfig.getWidth(5),
              ),
              Text(
                '฿1,599.00 ',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Color.fromRGBO(253, 41, 86, 1),
                    fontSize: SizeConfig.getFontSize(22),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w700),
              ),
            ],
          ),
          InkWell(
            onTap: () {
              Navigator.push(
                context,
                MaterialPageRoute(
                  builder: (context) => ShopListDetail(),
                ),
              );
            },
            child: Stack(
              children: <Widget>[
                Container(
                  child: Image.asset('assets/images/btn_shoplist.png'),
                  padding: EdgeInsets.only(
                    left: SizeConfig.getPadding(20),
                    right: SizeConfig.getPadding(20),
                    top: SizeConfig.getPadding(20),
                    bottom: SizeConfig.getPadding(20),
                  ),
                ),
                Container(
                  alignment: Alignment.center,
                  child: Text(
                    'หยิบใส่รถเข็น',
                    textAlign: TextAlign.center,
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(14),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                  padding: EdgeInsets.only(
                    left: SizeConfig.getPadding(60),
                    right: SizeConfig.getPadding(20),
                    top: SizeConfig.getPadding(30),
                    bottom: SizeConfig.getPadding(20),
                  ),
                )
              ],
            ),
          )
        ],
      ),
    );
  }}