import 'package:feelverapp/ui/booking/bookingflow.dart';
import 'package:feelverapp/ui/home/home.dart';
import 'package:feelverapp/ui/reserve/reserve_date_time.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class ReserveList extends StatefulWidget {
  @override
  _ReserveListState createState() => _ReserveListState();
}

class _ReserveListState extends State<ReserveList> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: _setupView(),
      bottomNavigationBar: Container(
        height: SizeConfig.getHeight(100),
        color: Color.fromRGBO(106, 179, 170, 1),
        child: Stack(
          children: <Widget>[
            Positioned(
              top: SizeConfig.getPadding(24),
              left: SizeConfig.getPadding(20),
              child: Container(
//                color: Colors.red,
                width: MediaQuery.of(context).size.width / 2.5,
                height: SizeConfig.getHeight(45),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(24),
                  color: Color.fromRGBO(54, 148, 163, 1),
                ),
                child: Container(
                  padding: EdgeInsets.only(top: SizeConfig.getPadding(6)),
                  child: Text(
                    'หยิบใส่รถเข็น',
                    textAlign: TextAlign.center,
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(14),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                ),
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(20),
              child: InkWell(
                onTap: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                      builder: (context) => BookingFlow(),
                    ),
                  );
                },
                child: Container(
//                color: Colors.red,
                  width: MediaQuery.of(context).size.width / 2.5,
                  height: SizeConfig.getHeight(45),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(24),
                    color: Color.fromRGBO(232, 166, 180, 1),
                  ),
                  child: Container(
                    padding: EdgeInsets.only(top: SizeConfig.getPadding(6)),
                    child: Text(
                      'จองเลย',
                      textAlign: TextAlign.center,
                      style: TextStyle(
                          color: Colors.white,
                          fontSize: SizeConfig.getFontSize(14),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),
                    ),
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  _setupView() {
    return SingleChildScrollView(
      child: Column(
        children: <Widget>[
          Stack(
            children: <Widget>[
              Image.network(
                'https://www.cancurreu.com/wp-content/uploads/can_curreu_hotel_ibiza_spa_tratamientos.jpg',
                width: MediaQuery.of(context).size.width,
                fit: BoxFit.cover,
              ),
              Positioned(
                top: SizeConfig.getPadding(44),
                left: SizeConfig.getPadding(16),
                child: InkWell(
                  onTap: () {
                    Navigator.pop(context);
                  },
                  child: Image.asset(
                    'assets/images/ic_back.png',
                    width: SizeConfig.getWidth(20),
                    height: SizeConfig.getWidth(20),
                  ),
                ),
              )
            ],
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(16)),
            alignment: Alignment.topLeft,
            child: Text(
              'คุณกำลังจอง',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Color.fromRGBO(106, 179, 170, 1),
                  fontSize: SizeConfig.getFontSize(14),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(3),
                bottom: SizeConfig.getPadding(8)),
            alignment: Alignment.topLeft,
            child: Text(
              'Thai Body',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black,
                  fontSize: SizeConfig.getFontSize(26),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
          Row(
            children: <Widget>[
              SizedBox(
                width: SizeConfig.getWidth(20),
              ),
              Image.asset(
                'assets/images/clock.png',
                width: SizeConfig.getWidth(20),
                height: SizeConfig.getWidth(20),
              ),
              SizedBox(
                width: SizeConfig.getWidth(10),
              ),
              Text(
                '90 นาที',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Colors.black87,
                    fontSize: SizeConfig.getFontSize(12),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ],
          ),
          SizedBox(
            height: 8,
          ),
          Row(
            children: <Widget>[
              SizedBox(
                width: SizeConfig.getWidth(22),
              ),
              Text(
                '฿599.00',
                textAlign: TextAlign.left,
                style: TextStyle(
                    decoration: TextDecoration.lineThrough,
                    color: Colors.black54,
                    fontSize: SizeConfig.getFontSize(12),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
              SizedBox(
                width: SizeConfig.getWidth(5),
              ),
              Text(
                '฿1,599.00 ',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Color.fromRGBO(253, 41, 86, 1),
                    fontSize: SizeConfig.getFontSize(22),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w700),
              ),
            ],
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(8),
                bottom: SizeConfig.getPadding(8)),
            alignment: Alignment.topLeft,
            child: Text(
              'เลือกพนักงานบริการ ที่คุณต้องการหากไม่ต้องการระบุพนักงานบริการให้กดที่ปุ่มถัดไป ',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black54,
                  fontSize: SizeConfig.getFontSize(14),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          _ratingMenu(),
        ],
      ),
    );
  }

  _ratingMenu() {
    final List<String> entries = <String>[
      'assets/images/ic_flower.png',
      'assets/images/ic_homee.png',
      'assets/images/ic_tagservice.png',
      'assets/images/ic_cash.png'
    ];
    final List<String> title = <String>[
      'อพินญา วงวาลัย',
      'อพินญา วงวาลัย',
      'อพินญา วงวาลัย',
      'อพินญา วงวาลัย'
    ];
    return Container(
      height: MediaQuery.of(context).size.height / 2,
      child: GridView.count(
        crossAxisCount: 3,
        physics: const NeverScrollableScrollPhysics(),
        children: List.generate(
          entries.length,
          (index) {
            return Column(
              children: <Widget>[
                ClipRRect(
                  borderRadius: BorderRadius.circular(50),
                  child: Image.network(
                    'https://scontent.fbkk7-2.fna.fbcdn.net/v/t1.0-9/104204530_3370427592977187_6031309814586327212_o.jpg?_nc_cat=106&_nc_sid=110474&_nc_eui2=AeE2vpoR5NHZLbG8b3YABiSdSsMCoPYM3W1KwwKg9gzdbZuYqR1gPnkW3tGe-TS2Vtphdvn2OuvO2CdDLaCMVvcI&_nc_ohc=T5EK3sWOgtAAX994m4I&_nc_ht=scontent.fbkk7-2.fna&oh=0b3e434546b19e256c07ecd6a4d499fb&oe=5F098A94',
                    width: 85.0,
                    height: 85.0,
                    fit: BoxFit.cover,
                  ),
                ),
                SizedBox(
                  height: 8,
                ),
                Text(
                  title[index],
                  textAlign: TextAlign.center,
                  style: TextStyle(
                      color: Colors.black87,
                      fontSize: SizeConfig.getFontSize(15),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                )
              ],
            );
          },
        ),
      ),
    );
  }
}
