import 'package:feelverapp/ui/login/login.dart';
import 'package:feelverapp/ui/menu/menu.dart';
import 'package:feelverapp/ui/nearme/near_me_list.dart';
import 'package:feelverapp/ui/reserve/reserve_list.dart';
import 'package:feelverapp/ui/shop/shop_list.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class HomePage extends StatefulWidget {
  @override
  _HomePageState createState() => _HomePageState();
}

class _HomePageState extends State<HomePage> {

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
      bottomNavigationBar: Container(
        color: Color.fromRGBO(69, 85, 79, 1),
        height: SizeConfig.getWidth(80),
        child: Row(
          children: <Widget>[
            Container(
              margin: EdgeInsets.only(left: SizeConfig.getPadding(16), top: 0),
              width: SizeConfig.getWidth(60),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_home.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
                      print("Pressed");
                    },
                  ),
                  Text(
                    'หน้าแรก',
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(left: SizeConfig.getPadding(16), top: 0),
              width: SizeConfig.getWidth(100),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_list.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
                      Navigator.push(
                        context,
                        MaterialPageRoute(builder: (context) => ReserveList()),
                      );
                      print("Pressed");
                    },
                  ),
                  Text(
                    'การจองของฉัน',
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(left: SizeConfig.getPadding(16), top: 0),
              width: SizeConfig.getWidth(80),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_cart.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
//                      Navigator.push(
//                        context,
//                        MaterialPageRoute(builder: (context) => LoginPage()),
//                      );
                    },
                  ),
                  Text(
                    'รถเข็นของฉัน',
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  )
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(
                  left: SizeConfig.getPadding(16), top: 0, right: 0),
              width: SizeConfig.getWidth(60),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_nearme.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
//                      Navigator.push(
//                        context,
//                        MaterialPageRoute(builder: (context) => LoginPage()),
//                      );
                    },
                  ),
                  Text(
                    'ใกล้ฉัน',
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  )
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  _setupView() {
    return Column(
      children: <Widget>[
        Stack(
          children: <Widget>[
            Container(
              child: Image.asset(
                'assets/images/banner_top.png',
                height: SizeConfig.getHeight(200),
                width: MediaQuery.of(context).size.width,
                fit: BoxFit.cover,
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(77),
              left: SizeConfig.getPadding(16),
              child: Container(
                child: GestureDetector(
                  onTap: () {
                    showDialog(
                        context: context,
                        builder: (BuildContext context) {
                          return NavDrawer();
                        });
                  },
                  child: Image.asset(
                    'assets/images/ic_menu.png',
                    height: SizeConfig.getWidth(24),
                    width: SizeConfig.getWidth(30),
                    fit: BoxFit.cover,
                  ),
                ),
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(77),
              right: SizeConfig.getPadding(60),
              child: Container(
                child: Image.asset(
                  'assets/images/ic_noti.png',
                  height: SizeConfig.getWidth(30),
                  width: SizeConfig.getWidth(30),
                  fit: BoxFit.cover,
                ),
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(77),
              right: SizeConfig.getPadding(20),
              child: InkWell(
                onTap: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(builder: (context) => LoginPage()),
                    );
                },
                child: Container(
                  child: Image.asset(
                    'assets/images/ic_userimg.png',
                    height: SizeConfig.getWidth(30),
                    width: SizeConfig.getWidth(30),
                    fit: BoxFit.cover,
                  ),
                ),
              ),
            ),
            _searchField(),
          ],
        ),
        Expanded(
          child: SingleChildScrollView(
            child: _listView(),
          ),
        ),
      ],
    );
  }

  _listView() {
    return Column(
      children: <Widget>[
        _listItem(
            Image.asset(
              'assets/images/banner_spa.png',
              height: SizeConfig.getWidth(130),
              width: MediaQuery.of(context).size.width,
              fit: BoxFit.fill,
            ),
            'SPA',
            '99 View',NearmeList()),
        _listItem(
            Image.asset(
              'assets/images/banner_massage.png',
              height: SizeConfig.getWidth(130),
              width: MediaQuery.of(context).size.width,
              fit: BoxFit.fill,
            ),
            'Massage',
            '99 View',NearmeList()),
        _listItem(
            Image.asset(
              'assets/images/banner_beauty.png',
              height: SizeConfig.getWidth(130),
              width: MediaQuery.of(context).size.width,
              fit: BoxFit.fill,
            ),
            'BEAUTY',
            '99 View',NearmeList()),
        _listItem(
            Image.asset(
              'assets/images/banner_nearme.png',
              height: SizeConfig.getWidth(130),
              width: MediaQuery.of(context).size.width,
              fit: BoxFit.fill,
            ),
            'NEAR ME',
            '99 View',NearmeList()),
        _listItem(
            Image.asset(
              'assets/images/banner_promotion.png',
              height: SizeConfig.getWidth(130),
              width: MediaQuery.of(context).size.width,
              fit: BoxFit.fill,
            ),
            'PROMOTION',
            '99 View',NearmeList()),
        _listItem(
            Image.asset(
              'assets/images/banner_mostpopular.png',
              height: SizeConfig.getWidth(130),
              width: MediaQuery.of(context).size.width,
              fit: BoxFit.fill,
            ),
            'MOST POPULAR',
            '99 Vidw',NearmeList()),
        _listItem(
            Image.asset(
              'assets/images/banner_recommended.png',
              height: SizeConfig.getWidth(130),
              width: MediaQuery.of(context).size.width,
              fit: BoxFit.fill,
            ),
            'RECOMMEND',
            '99 View',NearmeList()),
        SizedBox(
          height: 30,
        ),
      ],
    );
  }

  Widget _listItem(Image img, String title, String view, Widget page) {
    return GestureDetector(
      onTap: () {
        Navigator.push(
          context,
          MaterialPageRoute(
            builder: (context) => page,
          ),
        );
      },
      child: Container(
        margin: EdgeInsets.all(
          SizeConfig.getPadding(24),
        ),
        width: MediaQuery.of(context).size.width,
        child: Stack(
          children: <Widget>[
            Container(
              width: MediaQuery.of(context).size.width,
              child: img,
            ),
            Container(
              alignment: Alignment.center,
              padding: EdgeInsets.only(
                top: SizeConfig.getPadding(40),
              ),
              child: Text(
                title,
                style: TextStyle(
                  color: Colors.white,
                  fontSize: SizeConfig.getFontSize(30),
                  fontWeight: FontWeight.w600,
                ),
              ),
            ),
            Container(
              alignment: Alignment.center,
              padding: EdgeInsets.only(
                top: SizeConfig.getPadding(75),
              ),
              child: Text(
                view,
                style: TextStyle(
                  color: Colors.white,
                  fontSize: SizeConfig.getFontSize(20),
                  fontWeight: FontWeight.w500,
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  _searchField() {
    return Container(
      margin: EdgeInsets.only(
        top: 135,
        left: 24,
        right: 24,
      ),
      height: 55,
      child: TextField(
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(30.0),
              ),
            ),
            prefixIcon: IconButton(
                    onPressed: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(builder: (context) => ShopList()),
                  );
                },
                icon: Icon(Icons.search, color: Colors.grey)),
            filled: true,
            hintText: 'ค้นหาแบบละเอียด',
            fillColor: Colors.white),
      ),
    );
  }
}
