import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class BookingFlow extends StatefulWidget {
  @override
  _BookingFlowState createState() => _BookingFlowState();
}

class _BookingFlowState extends State<BookingFlow> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: _setupView(),
      bottomNavigationBar: Container(
        height: SizeConfig.getHeight(100),
        color: Color.fromRGBO(106, 179, 170, 1),
        child: Stack(
          children: <Widget>[
            Positioned(
              top: SizeConfig.getPadding(24),
              left: SizeConfig.getPadding(20),
              child: Container(
//                color: Colors.red,
                width: MediaQuery.of(context).size.width / 2.5,
                height: SizeConfig.getHeight(45),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(24),
                  color: Color.fromRGBO(54, 148, 163, 1),
                ),
                child: Container(
                  padding: EdgeInsets.only(top: SizeConfig.getPadding(6)),
                  child: Text(
                    'หยิบใส่รถเข็น',
                    textAlign: TextAlign.center,
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(14),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                ),
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(20),
              child: InkWell(
                onTap: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                      builder: (context) => BookingFlow(),
                    ),
                  );
                },
                child: Container(
//                color: Colors.red,
                  width: MediaQuery.of(context).size.width / 2.5,
                  height: SizeConfig.getHeight(45),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(24),
                    color: Color.fromRGBO(232, 166, 180, 1),
                  ),
                  child: Container(
                    padding: EdgeInsets.only(top: SizeConfig.getPadding(6)),
                    child: Text(
                      'จองเลย',
                      textAlign: TextAlign.center,
                      style: TextStyle(
                          color: Colors.white,
                          fontSize: SizeConfig.getFontSize(14),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),
                    ),
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  _setupView() {
    return SingleChildScrollView(
      child: Column(
        children: <Widget>[
          Stack(
            children: <Widget>[
              Image.network(
                'https://www.cancurreu.com/wp-content/uploads/can_curreu_hotel_ibiza_spa_tratamientos.jpg',
                width: MediaQuery.of(context).size.width,
                height: SizeConfig.getHeight(450),
                fit: BoxFit.cover,
              ),
              Positioned(
                top: SizeConfig.getPadding(44),
                left: SizeConfig.getPadding(16),
                child: InkWell(
                  onTap: () {
                    Navigator.pop(context);
                  },
                  child: Image.asset(
                    'assets/images/ic_back.png',
                    width: SizeConfig.getWidth(20),
                    height: SizeConfig.getWidth(20),
                  ),
                ),
              ),
            ],
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(16)),
            alignment: Alignment.topLeft,
            child: Text(
              '4 ธ.ค. 2561 18:55 น.',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black54,
                  fontSize: SizeConfig.getFontSize(11),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(3),
                bottom: SizeConfig.getPadding(8)),
            alignment: Alignment.topLeft,
            child: Text(
              'Thai Body',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black,
                  fontSize: SizeConfig.getFontSize(26),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
          Row(
            children: <Widget>[
              SizedBox(
                width: SizeConfig.getWidth(24),
              ),
              ImageIcon(
                AssetImage('assets/images/ic_fav_active.png'),
                color: Colors.pink,
                size: SizeConfig.getFontSize(24),
              ),
              SizedBox(
                width: SizeConfig.getWidth(8),
              ),
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  '70',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.black54,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(5),
                    left: SizeConfig.getPadding(0),
                    bottom: SizeConfig.getPadding(4)),
              ),
              SizedBox(
                width: SizeConfig.getWidth(20),
              ),
              ImageIcon(
                AssetImage('assets/images/ic_comment.png'),
                color: Colors.grey,
                size: SizeConfig.getFontSize(24),
              ),
              SizedBox(
                width: SizeConfig.getWidth(8),
              ),
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  '70',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.black54,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(5),
                    left: SizeConfig.getPadding(0),
                    bottom: SizeConfig.getPadding(4)),
              ),
              SizedBox(
                width: SizeConfig.getWidth(20),
              ),
              ImageIcon(
                AssetImage('assets/images/facebook-icon.png'),
                color: Colors.grey,
                size: SizeConfig.getFontSize(24),
              ),
              SizedBox(
                width: SizeConfig.getWidth(20),
              ),
              ImageIcon(
                AssetImage('assets/images/ic_twitter.png'),
                color: Colors.grey,
                size: SizeConfig.getFontSize(24),
              ),
            ],
          ),
          SizedBox(
            height: SizeConfig.getWidth(20),
          ),
          Container(
            padding: EdgeInsets.only(
              left: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(24),
            ),
            child: Card(
              child: Column(
                children: <Widget>[
                  Padding(
                    padding: const EdgeInsets.all(8.0),
                    child: Row(
                      children: <Widget>[
                        ClipRRect(
                          borderRadius: BorderRadius.circular(11.0),
                          child: Image.network(
                            'https://image.freepik.com/free-photo/girl-massage-spa-salon_110955-422.jpg',
                            fit: BoxFit.cover,
                            height: 100.0,
                            width: 100.0,
                          ),
                        ),
                        Column(
                          children: <Widget>[
                            Container(
                              alignment: Alignment.topLeft,
                              child: Text(
                                'SPA By CLARINS',
                                textAlign: TextAlign.left,
                                style: TextStyle(
                                    color: Colors.black,
                                    fontSize: SizeConfig.getFontSize(12),
                                    fontFamily: "SF_Pro_Text",
                                    fontWeight: FontWeight.w700),
                              ),
                              padding: EdgeInsets.only(
                                  top: SizeConfig.getPadding(5),
                                  left: SizeConfig.getPadding(0),
                                  bottom: SizeConfig.getPadding(5)),
                            ),
                            Row(
                              children: <Widget>[
                                SizedBox(
                                  width: 16,
                                ),
                                ImageIcon(
                                  AssetImage('assets/images/pin_drop.png'),
                                  color: Colors.black54,
                                  size: SizeConfig.getFontSize(16),
                                ),
                                SizedBox(
                                  width: SizeConfig.getWidth(4),
                                ),
                                Container(
                                  alignment: Alignment.topLeft,
                                  child: Text(
                                    'พญาไท กรุงเทพ (3.8 km)',
                                    textAlign: TextAlign.left,
                                    style: TextStyle(
                                        color: Colors.black87,
                                        fontSize: SizeConfig.getFontSize(12),
                                        fontFamily: "SF_Pro_Text",
                                        fontWeight: FontWeight.w500),
                                  ),
                                  padding: EdgeInsets.only(
                                      top: SizeConfig.getPadding(5),
                                      left: SizeConfig.getPadding(0),
                                      bottom: SizeConfig.getPadding(5)),
                                ),
                              ],
                            ),
                            Row(
                              children: <Widget>[
                                SizedBox(
                                  width: SizeConfig.getWidth(24),
                                ),
                                Container(
                                  alignment: Alignment.topLeft,
                                  child: Text(
                                    '4.4',
                                    textAlign: TextAlign.left,
                                    style: TextStyle(
                                        color: Colors.black54,
                                        fontSize: SizeConfig.getFontSize(12),
                                        fontFamily: "SF_Pro_Text",
                                        fontWeight: FontWeight.w500),
                                  ),
                                  padding: EdgeInsets.only(
                                      top: SizeConfig.getPadding(5),
                                      left: SizeConfig.getPadding(10),
                                      bottom: SizeConfig.getPadding(5)),
                                ),
                                SizedBox(
                                  width: SizeConfig.getWidth(14),
                                ),
                                ImageIcon(
                                  AssetImage(
                                      'assets/images/ic_star_active.png'),
                                  color: Color.fromRGBO(255, 207, 7, 1),
                                  size: SizeConfig.getFontSize(16),
                                ),
                                SizedBox(
                                  width: SizeConfig.getWidth(2),
                                ),
                                ImageIcon(
                                  AssetImage(
                                      'assets/images/ic_star_active.png'),
                                  color: Color.fromRGBO(255, 207, 7, 1),
                                  size: SizeConfig.getFontSize(16),
                                ),
                                SizedBox(
                                  width: SizeConfig.getWidth(2),
                                ),
                                ImageIcon(
                                  AssetImage(
                                      'assets/images/ic_star_active.png'),
                                  color: Color.fromRGBO(255, 207, 7, 1),
                                  size: SizeConfig.getFontSize(16),
                                ),
                                SizedBox(
                                  width: SizeConfig.getWidth(2),
                                ),
                                ImageIcon(
                                  AssetImage(
                                      'assets/images/ic_star_active.png'),
                                  color: Color.fromRGBO(255, 207, 7, 1),
                                  size: SizeConfig.getFontSize(16),
                                ),
                                SizedBox(
                                  width: SizeConfig.getWidth(2),
                                ),
                                ImageIcon(
                                  AssetImage(
                                      'assets/images/ic_star_unactive.png'),
                                  color: Colors.grey,
                                  size: SizeConfig.getFontSize(16),
                                ),
                                SizedBox(
                                  width: SizeConfig.getWidth(40),
                                  height: SizeConfig.getWidth(30),
                                ),
                              ],
                            ),
                          ],
                        ),
                      ],
                    ),
                  ),
                  SizedBox(
                    height: SizeConfig.getHeight(8),
                  ),
                  Container(
                    width: MediaQuery.of(context).size.width / 1.5,
                    height: SizeConfig.getHeight(40),
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(24),
                      color: Color.fromRGBO(54, 148, 163, 1),
                    ),
                    child: Container(
                      padding: EdgeInsets.only(top: SizeConfig.getPadding(6)),
                      child: Text(
                        'ร้านแนะนำ',
                        textAlign: TextAlign.center,
                        style: TextStyle(
                            color: Colors.white,
                            fontSize: SizeConfig.getFontSize(14),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                      ),
                    ),
                  ),
                  SizedBox(
                    height: SizeConfig.getHeight(16),
                  ),
                ],
              ),
            ),
          ),
          Container(
            alignment: Alignment.topLeft,
            padding: EdgeInsets.only(
                top: SizeConfig.getPadding(24),
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24)),
            child: Text(
              'A four hand massage performed by two therapists in unison, this experience coordinates a blend of Thai, Swedish, Shiatsu and Reflexology techniques using deep rhythmic movement to leave you feeling completely renewed. Top Tip: This is Khun Taras (our Group Spa Director) favourite massage. She loves it because having the sensation of two therapists working on you means your mind cant concentrate on one area and it basically just gives up! This massage almost forces you to switch your mind off. Try it and see.',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black54,
                  fontSize: SizeConfig.getFontSize(14),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(3),
                bottom: SizeConfig.getPadding(8)),
            alignment: Alignment.topLeft,
            child: Text(
              'Thai Body Balance 60 นาที',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black,
                  fontSize: SizeConfig.getFontSize(26),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          Container(
            alignment: Alignment.topLeft,
            width: MediaQuery.of(context).size.width / 3,
            height: SizeConfig.getHeight(50),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(24),
              color: Color.fromRGBO(54, 148, 163, 1),
            ),
            child: Container(
              alignment: Alignment.topCenter,
              padding: EdgeInsets.only(top: SizeConfig.getPadding(10)),
              child: Text(
                'ร้านแนะนำ',
                textAlign: TextAlign.center,
                style: TextStyle(
                    color: Colors.white,
                    fontSize: SizeConfig.getFontSize(14),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
          ),
          SizedBox(
            height: SizeConfig.getHeight(30),
          ),
        ],
      ),
    );
  }
}
