import 'package:flutter/material.dart';

import 'SizeConfig.dart';


class RatingStar extends StatelessWidget {
  final double rate;
  final double starSize;
  final bool isRating;
  final Function onChangeRate;

  RatingStar({
    @required this.rate,
    this.isRating = false,
    this.starSize = 16,
    this.onChangeRate,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      child: Row(
        mainAxisAlignment: MainAxisAlignment.center,
        children: [1.0, 2.0, 3.0, 4.0, 5.0].map((index) {
          return GestureDetector(
            onTap: !this.isRating
                ? null
                : () {

              onChangeRate(index);

            },
            child: _star(context, index),
          );
        }).toList(),
      ),
    );
  }

  Widget _star(BuildContext context, double index) {
    if (index <= rate) {
      return Icon(Icons.star,
          color: Colors.yellow,
          size: SizeConfig.getFontSize(this.starSize));
    } else if (index > rate && index < rate + 1) {
      return Icon(Icons.star,
          color: Colors.yellow,
          size: SizeConfig.getFontSize(this.starSize));
    } else {
      return Icon(Icons.star_border,
          color: Colors.yellow,
          size: SizeConfig.getFontSize(this.starSize));
    }
  }
}
