import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_screenutil/screenutil.dart';

class SizeConfig {
  BuildContext context;

  SizeConfig(this.context){
    ScreenUtil.init(context,width: 375,height: 812);
  }

  static double getScreenWidth(){
    return ScreenUtil.screenWidth;
  }

  static double getScreenHeight(){
    return ScreenUtil.screenHeight;
  }

  static double getScaleOfWidth(double scaleFactor){
    return ScreenUtil.screenWidth*scaleFactor;
  }

  static double getPadding(double value, {double right}){
    return ScreenUtil().setWidth(value);
  }

  static double getWidth(double value){
    return ScreenUtil().setWidth(value);
  }

  static double getHeight(double value){
    return ScreenUtil().setHeight(value);
  }

  static double getFontSize(double value){
    return ScreenUtil().setSp(value, allowFontScalingSelf: true);
  }
}