
import 'package:feelverapp/model/cart/add_cart_model.dart';
import 'package:feelverapp/model/favorite/addfav_model.dart';
import 'package:feelverapp/model/shoplistdetail/shoplistdetail_Model.dart';
import 'package:feelverapp/service/Loading.dart';
import 'package:feelverapp/service/api.dart';
import 'package:feelverapp/service/base_presenter.dart';
import 'package:feelverapp/ui/payment/mycart.dart';
import 'package:feelverapp/ui/shop/shop_list_detail.dart';
import 'package:feelverapp/ui/splashscreen/splash_screen_page.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:rflutter_alert/rflutter_alert.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:url_launcher/url_launcher.dart';

class ShoplistdetailPresenter extends BasePresenter<ShopListDetail> {
  Api _api;
  final formkey = GlobalKey<FormState>();
  shoplistdetailModel model;
  AddfavModel addmodel;
  AddCartModel addCartModel;
  bool fav = false;
  int get_id;
  String vendor_id;
  String store_id;
  String user_id;
  String product_id;

  ShoplistdetailPresenter(State<ShopListDetail> state) : super(state);
  String uid;

  addCart(BuildContext context) async {
    print(getid);
    print(store_id);
    print(vendor_id);

    _api = Api<AddCartModel>();

    var res = await _api.addCart(
        'https://backend.feelver.com/api/cart/add?' +
            'store_id=' +
            store_id.toString() +
            '&vendor_id=' +
            vendor_id.toString() +
            '&user_id=' +
            id.toString() +
            '&product_id=' +
            product_id.toString() +
            '&access_type=portal');

    if (res.fail == null) {
      // if (res.success.status) {
      setState(
            () {
          print("AAAA :${res.success}");
          addCartModel = res.success;
          Alert(
            style: AlertStyle(
              animationType: AnimationType.grow,
              isCloseButton: true,
            ),
            context: state.context,
            title: addCartModel.message.toString(),
            content: Icon(
              Icons.warning,
              color: Colors.orange,
              size: 80,
            ),
            buttons: [
              DialogButton(
                color: Color.fromRGBO(106, 179, 170, 1),
                onPressed: () {
                  if (addCartModel != null) {
                    Navigator.push(
                      context,
                      CupertinoPageRoute(
                        builder: (context) => MyCart(
                          user_id: user_id,
                        ),
                      ),
                    );
                  }
                },
                child: Text(
                  "Ok",
                  style: TextStyle(color: Colors.white, fontSize: 20),
                ),
              ),
            ],
          ).show();
        },
      );
    } else {
      Alert(
          style: AlertStyle(
            animationType: AnimationType.fromTop,
            isCloseButton: false,
          ),
          context: state.context,
          title: "ไม่พบข้อมูล",
          content: Icon(
            Icons.warning,
            color: Colors.orange,
            size: 80,
          ),
          buttons: [
            DialogButton(
              color: Color.fromRGBO(106, 179, 170, 1),
              onPressed: () => Navigator.pop(state.context),
              child: Text(
                "ลองอีกครั้ง",
                style: TextStyle(color: Colors.white, fontSize: 20),
              ),
            )
          ]).show();
    }
  }

  Detai(String id) async {
    _api = Api<shoplistdetailModel>();
    var res = await _api.shoplistDetail({
      "id": id,
    });

    if (res.fail == null) {
      setState(() {
        model = res.success;
        print("complete");
      });
      print('res Success');
    } else {
      print('res Fail');
    }
  }

  getid() async {
    SharedPreferences pref = await SharedPreferences.getInstance();
    setState(() {
      uid = pref.getString('Id');
    });
    return uid;
  }

  Addfav(String id) async {
    LoadingView(state.context).show();
    _api = Api<AddfavModel>();
    var res = await _api.addfav({
      "customer_id": uid,
      "store_id": id,
      "vendor_id": id,
      "product_id": id,
    });
    LoadingView(state.context).hide();
    if (res.fail == null) {
      setState(() {
        addmodel = res.success;
        print("complete");
        fav = true;
      });
      showDialog(
          context: state.context,
          builder: (context) {
            Future.delayed(Duration(seconds: 1), () {
              Navigator.of(context).pop(true);
            });
            return AlertDialog(
              content: ImageIcon(
                AssetImage('assets/images/ic_fav_list.png'),
                color: fav ? Color(0xFFDD175F) : Colors.grey,
                size: SizeConfig.getFontSize(30),
              ),
              title: Center(child: Text('บันทึกสำเร็จ')),
            );
          });
    } else {
      print('res Fail');
    }
  }

  gotoDirection(String lat, String lng) {
    print("debug");
    print(lat);
    print(lng);

    launch('https://www.google.com/maps/dir/?api=1&destination=${lat},${lng}');
  }
}
