import 'package:feelverapp/ui/shop/shop_service_presenter.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:feelverapp/util/rating_star.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

import '../../service/api.dart';
import '../booking/booking_detail.dart';
import 'shop_main.dart';

class ShopServicePage extends StatefulWidget {
  int getid;
  int vendor_id;
  int store_id;
  String user_id;

  ShopServicePage({Key key, this.getid, this.vendor_id, this.store_id,this.user_id})
      : super(key: key);

  @override
  _ShopServicePageState createState() => _ShopServicePageState();
}

class _ShopServicePageState extends State<ShopServicePage>
    with TickerProviderStateMixin {
  double rate1 = 0;

  ShopServicePresenter presenter;

  @override
  void initState() {
    super.initState();

    presenter = ShopServicePresenter(this);
    setState(() {
      presenter.vendor_id = widget.vendor_id;
      presenter.store_id = widget.store_id;
      presenter.getid = widget.getid;
      presenter.user_id = widget.user_id;
    });

    presenter.Servicelistitem();
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);

    return presenter.serviceModel == null
        ? Container(
            child: Center(
              child: CircularProgressIndicator(
                valueColor: new AlwaysStoppedAnimation<Color>(Colors.teal),
              ),
            ),
          )
        : Container(
            child: presenter.serviceModel.data == null
                ? Container()
                : ListView.builder(
                    itemCount: presenter.serviceModel.data.length,
                    itemBuilder: (context, i) {
//                print(presenter.serviceModel.data.length);
                      return myCard(
                        presenter.serviceModel.data[i].name,
                        presenter.serviceModel.data[i].cover == null
                            ? "https://heart.kku.ac.th/media/tz_portfolio_plus/article/cache/dujdao-sahasthas-2-14_o.png"
                            : presenter.serviceModel.data[i].cover,
                        presenter.serviceModel.data[i].excerpt,
                        presenter.serviceModel.data[i].price,
                        presenter.serviceModel.data[i].duration,
                        presenter.serviceModel.data[i].id,
                        presenter.serviceModel.data[i].specialPrice == null
                            ? ""
                            : presenter.serviceModel.data[i].specialPrice,
                        presenter.serviceModel.data[i].vendorId,
                        presenter.serviceModel.data[i].storeId,
                      );
                    },
                  ),
          );
  }

  Widget myCard(String title, String image, String detail, String price,
      String time, int id, String special_price, int vendor_id, int store_id) {
    return InkWell(
      onTap: () {
        setState(
          () {
            Navigator.push(
              context,
              CupertinoPageRoute(
                builder: (context) => MainShop(
                  getid: id,
                  vendor_id: vendor_id,
                  store_id: store_id,
                ),
              ),
            );
          },
        );
      },
      child: Card(
        margin: EdgeInsets.only(
            right: SizeConfig.getPadding(16),
            left: SizeConfig.getPadding(16),
            top: SizeConfig.getPadding(10),
            bottom: SizeConfig.getPadding(10)),
        child: Container(
//        color: Colors.red,
          margin: EdgeInsets.only(right: 15, left: 15, bottom: 20, top: 20),
//                          color: Colors.blueGrey,
          child: Column(
            children: <Widget>[
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 3,
                    child: Container(
//                          color: Colors.blue,
                      height: SizeConfig.getHeight(250),
                      child: presenter.serviceModel == null
                          ? Image.network(
                              "assets/images/demo_img.png",
                              fit: BoxFit.cover,
                            )
                          : Image.network(
                              Api.baseApiforimage + image,
                              fit: BoxFit.cover,
                            ),
                    ),
                  ),
                  Expanded(
                    flex: 5,
                    child: Container(
                      margin: EdgeInsets.only(left: 15),
//                          color: Colors.yellow,
                      height: SizeConfig.getHeight(260),
                      child: Column(
                        children: <Widget>[
                          Container(
                            padding: EdgeInsets.all(10),
                            alignment: Alignment.topLeft,
//                                  color: Colors.red,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                Text(
                                  title,
                                  style: TextStyle(
                                      color: Colors.black,
                                      fontSize: SizeConfig.getFontSize(18),
                                      fontFamily: "SF_Pro_Text",
                                      fontWeight: FontWeight.w500),
                                ),
                                SizedBox(
                                  height: 5,
                                ),
                                Text(
                                  detail,
                                  style: TextStyle(
                                      color: Color(0xff969696),
                                      fontSize: SizeConfig.getFontSize(11),
                                      fontFamily: "SF_Pro_Text",
                                      fontWeight: FontWeight.w500),maxLines: 3,
                                ),
                              ],
                            ),
                          ),
                          Container(
                            padding: EdgeInsets.only(left: 10, right: 10),
                            alignment: Alignment.topLeft,
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.start,
                              children: <Widget>[
//                                Row(
//                                  crossAxisAlignment: CrossAxisAlignment.center,
//                                  children: <Widget>[
//                                    Image.asset(
//                                      'assets/images/pin_drop.png',
//                                      height: 20,
//                                      width: 20,
//                                    ),
//                                    SizedBox(
//                                      width: 5,
//                                    ),
//                                    Text(
//                                      addres,
//                                      style: TextStyle(
//                                        color: Colors.black,
//                                        fontSize: SizeConfig.getFontSize(13),
//                                        fontFamily: "SF_Pro_Text",
//                                      ),
//                                    ),
//                                  ],
//                                ),

                                Row(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  children: <Widget>[
                                    Icon(
                                      Icons.access_time,
                                      color: Color(0xffEEAFB7),
                                    ),
                                    SizedBox(
                                      width: 5,
                                    ),
                                    Text(
                                      time,
                                      style: TextStyle(
                                        color: Colors.black,
                                        fontSize: SizeConfig.getFontSize(13),
                                        fontFamily: "SF_Pro_Text",
                                      ),
                                    ),
                                  ],
                                ),
                                SizedBox(
                                  height: 10,
                                ),
                                Row(
                                  crossAxisAlignment: CrossAxisAlignment.end,
                                  children: <Widget>[
                                    Text(
                                      special_price,
                                      style: TextStyle(
                                        fontSize: SizeConfig.getFontSize(12),
                                        decoration: TextDecoration.lineThrough,
                                      ),
                                    ),
                                    SizedBox(
                                      width: 15,
                                    ),
                                    Text(
                                      "฿" + price,
                                      style: TextStyle(
                                          color: Colors.red,
                                          fontSize: SizeConfig.getFontSize(18),
                                          fontFamily: "SF_Pro_Text",
                                          fontWeight: FontWeight.w500),
                                    ),
                                  ],
                                ),
                                SizedBox(
                                  height: SizeConfig.getHeight(5),
                                ),
                                Container(
                                  child: Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: <Widget>[
                                      RatingStar(
                                        isRating: true,
                                        rate: rate1,
                                        starSize: 20,
                                        onChangeRate: (i) {
                                          setState(() {
                                            rate1 = i;
                                            print(i);
                                          });
                                        },
                                      ),
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
