import 'package:feelverapp/ui/booking/booking_detail.dart';
import 'package:feelverapp/ui/shop/shop.dart';
import 'package:feelverapp/ui/shop/shop_Nearby_places.dart';
import 'package:feelverapp/ui/shop/shop_reviews.dart';
import 'package:feelverapp/ui/shop/shop_service.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/material.dart';

import 'dart:math';

class MainShop extends StatefulWidget {

  int getid;
  int vendor_id;
  int store_id;
  String user_id;

  MainShop({Key key, this.title,this.getid,this.vendor_id,this.store_id,this.user_id}) : super(key: key);


  final String title;


  @override
  _MainShopState createState() => _MainShopState();
}

class _MainShopState extends State<MainShop>
    with SingleTickerProviderStateMixin/*<-- This is for the controllers*/ {
  TabController _controller; // To control switching tabs
  ScrollController _scrollViewController; // To control scrolling

  List<String> items = [];
  List<Color> colors = [
    Colors.red,
    Colors.green,
    Colors.yellow,
    Colors.purple,
    Colors.blue,
    Colors.amber,
    Colors.cyan,
    Colors.pink
  ];
  Random random = new Random();

  Color getRandomColor() {
    return colors.elementAt(random.nextInt(colors.length));
  }

  @override
  void initState() {
    super.initState();
    _controller = new TabController(length: 4, vsync: this);
    _controller.addListener(_handleTabSelection);
    _scrollViewController = ScrollController();
  }

  void _handleTabSelection() {
    setState(() {});
  }

  @override
  void dispose() {
    super.dispose();
    _controller.dispose();
    _scrollViewController.dispose();
  }

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    // Init the items
    print(widget.user_id);

    return Scaffold(
      //  backgroundColor: Colors.transparent,

      body: NestedScrollView(
        controller: _scrollViewController,
        headerSliverBuilder: (BuildContext context, bool boxIsScrolled) {
          return <Widget>[
            SliverAppBar(
              backgroundColor: Color.fromRGBO(69, 85, 79, 1),
              leading: IconButton(
                icon: Icon(Icons.arrow_back_ios, color: Colors.white),
                onPressed: () => Navigator.of(context).pop(),
              ),
              title: Center(
                child: Text(
                  "Thai Body Balance",
                  style: TextStyle(
                      color: Colors.white,
                      fontSize: SizeConfig.getFontSize(20),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w700),
                ),
              ),
              floating: true,
              pinned: false,
              snap: true,
              bottom: new TabBar(
                indicatorColor: Colors.transparent,
                controller: _controller,
                tabs: [
                  new Tab(
                    icon: Icon(Icons.assignment,
                        color: _controller.index == 0
                            ? Colors.yellowAccent
                            : Colors.white),
                    child: Text(
                      'ข้อมูลร้าน',
                      style: TextStyle(
                          color: _controller.index == 0
                              ? Colors.yellowAccent
                              : Colors.white,
                          fontSize: SizeConfig.getFontSize(11),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w700),
                    ),
                  ),
                  new Tab(
                    icon: Icon(Icons.loyalty,
                        color: _controller.index == 1
                            ? Colors.yellowAccent
                            : Colors.white),
                    child: Text(
                      'บริการ',
                      style: TextStyle(
                          color: _controller.index == 1
                              ? Colors.yellowAccent
                              : Colors.white,
                          fontSize: SizeConfig.getFontSize(11),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w700),
                    ),
                  ),
                  new Tab(
                    icon: Icon(Icons.star,
                        color: _controller.index == 2
                            ? Colors.yellowAccent
                            : Colors.white),
                    child: Text(
                      'รีวิว',
                      style: TextStyle(
                          color: _controller.index == 2
                              ? Colors.yellowAccent
                              : Colors.white,
                          fontSize: SizeConfig.getFontSize(11),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w700),
                    ),
                  ),
                  Container(
                    width: 200,
                    child: Tab(
                      icon: Icon(Icons.pin_drop,
                          color: _controller.index == 3
                              ? Colors.yellowAccent
                              : Colors.white),
                      child: Text(
                        'สถานที่ใกล้เคียง',
                        maxLines: 1,
                        style: TextStyle(
                            color: _controller.index == 3
                                ? Colors.yellowAccent
                                : Colors.white,
                            fontSize: SizeConfig.getFontSize(11),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w700),
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ];
        },
        body: new Container(
          height: double.maxFinite,
          child: new TabBarView(
            controller: _controller,
            children: <Widget>[
              Container(
                child: BookingDetail(getid: widget.getid,vendor_id: widget.vendor_id,store_id: widget.store_id,user_id: widget.user_id,),
                // child: getlist(),
                //width: 20,
              ),
              Column(
                children: <Widget>[
                  Container(
                    padding: EdgeInsets.only(left: SizeConfig.getPadding(24),top: SizeConfig.getPadding(24)),
                    alignment: Alignment.topLeft,
                    child: Wrap(
                      alignment: WrapAlignment.start,
                      spacing: 10.0, // gap between adjacent chips
                      runSpacing: 5.0, // gap between lines
                      children: <Widget>[
                        FilterChip(
                          label: Text(
                            "ทั้งหมด",
                            style: TextStyle(
                                color: Colors.white,
                                fontSize: SizeConfig.getFontSize(15),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),
                          ),
                          backgroundColor: Color.fromRGBO(69, 85, 79, 1),
                          shape: StadiumBorder(
                            side: BorderSide(color: Colors.white),
                          ),
                          onSelected: (bool value) {
                            print("selected");
                            setState(() {});
                          },
                        ),
                        FilterChip(
                          label: Text(
                            "ที่เที่ยว",
                            style: TextStyle(
                                color: Colors.white,
                                fontSize: SizeConfig.getFontSize(15),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),
                          ),
                          backgroundColor:Color.fromRGBO(69, 85, 79, 1),
                          shape: StadiumBorder(
                            side: BorderSide(color: Colors.white),
                          ),
                          onSelected: (bool value) {
                            print("selected");
                          },
                        ),
                        FilterChip(
                          label: Text(
                            "ที่กิน",
                            style: TextStyle(
                                color: Colors.white,
                                fontSize: SizeConfig.getFontSize(15),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),
                          ),
                          backgroundColor:Color.fromRGBO(69, 85, 79, 1),
                          shape: StadiumBorder(
                            side: BorderSide(color: Colors.white),
                          ),
                          onSelected: (bool value) {
                            print("selected");
                          },
                        ),
                        FilterChip(
                          label: Text(
                            "ที่พัก",
                            style: TextStyle(
                                color: Colors.white,
                                fontSize: SizeConfig.getFontSize(15),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),
                          ),
                          backgroundColor: Color.fromRGBO(69, 85, 79, 1),
                          shape: StadiumBorder(
                            side: BorderSide(color: Colors.white),
                          ),
                          onSelected: (bool value) {
                            print("selected");
                          },
                        ),
                        FilterChip(
                          label: Text(
                            "กิจกรรม",
                            style: TextStyle(
                                color: Colors.white,
                                fontSize: SizeConfig.getFontSize(15),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),
                          ),
                          backgroundColor: Color.fromRGBO(69, 85, 79, 1),
                          shape: StadiumBorder(
                            side: BorderSide(color: Colors.white),
                          ),
                          onSelected: (bool value) {
                            print("selected");
                          },
                        ),
                      ],

                    ),
                  ),
                  Expanded(
                    child: Container(
                      //  color: Colors.blue,
                      //  height: double.maxFinite,
                      child: ShopServicePage(getid: widget.getid,vendor_id: widget.vendor_id,store_id: widget.store_id,user_id: widget.user_id,),
                    ),
                  ),
                ],
              ),
              // child: getlist(),
              //width: 20,

              Container(
//                  color: Colors.red,
                child: ShopReviewsPage(getid: widget.getid,vendor_id: widget.vendor_id,store_id: widget.store_id,user_id: widget.user_id,),
                // child: getlist(),
                //width: 20,
              ),
//
              Container(
//                width: double.maxFinite,
//                color: Colors.yellow,
//              child: setupView(),
                child: ShopNearbyPlacesPage(),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
