import 'package:carousel_pro/carousel_pro.dart';
import 'package:feelverapp/service/api.dart';
import 'package:feelverapp/ui/booking/bookingflow.dart';
import 'package:feelverapp/ui/home/home.dart';
import 'package:feelverapp/ui/menu/menu.dart';
import 'package:feelverapp/ui/payment/mycart.dart';
import 'package:feelverapp/ui/review_shop/review_shop_page.dart';
import 'package:feelverapp/ui/shop/shop_main.dart';
import 'package:feelverapp/ui/shop/shop_reviews.dart';
import 'package:feelverapp/ui/shop/shop_main.dart';
import 'package:feelverapp/ui/shop/shoplistdetail_presenter.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class ShopListDetail extends StatefulWidget {
  String id;

  ShopListDetail({
    Key key,
    this.id,
  }) : super(key: key);

  @override
  _ShopListDetailState createState() => _ShopListDetailState();
}

class _ShopListDetailState extends State<ShopListDetail> {
  bool fav = false;
  ShoplistdetailPresenter presenter;

  @override
  void initState() {
    super.initState();
    print(widget.id);
    presenter = ShoplistdetailPresenter(this);
    presenter.Detai(widget.id);
    presenter.getid();

    // List values = presenter.model.result[0].location.split(","); // split() will split from . and gives new List with separated elements.
    //values.forEach(print);
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: presenter.model == null
          ? Container(
              child: Center(
                child: CircularProgressIndicator(
                  valueColor: new AlwaysStoppedAnimation<Color>(
                    Color.fromRGBO(69, 85, 79, 1),
                  ),
                ),
              ),
            )
          : _setupView(),
    );
  }

  _setupView() {
    return SingleChildScrollView(
      child: Column(
        children: <Widget>[
          Stack(
            children: <Widget>[
              Container(
                color: Color.fromRGBO(69, 85, 79, 1),
                height: SizeConfig.getHeight(150),
                width: MediaQuery.of(context).size.width,
              ),
              Positioned(
                top: SizeConfig.getPadding(50),
                left: SizeConfig.getPadding(
                    MediaQuery.of(context).size.width / 3.3),
                child: Container(
                  alignment: Alignment.topCenter,
                  child: Image.asset(
                    'assets/images/feelver_banner.png',
                    width: MediaQuery.of(context).size.width / 2.5,
                  ),
                  //    Image.network(
                  //  Api.baseApiforimage+ presenter.model.result[0].storeLogo,
                  //   height: SizeConfig.getWidth(180),
                  //   width: MediaQuery.of(context).size.width,
                  //   fit: BoxFit.cover,
                  // ),
                ),
              ),
              Positioned(
                top: SizeConfig.getPadding(70),
                left: SizeConfig.getPadding(16),
                child: Container(
                  child: GestureDetector(
                    onTap: () {
                      Navigator.pop(context);
                    },
                    child: Icon(
                      Icons.keyboard_arrow_left,
                      color: Colors.white,
                      size: SizeConfig.getFontSize(40),
                    ),
                  ),
                ),
              ),
            ],
          ),
          Container(
            height: SizeConfig.getHeight(270),
            child: Stack(
              children: <Widget>[
                Container(
                  height: SizeConfig.getHeight(230),
                  width: SizeConfig.getWidth(MediaQuery.of(context).size.width),
                  child: Carousel(
                    images: [
                      Image.network(
                        presenter.model.result[0].storeCover,
                        fit: BoxFit.cover,
                      ),
                      Image.network(
                        presenter.model.result[0].storeCover,
                        fit: BoxFit.cover,
                      ),
                      Image.network(
                        presenter.model.result[0].storeCover,
                        fit: BoxFit.cover,
                      ),
                      Image.network(
                        presenter.model.result[0].storeCover,
                        fit: BoxFit.cover,
                      ),
                    ],
                    animationDuration: const Duration(milliseconds: 300),
                    dotSize: 8.0,
                    dotSpacing: 25.0,
                    dotIncreaseSize: 2.0,
                    dotColor: Colors.white,
                    dotBgColor: Colors.transparent,
                    // showIndicator: true,
                    indicatorBgPadding: 20.0,
                    boxFit: BoxFit.cover,
                    radius: Radius.circular(0.0),
                    overlayShadow: false,
                    // overlayShadowColors: Colors.transparent,
                    // overlayShadowSize: 0.5,
                    autoplay: true,
                  ),
                ),
                Positioned(
                  right: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(16),
                  child: InkResponse(
                    highlightShape: BoxShape.circle,
                    highlightColor: Color(0xFFDD175F),
                    focusColor: Color(0xFFDD175F),
                    splashColor: Color(0xFFDD175F),
                    onTap: () {
                      setState(() {
                        presenter.fav
                            ? presenter.fav = false
                            : presenter.Addfav(widget.id);
                      });
                    },
                    child: ImageIcon(
                      AssetImage('assets/images/ic_fav_list.png'),
                      color: presenter.fav ? Color(0xFFDD175F) : Colors.white,
                      size: SizeConfig.getFontSize(30),
                    ),
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(165),
                  child: Image.asset(
                    'assets/images/pin_list.png',
                    width: SizeConfig.getWidth(60),
                    height: SizeConfig.getWidth(60),
                  ),
                ),
                Positioned(
                    left: SizeConfig.getPadding(80),
                    top: SizeConfig.getPadding(200),
                    child: GestureDetector(
                      onTap: () {
                        print(presenter.model.result[0].location);

                        List values = presenter.model.result[0].location.split(
                            ","); // split() will split from . and gives new List with separated elements.
                        values.forEach(print);
                        print("lat =" + values[0]);
                        print("lng =" + values[1]);
                        presenter.gotoDirection(values[0], values[1]);
                      },
                      child: Text(
                        "นำทาง",
                        textAlign: TextAlign.left,
                        style: TextStyle(
                            decoration: TextDecoration.underline,
                            color: Colors.black87,
                            fontSize: SizeConfig.getFontSize(13),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w700),
                      ),
                    )),
              ],
            ),
          ),
          SizedBox(
            height: SizeConfig.getHeight(16),
          ),
          Container(
            padding: EdgeInsets.only(
              left: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(24),
              bottom: SizeConfig.getPadding(5),
            ),
            alignment: Alignment.topLeft,
            child: Text(
              presenter.model.result[0].storeName,
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black87,
                  fontSize: SizeConfig.getFontSize(16),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                bottom: SizeConfig.getPadding(15)),
            alignment: Alignment.topLeft,
            child: Text(
              "โทร " + presenter.model.result[0].phone,
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.grey,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                bottom: SizeConfig.getPadding(15)),
            alignment: Alignment.topLeft,
            child: Text(
              "email " + presenter.model.result[0].email,
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.grey,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                bottom: SizeConfig.getPadding(15)),
            alignment: Alignment.topLeft,
            child: Text(
              "ที่อยู่ " + presenter.model.result[0].address,
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.grey,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          Container(
            padding: EdgeInsets.only(
              left: SizeConfig.getPadding(20),
              right: SizeConfig.getPadding(20),
              top: SizeConfig.getPadding(20),
              bottom: SizeConfig.getPadding(20),
            ),
            height: SizeConfig.getHeight(1),
            width: MediaQuery.of(context).size.width - 40,
            color: Colors.grey,
          ),
          _dayOpen(),
          _rating(),
          _ratingMenu(),
          SizedBox(
            height: SizeConfig.getHeight(20),
          ),
          Container(
            padding: EdgeInsets.only(
              left: SizeConfig.getPadding(20),
              right: SizeConfig.getPadding(20),
              top: SizeConfig.getPadding(40),
              bottom: SizeConfig.getPadding(20),
            ),
            height: SizeConfig.getHeight(1),
            width: MediaQuery.of(context).size.width - 40,
            color: Colors.grey,
          ),
          SizedBox(
            height: SizeConfig.getHeight(20),
          ),
          _detail(),
          _servicelist(),
        ],
      ),
    );
  }

  _servicelist() {
    return Container(
      padding: EdgeInsets.only(left: SizeConfig.getPadding(16), right: SizeConfig.getPadding(16)
      ),
      child: Column(
        children: <Widget>[
          Container(
            padding: EdgeInsets.only(
              top: SizeConfig.getPadding(15),
              left: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(24),
              bottom: SizeConfig.getPadding(5),
            ),
            alignment: Alignment.topLeft,
//            child: Text(
//              'บริการ',
//              textAlign: TextAlign.left,
//              style: TextStyle(
//                  color: Colors.black87,
//                  fontSize: SizeConfig.getFontSize(16),
//                  fontFamily: "SF_Pro_Text",
//                  fontWeight: FontWeight.w700),
//            ),
          ),
          Column(
            children: List.generate(
              presenter.model.result[0].openHour.length,
              (i) {
                return InkWell(
                  onTap: () {
                    Navigator.push(
                      context,
                      CupertinoPageRoute(
                        builder: (context) => MainShop(
                          getid: presenter
                              .model.result[0].storeProduct[i].product.id,
                          vendor_id: presenter
                              .model.result[0].storeProduct[i].product.vendorId,
                          store_id:
                              presenter.model.result[0].storeProduct[i].storeId,
                          user_id: widget.id,

                        ),
                      ),
                    );
                  },
                  child: Column(
                    children: [
                      SizedBox(
                        height: 5,
                      ),
                      Align(
                        alignment: Alignment.topLeft,
                        child: Text(
                          presenter
                              .model.result[0].storeProduct[i].product.name,
                          textAlign: TextAlign.left,
                          style: TextStyle(
                              color: Colors.black87,
                              fontSize: SizeConfig.getFontSize(16),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.w700),
                        ),
                      ),
                      SizedBox(
                        height: 16,
                      ),
                      Row(children: [
                        Icon(

                          Icons.timer,
                          color: Colors.pinkAccent,
                          size: 20,
                        ),
                        Text(
                          " " +
                              presenter.model.result[0].storeProduct[i].product
                                  .duration +
                              " ชม.",
                          textAlign: TextAlign.left,
                          style: TextStyle(
                              color: Colors.black87,
                              fontSize: SizeConfig.getFontSize(12),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.w200),
                        ),
                        Spacer(),
                        presenter.model.result[0].storeProduct[i].product
                                    .specialPrice ==
                                null
                            ? Text(
                                "฿" +
                                    presenter.model.result[0].storeProduct[i]
                                        .product.price,
                                textAlign: TextAlign.left,
                                style: TextStyle(
                                    color: Colors.red,
                                    fontSize: SizeConfig.getFontSize(18),
                                    fontFamily: "SF_Pro_Text",
                                    fontWeight: FontWeight.w700),
                              )
                            : Container(
                                child: Row(
                                children: [
                                  Icon(
                                    Icons.local_offer,
                                    color: Colors.pinkAccent,
                                    size: 20,
                                  ),
                                  Text(
                                    " ฿" +
                                        presenter.model.result[0]
                                            .storeProduct[i].product.price,
                                    textAlign: TextAlign.left,
                                    style: TextStyle(
                                        decoration: TextDecoration.lineThrough,
                                        color: Colors.pinkAccent,
                                        fontSize: SizeConfig.getFontSize(14),
                                        fontFamily: "SF_Pro_Text",
                                        fontWeight: FontWeight.w700),
                                  ),
                                  Text(
                                    " ฿" +
                                        presenter
                                            .model
                                            .result[0]
                                            .storeProduct[i]
                                            .product
                                            .specialPrice,
                                    textAlign: TextAlign.left,
                                    style: TextStyle(
                                        color: Colors.red,
                                        fontSize: SizeConfig.getFontSize(18),
                                        fontFamily: "SF_Pro_Text",
                                        fontWeight: FontWeight.w700),
                                  )
                                ],
                              ))
                      ]),
                      SizedBox(
                        height: 10,
                      ),
                      Padding(
                        padding: EdgeInsets.fromLTRB(0.0, 5.0, 0.0, 0.0),
                        child: Material(
                          //Wrap with Material

                          shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(30.0)),
                          elevation: 0.0,
                          color: Color(0xff3694A3),
                          clipBehavior: Clip.antiAlias,
                          // Add This
                          child: MaterialButton(
                            minWidth: MediaQuery.of(context).size.width - 50,
                            height: SizeConfig.getHeight(50),
                            color: Color(0xff3694A3),
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Icon(
                                  Icons.shopping_cart,
                                  color: Colors.white,
                                  size: 25,
                                ),
                                new Text(' หยิบใส่รถเข็น',
                                    style: new TextStyle(
                                        fontSize: 16.0, color: Colors.white)),
                              ],
                            ),
                            onPressed: () {
                              setState(() {
                                presenter.user_id = widget.id;
                                presenter.store_id =  presenter.model.result[0].storeProduct[i].storeId.toString();
                                presenter.vendor_id =  presenter.model.result[0].storeProduct[i].vendorId.toString();
                                presenter.product_id =  presenter.model.result[0].storeProduct[i].productId.toString();
                                presenter.addCart(context);
                              });
//                               Navigator.push(
//                                 context,
//                                 CupertinoPageRoute(
//                                   builder: (context) => MyCart(
// //                                    getid: presenter.model.result[0]
// //                                        .storeProduct[i].product.id,
// //                                    vendor_id:     presenter.model.result[0].storeProduct[i]
// //                                        .product.vendorId,
// //                                    store_id:     presenter.model.result[0].storeProduct[i].storeId,
//                                   ),
//                                 ),
//                               );
                              print(" Go to cart");
                            },
                          ),
                        ),
                      ),
                      SizedBox(
                        height: 30,
                      ),
                      Container(
                        padding: EdgeInsets.only(
                          left: SizeConfig.getPadding(20),
                          right: SizeConfig.getPadding(20),
                          top: SizeConfig.getPadding(40),
                          bottom: SizeConfig.getPadding(20),
                        ),
                        height: SizeConfig.getHeight(1),
                        width: MediaQuery.of(context).size.width - 40,
                        color: Colors.grey,
                      )
                    ],
                  ),
                );
              },
            ),
          ),
          Container(
            padding: EdgeInsets.only(
              left: SizeConfig.getPadding(20),
              right: SizeConfig.getPadding(20),
              top: SizeConfig.getPadding(40),
              bottom: SizeConfig.getPadding(20),
            ),
            height: SizeConfig.getHeight(1),
            width: MediaQuery.of(context).size.width - 40,
            color: Colors.grey,
          ),
        ],
      ),
    );
  }

  _dayOpen() {
    return Column(
      children: <Widget>[
        Container(
          padding: EdgeInsets.only(
            top: SizeConfig.getPadding(15),
            left: SizeConfig.getPadding(24),
            right: SizeConfig.getPadding(24),
            bottom: SizeConfig.getPadding(0),
          ),
          alignment: Alignment.topLeft,
          child: Text(
            'วันเปิดปิดทำการ',
            textAlign: TextAlign.left,
            style: TextStyle(
                color: Colors.black87,
                fontSize: SizeConfig.getFontSize(16),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w700),
          ),
        ),
        Container(
          height: SizeConfig.getHeight(180),
          padding: EdgeInsets.only(
            top: SizeConfig.getPadding(0),
            left: SizeConfig.getPadding(24),
            right: SizeConfig.getPadding(24),
            bottom: SizeConfig.getPadding(5),
          ),
          alignment: Alignment.topLeft,
          child: ListView.builder(
            physics: const NeverScrollableScrollPhysics(),
            itemCount: presenter.model.result[0].openHour.length,
            itemBuilder: (context, i) {
              return Text(
                "${presenter.model.result[0].openHour[i].name}  ${presenter.model.result[0].openHour[i].open} - ${presenter.model.result[0].openHour[i].closed} ",
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Colors.black54,
                    fontSize: SizeConfig.getFontSize(12),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              );
            },
          ),
        ),
        Container(
          padding: EdgeInsets.only(
            left: SizeConfig.getPadding(20),
            right: SizeConfig.getPadding(20),
            top: SizeConfig.getPadding(40),
            bottom: SizeConfig.getPadding(20),
          ),
          height: SizeConfig.getHeight(1),
          width: MediaQuery.of(context).size.width - 40,
          color: Colors.grey,
        ),
      ],
    );
  }

  _rating() {
    return Container(
      height: SizeConfig.getHeight(100),
      child: Stack(
        children: <Widget>[
          Container(
            padding: EdgeInsets.only(
              top: SizeConfig.getPadding(15),
              left: SizeConfig.getPadding(24),
              bottom: SizeConfig.getPadding(5),
            ),
            alignment: Alignment.topLeft,
            child: Text(
              'คะแนนร้านค้าและการรีวิว',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black87,
                  fontSize: SizeConfig.getFontSize(16),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
          Positioned(
            right: SizeConfig.getPadding(15),
            top: SizeConfig.getPadding(10),
            child: FlatButton(
              onPressed: (){
                Navigator.push(
                  context,
                  MaterialPageRoute(builder: (context) => ReviewShopPage()),
                );
              },
              child: Text(
                'ดูทั้งหมด',
                textAlign: TextAlign.right,
                style: TextStyle(
                    decoration: TextDecoration.underline,
                    color: Colors.black54,
                    fontSize: SizeConfig.getFontSize(12),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w700),
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(53),
            left: SizeConfig.getPadding(20),
            child: Image.asset(
              'assets/images/ic_star_active.png',
              width: SizeConfig.getWidth(16),
              height: SizeConfig.getWidth(16),
            ),
          ),
          Positioned(
            left: SizeConfig.getPadding(45),
            top: SizeConfig.getPadding(50),
            child: Text(
              presenter.model.result[0].star,
              textAlign: TextAlign.right,
              style: TextStyle(
                  decoration: TextDecoration.underline,
                  color: Colors.black87,
                  fontSize: SizeConfig.getFontSize(16),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
//           Positioned(
//             left: SizeConfig.getPadding(80),
//             top: SizeConfig.getPadding(52),
//             child: Text(
//               '267 รีวิว',
//               textAlign: TextAlign.right,
//               style: TextStyle(
// //                  decoration: TextDecoration.underline,
//                   color: Colors.black54,
//                   fontSize: SizeConfig.getFontSize(12),
//                   fontFamily: "SF_Pro_Text",
//                   fontWeight: FontWeight.w500),
//             ),
//           ),
          Positioned(
            right: SizeConfig.getPadding(20),
            top: SizeConfig.getPadding(52),
            child: Text(
              '',
              textAlign: TextAlign.right,
              style: TextStyle(
//                  decoration: TextDecoration.underline,
                  color: Colors.black87,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
        ],
      ),
    );
  }

  _ratingMenu() {
    final List<String> entries = <String>[
      'assets/images/ic_flower.png',
      'assets/images/ic_homee.png',
      'assets/images/ic_tagservice.png',
      'assets/images/ic_cash.png'
    ];
    final List<String> title = <String>[
      'บรรยากาศ',
      'ความสะอาด',
      'บริการ',
      'ความคุ้มค่า'
    ];
    return Container(
      height: 70,
      child: GridView.count(
        crossAxisCount: 4,
        physics: const NeverScrollableScrollPhysics(),
        children: List.generate(
          entries.length,
          (index) {
            return Center(
              child: Column(
                children: <Widget>[
                  Image.asset(
                    entries[index],
                    width: SizeConfig.getWidth(24),
                    height: SizeConfig.getWidth(24),
                  ),
                  SizedBox(
                    height: 10,
                  ),
                  Text(
                    title[index],
                    textAlign: TextAlign.right,
                    style: TextStyle(
//                  decoration: TextDecoration.underline,
                        color: Colors.black54,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  )
                ],
              ),
            );
          },
        ),
      ),
    );
  }

  _detail() {
    return Column(
      children: <Widget>[
        Container(
          alignment: Alignment.topLeft,
          padding: EdgeInsets.only(
            left: SizeConfig.getPadding(20),
          ),
          child: Text(
            'ข้อมูลร้านค้า',
            textAlign: TextAlign.left,
            style: TextStyle(
//                  decoration: TextDecoration.underline,
                color: Colors.black87,
                fontSize: SizeConfig.getFontSize(16),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w700),
          ),
        ),
        Container(
          alignment: Alignment.topLeft,
          padding: EdgeInsets.only(
            left: SizeConfig.getPadding(20),
            right: SizeConfig.getPadding(20),
            top: SizeConfig.getPadding(10),
          ),
          child: Text(
            presenter.model.result[0].excerpt,
            textAlign: TextAlign.left,
            style: TextStyle(
//                  decoration: TextDecoration.underline,
                color: Colors.black54,
                fontSize: SizeConfig.getFontSize(14),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w500),
          ),
        ),
        SizedBox(
          height: SizeConfig.getHeight(20),
        ),
        Container(
          padding: EdgeInsets.only(
            left: SizeConfig.getPadding(20),
            right: SizeConfig.getPadding(20),
            top: SizeConfig.getPadding(40),
            bottom: SizeConfig.getPadding(10),
          ),
          height: SizeConfig.getHeight(1),
          width: MediaQuery.of(context).size.width - 40,
          color: Colors.grey,
        ),
      ],
    );
  }

  _getlist() {
    final List<String> entries = <String>[
      'Ivory Relax and Spa',
      'Sunshine Spa & Massage',
      'Mandarin Ginger Spa'
    ];
    return Expanded(
      child: Container(
        padding: EdgeInsets.only(
          top: SizeConfig.getPadding(16),
          left: SizeConfig.getPadding(16),
          right: SizeConfig.getPadding(16),
          bottom: SizeConfig.getPadding(10),
        ),
        child: ListView.builder(
          itemCount: entries.length,
          itemBuilder: (context, i) {
            return _shopItem(entries[i]);
          },
        ),
      ),
    );
  }

  Widget _shopItem(String title) {
    return Card(
      child: Column(
        children: <Widget>[
          Container(
            height: SizeConfig.getHeight(270),
            child: Stack(
              children: <Widget>[
                Image.network(
                  'https://image.freepik.com/free-photo/girl-massage-spa-salon_110955-422.jpg',
                  height: SizeConfig.getWidth(180),
                  width: MediaQuery.of(context).size.width,
                  fit: BoxFit.cover,
                ),
                Positioned(
                  right: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(16),
                  child: ImageIcon(
                    AssetImage('assets/images/ic_fav_list.png'),
                    color: Colors.white,
                    size: SizeConfig.getFontSize(30),
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(165),
                  child: Image.asset(
                    'assets/images/pin_list.png',
                    width: SizeConfig.getWidth(50),
                    height: SizeConfig.getWidth(50),
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(75),
                  top: SizeConfig.getPadding(190),
                  child: Text(
                    title,
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ),
              ],
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24)),
            alignment: Alignment.topLeft,
            child: Text(
              '4/18, 4/21 BTS Nana Exit4 Sukhumvit Soi 8 , KlongToey Bangkok, Thailand 10110',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.grey,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                top: SizeConfig.getPadding(10),
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                bottom: SizeConfig.getPadding(10)),
            alignment: Alignment.topLeft,
            child: Text(
              'Body Scrub',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
          Row(
            children: <Widget>[
              SizedBox(
                width: SizeConfig.getWidth(20),
              ),
              Image.asset(
                'assets/images/clock.png',
                width: SizeConfig.getWidth(20),
                height: SizeConfig.getWidth(20),
              ),
              SizedBox(
                width: SizeConfig.getWidth(10),
              ),
              Text(
                '90 นาที',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Colors.black87,
                    fontSize: SizeConfig.getFontSize(12),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
              SizedBox(
                width: SizeConfig.getWidth(30),
              ),
              Image.asset(
                'assets/images/sell.png',
                width: SizeConfig.getWidth(20),
                height: SizeConfig.getWidth(20),
              ),
              SizedBox(
                width: SizeConfig.getWidth(5),
              ),
              Text(
                '฿1,599.00 ',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Color.fromRGBO(238, 175, 183, 1),
                    fontSize: SizeConfig.getFontSize(12),
                    decoration: TextDecoration.lineThrough,
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
              SizedBox(
                width: SizeConfig.getWidth(5),
              ),
              Text(
                '฿1,599.00 ',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Color.fromRGBO(253, 41, 86, 1),
                    fontSize: SizeConfig.getFontSize(22),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w700),
              ),
            ],
          ),
          InkWell(
            onTap: () {
              Navigator.push(
                context,
                MaterialPageRoute(
                  builder: (context) => ShopListDetail(),
                ),
              );
            },
            child: Stack(
              children: <Widget>[
                Container(
                  child: Image.asset('assets/images/btn_shoplist.png'),
                  padding: EdgeInsets.only(
                    left: SizeConfig.getPadding(20),
                    right: SizeConfig.getPadding(20),
                    top: SizeConfig.getPadding(20),
                    bottom: SizeConfig.getPadding(20),
                  ),
                ),
                Container(
                  alignment: Alignment.center,
                  child: Text(
                    'หยิบใส่รถเข็น',
                    textAlign: TextAlign.center,
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(14),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                  padding: EdgeInsets.only(
                    left: SizeConfig.getPadding(60),
                    right: SizeConfig.getPadding(20),
                    top: SizeConfig.getPadding(30),
                    bottom: SizeConfig.getPadding(20),
                  ),
                )
              ],
            ),
          )
        ],
      ),
    );
  }
}
