import 'package:feelverapp/ui/home/home.dart';
import 'package:feelverapp/ui/menu/menu.dart';
import 'package:feelverapp/ui/shop/shop_list_detail.dart';
import 'package:feelverapp/ui/shop/shoplist_presenter.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class ShopList extends StatefulWidget {
  @override
  _ShopListState createState() => _ShopListState();
}

class _ShopListState extends State<ShopList> with TickerProviderStateMixin {
//  var entries = new List<String>.generate(2, (i) => "Item $i");

  ShoplistPresenter presenter;

  @override
  void initState() {
    super.initState();

    presenter = ShoplistPresenter(this);
    presenter.Listitem();
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
      bottomNavigationBar: Container(
        color: Color.fromRGBO(69, 85, 79, 1),
        height: SizeConfig.getWidth(80),
        child: Row(
          children: <Widget>[
            Container(
              margin: EdgeInsets.only(left: SizeConfig.getPadding(16), top: 0),
              width: SizeConfig.getWidth(60),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_home.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
                      print("Pressed");
                      Navigator.push(
                        context,
                        MaterialPageRoute(builder: (context) => HomePage()),
                      );
                    },
                  ),
                  Text(
                    'หน้าแรก',
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(left: SizeConfig.getPadding(16), top: 0),
              width: SizeConfig.getWidth(100),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_list.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
//                      Navigator.push(
//                        context,
//                        MaterialPageRoute(builder: (context) => LoginPage()),
//                      );
                      print("Pressed");
                    },
                  ),
                  Text(
                    'การจองของฉัน',
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(left: SizeConfig.getPadding(16), top: 0),
              width: SizeConfig.getWidth(80),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_cart.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
//                      Navigator.push(
//                        context,
//                        MaterialPageRoute(builder: (context) => LoginPage()),
//                      );
                    },
                  ),
                  Text(
                    'รถเข็นของฉัน',
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  )
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(
                  left: SizeConfig.getPadding(16), top: 0, right: 0),
              width: SizeConfig.getWidth(60),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_nearme.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
//                      Navigator.push(
//                        context,
//                        MaterialPageRoute(builder: (context) => LoginPage()),
//                      );
                    },
                  ),
                  Text(
                    'ใกล้ฉัน',
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  )
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  _setupView() {
    return Column(
      children: <Widget>[
        Stack(
          children: <Widget>[
            Container(
              color: Color.fromRGBO(69, 85, 79, 1),
              height: SizeConfig.getHeight(200),
              width: MediaQuery.of(context).size.width,
            ),
            Positioned(
              top: SizeConfig.getPadding(50),
              left: SizeConfig.getPadding(
                  MediaQuery.of(context).size.width / 3.5),
              child: Container(
                alignment: Alignment.topCenter,
                child: Image.asset(
                  'assets/images/feelver_banner.png',
                  width: MediaQuery.of(context).size.width / 2.5,
                ),
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(77),
              left: SizeConfig.getPadding(16),
              child: Container(
                child: GestureDetector(
                  onTap: () {
                    showDialog(
                      context: context,
                      builder: (BuildContext context) {
                        return NavDrawer();
                      },
                    );
                  },
                  child: Image.asset(
                    'assets/images/ic_menu.png',
                    height: SizeConfig.getWidth(24),
                    width: SizeConfig.getWidth(30),
                    fit: BoxFit.cover,
                  ),
                ),
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(77),
              right: SizeConfig.getPadding(60),
              child: Container(
                child: Image.asset(
                  'assets/images/ic_noti.png',
                  height: SizeConfig.getWidth(30),
                  width: SizeConfig.getWidth(30),
                  fit: BoxFit.cover,
                ),
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(77),
              right: SizeConfig.getPadding(20),
              child: InkWell(
//                onTap: () {
//                  Navigator.push(
//                    context,
//                    MaterialPageRoute(builder: (context) => LoginPage()),
//                  );
//                },
                child: Container(
                  child: Image.asset(
                    'assets/images/ic_userimg.png',
                    height: SizeConfig.getWidth(30),
                    width: SizeConfig.getWidth(30),
                    fit: BoxFit.cover,
                  ),
                ),
              ),
            ),
            _searchField(),
          ],
        ),
        _getlist(),
      ],
    );
  }

  _getlist() {
    return Expanded(
      child: Container(
        padding: EdgeInsets.only(
          top: SizeConfig.getPadding(16),
          left: SizeConfig.getPadding(16),
          right: SizeConfig.getPadding(16),
          bottom: SizeConfig.getPadding(10),
        ),
        child: presenter.shopModel == null
            ? Container()
            : ListView.builder(
                itemCount: presenter.shopModel.dATA[0].storeCode.length,
                itemBuilder: (context, i) {
//               new RaisedButton(
//                  child: new Text(
//                    'Load more ...',
//                    style: new TextStyle(
//                      color: Colors.black,
//                      fontWeight: FontWeight.bold,
//                    ),
//                  ),
//                  onPressed: () {
//                    var nextItems = new List<String>.generate(2, (i) {
//                      var itemId = i + presenter.shopModel.dATA[i].storeName.length;
//                      return "Item $itemId";
//                    });
//                    setState(() {
//                      entries.addAll(nextItems);
//                    });
//                  });
                  return _shopItem(
                      presenter.shopModel.dATA[i].storeName,
                      presenter.shopModel.dATA[i].storeCover,
                      presenter.shopModel.dATA[i].address,
                      presenter.shopModel.dATA[i].detail == null ? "" : presenter.shopModel.dATA[i].detail);
                }),
      ),
    );
  }

  Widget _shopItem(String title, String image, String address, String detail) {
    return Card(
      child: Column(
        children: <Widget>[
          Container(
            height: SizeConfig.getHeight(270),
            child: Stack(
              children: <Widget>[
                presenter.shopModel == null
                    ? Image.network(
                        'https://image.freepik.com/free-photo/girl-massage-spa-salon_110955-422.jpg',
                        height: SizeConfig.getWidth(180),
                        width: MediaQuery.of(context).size.width,
                        fit: BoxFit.cover,
                      )
                    : Image.network(
                        image,
                        height: SizeConfig.getWidth(180),
                        width: MediaQuery.of(context).size.width,
                        fit: BoxFit.cover,
                      ),
                Positioned(
                  right: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(16),
                  child: ImageIcon(
                    AssetImage('assets/images/ic_fav_list.png'),
                    color: Colors.white,
                    size: SizeConfig.getFontSize(30),
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(165),
                  child: Image.asset(
                    'assets/images/pin_list.png',
                    width: SizeConfig.getWidth(50),
                    height: SizeConfig.getWidth(50),
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(75),
                  top: SizeConfig.getPadding(190),
                  child: Text(
                    title,
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ),
                   Positioned(
                  left: SizeConfig.getPadding(280),
                  top: SizeConfig.getPadding(190),
                  child:Icon(Icons.star,color: Colors.orangeAccent,size: SizeConfig.getFontSize(18),),
                ),
                  Positioned(
                  left: SizeConfig.getPadding(300),
                  top: SizeConfig.getPadding(190),
                  child: Text(
                    "4.9",
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ),
              ],
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24)),
            alignment: Alignment.topLeft,
            child: presenter.shopModel == null
                ? Text(
                    "",
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  )
                : Text(
                    address,
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
          ),
          Container(
            padding: EdgeInsets.only(
                top: SizeConfig.getPadding(10),
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                bottom: SizeConfig.getPadding(10)),
            alignment: Alignment.topLeft,
            child: Text(
              detail,
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
   
  
        ],
      ),
    );
  }

  _searchField() {
    return Container(
      margin: EdgeInsets.only(
        top: 135,
        left: 24,
        right: 24,
      ),
      height: 55,
      child: TextField(
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(30.0),
              ),
            ),
            prefixIcon: IconButton(
                onPressed: () {
                  print('object');
                },
                icon: Icon(Icons.search, color: Colors.grey)),
            filled: true,
            hintText: 'ค้นหาแบบละเอียด',
            fillColor: Colors.white),
      ),
    );
  }
}
