import 'package:feelverapp/service/api.dart';
import 'package:feelverapp/ui/nearme/near_me_detail.dart';
import 'package:feelverapp/ui/nearme/near_me_list_presenter.dart';
import 'package:feelverapp/ui/shop/shop_main.dart';
import 'package:feelverapp/ui/shop/show_Nearby_places_presenter.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:feelverapp/util/Util.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

import '../splashscreen/splash_screen_page.dart';
import 'shop_list_detail.dart';

class ShopNearbyPlacesPage extends StatefulWidget {
  @override
  _ShopNearbyPlacesPageState createState() => _ShopNearbyPlacesPageState();
}

final List<String> detail = <String>[
  'SPA Cenvaree @ centara Grand Centralworld',
  'SPA Cenvaree @ centara Grand Centralworld',
  'SPA Cenvaree @ centara Grand Centralworld'
];
final List<String> place = <String>['พญาไทย', 'บางเขน', 'เกษตร'];

class _ShopNearbyPlacesPageState extends State<ShopNearbyPlacesPage>
    with TickerProviderStateMixin {
  ShopNearByPlacePresenter presenter;

  @override
  void initState() {
    super.initState();

    presenter = ShopNearByPlacePresenter(this);
    presenter.getnearme();
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Stack(
      children: <Widget>[
        Container(
            width: double.maxFinite,
//          color: Colors.orangeAccent,
            child: Column(
              children: <Widget>[
                Container(
//                  color: Colors.blue,
                  padding: EdgeInsets.only(
                      top: SizeConfig.getPadding(15),
                      bottom: SizeConfig.getPadding(10),
                      left: SizeConfig.getPadding(24),
                      right: SizeConfig.getPadding(24)),
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Text(
                        'สถานที่ใกล้เคียง',
                        style: TextStyle(
                          color: Color.fromRGBO(69, 85, 79, 1),
                          fontSize: SizeConfig.getFontSize(14),
                        ),
                      ),
                      Spacer(),
                      Text(
                        'ดูทั้งหมด',
                        style: TextStyle(
                          color: Colors.black,
                          fontSize: SizeConfig.getFontSize(14),
                        ),
                      ),
                    ],
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(left: SizeConfig.getPadding(24)),
                  alignment: Alignment.topLeft,
                  child: Wrap(
                    alignment: WrapAlignment.start,
                    spacing: 10.0, // gap between adjacent chips
                    runSpacing: 5.0, // gap between lines
                    children: <Widget>[
                      FilterChip(
                        label: Text(
                          "ทั้งหมด",
                          style: TextStyle(
                              color: Colors.white,
                              fontSize: SizeConfig.getFontSize(15),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.w500),
                        ),
                        backgroundColor: Color.fromRGBO(69, 85, 79, 1),
                        shape: StadiumBorder(
                          side: BorderSide(color: Colors.white),
                        ),
                        onSelected: (bool value) {
                          print("selected");
                          setState(() {});
                        },
                      ),
                      FilterChip(
                        label: Text(
                          "ที่เที่ยว",
                          style: TextStyle(
                              color: Colors.white,
                              fontSize: SizeConfig.getFontSize(15),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.w500),
                        ),
                        backgroundColor: Color.fromRGBO(69, 85, 79, 1),
                        shape: StadiumBorder(
                          side: BorderSide(color: Colors.white),
                        ),
                        onSelected: (bool value) {
                          print("selected");
                        },
                      ),
                      FilterChip(
                        label: Text(
                          "ที่กิน",
                          style: TextStyle(
                              color: Colors.white,
                              fontSize: SizeConfig.getFontSize(15),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.w500),
                        ),
                        backgroundColor: Color.fromRGBO(69, 85, 79, 1),
                        shape: StadiumBorder(
                          side: BorderSide(color: Colors.white),
                        ),
                        onSelected: (bool value) {
                          print("selected");
                        },
                      ),
                      FilterChip(
                        label: Text(
                          "ที่พัก",
                          style: TextStyle(
                              color: Colors.white,
                              fontSize: SizeConfig.getFontSize(15),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.w500),
                        ),
                        backgroundColor: Color.fromRGBO(69, 85, 79, 1),
                        shape: StadiumBorder(
                          side: BorderSide(color: Colors.white),
                        ),
                        onSelected: (bool value) {
                          print("selected");
                        },
                      ),
                      FilterChip(
                        label: Text(
                          "กิจกรรม",
                          style: TextStyle(
                              color: Colors.white,
                              fontSize: SizeConfig.getFontSize(15),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.w500),
                        ),
                        backgroundColor: Color.fromRGBO(69, 85, 79, 1),
                        shape: StadiumBorder(
                          side: BorderSide(color: Colors.white),
                        ),
                        onSelected: (bool value) {
                          print("selected");
                        },
                      ),
                    ],
                  ),
                ),
              ],
            )),
        getlist(),
      ],
    );
  }

  getlist() {
    print(presenter.getmodel);
    return presenter.getmodel == null
        ? Container(
            child: Center(
              child: CircularProgressIndicator(
                valueColor: new AlwaysStoppedAnimation<Color>(Colors.teal),
              ),
            ),
          )
        : Container(
            padding: EdgeInsets.only(
              top: SizeConfig.getPadding(80),
              left: SizeConfig.getPadding(16),
              right: SizeConfig.getPadding(16),
              bottom: SizeConfig.getPadding(10),
            ),
            child: ListView.builder(
                itemCount: presenter.getmodel.results.data.length,
                itemBuilder: (context, i) {
                  return _nearByItem(
                      presenter.getmodel.results.data[i].storeName,
                      presenter.getmodel.results.data[i].detail,
                      presenter.getmodel.results.data[i].storeLogo,
                      presenter.getmodel.results.data[i].address,
                      presenter.getmodel.results.data[i].location,
                      presenter.getmodel.results.data[i].updatedAt,
                      presenter.getmodel.results.data[i].distanceWithLocation
                          .toString());
                }),
          );
  }

  Widget _nearByItem(String title, String detail, String img, String address,
      String latlng, String date_time, String distanceWithLocation) {
    return InkWell(
      onTap: () {
        setState(() {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => ShopListDetail(
//                id: id,
                  ),
            ),
          );
        });
      },
      child: Card(
        margin: EdgeInsets.only(
            right: SizeConfig.getPadding(0),
            left: SizeConfig.getPadding(0),
            top: SizeConfig.getPadding(50),
            bottom: SizeConfig.getPadding(10)),
        child: Container(
//        color: Colors.red,
          margin: EdgeInsets.only(right: 15, left: 15, bottom: 20, top: 20),
//                          color: Colors.blueGrey,
          child: Column(
            children: <Widget>[
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 3,
                    child: Container(
//                          color: Colors.blue,
                      height: SizeConfig.getHeight(250),
                      child: presenter.getmodel == null
                          ? Image.asset(
                              "assets/images/demo_img.png",
                              fit: BoxFit.cover,
                            )
                          : Image.network(
                              Api.baseApiforimage + img,
                              fit: BoxFit.cover,
                            ),
                    ),
                  ),
                  Expanded(
                    flex: 5,
                    child: Container(
                      margin: EdgeInsets.only(left: 15),
//                          color: Colors.yellow,
                      height: SizeConfig.getHeight(260),
                      child: Column(
                        children: <Widget>[
                          Container(
                            padding: EdgeInsets.all(10),
                            alignment: Alignment.topLeft,
//                                  color: Colors.red,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                Text(
                                  title,
                                  style: TextStyle(
                                      color: Colors.black,
                                      fontSize: SizeConfig.getFontSize(18),
                                      fontFamily: "SF_Pro_Text",
                                      fontWeight: FontWeight.w500),
                                ),
                                SizedBox(
                                  height: 5,
                                ),
                                Text(
                                  "SPA Cenvaree @ Centara Grand CentralWorld Bangkok",
                                  style: TextStyle(
                                      color: Color(0xff969696),
                                      fontSize: SizeConfig.getFontSize(11),
                                      fontFamily: "SF_Pro_Text",
                                      fontWeight: FontWeight.w500),
                                ),
                              ],
                            ),
                          ),
                          Container(
                            padding: EdgeInsets.only(left: 10, right: 10),
                            alignment: Alignment.topLeft,
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.start,
                              children: <Widget>[
                                Row(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  children: <Widget>[
                                    Image.asset(
                                      'assets/images/pin_drop.png',
                                      height: 20,
                                      width: 20,
                                    ),
                                    SizedBox(
                                      width: 5,
                                    ),
                                    Text(
                                      "พญาไท กรุงเทพฯ",
                                      style: TextStyle(
                                        color: Colors.black,
                                        fontSize: SizeConfig.getFontSize(13),
                                        fontFamily: "SF_Pro_Text",
                                      ),
                                    ),
                                  ],
                                ),
                                SizedBox(
                                  height: 10,
                                ),
                                Row(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  children: <Widget>[
                                    Icon(
                                      Icons.access_time,
                                      color: Color(0xffEEAFB7),
                                    ),
                                    SizedBox(
                                      width: 5,
                                    ),
                                  ],
                                ),
                                SizedBox(
                                  height: 10,
                                ),
                                SizedBox(
                                  height: SizeConfig.getHeight(5),
                                ),
                              ],
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
