import 'package:feelverapp/ui/home/home.dart';
import 'package:feelverapp/ui/menu/menu.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/material.dart';

class Shop extends StatefulWidget {
  @override
  _ShopState createState() => _ShopState();
}

class _ShopState extends State<Shop> {
  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return ListView(padding: EdgeInsets.all(0), children: <Widget>[
      _setupView(),
    ]);
  }

  _setupView() {
    return Column(
      children: <Widget>[
        header(),
        SizedBox(height: 20),
        _listItem1(), bottom(),
        SizedBox(height: 30),
        Container(
          padding: EdgeInsets.only(left: SizeConfig.getPadding(34)),
          alignment: Alignment.topLeft,
          child: Wrap(
            alignment: WrapAlignment.start,
            spacing: 10.0, // gap between adjacent chips
            runSpacing: 5.0, // gap between lines
            children: <Widget>[
              FilterChip(
                label: Text(
                  "ทั้งหมด (10)",
                  style: TextStyle(
                      color: Colors.white,
                      fontSize: SizeConfig.getFontSize(15),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                backgroundColor: Color.fromRGBO(106, 179, 170, 1),
                shape: StadiumBorder(
                  side: BorderSide(color: Colors.white),
                ),
                onSelected: (bool value) {
                  print("selected");
                  setState(() {});
                },
              ),
              FilterChip(
                label: Text(
                  "ที่เที่ยว (5)",
                  style: TextStyle(
                      color: Colors.white,
                      fontSize: SizeConfig.getFontSize(15),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                backgroundColor: Color.fromRGBO(106, 179, 170, 1),
                shape: StadiumBorder(
                  side: BorderSide(color: Colors.white),
                ),
                onSelected: (bool value) {
                  print("selected");
                },
              ),
              FilterChip(
                label: Text(
                  "ที่กิน (3)",
                  style: TextStyle(
                      color: Colors.white,
                      fontSize: SizeConfig.getFontSize(15),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                backgroundColor: Color.fromRGBO(106, 179, 170, 1),
                shape: StadiumBorder(
                  side: BorderSide(color: Colors.white),
                ),
                onSelected: (bool value) {
                  print("selected");
                },
              ),
              FilterChip(
                label: Text(
                  "ที่พัก (1)",
                  style: TextStyle(
                      color: Colors.white,
                      fontSize: SizeConfig.getFontSize(15),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                backgroundColor: Color.fromRGBO(106, 179, 170, 1),
                shape: StadiumBorder(
                  side: BorderSide(color: Colors.white),
                ),
                onSelected: (bool value) {
                  print("selected");
                },
              ),
              FilterChip(
                label: Text(
                  "กิจกรรม (1)",
                  style: TextStyle(
                      color: Colors.white,
                      fontSize: SizeConfig.getFontSize(15),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                backgroundColor: Color.fromRGBO(106, 179, 170, 1),
                shape: StadiumBorder(
                  side: BorderSide(color: Colors.white),
                ),
                onSelected: (bool value) {
                  print("selected");
                },
              ),
            ],
          ),
        ),
        SizedBox(height: 30),

        // _getlist(),
      ],
    );
  }

  _getlist() {
    final List<String> entries = <String>[
      'Ivory Relax and Spa',
      'Sunshine Spa & Massage',
      'Mandarin Ginger Spa'
    ];
    return Expanded(
      child: Container(
        padding: EdgeInsets.only(
          top: SizeConfig.getPadding(16),
          left: SizeConfig.getPadding(16),
          right: SizeConfig.getPadding(16),
          bottom: SizeConfig.getPadding(10),
        ),
        child: ListView.builder(
          itemCount: entries.length,
          itemBuilder: (context, i) {
            return _listItem1();
          },
        ),
      ),
    );
  }

  _rating() {
    return Container(
      height: SizeConfig.getHeight(80),
      child: Row(
        children: <Widget>[
          Text(
            '5.0',
            textAlign: TextAlign.right,
            style: TextStyle(
                color: Colors.black38,
                fontSize: SizeConfig.getFontSize(16),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w700),
          ),SizedBox(width:5),
          Image.asset(
            'assets/images/ic_star_active.png',
            width: SizeConfig.getWidth(16),
            height: SizeConfig.getWidth(16),
          ),
          Image.asset(
            'assets/images/ic_star_active.png',
            width: SizeConfig.getWidth(16),
            height: SizeConfig.getWidth(16),
          ),
          Image.asset(
            'assets/images/ic_star_active.png',
            width: SizeConfig.getWidth(16),
            height: SizeConfig.getWidth(16),
          ),
          Image.asset(
            'assets/images/ic_star_active.png',
            width: SizeConfig.getWidth(16),
            height: SizeConfig.getWidth(16),
          ),
          Image.asset(
            'assets/images/ic_star_active.png',
            width: SizeConfig.getWidth(16),
            height: SizeConfig.getWidth(16),
          ),
        ],
      ),
    );
  }

  Widget _listItem1() {
    return Container(
        padding: EdgeInsets.only(
            left: SizeConfig.getPadding(24), right: SizeConfig.getPadding(24)),
        alignment: Alignment.center,
        child: Column(
          children: <Widget>[
            Text(
              "SPA Cenvaree @ Centara \nGrand CentralWorld Bangkok",
              style: TextStyle(fontSize: 25.0, color: Colors.black),
            ),
            _rating(),
            Row(
              children: <Widget>[
                Text(
                  "Available Payment",
                  style: TextStyle(fontSize: 25.0, color: Colors.black),
                )
              ],
            ),
            Row(
              children: <Widget>[
                Image.asset(
                  'assets/images/mastercard_logo.png',
                  width: SizeConfig.getWidth(50),
                  height: SizeConfig.getWidth(50),
                ),
              ],
            ),

            Text(
              "A four hand massage performed by two therapists in unison, this experience coordinates a blend of Thai, Swedish, Shiatsu and Reflexology techniques using deep rhythmic movement to leave you feeling completely renewed. Top Tip: This is Khun Tara’s (our Group Spa Director) favourite massage. She loves it because having the sensation of two therapists working on you means your mind can’t concentrate on one area and it basically just gives up! This massage almost forces you to switch your mind off. Try it and see.",
              style: TextStyle(fontSize: 18.0, color: Colors.black),
            ),

            //  Container(
            //             alignment: Alignment.topCenter,

            //             child:   Image.network(
            //                 'https://image.freepik.com/free-photo/girl-massage-spa-salon_110955-422.jpg',
            //                 height: SizeConfig.getHeight(300),
            //                 width: MediaQuery.of(context).size.width,
            //                 fit: BoxFit.cover,
            //               ),
            //           ),
          ],
        ));
  }

  Widget header() {
    return Container(
      child: Stack(
        children: <Widget>[
          Container(
            color: Color.fromRGBO(69, 85, 79, 1),
            height: SizeConfig.getHeight(350),
            width: MediaQuery.of(context).size.width,
            
          ),
          Positioned(
            top: SizeConfig.getPadding(0),
            child: Container(
              alignment: Alignment.topCenter,
              child: Image.network(
                'https://image.freepik.com/free-photo/girl-massage-spa-salon_110955-422.jpg',
                height: SizeConfig.getHeight(350),
                width: MediaQuery.of(context).size.width,
                fit: BoxFit.cover,
              ),
            ),
          ),Positioned(
            top: SizeConfig.getPadding(0),
            child: Container(
                 height: SizeConfig.getHeight(350),
                width: MediaQuery.of(context).size.width,
              alignment: Alignment.topCenter,
              color: Colors.deepOrangeAccent.withOpacity(0.4)
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(170),
            right: SizeConfig.getPadding(30),
            child: Container(
              child: Text(
                "SPA Cenvaree @ Centara \nGrand CentralWorld Bangkok",
                style: TextStyle(fontSize: 18.0, color: Colors.white),
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(172),
            left: SizeConfig.getPadding(10),
            child: InkWell(
//                onTap: () {
//                  Navigator.push(
//                    context,
//                    MaterialPageRoute(builder: (context) => LoginPage()),
//                  );
//                },
              child: Container(
                child: Image.asset(
                  'assets/images/ic_userimg.png',
                  height: SizeConfig.getWidth(80),
                  width: SizeConfig.getWidth(80),
                  fit: BoxFit.cover,
                ),
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(220),
            left: SizeConfig.getPadding(100),
            child: Container(
              padding: EdgeInsets.only(left: 5),
              child: Row(
                children: <Widget>[
                  Column(
                    children: <Widget>[
                      SizedBox(
                          width: 70.0,
                          height: 35.0,
                          child: FlatButton(
                            color: Color.fromRGBO(106, 179, 170, 1),
                            textColor: Colors.white,
                            disabledColor: Colors.grey,
                            disabledTextColor: Colors.black,
                            padding: EdgeInsets.all(0.0),
                            splashColor: Colors.blueAccent,
                            onPressed: () {
                              /*...*/
                            },
                            shape: new RoundedRectangleBorder(
                                borderRadius: new BorderRadius.circular(20.0)),
                            child: Text(
                              "ถูกใจ",
                              style: TextStyle(fontSize: 12.0),
                            ),
                          ))
                    ],
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(5),
                  ),
                  SizedBox(
                      width: 70.0,
                      height: 30.0,
                      child: FlatButton(
                        color: Color.fromRGBO(106, 179, 170, 1),
                        textColor: Colors.white,
                        disabledColor: Colors.grey,
                        disabledTextColor: Colors.black,
                        padding: EdgeInsets.all(0.0),
                        splashColor: Colors.blueAccent,
                        onPressed: () {
                          /*...*/
                        },
                        shape: new RoundedRectangleBorder(
                            borderRadius: new BorderRadius.circular(20.0)),
                        child: Text(
                          "ติดตาม",
                          style: TextStyle(fontSize: 12.0),
                        ),
                      )),
                  SizedBox(
                    width: SizeConfig.getWidth(5),
                  ),
                  SizedBox(
                      width: 70.0,
                      height: 30.0,
                      child: FlatButton(
                        color: Color.fromRGBO(106, 179, 170, 1),
                        textColor: Colors.white,
                        disabledColor: Colors.grey,
                        disabledTextColor: Colors.black,
                        padding: EdgeInsets.all(0.0),
                        splashColor: Colors.blueAccent,
                        onPressed: () {
                          /*...*/
                        },
                        shape: new RoundedRectangleBorder(
                            borderRadius: new BorderRadius.circular(20.0)),
                        child: Text(
                          "แชร์",
                          style: TextStyle(fontSize: 12.0),
                        ),
                      ))
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget bottom() {
    return Container(
      child: Stack(
        children: <Widget>[
          Container(
            color: Color.fromRGBO(106, 179, 170, 1),
          
            height: SizeConfig.getHeight(470),
            width: MediaQuery.of(context).size.width,
          ),
          Positioned(
            top: SizeConfig.getPadding(0),
            child: Container(
              alignment: Alignment.topCenter,
              child: Image.network(
                'https://image.freepik.com/free-photo/girl-massage-spa-salon_110955-422.jpg',
                height: SizeConfig.getHeight(300),
                width: MediaQuery.of(context).size.width,
                fit: BoxFit.cover,
              ),
            ),
          ),
          Positioned(
            bottom: SizeConfig.getPadding(100),
            left: SizeConfig.getPadding(40),
            child: Container(
              child: Text(
                "เวลาทำการ",
                style: TextStyle(fontSize: 18.0, color: Colors.white),
              ),
            ),
          ),
          Positioned(
            bottom: SizeConfig.getPadding(50),
            left: SizeConfig.getPadding(40),
            child: Container(
              child: Text(
                "จันทร์ - ศุกร์ 10:00 AM - 08:00 PM\nเสาร์ - อาทิตย์ 10:00 AM - 10:00 PM",
                style: TextStyle(fontSize: 18.0, color: Colors.white),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
