import 'package:feelverapp/ui/review_shop/review_shop_presenter.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:feelverapp/util/rating_star.dart';
import 'package:flutter/material.dart';

class ReviewShopPage extends StatefulWidget {
  @override
  _ReviewShopPageState createState() => _ReviewShopPageState();
}

class _ReviewShopPageState extends State<ReviewShopPage> {
  double rate1 = 0;

  ReviewshopPresenter presenter;

  @override
  void initState() {
    super.initState();

    presenter = ReviewshopPresenter(this);
    presenter.Commentlist();
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Color.fromRGBO(69, 85, 79, 1),
        elevation: 0,
        centerTitle: true,
        title: Text(
          'ชื่อร้านค้า',
          style: TextStyle(
              color: Colors.white,
              fontSize: SizeConfig.getFontSize(20),
              fontFamily: "SF_Pro_Text",
              fontWeight: FontWeight.w500),
        ),
      ),
      body: _setupView(),
    );
  }

  _setupView() {
    return Container(
      child: Column(
        children: <Widget>[
          texttop(),
          star(),
          containt(),
        ],
      ),
    );
  }

  Widget containt() {
    return Expanded(
      child: Container(
        child: presenter.reviewShopModel == null
            ? Container()
            : ListView.builder(
                itemCount: presenter.reviewShopModel.result[0].comment.length,
                itemBuilder: (context, i) {
                  print(presenter.reviewShopModel.result[0].comment[i].infoCustomer.name);
                  return list(
                    presenter.reviewShopModel.result[0].comment[i].infoCustomer.name,
                    presenter.reviewShopModel.result[0].comment[i].infoCustomer.image,
                    presenter.reviewShopModel.result[0].comment[i].commentContent,
                  );
                }),
      ),
    );
  }

  Widget star() {
    return Container(
//      color: Colors.blue,
      margin: EdgeInsets.only(
          right: SizeConfig.getPadding(16),
          left: SizeConfig.getPadding(16),
          top: SizeConfig.getPadding(10),
          bottom: SizeConfig.getPadding(10)),
      child: Container(
//        color: Colors.red,
        padding: EdgeInsets.only(
          right: SizeConfig.getPadding(15),
          left: SizeConfig.getPadding(15),
          top: SizeConfig.getPadding(10),
        ),
//        color: Colors.blueGrey,
        child: Column(
          children: <Widget>[
            Container(
//              color: Colors.green,
              child: Column(
                children: <Widget>[
                  Row(
                    children: <Widget>[
                      Text(
                        '4.4',
                        style: TextStyle(
                          fontSize: SizeConfig.getFontSize(16),
                          color: Color(0xFFD5D5D5),
                        ),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(8),
                      ),
                      RatingStar(
                        isRating: true,
                        rate: rate1,
                        starSize: 20,
                        onChangeRate: (i) {
                          setState(() {
                            rate1 = i;
                            print(i);
                          });
                        },
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(8),
                      ),
                      Text(
                        '(221)',
                        style: TextStyle(
                          fontSize: SizeConfig.getFontSize(16),
                          color: Color(0xFFD5D5D5),
                        ),
                      ),
                    ],
                  ),
                  SizedBox(
                    height: SizeConfig.getHeight(35),
                  ),
                  Row(
                    children: <Widget>[
                      Text(
                        'คุ้มค่า',
                        style: TextStyle(
                            fontSize: SizeConfig.getFontSize(16),
                            color: Colors.black),
                      ),
                      Spacer(),
                      RatingStar(
                        isRating: true,
                        rate: rate1,
                        starSize: 20,
                        onChangeRate: (i) {
                          setState(() {
                            rate1 = i;
                            print(i);
                          });
                        },
                      ),
                    ],
                  ),
                  SizedBox(
                    height: SizeConfig.getHeight(15),
                  ),
                  Row(
                    children: <Widget>[
                      Text(
                        'บรรยากาศดี',
                        style: TextStyle(
                            fontSize: SizeConfig.getFontSize(16),
                            color: Colors.black),
                      ),
                      Spacer(),
                      RatingStar(
                        isRating: true,
                        rate: rate1,
                        starSize: 20,
                        onChangeRate: (i) {
                          setState(() {
                            rate1 = i;
                            print(i);
                          });
                        },
                      ),
                    ],
                  ),
                  SizedBox(
                    height: SizeConfig.getHeight(15),
                  ),
                  Row(
                    children: <Widget>[
                      Text(
                        'บริการเยี่ยม',
                        style: TextStyle(
                            fontSize: SizeConfig.getFontSize(16),
                            color: Colors.black),
                      ),
                      Spacer(),
                      RatingStar(
                        isRating: true,
                        rate: rate1,
                        starSize: 20,
                        onChangeRate: (i) {
                          setState(() {
                            rate1 = i;
                            print(i);
                          });
                        },
                      ),
                    ],
                  ),
                  SizedBox(
                    height: SizeConfig.getHeight(15),
                  ),
                  Row(
                    children: <Widget>[
                      Text(
                        'สะอาด',
                        style: TextStyle(
                            fontSize: SizeConfig.getFontSize(16),
                            color: Colors.black),
                      ),
                      Spacer(),
                      RatingStar(
                        isRating: true,
                        rate: rate1,
                        starSize: 20,
                        onChangeRate: (i) {
                          setState(() {
                            rate1 = i;
                            print(i);
                          });
                        },
                      ),
                    ],
                  ),
                  SizedBox(
                    height: SizeConfig.getHeight(15),
                  ),
                ],
              ),
            ),
            Divider(
              color: Color(0xFF606060),
            ),
          ],
        ),
      ),
    );
  }

  Widget list(String name,String image,String content) {
    return Card(
      child: Container(
//          color: Colors.deepPurpleAccent,
          margin: EdgeInsets.only(
            right: SizeConfig.getPadding(20),
            left: SizeConfig.getPadding(20),
            top: SizeConfig.getPadding(10),
            bottom: SizeConfig.getPadding(10),
          ),
          child: Column(
            children: <Widget>[
              Row(
                children: <Widget>[
                  ClipRRect(
                    borderRadius: BorderRadius.circular(50),
                    child: presenter.reviewShopModel == null ? Image.asset(
                      'assets/images/ic_userimg.png',
                      width: 55.0,
                      height: 55.0,
                      fit: BoxFit.cover,
                    ) : Image.network(
                      "https://backend.feelver.com/"+image,
                      width: 55.0,
                      height: 55.0,
                      fit: BoxFit.cover,)
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(10),
                  ),
                  Expanded(
                    child: Container(
//                      color: Colors.green,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                           Row(
                              children: <Widget>[
                                Text(
                                  name,
                                  style: TextStyle(
                                      fontSize: SizeConfig.getFontSize(20),
                                      color: Colors.black),
                                ),
                                Spacer(),
                                Container(
                                  child: Icon(Icons.more_vert),
                                )
                              ],
                            ),

                          SizedBox(
                            height: SizeConfig.getHeight(5),
                          ),
                          Container(
//                            color: Colors.blue,
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                RatingStar(
                                  isRating: true,
                                  rate: rate1,
                                  starSize: 20,
                                  onChangeRate: (i) {
                                    setState(() {
                                      rate1 = i;
                                      print(i);
                                    });
                                  },
                                ),
                              ],
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                ],
              ),
              Container(
//                color: Colors.blue,
                child: Column(
                  children: <Widget>[
                    Padding(
                      padding: const EdgeInsets.only(
                          top: 10, bottom: 10, left: 2, right: 2),
                      child: Text(
                        content,
                        style: TextStyle(
                          fontSize: SizeConfig.getFontSize(12),
                        ),
                      ),
                    ),
                    Row(
                      children: <Widget>[
                        RaisedButton(
                          color: Color(0xFF3694A3),
                          shape: RoundedRectangleBorder(
                            borderRadius: BorderRadius.circular(20),
                          ),
                          onPressed: () {},
                          child: Text(
                            "บริการดีมาก",
                            style: TextStyle(
                              color: Colors.white,
                            ),
                          ),
                        ),
                        SizedBox(
                          width: SizeConfig.getWidth(14),
                        ),
                        RaisedButton(
                          color: Color(0xFF3694A3),
                          shape: RoundedRectangleBorder(
                            borderRadius: BorderRadius.circular(20),
                          ),
                          onPressed: () {},
                          child: Padding(
                            padding: const EdgeInsets.only(
                              right: 10,
                              left: 10,
                            ),
                            child: Text(
                              "คุ้มค่าดี",
                              style: TextStyle(
                                color: Colors.white,
                              ),
                            ),
                          ),
                        ),
                      ],
                    ),
                    SizedBox(
                      height: SizeConfig.getHeight(10),
                    ),
                  ],
                ),
              ),
            ],
          )),
    );
  }

  Widget texttop() {
    return Container(
      margin: EdgeInsets.only(
          right: SizeConfig.getPadding(16),
          left: SizeConfig.getPadding(16),
          top: SizeConfig.getPadding(15),
          bottom: SizeConfig.getPadding(5)),
      child: Row(
        children: <Widget>[
          Text(
            'รีวิว(จากผู้ใช้บริการจริง)',
            style: TextStyle(
              color: Color(0xFF6AB3AA),
              fontSize: SizeConfig.getFontSize(14),
            ),
          ),
          Spacer(),
        ],
      ),
    );
  }
}
