
import 'package:feelverapp/ui/home/home.dart';
import 'package:feelverapp/ui/login/login_presenter.dart';
//import 'package:feelverapp/ui/login/login_presenter.dart';
import 'package:feelverapp/ui/register/register_email.dart';
import 'package:feelverapp/ui/register/register_presenter.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class Registerpage extends StatefulWidget {
  @override
  _RegisterpageState createState() => _RegisterpageState();
}

class _RegisterpageState extends State<Registerpage> with TickerProviderStateMixin {
  TabController _tabController;
   RegisterPresenter presenter;
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    presenter = RegisterPresenter(this);
   
    _tabController = TabController(length: 2, vsync: this);
     _tabController.addListener(_handleTabSelection);
//    registerBloc = RegisterBloc(this);
//    loginBloc = LoginBloc(this);
  }
   void _handleTabSelection() {
    setState(() {});
  }
 @override
  void dispose() {
    super.dispose();
    _tabController.dispose();
    
  }

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
    );
  }

  _setupView() {
    return Container(
      
      
        
      child: Column(
        children: <Widget>[
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(60),
                right: SizeConfig.getPadding(40),
                top: SizeConfig.getPadding(60)),
            child: Image.asset(
              'assets/images/logo.png',
              width: SizeConfig.getWidth(MediaQuery.of(context).size.width),
              fit: BoxFit.fitWidth,
            ),
          ),
          SizedBox(
            height: SizeConfig.getWidth(24),
          ),
          TabBar(
            indicatorColor: Color.fromRGBO(106, 179, 170, 1),
            unselectedLabelColor: Colors.grey[400],
            labelColor: Colors.black,
            controller: _tabController,
//          onTap: (v) => registerBloc.changeMethodRegister(v),
            tabs: <Widget>[
              Tab(
                child: Text(
                  'อีเมล์',
                  style: TextStyle(
                    fontSize: SizeConfig.getFontSize(16),
                  ),
                ),
              ),
              Tab(
                child: Text(
                  'เบอร์โทร',
                  style: TextStyle(fontSize: SizeConfig.getFontSize(16)),
                ),
              ),
            ],
          ),
          SizedBox(height: SizeConfig.getWidth(30)),
           Expanded(
                        child: new Container(
              // height: double.maxFinite,
              child: new TabBarView(
                controller: _tabController,
                children: <Widget>[
               _formLogin(),
               _phoneregis()

              // Container(
              //   color: Colors.red,
              // ),
              // Container(
              //   color: Colors.green,
              // ),
        


                ],
              ),
          ),
           ),
         // _phoneLogin(),
        ],
      ),
    );
  }

  Widget _formLogin() {
    print("index = " +"${_tabController.index}");
    return SingleChildScrollView(
      child: Form(
        child: Column(
          children: <Widget>[
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'อีเมล์',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                vertical: SizeConfig.getPadding(8.0),
                horizontal: SizeConfig.getPadding(24),
              ),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(
                    SizeConfig.getPadding(50.0),
                  ),
                ),
                child: TextFormField(

                 controller: presenter.emailCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'email', key: 'login') +
//                        ' / ' +
//                        allTranslations.text(
//                            key2: 'tel_number', key: 'register'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                ),
              ),
            ),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'รหัสผ่าน',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(8.0),
                  horizontal: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius:
                      BorderRadius.circular(SizeConfig.getPadding(50.0)),
                ),
                child: TextFormField(
                    controller: presenter.passCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                  obscureText: true,
                ),
              ),
            ),
                   Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'ชื่อ',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(8.0),
                  horizontal: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius:
                  BorderRadius.circular(SizeConfig.getPadding(50.0)),
                ),
                child: TextFormField(
              controller: presenter.firstnameCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                
                ),
              ),
            ),
                   Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'นามสกุล',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(8.0),
                  horizontal: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius:
                  BorderRadius.circular(SizeConfig.getPadding(50.0)),
                ),
                child: TextFormField(
                   controller: presenter.lastnameCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                 
                ),
              ),
            ),
            SizedBox(
              height: SizeConfig.getWidth(24),
            ),
          
            _submitLoginButton(),
           
          ],
        ),
      ),
    );
  }

  Widget _phoneregis() {
    print("index = " +"${_tabController.index}");
    return SingleChildScrollView(
      child: Form(
        child: Column(
          children: <Widget>[
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'เบอร์โทร',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                vertical: SizeConfig.getPadding(8.0),
                horizontal: SizeConfig.getPadding(24),
              ),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(
                    SizeConfig.getPadding(50.0),
                  ),
                ),
                child: TextFormField(
             controller: presenter.phonenumberCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'email', key: 'login') +
//                        ' / ' +
//                        allTranslations.text(
//                            key2: 'tel_number', key: 'register'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                ),
              ),
            ),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'รหัสผ่าน',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(8.0),
                  horizontal: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius:
                  BorderRadius.circular(SizeConfig.getPadding(50.0)),
                ),
                child: TextFormField(
                   controller: presenter.passCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                  obscureText: true,
                ),
              ),
            ),
            SizedBox(
              height: SizeConfig.getWidth(24),
            ),
               
            _submitLoginButton(),
         
          ],
        ),
      ),
    );
  }

  _submitLoginButton() {
    return Padding(
      padding: EdgeInsets.symmetric(
          vertical: SizeConfig.getPadding(20.0),
          horizontal: SizeConfig.getPadding(32)),
      child: Container(
        height: SizeConfig.getWidth(55),
        child: CupertinoButton(
          color: Color.fromRGBO(106, 179, 170, 1),
          padding: EdgeInsets.all(0),
          borderRadius: BorderRadius.all(Radius.circular(50)),
          onPressed: () {
    if (_tabController.index==0){
            presenter.letCheckData();}
            else{

              presenter.letCheckData_phone();

            }
            // Navigator.push(
            //   context,
            //   MaterialPageRoute(builder: (context) => HomePage()),
            // );
//            if (loginBloc.formKey.currentState.validate()) {
//              loginBloc.getLogin();
//            }
          },
          child: Center(
            child: Text(
              'สมัครสมาชิก',
              style: TextStyle(color: Colors.white),
            ),
          ),
        ),
      ),
    );
  }



}
