import 'package:feelverapp/ui/favorite/favorite.dart';
import 'package:feelverapp/ui/menu/menu.dart';
import 'package:feelverapp/ui/payment/payment_detail.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class Payment extends StatefulWidget {
  @override
  _PaymentState createState() => _PaymentState();
}

class _PaymentState extends State<Payment> {
  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
      bottomNavigationBar: Container(
        color: Color.fromRGBO(69, 85, 79, 1),
        height: SizeConfig.getWidth(180),
        child: Column(
          children: <Widget>[
            Container(
              margin: EdgeInsets.only(
                left: SizeConfig.getPadding(15),
                top: SizeConfig.getPadding(17),
              ),
              child: Row(
                children: <Widget>[
                  Icon(
                    Icons.local_offer,
                    color: Colors.white,
                  ),
                  Padding(
                    padding: const EdgeInsets.only(left: 7, right: 12),
                    child: Text(
                      'โค้ดส่วนลด',
                      style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(16),
                      ),
                    ),
                  ),
                  Container(
                    height: SizeConfig.getHeight(40),
                    width: SizeConfig.getWidth(180),
                    color: Colors.white,
                    child: TextField(
                      decoration: InputDecoration(
                        border: InputBorder.none,
                      ),
                    ),
                  ),
                  IconButton(
                      icon: Icon(
                        Icons.keyboard_arrow_right,
                        color: Colors.white,
                        size: 40,
                      ),
                      onPressed: () {}),
                ],
              ),
            ),
            Divider(
              color: Colors.white,
              height: SizeConfig.getHeight(35),
              indent: 20,
              endIndent: 20,
            ),
            Container(
              child: Row(
                children: <Widget>[
                  Spacer(),
                  Container(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'ยอดชำระเงินทั้งหมด',
                          style: TextStyle(
                            color: Colors.white,
                            fontSize: SizeConfig.getFontSize(14),
                          ),
                        ),
                        Text(
                          '฿2,000',
                          style: TextStyle(
                            color: Color(0xFFEEAFB7),
                            fontSize: SizeConfig.getFontSize(24),
                          ),
                        ),
                      ],
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(
                      right: SizeConfig.getPadding(10),
                      left: SizeConfig.getPadding(12),
                    ),
                    child: RaisedButton(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(30.0),
                      ),
                      onPressed: () {
                        Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder: (context) => Paymentdetail(),
                          ),
                        );
                      },
                      padding: EdgeInsets.only(
                        left: SizeConfig.getPadding(35),
                        right: SizeConfig.getPadding(35),
                        top: SizeConfig.getPadding(15),
                        bottom: SizeConfig.getPadding(15),
                      ),
                      color: Color(0xFFEEAFB7),
                      child: Text(
                        'ยืนยัน',
                        style: TextStyle(
                          fontSize: SizeConfig.getFontSize(16),
                          color: Colors.white,
                        ),
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  _setupView() {
    return Column(
      children: <Widget>[
        header(),
        Container(
          padding: EdgeInsets.only(
              left: SizeConfig.getPadding(24), top: SizeConfig.getPadding(24)),
          alignment: Alignment.topLeft,
          child: Text(
            'เเพ็คเกจที่คุณเลือก',
            style: TextStyle(
              color: Colors.black,
              fontSize: SizeConfig.getFontSize(16),
              fontFamily: "SF_Pro_Text",
              fontWeight: FontWeight.w700,
            ),
          ),
        ),
        // SizedBox(
        //   // height: SizeConfig.getHeight(20),
        // ),
        _getlist(),
      ],
    );
  }


  _getlist() {
    return Expanded(
      child: Container(
        margin: EdgeInsets.only(
          top: SizeConfig.getPadding(0),
          left: SizeConfig.getPadding(16),
          right: SizeConfig.getPadding(16),
          bottom: SizeConfig.getPadding(16),
        ),
//        child: presenter.shopModel == null
//            ? Container()
//            :
        child: ListView.builder(
          itemCount: 3,
          itemBuilder: (context, i) {
            return list1();
          },
        ),
      ),
    );
  }

  Widget list1() {
    return Card(
      elevation: 5,
      child: Container(
        padding: EdgeInsets.only(
          left: SizeConfig.getPadding(8),
          top: SizeConfig.getPadding(8),
          bottom: SizeConfig.getPadding(16),
        ),
        child: Column(
          children: <Widget>[

            SizedBox(
              height: SizeConfig.getHeight(16),
            ),


            Row(
              children: <Widget>[
                Image.asset(
                  'assets/images/demo_img.png',
                  height: SizeConfig.getPadding(90),
                  width: SizeConfig.getPadding(80),
                  fit: BoxFit.cover,
                ),
                Expanded(
                  child: Container(
//                  color: Colors.green,
                    padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(8),
                    ),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          'Ivory Relax and Spa',
                          style: TextStyle(
                              color: Colors.black,
                              fontSize: SizeConfig.getFontSize(16),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.w700),
                        ),
                        SizedBox(
                          height: SizeConfig.getHeight(12),
                        ),
                        Text(
                          'นวดแผนไทย',
                          style: TextStyle(
                              color: Colors.black,
                              fontSize: SizeConfig.getFontSize(16),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.w500),
                        ),
                        SizedBox(
                          height: SizeConfig.getHeight(15),
                        ),
                        Row(
                          children: <Widget>[
                            Text(
                              '฿1,200.00',
                              style: TextStyle(
                                fontSize: SizeConfig.getFontSize(20),
                                color: Color(0xFFFD2956),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w700,
                              ),
                            ),
                            Spacer(),
                            Container(padding: EdgeInsets.only(right: SizeConfig.getPadding(16)),
                              child: Text(
                                'x1',
                                style: TextStyle(
                                  color: Color(0xFF9D9D9D),
                                  fontSize: SizeConfig.getFontSize(20),
                                ),
                              ),
                            ),
                          ],
                        ),
                      ],
                    ),
                  ),
                ),
              ],
            ),
//          Divider(
//            color: Colors.black,
//            height: 40,
//          ),
          ],
        ),
      ),
    );
  }

  Widget payment() {
    return Container(
//      color: Colors.green,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          Text(
            'ช่องทางการชำระเงิน',
            style: TextStyle(
              color: Colors.black,
              fontSize: SizeConfig.getFontSize(18),
              fontWeight: FontWeight.bold,
            ),
          ),
          SizedBox(
            height: SizeConfig.getHeight(5),
          ),
          Row(
            children: <Widget>[
              Image.asset(
                'assets/images/no-image.png',
                height: SizeConfig.getPadding(50),
                width: SizeConfig.getPadding(50),
              ),
              SizedBox(
                width: SizeConfig.getWidth(5),
              ),
              Text(
                'บัตรเครดิต/บัตรเดบิต',
                style: TextStyle(
                  color: Colors.black,
                  fontSize: SizeConfig.getFontSize(16),
                  fontWeight: FontWeight.bold,
                ),
              ),
            ],
          ),
          Divider(
            color: Colors.black,
            height: 10,
          ),
          Row(
            children: <Widget>[
              Image.asset(
                'assets/images/no-image.png',
                height: SizeConfig.getPadding(50),
                width: SizeConfig.getPadding(50),
              ),
              SizedBox(
                width: SizeConfig.getWidth(5),
              ),
              Text(
                'All Pay',
                style: TextStyle(
                  color: Colors.black,
                  fontSize: SizeConfig.getFontSize(16),
                  fontWeight: FontWeight.bold,
                ),
              ),
            ],
          ),
          Divider(
            color: Colors.black,
            height: 10,
          ),
          Row(
            children: <Widget>[
              Image.asset(
                'assets/images/no-image.png',
                height: SizeConfig.getPadding(50),
                width: SizeConfig.getPadding(50),
              ),
              SizedBox(
                width: SizeConfig.getWidth(5),
              ),
              Text(
                'QF Pay',
                style: TextStyle(
                  color: Colors.black,
                  fontSize: SizeConfig.getFontSize(16),
                  fontWeight: FontWeight.bold,
                ),
              ),
            ],
          ),
          Divider(
            color: Colors.black,
            height: 10,
          ),
        ],
      ),
    );
  }

  Widget header() {
    return Stack(
      children: <Widget>[
        Container(
          color: Color.fromRGBO(69, 85, 79, 1),
          height: SizeConfig.getHeight(150),
          width: MediaQuery.of(context).size.width,
        ),
        Positioned(
          top: SizeConfig.getPadding(50),
          left: SizeConfig.getPadding(MediaQuery.of(context).size.width / 3.3),
          child: Container(
            alignment: Alignment.topCenter,
            child: Image.asset(
              'assets/images/feelver_banner.png',
              width: MediaQuery.of(context).size.width / 2.5,
            ),
          ),
        ),
        Positioned(
          top: SizeConfig.getPadding(70),
          left: SizeConfig.getPadding(16),
          child: Container(
            child: GestureDetector(
              onTap: () {
                Navigator.pop(context);
              },
              child: Icon(
                Icons.keyboard_arrow_left,
                color: Colors.white,
                size: SizeConfig.getFontSize(40),
              ),
            ),
          ),
        ),
      ],
    );
  }
}
