import 'package:feelverapp/ui/guest_info/guest_info.dart';
import 'package:feelverapp/ui/menu/menu.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/material.dart';
import 'package:flutter_datetime_picker/flutter_datetime_picker.dart';

class PaymentBookingDateTime extends StatefulWidget {
  String bith = 'ปี / เดือน / วัน / เวลาเข้าใช้บริการ';
  DateTime day;

  @override
  _PaymentBookingDateTimeState createState() => _PaymentBookingDateTimeState();
}

class _PaymentBookingDateTimeState extends State<PaymentBookingDateTime> {
  bool checkBoxValue = false;
  int a = 1;
  int b = 1;

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
      bottomNavigationBar: Container(
        color: Color.fromRGBO(69, 85, 79, 1),
        height: SizeConfig.getWidth(120),
        child: Column(
          children: <Widget>[
            Container(
              margin: EdgeInsets.only(
                left: SizeConfig.getPadding(0),
                top: SizeConfig.getPadding(0),
              ),
            ),
            Container(
              alignment: Alignment.center,
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(10),
                right: SizeConfig.getPadding(15),
              ),
              child: Row(
                children: <Widget>[
                  Checkbox(
                    checkColor: Color(0xFFEEAFB7),
                    activeColor: Colors.white,
                    value: checkBoxValue,
                    onChanged: (bool value) {
                      setState(() {
                        print(value);
                        checkBoxValue = value;
                      });
                    },
                  ),
                  Text(
                    'หากจองให้คนอื่น กรุณาทำเครื่องหมายช่องนี้',
                    style: TextStyle(
                      color: Colors.white,
                      fontSize: SizeConfig.getFontSize(16),
                    ),
                  ),
//                  Spacer(),
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(8),
//    bottom: SizeConfig.getPadding(15),
              ),
              width: MediaQuery.of(context).size.width,
              height: SizeConfig.getHeight(50),
              child: RaisedButton(
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(25.0),
                ),
                onPressed: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                      builder: (context) => GuestInfo(),
                    ),
                  );
                },
//                padding: EdgeInsets.only(
//                  left: SizeConfig.getPadding(85),
//                  right: SizeConfig.getPadding(85),
//                  top: SizeConfig.getPadding(15),
//                  bottom: SizeConfig.getPadding(15),
//                ),
                color: Color(0xFF3694A3),
                child: Text(
                  'ยืนยัน',
                  style: TextStyle(
                    fontSize: SizeConfig.getFontSize(16),
                    fontWeight: FontWeight.bold,
                    color: Colors.white,
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  _setupView() {
    return Column(
      children: <Widget>[
        header(),
        _formDate(),
      ],
    );
  }

  Widget header() {
    return Container(
      child: Stack(
        children: <Widget>[
          Container(
            color: Color.fromRGBO(69, 85, 79, 1),
            height: SizeConfig.getHeight(200),
            width: MediaQuery.of(context).size.width,
          ),
          Positioned(
            top: SizeConfig.getPadding(50),
            left:
                SizeConfig.getPadding(MediaQuery.of(context).size.width / 3.5),
            child: Container(
              alignment: Alignment.topCenter,
              child: Image.asset(
                'assets/images/feelver_banner.png',
                width: MediaQuery.of(context).size.width / 2.5,
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(77),
            left: SizeConfig.getPadding(16),
            child: Container(
              child: GestureDetector(
                onTap: () {
                  showDialog(
                    context: context,
                    builder: (BuildContext context) {
                      return NavDrawer();
                    },
                  );
                },
                child: Image.asset(
                  'assets/images/ic_menu.png',
                  height: SizeConfig.getWidth(24),
                  width: SizeConfig.getWidth(30),
                  fit: BoxFit.cover,
                ),
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(77),
            right: SizeConfig.getPadding(60),
            child: Container(
              child: Image.asset(
                'assets/images/ic_noti.png',
                height: SizeConfig.getWidth(30),
                width: SizeConfig.getWidth(30),
                fit: BoxFit.cover,
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(77),
            right: SizeConfig.getPadding(20),
            child: InkWell(
//                onTap: () {
//                  Navigator.push(
//                    context,
//                    MaterialPageRoute(builder: (context) => LoginPage()),
//                  );
//                },
              child: Container(
                child: Image.asset(
                  'assets/images/ic_userimg.png',
                  height: SizeConfig.getWidth(30),
                  width: SizeConfig.getWidth(30),
                  fit: BoxFit.cover,
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget _formDate() {
    return Container(
      child: Form(
        child: Column(
          children: <Widget>[
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(
                  left: SizeConfig.getPadding(30),
                  top: SizeConfig.getPadding(24)),
              child: Text(
                'ระบุวันที่เข้าใช้บริการ',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w700),
              ),
            ),
            Container(
              width: MediaQuery.of(context).size.width / 1,
              margin: EdgeInsets.only(
                  top: SizeConfig.getPadding(12),
                  left: SizeConfig.getPadding(24),
                  right: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(
                    SizeConfig.getPadding(50.0),
                  ),
                ),
                child: FlatButton(
                    onPressed: () {
                      DatePicker.showDateTimePicker(context,
                          showTitleActions: true, onChanged: (date) {
                        print('change $date in time zone ' +
                            date.timeZoneOffset.inHours.toString());
                      }, onConfirm: (date) {
                        setState(() {
                          widget.day = date;
                          widget.bith =
                              "${widget.day.year}-${widget.day.month}-${widget.day.day} เวลา ${widget.day.hour} : ${widget.day.minute}";
                          print(
                              '${widget.day.year} / ${widget.day.month} / ${widget.day.day}');
                          print(widget.bith);
                        });
                        print('confirm $date');
                      }, currentTime: DateTime.now(), locale: LocaleType.th);
                    },
                    child: widget.bith == 'ปี / เดือน / วัน / เวลาเข้าใช้บริการ'
                        ? Text(
                            'ปี / เดือน / วัน / เวลาเข้าใช้บริการ',
                            style: TextStyle(
                                color: Colors.black54,
                                fontSize: SizeConfig.getFontSize(16),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),
                          )
                        : Text(
                            '${widget.bith}',
                            style: TextStyle(
                                color: Colors.black54,
                                fontSize: SizeConfig.getFontSize(16),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),
                          ),),
              ),
            ),
            SizedBox(
              height: SizeConfig.getWidth(30),
            ),
          ],
        ),
      ),
    );
  }
}
