import 'package:feelverapp/model/cart/add_cart_model.dart';
import 'package:feelverapp/model/cart/my_cart_model.dart';
import 'package:feelverapp/model/favorite/addfav_model.dart';
import 'package:feelverapp/service/Loading.dart';

import 'package:feelverapp/service/api.dart';
import 'package:feelverapp/service/base_presenter.dart';
import 'package:feelverapp/ui/payment/mycart.dart';

import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/material.dart';
import 'package:rflutter_alert/rflutter_alert.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:feelverapp/ui/booking/booking_detail.dart';
import '../../model/booking_detail/booking_detail_model.dart';

class MyCartPresenter extends BasePresenter<MyCart> {
  final formkey = GlobalKey<FormState>();
  Api _api;
  int getid;
  int vendor_id;
  int store_id;
  String user_id;

  bool fav = false;
  String uid;
OrderCartModel orderCartModel;


  MyCartPresenter(State<MyCart> state) : super(state);
  getListCart() async {

    print(user_id);

    _api = Api<OrderCartModel>();

    var res = await _api.orderCart(
        'https://backend.feelver.com/api/cart/order?customer_id=' +
            user_id.toString() + '&access_type=portal'
    );

    if (res.fail == null) {
      setState(
            () {
          print("AAAA :${res.success}");
          orderCartModel = res.success;
          print(orderCartModel.dATA[0]);
        },
      );
    } else {
      Alert(
          style: AlertStyle(
            animationType: AnimationType.fromTop,
            isCloseButton: false,
          ),
          context: state.context,
          title: "ไม่พบข้อมูล",
          content: Icon(
            Icons.warning,
            color: Colors.orange,
            size: 80,
          ),
          buttons: [
            DialogButton(
              color: Color.fromRGBO(106, 179, 170, 1),
              onPressed: () => Navigator.pop(state.context),
              child: Text(
                "ลองอีกครั้ง",
                style: TextStyle(color: Colors.white, fontSize: 20),
              ),
            )
          ]).show();
    }
  }


}