import 'package:feelverapp/ui/menu/menu.dart';
import 'package:feelverapp/ui/payment/mycart_presenter.dart';
import 'package:feelverapp/ui/payment/payment_page.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/material.dart';

class MyCart extends StatefulWidget {
  String user_id;

  MyCart({Key key, this.user_id}) : super(key: key);

  @override
  _MyCartState createState() => _MyCartState();
}

class _MyCartState extends State<MyCart> {
  bool checkBoxValue = false;
  int a = 1;
  int b = 1;
  List<int> _counter = List();
  MyCartPresenter presenter;

  @override
  void initState() {
    super.initState();
//    widget.getid = 55;
//    print(widget.getid);
    presenter = MyCartPresenter(this);
    setState(() {
      // presenter.vendor_id = widget.v;
      // presenter.store_id = widget.store_id;
      // presenter.getid = widget.getid;
      presenter.user_id = widget.user_id;
    });

    presenter.getListCart();
  }

  @override
  void dispose() {
    super.dispose();
  }
  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
      bottomNavigationBar: Container(
        color: Color.fromRGBO(69, 85, 79, 1),
        height: SizeConfig.getWidth(180),
        child: Column(
          children: <Widget>[
            Container(
              margin: EdgeInsets.only(
                left: SizeConfig.getPadding(15),
                top: SizeConfig.getPadding(17),
              ),
              child: Row(
                children: <Widget>[
                  Icon(
                    Icons.local_offer,
                    color: Colors.white,
                  ),
                  Padding(
                    padding: const EdgeInsets.only(
                      left: 7,
                      right: 12,
                    ),
                    child: Text(
                      'โค้ดส่วนลด',
                      style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(16),
                      ),
                    ),
                  ),
                  Container(
                    height: SizeConfig.getHeight(40),
                    width: SizeConfig.getWidth(180),
                    color: Colors.white,
                    child: TextField(
                      decoration: InputDecoration(
                        border: InputBorder.none,
                      ),
                    ),
                  ),
                  IconButton(
                      icon: Icon(
                        Icons.keyboard_arrow_right,
                        color: Colors.white,
                        size: 30,
                      ),
                      onPressed: () {}),
                ],
              ),
            ),
            Divider(
              color: Colors.white,
              height: SizeConfig.getHeight(35),
              indent: 20,
              endIndent: 20,
            ),
            Container(
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(10),
                right: SizeConfig.getPadding(15),
              ),
              child: Row(
                children: <Widget>[
                  Checkbox(
                      checkColor: Color(0xFFEEAFB7),
                      activeColor: Colors.white,
                      value: checkBoxValue,
                      onChanged: (bool value) {
                        setState(() {
                          print(value);
                          checkBoxValue = value;
                        });
                      }),
                  Text(
                    'เลือกทั้งหมด',
                    style: TextStyle(
                      color: Colors.white,
                      fontSize: SizeConfig.getFontSize(16),
                    ),
                  ),
                  Spacer(),
                  Container(
                    child: Column(
                      children: <Widget>[
                        Text(
                          'รวมทั้งหมด',
                          style: TextStyle(
                            color: Colors.white,
                            fontSize: SizeConfig.getFontSize(16),
                          ),
                        ),
                        Text(
                          '฿2,000',
                          style: TextStyle(
                            color: Color(0xFFEEAFB7),
                            fontSize: SizeConfig.getFontSize(24),
                          ),
                        ),
                      ],
                    ),
                  ),
                  Spacer(),
                  Container(
                    child: RaisedButton(
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(30.0),
                      ),
                      onPressed: () {
                        Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder: (context) => Payment(),
                          ),
                        );
                      },
                      padding: EdgeInsets.only(
                        left: SizeConfig.getPadding(35),
                        right: SizeConfig.getPadding(35),
                        top: SizeConfig.getPadding(15),
                        bottom: SizeConfig.getPadding(15),
                      ),
                      color: Color(0xFFEEAFB7),
                      child: Text(
                        'สั่งซื้อ',
                        style: TextStyle(
                          fontSize: SizeConfig.getPadding(16),
                          color: Colors.white,
                        ),
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  _setupView() {
    return Column(
      children: <Widget>[
        header(),
        _getlist(),
      ],
    );
  }

  _getlist() {
    return Expanded(
      child: Container(
        margin: EdgeInsets.only(
          top: SizeConfig.getPadding(0),
          left: SizeConfig.getPadding(16),
          right: SizeConfig.getPadding(16),
          bottom: SizeConfig.getPadding(16),
        ),
        child: ListView.builder(
          itemCount: 1,
          itemBuilder: (context, i) {
            return InkWell(
              onTap: () {
                print(a);
              },
              child: list1(),
            );
          },
        ),
      ),
    );
  }

  Widget list1() {
    return Card(
      elevation: 5,
      child: Container(
        padding: EdgeInsets.only(
          left: SizeConfig.getPadding(8),
          top: SizeConfig.getPadding(8),
          bottom: SizeConfig.getPadding(16),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          children: <Widget>[
            Image.asset(
              'assets/images/demo_img.png',
              width: SizeConfig.getWidth(110),
              height: SizeConfig.getHeight(150),
              fit: BoxFit.fitWidth,
            ),
            Expanded(
              child: Container(
                padding: EdgeInsets.only(
                  left: SizeConfig.getPadding(5),
                  right: SizeConfig.getPadding(5),
                ),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Container(
//                    color: Colors.blue,
                      child: Row(
                        children: <Widget>[
                          Text(
                            'Ivory Relax and Spa',
                            style: TextStyle(
                              color: Colors.black,
                              fontSize: SizeConfig.getFontSize(16),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.w700,
                            ),
                          ),
                          Spacer(),
                          IconButton(
                            icon: Icon(Icons.delete),
                            color: Colors.grey,
                            onPressed: () {
                              print('delete');
                            },
                          ),
                        ],
                      ),
                    ),
                    Container(
                      child: Text(
                        'นวดเเผนไทย',
                        style: TextStyle(
                          color: Colors.black,
                          fontSize: SizeConfig.getFontSize(16),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w600,
                        ),
                      ),
                    ),
                    SizedBox(
                      height: SizeConfig.getHeight(12),
                    ),
                    Container(
//                    color: Colors.yellow,
                      child: Row(
                        children: <Widget>[
                          Image.asset(
                            'assets/images/clock.png',
                            height: SizeConfig.getHeight(20),
                            width: SizeConfig.getWidth(20),
                          ),
                          SizedBox(
                            width: SizeConfig.getWidth(5),
                          ),
                          Text('90 นาที'),
                          Spacer(),
                          Icon(
                            Icons.local_offer,
                            color: Color(0xFFEEAFB7),
                          ),
                          Text(
                            '฿1,599.00',
                            style: TextStyle(
                              decoration: TextDecoration.lineThrough,
                              fontSize: SizeConfig.getFontSize(16),
                              fontFamily: "SF_Pro_Text",
                              color: Color(0xFFEEAFB7),
                            ),
                          ),
                        ],
                      ),
                    ),
                    SizedBox(
                      height: SizeConfig.getHeight(10),
                    ),
                    Container(
//                    color: Colors.orangeAccent,
                      child: Row(
                        children: <Widget>[
                          SizedBox(
                            width: SizeConfig.getPadding(20),
                            height: SizeConfig.getPadding(20),
                            child: RaisedButton(
                              child: Text('-'),
                              padding: EdgeInsets.only(
                                right: SizeConfig.getPadding(0),
                              ),
                              onPressed: () {
                                setState(() {
                                  a--;
                                });
                              },
                            ),
                          ),
                          Padding(
                            padding: const EdgeInsets.only(right: 8, left: 8),
                            child: Text('$a'),
                          ),
                          SizedBox(
                            width: SizeConfig.getPadding(20),
                            height: SizeConfig.getPadding(20),
                            child: RaisedButton(
                              child: Text('+'),
                              padding: EdgeInsets.only(
                                right: SizeConfig.getPadding(0),
                              ),
                              onPressed: () {
                                setState(() {
                                  a++;
                                });
                              },
                            ),
                          ),
                          Spacer(),
                          Text(
                            '฿1,200.00',
                            style: TextStyle(
                              fontSize: SizeConfig.getFontSize(20),
                              color: Color(0xFFFD2956),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.bold,
                            ),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  Widget header() {
    return Stack(
      children: <Widget>[
        Container(
          color: Color.fromRGBO(69, 85, 79, 1),
          height: SizeConfig.getHeight(150),
          width: MediaQuery.of(context).size.width,
        ),
        Positioned(
          top: SizeConfig.getPadding(50),
          left: SizeConfig.getPadding(MediaQuery.of(context).size.width / 3.3),
          child: Container(
            alignment: Alignment.topCenter,
            child: Image.asset(
              'assets/images/feelver_banner.png',
              width: MediaQuery.of(context).size.width / 2.5,
            ),
          ),
        ),
        Positioned(
          top: SizeConfig.getPadding(70),
          left: SizeConfig.getPadding(16),
          child: Container(
            child: GestureDetector(
              onTap: () {
                Navigator.pop(context);
              },
              child: Icon(
                Icons.keyboard_arrow_left,
                color: Colors.white,
                size: SizeConfig.getFontSize(40),
              ),
            ),
          ),
        ),
      ],
    );
  }
}
