import 'dart:ui';

import 'package:feelverapp/util/AppBar.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class OtherMenuPage extends StatefulWidget {
  @override
  _OtherMenuPageState createState() => _OtherMenuPageState();
}

class _OtherMenuPageState extends State<OtherMenuPage> with SingleTickerProviderStateMixin{

  TabController controller;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    controller = new TabController(length: 3, vsync: this);
    controller.addListener(_handleTabSelection);
  }

  @override
  void dispose() {
    // TODO: implement dispose
    controller.dispose();
    super.dispose();
  }


  void _handleTabSelection() {
    setState(() {
    });
  }
  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
    );
  }

  _setupView() {
    return Stack(
      children: <Widget>[
        containt(),
        header(),
        myAppBar(),
      ],
    );
  }

  Widget containt(){
    return  Container(
      child: Column(
        children: <Widget>[
          Container(
            height: SizeConfig.getHeight(160),
          ),
          Expanded(
            child: Column(
                children: <Widget>[
//                  buttonBar(),
                SizedBox(
                  height: 60,
                ),
                  getTabBar(),
                  Expanded(
                    child: Container(
                        child: containTab()
                    ),
                  ),
                ],
              ),
          ),
        ],
      ),
    );
  }


  Widget LogoutButton(){
    return Container(
//                    color: Colors.red,
      margin: EdgeInsets.only(right: SizeConfig.getPadding(16)+10,left: SizeConfig.getPadding(16)+10,top: SizeConfig.getPadding(10),bottom: SizeConfig.getPadding(30)),
      height: SizeConfig.getHeight(40),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        children: <Widget>[
          Container(
            child: Image.asset("assets/images/Icon_close.png"),
          ),
          SizedBox(
            width: 10,
          ),
          Text("ออกจากระบบ",style: TextStyle(
              color: Color(0xffEEAFB7),
              fontSize: SizeConfig.getFontSize(16),
              fontFamily: "SF_Pro_Text",
              fontWeight: FontWeight.w500),),
        ],),
    );
  }


  Widget Card1(){
    return Card(
      margin: EdgeInsets.only(right: SizeConfig.getPadding(16),left: SizeConfig.getPadding(16),top: SizeConfig.getPadding(0),bottom: SizeConfig.getPadding(10)),
      child: Container(
        margin: EdgeInsets.only(right: 10,left: 10),
//                          color: Colors.yellow,
        child: Column(
          children: <Widget>[
            Divider(color: Color(0x00000000),),
            Container(
//                                color: Colors.red,
              height: SizeConfig.getHeight(40),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  Text("สิ่งที่ถูกใจ",style: TextStyle(
                      color: Color(0xffEEAFB7),
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),),
                  Icon(Icons.keyboard_arrow_right,color: Color(0xAAA8B8C3),size: SizeConfig.getFontSize(26),),
                ],),
            ),

            Divider(color: Color(0x11000000),),

            Container(
//                                color: Colors.red,
              height: SizeConfig.getHeight(40),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  Text("ข้อมูลการจองของฉัน",style: TextStyle(
                      color: Color(0xffEEAFB7),
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),),
                  Icon(Icons.keyboard_arrow_right,color: Color(0xAAA8B8C3),size: SizeConfig.getFontSize(26),),
                ],),
            ),

            Divider(color: Color(0x11000000),),

            Container(
//                                color: Colors.red,
              height: SizeConfig.getHeight(40),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  Text("ประวัติการใช้บริการของฉัน",style: TextStyle(
                      color: Color(0xffEEAFB7),
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),),
                  Icon(Icons.keyboard_arrow_right,color: Color(0xAAA8B8C3),size: SizeConfig.getFontSize(26),),
                ],),
            ),

            Divider(color: Color(0x11000000),),

            Container(
//                                color: Colors.red,
              height: SizeConfig.getHeight(40),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  Text("การแจ้งเตือน",style: TextStyle(
                      color: Color(0xffEEAFB7),
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),),
                  Icon(Icons.keyboard_arrow_right,color: Color(0xAAA8B8C3),size: SizeConfig.getFontSize(26),),
                ],),
            ),

            Divider(color: Color(0x11000000),),

            Container(
//                                color: Colors.red,
              height: SizeConfig.getHeight(40),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  Text("รีวิวของฉัน",style: TextStyle(
                      color: Color(0xffEEAFB7),
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),),
                  Icon(Icons.keyboard_arrow_right,color: Color(0xAAA8B8C3),size: SizeConfig.getFontSize(26),),
                ],),
            ),

            Divider(color: Color(0x00000000),),
          ],
        ),
      ),
    );
  }


  Widget Card2(){
    return Card(
      margin: EdgeInsets.only(right: SizeConfig.getPadding(16),left: SizeConfig.getPadding(16),top: SizeConfig.getPadding(10),bottom: SizeConfig.getPadding(10)),
      child: Container(
        margin: EdgeInsets.only(right: 10,left: 10),
//                          color: Colors.yellow,
//                          height: 200,
        child: Column(
          children: <Widget>[
            Divider(color: Color(0x00000000),),
            Container(
//                                color: Colors.red,
              height: SizeConfig.getHeight(40),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  Text("ตั้งค่าบัญชี",style: TextStyle(
                      color: Color(0xffEEAFB7),
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),),
                  Icon(Icons.keyboard_arrow_right,color: Color(0xAAA8B8C3),size: SizeConfig.getFontSize(26),),
                ],),
            ),

            Divider(color: Color(0x11000000),),

            Container(
//                                color: Colors.red,
              height: SizeConfig.getHeight(40),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: <Widget>[
                  Text("ความช่วยเหลือ",style: TextStyle(
                      color: Color(0xffEEAFB7),
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),),
                  Icon(Icons.keyboard_arrow_right,color: Color(0xAAA8B8C3),size: SizeConfig.getFontSize(26),),
                ],),
            ),

            Divider(color: Color(0x00000000),),
          ],
        ),
      ),
    );
  }



  Widget header(){
    return Container(
      height: SizeConfig.getHeight(210),
//                color: Colors.amber,
      child: Stack(
        children: <Widget>[

          Column(
            children: <Widget>[
              Container(
                color: Color(0xff6AB3AA),
                height: SizeConfig.getHeight(180),
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.end,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: <Widget>[
                    Container(
                      width: 85,
                      height: 85,
                      margin: EdgeInsets.only(left: SizeConfig.getPadding(16),bottom: 10),
                      //color: Colors.brown,
                    ),

                    Expanded(
                      child: Container(
                        alignment: Alignment.bottomLeft,
                        margin: EdgeInsets.only(bottom: 10),
                        padding: EdgeInsets.only(left: 20),
                        height: 85,
                        //color: Colors.red,
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.end,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: <Widget>[
                            Text("Rataya  Pratumkan",style: TextStyle(
                                color: Colors.white,
                                fontSize: SizeConfig.getFontSize(18),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),),
                            SizedBox(
                              height: 5,
                            ),
                            Text("แก้ไขข้อมูลส่วนตัว",style: TextStyle(
                                color: Colors.yellow,
                                fontSize: SizeConfig.getFontSize(12),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500,decoration: TextDecoration.underline),
                            ),
                            SizedBox(
                              height: 5,
                            ),
                          ],
                        ),
                      ),
                    ),
                    Container(
                      alignment: Alignment.centerRight,
                      //color: Colors.yellow,
                      width: 85,
                      height: 85,
                      margin: EdgeInsets.only(right: SizeConfig.getPadding(16),bottom: 10),
                      child: Icon(Icons.settings,color: Colors.white,),
                    ),
                  ],
                ),
              )
            ],
          ),

          Column(
            mainAxisAlignment: MainAxisAlignment.end,
            children: <Widget>[
              Row(
                mainAxisAlignment: MainAxisAlignment.start,
                children: <Widget>[
                  Container(
                    width: 85,
                    height: 85,
                    margin: EdgeInsets.only(left: SizeConfig.getPadding(16),bottom: 10),
                    //color: Colors.brown,
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(50),
                      child: Image.network(
                        'https://scontent.fbkk7-2.fna.fbcdn.net/v/t1.0-9/104204530_3370427592977187_6031309814586327212_o.jpg?_nc_cat=106&_nc_sid=110474&_nc_eui2=AeE2vpoR5NHZLbG8b3YABiSdSsMCoPYM3W1KwwKg9gzdbZuYqR1gPnkW3tGe-TS2Vtphdvn2OuvO2CdDLaCMVvcI&_nc_ohc=T5EK3sWOgtAAX994m4I&_nc_ht=scontent.fbkk7-2.fna&oh=0b3e434546b19e256c07ecd6a4d499fb&oe=5F098A94',
                        width: 85.0,
                        height: 85.0,
                        fit: BoxFit.cover,
                      ),
                    ),
                  ),
                ],
              ),
            ],
          ),

          Positioned(
            child: Image.asset("assets/images/icon_chat.png"),
            top: 60,
            right: 10,
          ),
        ],
      ),
    );
  }



  TabBar getTabBar() {
    return new TabBar(
      indicatorColor: Colors.transparent,
      controller: controller,
      tabs: [
        new Tab(
            icon: Icon(Icons.system_update,
                color: controller.index == 0
                    ? Color(0xff6AB3AA): Colors.grey,
                size: SizeConfig.getFontSize(24),
            ),
            child:Text(
              'การจองของฉัน',
              style: TextStyle(
                  color: controller.index == 0
                      ? Color(0xff6AB3AA): Colors.black,
                fontSize: SizeConfig.getFontSize(11),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w500,
              ),
              textAlign: TextAlign.center,
            ),

          ),
        new Tab(
          icon: Icon(Icons.assignment,
              color: controller.index == 1
                  ? Color(0xff6AB3AA): Colors.grey,
              size: SizeConfig.getFontSize(24),
          ),
          child:Text(
            'ประวัติการใช้บริการ',
            style: TextStyle(
                color: controller.index == 1
                    ? Color(0xff6AB3AA): Colors.black,
              fontSize: SizeConfig.getFontSize(11),
              fontFamily: "SF_Pro_Text",
              fontWeight: FontWeight.w500,
            ),
            textAlign: TextAlign.center,
          ),

        ),
        new Tab(
          icon: Icon(Icons.notifications,
              color: controller.index == 2
                  ? Color(0xff6AB3AA): Colors.grey,
              size: SizeConfig.getFontSize(24),

          ),
          child:Text(
            'การแจ้งเตือน',
            style: TextStyle(
                color: controller.index == 2
                    ? Color(0xff6AB3AA): Colors.black,
                fontSize: SizeConfig.getFontSize(11),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w500,

            ),
            textAlign: TextAlign.center,
          ),

        ),
      ],
    );
  }


  TabBarView getTabBarView(var tabs) {
    return new TabBarView(
      // Add tabs as widgets
      children: tabs,
      // set the controller
      controller: controller,
    );
  }

  Widget containTab(){
    return WillPopScope(
      ///onWillPop: onWillPop,
      child: getTabBarView(<Widget>[
        Container(
          padding: EdgeInsets.only(top: 10),
//          color: Colors.red,
          height: double.infinity,
          width: double.infinity,
          child: ListView(
            padding: EdgeInsets.all(0),
            children: <Widget>[
              Card1(),
              Card2(),
              LogoutButton(),
            ],
          ),
        ),
        Container(
          color: Colors.blue,
          height: double.infinity,
          width: double.infinity,
        ),
        Container(
          color: Colors.green,
          height: double.infinity,
          width: double.infinity,
        ),

      ]),
    );
  }


}
