import 'dart:ui';

import 'package:feelverapp/util/AppBar.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:feelverapp/util/rating_star.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class NotificationPage extends StatefulWidget {
  @override
  _NotificationPageState createState() => _NotificationPageState();
}

class _NotificationPageState extends State<NotificationPage> {
  double rate = 0;

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
    );
  }

  _setupView() {
    return Stack(
      children: <Widget>[
        containt(),
        header(),
        myAppBar(
          title: "การแจ้งเตือน",
        ),
      ],
    );
  }

  Widget containt() {
    return Container(
      child: Column(
        children: <Widget>[
          Container(
            height: SizeConfig.getHeight(160),
          ),
          Expanded(
            child: SingleChildScrollView(
              child: Column(
                children: <Widget>[
                  SizedBox(
                    height: SizeConfig.getHeight(65),
                  ),
                  Card1(),
                  Card1(),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget LogoutButton() {
    return Container(
//                                color: Colors.red,
      margin: EdgeInsets.only(
          right: SizeConfig.getPadding(16) + 10,
          left: SizeConfig.getPadding(16) + 10,
          top: SizeConfig.getPadding(10),
          bottom: SizeConfig.getPadding(30)),
      height: SizeConfig.getHeight(40),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        children: <Widget>[
          Container(
            child: Image.asset("assets/images/Icon_close.png"),
          ),
          SizedBox(
            width: 10,
          ),
          Text(
            "ออกจากระบบ",
            style: TextStyle(
                color: Color(0xffEEAFB7),
                fontSize: SizeConfig.getFontSize(16),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w500),
          ),
        ],
      ),
    );
  }

  Widget Card1() {
    return Card(
      clipBehavior: Clip.antiAlias,
      margin: EdgeInsets.only(
          right: SizeConfig.getPadding(16),
          left: SizeConfig.getPadding(16),
          top: SizeConfig.getPadding(10),
          bottom: SizeConfig.getPadding(25)),
      child: Container(
        margin: EdgeInsets.only(right: 0, left: 10),
//                          color: Colors.yellow,
        child: Row(
          children: <Widget>[
            Expanded(
              flex: 9,
              child: Container(
                height: SizeConfig.getHeight(220),
//                color: Colors.red,
                child: Column(
                  children: <Widget>[
                    Expanded(
                      flex: 4,
                      child: Container(
                        alignment: Alignment.bottomCenter,
//                        color: Colors.blue,
                        child: Image.asset(
                            "assets/images/icon_feelver_voucher.png"),
                      ),
                    ),
                    Expanded(
                      flex: 6,
                      child: Container(
//                        color: Colors.yellow,
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: <Widget>[
                            Text(
                              "50%",
                              style: TextStyle(
                                  color: Color(0xff6AB3AA),
                                  fontSize: SizeConfig.getFontSize(45),
                                  fontFamily: "SF_Pro_Text",
                                  fontWeight: FontWeight.w500,
                                  fontStyle: FontStyle.italic),
                            ),
                            Text(
                              "OFF",
                              style: TextStyle(
                                  color: Color(0xff6AB3AA),
                                  fontSize: SizeConfig.getFontSize(40),
                                  fontFamily: "SF_Pro_Text",
                                  fontWeight: FontWeight.w500,
                                  fontStyle: FontStyle.italic),
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
              ),
            ),
            Expanded(
              flex: 10,
              child: Stack(
                children: <Widget>[
                  Container(
                    height: SizeConfig.getHeight(210),
                    width: double.infinity,
                    color: Colors.green,
                    child: Image.asset(
                      "assets/images/demo_img.png",
                      fit: BoxFit.cover,
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(
                        top: 15, bottom: 15, left: 10, right: 10),
                    height: SizeConfig.getHeight(210),
                    width: double.infinity,
                    color: Color(0xddEEAFB7),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Text(
                          "Voucher Thai Body Balance",
                          style: TextStyle(
                            color: Colors.white,
                            fontSize: SizeConfig.getFontSize(14),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500,
                          ),
                        ),
                        SizedBox(
                          height: 5,
                        ),
                        Text(
                          "03/16/2019 12:43",
                          style: TextStyle(
                            color: Color(0xff6AB3AA),
                            fontSize: SizeConfig.getFontSize(12),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500,
                          ),
                        ),
                        SizedBox(
                          height: 10,
                        ),
                        Text(
                          "จะหมดในอีก 10 วัน อย่าลืมใช้นะคะ",
                          style: TextStyle(
                            color: Colors.white,
                            fontSize: SizeConfig.getFontSize(14),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500,
                          ),
                        ),
                        SizedBox(
                          height: 25,
                        ),
                      ],
                    ),
                  ),
                  Container(
                    height: SizeConfig.getHeight(240),
                    padding: EdgeInsets.only(
                        top: 50, bottom: 15, left: 10, right: 10),
                    alignment: Alignment.bottomCenter,
                    width: double.infinity,
//                    color: Colors.green,
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.end,
                      children: <Widget>[
                        RaisedButton(
                            shape: new RoundedRectangleBorder(
                                borderRadius: new BorderRadius.circular(180.0)),
                            child: Text(
                              "ดูข้อมูลการสั่งซื้อ",
                              style: TextStyle(
                                  color: Colors.white,
                                  fontSize: SizeConfig.getFontSize(16),
                                  fontFamily: "SF_Pro_Text",
                                  fontWeight: FontWeight.w500),
                            ),
                            color: Color(0xffE8A6B4),
                            onPressed: () {}),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  Widget buttonBar() {
    return Container(
      child: Row(
        children: <Widget>[
          Expanded(
            child: Container(
              height: SizeConfig.getHeight(130),
              padding: EdgeInsets.only(bottom: SizeConfig.getHeight(10)),
//                                color: Colors.green,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.end,
                children: <Widget>[
                  Image.asset(
                    "assets/images/icon_menu1_gray.png",
                    width: SizeConfig.getWidth(20),
                    height: SizeConfig.getHeight(30),
                    fit: BoxFit.cover,
                  ),
                  SizedBox(
                    height: SizeConfig.getHeight(8),
                  ),
                  Text(
                    "การจองของฉัน",
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  )
                ],
              ),
            ),
          ),
          Expanded(
            child: Container(
              height: SizeConfig.getHeight(130),
              padding: EdgeInsets.only(bottom: SizeConfig.getHeight(10)),
//                                color: Colors.blue,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.end,
                children: <Widget>[
                  Image.asset(
                    "assets/images/icon_menu2_gray.png",
                    width: SizeConfig.getWidth(20),
                    height: SizeConfig.getHeight(30),
                    fit: BoxFit.cover,
                  ),
                  SizedBox(
                    height: SizeConfig.getHeight(5),
                  ),
                  Text(
                    "ประวัติการใช้บริการ",
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  )
                ],
              ),
            ),
          ),
          Expanded(
            child: Container(
              height: SizeConfig.getHeight(130),
              padding: EdgeInsets.only(bottom: SizeConfig.getHeight(10)),
//                                color: Colors.red,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.end,
                children: <Widget>[
                  Image.asset(
                    "assets/images/icon_menu3_gray.png",
                    width: SizeConfig.getWidth(20),
                    height: SizeConfig.getHeight(30),
                    fit: BoxFit.cover,
                  ),
                  SizedBox(
                    height: SizeConfig.getHeight(5),
                  ),
                  Text(
                    "การแจ้งเตือน",
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  )
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget header() {
    return Container(
      height: SizeConfig.getHeight(210),
//                color: Colors.amber,
      child: Stack(
        children: <Widget>[
          Column(
            children: <Widget>[
              Container(
                color: Color(0xff6AB3AA),
                height: SizeConfig.getHeight(180),
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.end,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: <Widget>[
                    Container(
                      width: 85,
                      height: 85,
                      margin: EdgeInsets.only(
                          left: SizeConfig.getPadding(16), bottom: 10),
                      //color: Colors.brown,
                    ),
                    Expanded(
                      child: Container(
                        alignment: Alignment.bottomLeft,
                        margin: EdgeInsets.only(bottom: 10),
                        padding: EdgeInsets.only(left: 20),
                        height: 85,
                        //color: Colors.red,
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.end,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: <Widget>[
                            Text(
                              "Rataya  Pratumkan",
                              style: TextStyle(
                                  color: Colors.white,
                                  fontSize: SizeConfig.getFontSize(18),
                                  fontFamily: "SF_Pro_Text",
                                  fontWeight: FontWeight.w500),
                            ),
                            SizedBox(
                              height: 5,
                            ),
                            SizedBox(
                              height: 5,
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
              )
            ],
          ),
          Column(
            mainAxisAlignment: MainAxisAlignment.end,
            children: <Widget>[
              Row(
                mainAxisAlignment: MainAxisAlignment.start,
                children: <Widget>[
                  Container(
                    width: 85,
                    height: 85,
                    margin: EdgeInsets.only(
                        left: SizeConfig.getPadding(16), bottom: 10),
                    //color: Colors.brown,
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(50),
                      child: Image.network(
                        'https://scontent.fbkk7-2.fna.fbcdn.net/v/t1.0-9/104204530_3370427592977187_6031309814586327212_o.jpg?_nc_cat=106&_nc_sid=110474&_nc_eui2=AeE2vpoR5NHZLbG8b3YABiSdSsMCoPYM3W1KwwKg9gzdbZuYqR1gPnkW3tGe-TS2Vtphdvn2OuvO2CdDLaCMVvcI&_nc_ohc=T5EK3sWOgtAAX994m4I&_nc_ht=scontent.fbkk7-2.fna&oh=0b3e434546b19e256c07ecd6a4d499fb&oe=5F098A94',
                        width: 85.0,
                        height: 85.0,
                        fit: BoxFit.cover,
                      ),
                    ),
                  ),
                ],
              ),
            ],
          ),
        ],
      ),
    );
  }
}
