import 'package:feelverapp/service/api.dart';
import 'package:feelverapp/ui/nearme/near_me_detail.dart';
import 'package:feelverapp/ui/nearme/near_me_list_presenter.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:feelverapp/util/Util.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class NearmeList extends StatefulWidget {
  @override
  _NearmeListState createState() => _NearmeListState();
}

class _NearmeListState extends State<NearmeList> with TickerProviderStateMixin {
  NearmeListPresenter presenter;

  @override
  void initState() {
    super.initState();

    presenter = NearmeListPresenter(this);
    presenter.getnearme();
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Color.fromRGBO(69, 85, 79, 1),
        elevation: 0,
        centerTitle: true,
        title: Text(
          'สถานที่ใกล้เคียงทั้งหมด',
          style: TextStyle(
              color: Colors.white,
              fontSize: SizeConfig.getFontSize(20),
              fontFamily: "SF_Pro_Text",
              fontWeight: FontWeight.w500),
        ),
      ),
      body: _setupView(),
    );
  }

  _setupView() {
    return Stack(
      children: <Widget>[
        Container(
          height: SizeConfig.getWidth(110),
          color: Color.fromRGBO(69, 85, 79, 1),
          child: Container(
            padding: EdgeInsets.only(left: SizeConfig.getPadding(24)),
            alignment: Alignment.topLeft,
            child: Wrap(
              alignment: WrapAlignment.start,
              spacing: 10.0, // gap between adjacent chips
              runSpacing: 5.0, // gap between lines
              children: <Widget>[
                FilterChip(
                  label: Text(
                    "ทั้งหมด",
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(15),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                  backgroundColor: Color.fromRGBO(69, 85, 79, 1),
                  shape: StadiumBorder(
                    side: BorderSide(color: Colors.white),
                  ),
                  onSelected: (bool value) {
                    print("selected");
                    setState(() {
                      presenter.type = "";
                    });
                  },
                ),
                FilterChip(
                  label: Text(
                    "ที่เที่ยว",
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(15),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                  backgroundColor: Color.fromRGBO(69, 85, 79, 1),
                  shape: StadiumBorder(
                    side: BorderSide(color: Colors.white),
                  ),
                  onSelected: (bool value) {
                    print("selected");
                  },
                ),
                FilterChip(
                  label: Text(
                    "ที่กิน",
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(15),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                  backgroundColor: Color.fromRGBO(69, 85, 79, 1),
                  shape: StadiumBorder(
                    side: BorderSide(color: Colors.white),
                  ),
                  onSelected: (bool value) {
                    print("selected");
                  },
                ),
                FilterChip(
                  label: Text(
                    "ที่พัก",
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(15),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                  backgroundColor: Color.fromRGBO(69, 85, 79, 1),
                  shape: StadiumBorder(
                    side: BorderSide(color: Colors.white),
                  ),
                  onSelected: (bool value) {
                    print("selected");
                  },
                ),
                FilterChip(
                  label: Text(
                    "กิจกรรม",
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(15),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                  backgroundColor: Color.fromRGBO(69, 85, 79, 1),
                  shape: StadiumBorder(
                    side: BorderSide(color: Colors.white),
                  ),
                  onSelected: (bool value) {
                    print("selected");
                  },
                ),
              ],
            ),
          ),
        ),
        _getlist(),
      ],
    );
  }

  _getlist() {
    print(presenter.getmodel);
    return presenter.getmodel == null
        ? Container(
            child: Center(
                child: CircularProgressIndicator(
            valueColor: new AlwaysStoppedAnimation<Color>(Colors.teal),
          )))
        : Container(
            padding: EdgeInsets.only(
              top: SizeConfig.getPadding(140),
              left: SizeConfig.getPadding(16),
              right: SizeConfig.getPadding(16),
              bottom: SizeConfig.getPadding(10),
            ),
            child: ListView.builder(
              itemCount: presenter.getmodel.results.data.length,
              itemBuilder: (context, i) {
                return _nearByItem(
                    presenter.getmodel.results.data[i].storeName,
                    presenter.getmodel.results.data[i].detail,
                    presenter.getmodel.results.data[i].storeLogo,
                    presenter.getmodel.results.data[i].address,
                    presenter.getmodel.results.data[i].location,
                    presenter.getmodel.results.data[i].updatedAt,
                    presenter.getmodel.results.data[i].distanceWithLocation
                        .toString());
              },
            ),
          );
  }

  Widget _nearByItem(String title, String detail, String img, String address,
      String latlng, String date_time, String distanceWithLocation) {
    return InkWell(
      onTap: () {
        Navigator.push(
          context,
          CupertinoPageRoute(
            builder: (context) => NearmeDetail(
              store_name: title,
              img_url: 'https://backend.feelver.com/storage/' + img,
              detail: Util.removeHTMLTag('${detail}'),
              address: address,
              latlng: latlng,
              date_time: date_time,
              distanceWithLocation: distanceWithLocation + ' Km. ',
            ),
          ),
        );
      },
      child: Card(
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          children: <Widget>[
            SizedBox(
              width: SizeConfig.getWidth(16),
            ),
            Expanded(
              child: Image.network(
                Api.baseApiforimage + img,
//                width: SizeConfig.getWidth(50),
                height: SizeConfig.getHeight(160),
                fit: BoxFit.fitHeight,
              ),
            ),
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Container(
                    child: Text(
                      title,
                      style: TextStyle(
                          color: Colors.black87,
                          fontSize: SizeConfig.getFontSize(16),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w700),
                    ),
                    padding: EdgeInsets.only(
                        top: SizeConfig.getPadding(30),
                        left: SizeConfig.getPadding(16),
                        right: SizeConfig.getPadding(16),
                        bottom: SizeConfig.getPadding(4)),
                  ),
//                  Container(
//                    child: Text(
//                      '',
//                      textAlign: TextAlign.left,
//                      style: TextStyle(
//                          color: Colors.black54,
//                          fontSize: SizeConfig.getFontSize(12),
//                          fontFamily: "SF_Pro_Text",
//                          fontWeight: FontWeight.w500),
//                    ),
////                  alignment: Alignment.topLeft,
//                    padding: EdgeInsets.only(
//                        top: SizeConfig.getPadding(0),
//                        left: SizeConfig.getPadding(16),
//                        bottom: SizeConfig.getPadding(4)),
//                  ),
                  SizedBox(
                    height: 8,
                  ),
                  Row(
                    children: <Widget>[
                      SizedBox(
                        width: SizeConfig.getWidth(16),
                      ),
                      ImageIcon(
                        AssetImage('assets/images/pin_drop.png'),
                        color: Colors.black54,
                        size: SizeConfig.getFontSize(16),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(4),
                      ),
                      Text(
                        distanceWithLocation + ' Km.',
                        style: TextStyle(
                          fontWeight: FontWeight.w500,
                          fontSize: SizeConfig.getFontSize(12),
                          color: Colors.black54,
                        ),
                      ),
                    ],
                  ),
                  Container(
                    child: Text(
                      Util.removeHTMLTag('${detail}'),
                      textAlign: TextAlign.left,
                      maxLines: 3,
                      style: TextStyle(
                          color: Colors.black54,
                          fontSize: SizeConfig.getFontSize(12),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),
                    ),
//                  alignment: Alignment.topLeft,
                    padding: EdgeInsets.only(
                        top: SizeConfig.getPadding(8),
                        left: SizeConfig.getPadding(16),
                        right: SizeConfig.getPadding(8),
                        bottom: SizeConfig.getPadding(0)),
                  ),
                  Row(
                    children: <Widget>[
                      SizedBox(
                        width: SizeConfig.getWidth(4),
                      ),
                      Container(
                        alignment: Alignment.topLeft,
                        child: Text(
                          '4.4',
                          textAlign: TextAlign.left,
                          style: TextStyle(
                              color: Colors.black54,
                              fontSize: SizeConfig.getFontSize(14),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.w500),
                        ),
                        padding: EdgeInsets.only(
                            top: SizeConfig.getPadding(5),
                            left: SizeConfig.getPadding(10),
                            bottom: SizeConfig.getPadding(5)),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(14),
                      ),
                      ImageIcon(
                        AssetImage('assets/images/ic_star_active.png'),
                        color: Color.fromRGBO(255, 207, 7, 1),
                        size: SizeConfig.getFontSize(16),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(2),
                      ),
                      ImageIcon(
                        AssetImage('assets/images/ic_star_active.png'),
                        color: Color.fromRGBO(255, 207, 7, 1),
                        size: SizeConfig.getFontSize(16),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(2),
                      ),
                      ImageIcon(
                        AssetImage('assets/images/ic_star_active.png'),
                        color: Color.fromRGBO(255, 207, 7, 1),
                        size: SizeConfig.getFontSize(16),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(2),
                      ),
                      ImageIcon(
                        AssetImage('assets/images/ic_star_active.png'),
                        color: Color.fromRGBO(255, 207, 7, 1),
                        size: SizeConfig.getFontSize(16),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(2),
                      ),
                      ImageIcon(
                        AssetImage('assets/images/ic_star_unactive.png'),
                        color: Colors.grey,
                        size: SizeConfig.getFontSize(16),
                      ),
                      SizedBox(
                        width: SizeConfig.getWidth(20),
                        height: SizeConfig.getWidth(30),
                      ),
                    ],
                  ),
                  SizedBox(
                    height: SizeConfig.getWidth(10),
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
}
