import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:url_launcher/url_launcher.dart';
import 'package:date_format/date_format.dart';

class NearmeDetail extends StatefulWidget {
  String store_name;
  String img_url;
  String detail;
  String date_time;
  String address;
  String latlng;
  String month;
  String distanceWithLocation;

  NearmeDetail(
      {Key key,
      this.store_name,
      this.img_url,
      this.detail,
      this.date_time,
      this.address,
      this.latlng,this.distanceWithLocation})
      : super(key: key);

  @override
  _NearmeDetailState createState() => _NearmeDetailState();
}

void convertDateFromString(String strDate) {
  DateTime todayDate = DateTime.parse(strDate);
  print(todayDate);
  print(formatDate(todayDate,
      [yyyy, ' ', mm, ' ', dd, ' ', hh, ' เวลา: ', nn, ':', ss, ' ', am]));
}

class _NearmeDetailState extends State<NearmeDetail> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
//      appBar: AppBar(
//        backgroundColor: Colors.transparent,
//        elevation: 0,
//        centerTitle: true,
//        title: Text(
//          'k',
//          style: TextStyle(
//              color: Colors.white,
//              fontSize: SizeConfig.getFontSize(20),
//              fontFamily: "SF_Pro_Text",
//              fontWeight: FontWeight.w500),
//        ),
//      ),
      body: _setupView(context),
    );
  }

  void getMM(String mm, String dd, String yy) {
    print('object' + mm);
    if (mm == '01') {
      mm = 'มกราคม';
    }else if (mm == '02') {
      mm = 'กุมภาพันธ์';
    }else if (mm == '03') {
      mm = 'มีนาคม';
    }else if (mm == '04') {
      mm = 'เมษายน';
    }else if (mm == '05') {
      mm = 'พฤษภาคม';
    }else if (mm == '06') {
      mm = 'มิถุนายน';
    }else if (mm == '07') {
      mm = 'กรกฎาคม';
    }else if (mm == '08') {
      mm = 'สิงหาคม';
    }else if (mm == '09') {
      mm = 'กันยายน';
    }else if (mm == '10') {
      mm = 'ตุลาคม';
    }else if (mm == '11') {
      mm = 'พฤศจิกายน';
    }else if (mm == '12') {
      mm = 'ธันวาคม';
    }
widget.month = dd + ' '+ mm + ' ' + yy;
    print(widget.date_time.toString());
  }

  _setupView(BuildContext context) {
    var mydate = widget.date_time.toString().split(' ');
    var mm = mydate[0].toString().split('-');

   getMM( mm[1].toString(),  mm[2].toString(),  mm[0].toString());
    var arr = widget.latlng.toString().split(',');

    print(arr[0]);
    print(arr[1]);
    return SingleChildScrollView(
      child: Column(
        children: <Widget>[
          Stack(
            children: <Widget>[
              Container(
                height: SizeConfig.getWidth(460),
                child: Image.network(
                  widget.img_url.toString(),
                  width: double.maxFinite,
                  fit: BoxFit.fitHeight,
                ),
              ),
              Positioned(
                top: SizeConfig.getPadding(44),
                left: SizeConfig.getPadding(16),
                child: InkWell(
                  onTap: () {
                    Navigator.pop(context);
                  },
                  child: Image.asset(
                    'assets/images/ic_back.png',
                    width: 14,
                  ),
                ),
              ),
              Container(
                padding: EdgeInsets.only(
                  top: SizeConfig.getPadding(440),
                  right: SizeConfig.getPadding(0),
                  left: SizeConfig.getPadding(
                      MediaQuery.of(context).size.width / 1.6),
                ),
                child: GestureDetector(
                  onTap: () {
                    launch(
                        'https://www.google.com/maps/dir/?api=1&destination=${arr[0]},${arr[1]}');
                  },
                  child: Stack(
                    children: <Widget>[
                      Image.asset(
                        'assets/images/btn_nav.png',
                        width: SizeConfig.getWidth(120),
                      ),
                      Container(
                        child: Text(
                          'นำทาง',
                          textAlign: TextAlign.left,
                          style: TextStyle(
                              color: Colors.white,
                              fontSize: SizeConfig.getFontSize(16),
                              fontFamily: "SF_Pro_Text",
                              fontWeight: FontWeight.w500),
                        ),
                        padding: EdgeInsets.only(
                            top: SizeConfig.getPadding(7),
                            left: SizeConfig.getPadding(26),
                            bottom: SizeConfig.getPadding(4)),
                      ),
                    ],
                  ),
                ),
              ),
            ],
          ),
          Column(
            children: <Widget>[
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  widget.month.toString(),
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.grey,
                      fontSize: SizeConfig.getFontSize(14),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(16),
                    left: SizeConfig.getPadding(16),
                    bottom: SizeConfig.getPadding(0)),
              ),
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  widget.store_name.toString(),
                  style: TextStyle(
                      color: Colors.black87,
                      fontSize: SizeConfig.getFontSize(40),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w600),
                ),
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(10),
                    left: SizeConfig.getPadding(16),
                    right: SizeConfig.getPadding(16),
                    bottom: SizeConfig.getPadding(4)),
              ),
              Row(
                children: <Widget>[
                  SizedBox(
                    width: SizeConfig.getWidth(14),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_star_active.png'),
                    color: Color.fromRGBO(255, 207, 7, 1),
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(2),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_star_active.png'),
                    color: Color.fromRGBO(255, 207, 7, 1),
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(2),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_star_active.png'),
                    color: Color.fromRGBO(255, 207, 7, 1),
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(2),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_star_active.png'),
                    color: Color.fromRGBO(255, 207, 7, 1),
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(2),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_star_unactive.png'),
                    color: Colors.grey,
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(40),
                    height: SizeConfig.getWidth(30),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_fav_active.png'),
                    color: Colors.pink,
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(8),
                  ),
                  Container(
                    alignment: Alignment.topLeft,
                    child: Text(
                      '70',
                      textAlign: TextAlign.left,
                      style: TextStyle(
                          color: Colors.black54,
                          fontSize: SizeConfig.getFontSize(12),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),
                    ),
                    padding: EdgeInsets.only(
                        top: SizeConfig.getPadding(5),
                        left: SizeConfig.getPadding(0),
                        bottom: SizeConfig.getPadding(4)),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(20),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_comment.png'),
                    color: Colors.grey,
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(8),
                  ),
                  Container(
                    alignment: Alignment.topLeft,
                    child: Text(
                      '70',
                      textAlign: TextAlign.left,
                      style: TextStyle(
                          color: Colors.black54,
                          fontSize: SizeConfig.getFontSize(12),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),
                    ),
                    padding: EdgeInsets.only(
                        top: SizeConfig.getPadding(5),
                        left: SizeConfig.getPadding(0),
                        bottom: SizeConfig.getPadding(4)),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(20),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/facebook-icon.png'),
                    color: Colors.grey,
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(20),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/ic_twitter.png'),
                    color: Colors.grey,
                    size: SizeConfig.getFontSize(16),
                  ),
                ],
              ),
//              SizedBox(
//                height: SizeConfig.getWidth(8),
//              ),
//              Container(
//                alignment: Alignment.topLeft,
//                child: Text(
//                  'พิพิธภัณฑ์สัตว์น้ำ',
//                  textAlign: TextAlign.left,
//                  style: TextStyle(
//                      color: Colors.grey,
//                      fontSize: SizeConfig.getFontSize(14),
//                      fontFamily: "SF_Pro_Text",
//                      fontWeight: FontWeight.w500),
//                ),
//                padding: EdgeInsets.only(
//                    top: SizeConfig.getPadding(0),
//                    left: SizeConfig.getPadding(16),
//                    bottom: SizeConfig.getPadding(10)),
//              ),
              SizedBox(
                height: SizeConfig.getHeight(10),
              ),
              Row(
                children: <Widget>[
                  SizedBox(
                    width: SizeConfig.getWidth(16),
                  ),
                  ImageIcon(
                    AssetImage('assets/images/pin_drop.png'),
                    color: Colors.black54,
                    size: SizeConfig.getFontSize(16),
                  ),
                  SizedBox(
                    width: SizeConfig.getWidth(4),
                  ),
                  Text(
                    widget.distanceWithLocation.toString(),
                    style: TextStyle(
                      fontWeight: FontWeight.w500,
                      fontSize: SizeConfig.getFontSize(14),
                      color: Colors.black54,
                    ),
                  ),
                ],
              ),
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  widget.address.toString(),
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.grey,
                      fontSize: SizeConfig.getFontSize(14),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
//                  alignment: Alignment.topLeft,
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(10),
                    left: SizeConfig.getPadding(16),
                    right: SizeConfig.getPadding(16),
                    bottom: SizeConfig.getPadding(10)),
              ),
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  widget.detail.toString(),
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.black87,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
//                  alignment: Alignment.topLeft,
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(16),
                    left: SizeConfig.getPadding(16),
                    right: SizeConfig.getPadding(16),
                    bottom: SizeConfig.getPadding(30)),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
