import 'package:feelverapp/ui/my_service/service_paid.dart';
import 'package:feelverapp/ui/my_service/service_ready.dart';
import 'package:feelverapp/ui/my_service/service_success.dart';
import 'package:feelverapp/ui/my_service/service_ticket.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/material.dart';


class service_tab extends StatefulWidget {
  @override
  _service_tabState createState() => _service_tabState();
}

class _service_tabState extends State<service_tab> with SingleTickerProviderStateMixin{

  TabController controller;
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    controller = new TabController(length: 4, vsync: this);
    controller.addListener(_handleTabSelection);
  }

  @override
  void dispose() {
    // TODO: implement dispose
    controller.dispose();
    super.dispose();
  }

  void _handleTabSelection() {
    setState(() {
    });
  }

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      appBar: PreferredSize(
        preferredSize: Size.fromHeight(140),
        child: AppBar(

//        leading: IconButton(
//          icon: Icon(Icons.arrow_back_ios, color: Colors.white),
//          onPressed: () => Navigator.of(context).pop(),
//        ),

          backgroundColor: Color.fromRGBO(106, 179, 170, 1),
          title: new Text(controller.index==0?'ข้อมูลการจองของฉัน':'ประวัติการใช้บริการของฉัน'
              ,style: TextStyle(
              color: Colors.white,
              fontSize: SizeConfig.getFontSize(20),
              fontFamily: "SF_Pro_Text",
              fontWeight: FontWeight.w500)),
          elevation: 0,
          bottom: getTabBar(),

        ),
      ),
      body: containTab(),
    );
  }


  TabBar getTabBar() {
    return new TabBar(
      indicatorColor: Colors.transparent,
      controller: controller,
      tabs: [
        new Tab(
//            icon: Icon(Icons.assignment,
            icon: Icon(Icons.system_update,
                color: controller.index == 0
                    ? Colors.yellowAccent: Colors.white),
            child:Text(
              'การจอง',
              style: TextStyle(
                  color: controller.index == 0
                      ? Colors.yellowAccent: Colors.white,
                  fontSize: 11
              ),
              textAlign: TextAlign.center,
            ),

          ),
        new Tab(
          icon: Icon(Icons.check_circle,
              color: controller.index == 1
                  ? Colors.yellowAccent: Colors.white),
          child:Text(
            'บริการที่พร้อมใช้งาน',
            style: TextStyle(
                color: controller.index == 1
                    ? Colors.yellowAccent: Colors.white,
                fontSize: 11
            ),
            textAlign: TextAlign.center,
          ),

        ),
        new Tab(
          icon: Icon(Icons.credit_card,
              color: controller.index == 2
                  ? Colors.yellowAccent: Colors.white),
          child:Text(
            'บริการที่ต้องชำระ',
            style: TextStyle(
                color: controller.index == 2
                    ? Colors.yellowAccent: Colors.white,
                fontSize: 11
            ),
            textAlign: TextAlign.center,
          ),

        ),
        Container(
            width: 200,
            child: Tab(
              icon: Icon(Icons.thumb_up,
                  color: controller.index == 3
                      ? Colors.yellowAccent: Colors.white),
              child:
              Text(
                'บริการที่แล้วเสร็จ',maxLines: 1,
                style: TextStyle(
                    color: controller.index == 3
                        ? Colors.yellowAccent: Colors.white,
                    fontSize: 10
                ),


              ),))
      ],
    );
  }

  TabBarView getTabBarView(var tabs) {
    return new TabBarView(
      // Add tabs as widgets
      children: tabs,
      // set the controller
      controller: controller,
    );
  }

  Widget containTab(){
    return WillPopScope(
      ///onWillPop: onWillPop,
      child: getTabBarView(<Widget>[

        ServiceTicketPage(),
        ServiceReadyPage(),
        ServicePaidPage(),
        ServiceSuccessPage(),


      ]),


    );
  }
}
