import 'dart:ui';

import 'package:feelverapp/util/AppBar.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:feelverapp/util/rating_star.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class MyReviewsPage extends StatefulWidget {
  @override
  _MyReviewsPageState createState() => _MyReviewsPageState();
}

class _MyReviewsPageState extends State<MyReviewsPage> {
  double rate=0;


  @override
  Widget build(BuildContext context) {


    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
    );
  }

  _setupView() {
    return Stack(
      children: <Widget>[
        containt(),
        header(),
        myAppBar(title: "รีวิวของฉัน",),
      ],
    );
  }


  Widget containt(){
    return  Container(
      child: Column(
        children: <Widget>[
          Container(
            height: SizeConfig.getHeight(160),
          ),
          Expanded(
            child: SingleChildScrollView(
              child: Column(
                children: <Widget>[
                  SizedBox(height: SizeConfig.getHeight(65),),
                  Card1(),
                  Card2(),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }


  Widget LogoutButton(){
    return Container(
//                                color: Colors.red,
      margin: EdgeInsets.only(right: SizeConfig.getPadding(16)+10,left: SizeConfig.getPadding(16)+10,top: SizeConfig.getPadding(10),bottom: SizeConfig.getPadding(30)),
      height: SizeConfig.getHeight(40),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        children: <Widget>[
          Container(
            child: Image.asset("assets/images/Icon_close.png"),
          ),
          SizedBox(
            width: 10,
          ),
          Text("ออกจากระบบ",style: TextStyle(
              color: Color(0xffEEAFB7),
              fontSize: SizeConfig.getFontSize(16),
              fontFamily: "SF_Pro_Text",
              fontWeight: FontWeight.w500),),
        ],),
    );
  }


  Widget Card1(){
    return Card(
          margin: EdgeInsets.only(right: SizeConfig.getPadding(16),left: SizeConfig.getPadding(16),top: SizeConfig.getPadding(10),bottom: SizeConfig.getPadding(25)),
          child: Container(
            margin: EdgeInsets.only(right: 10,left: 10),
//                          color: Colors.yellow,
            child: Column(
              children: <Widget>[
                Container(
                  height: SizeConfig.getHeight(130),
//                  color: Colors.red,
                  child: Row(
                    children: <Widget>[
                      Container(
                        width: SizeConfig.getHeight(100),
                        height: SizeConfig.getHeight(100),
                        padding: EdgeInsets.all(10),
//                        color: Colors.yellow,
                        child: ClipRRect(
                          borderRadius: BorderRadius.circular(10),
                          child: Image.network(
                            'https://scontent.fbkk7-2.fna.fbcdn.net/v/t1.0-9/104204530_3370427592977187_6031309814586327212_o.jpg?_nc_cat=106&_nc_sid=110474&_nc_eui2=AeE2vpoR5NHZLbG8b3YABiSdSsMCoPYM3W1KwwKg9gzdbZuYqR1gPnkW3tGe-TS2Vtphdvn2OuvO2CdDLaCMVvcI&_nc_ohc=T5EK3sWOgtAAX994m4I&_nc_ht=scontent.fbkk7-2.fna&oh=0b3e434546b19e256c07ecd6a4d499fb&oe=5F098A94',
                            fit: BoxFit.cover,
                          ),
                        ),
                      ),
                      Expanded(
                        child: Container(
                          padding: EdgeInsets.all(10),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: <Widget>[
                              Text("Thai Body Balance",
                                style: TextStyle(
                                  color: Colors.black,
                                  fontSize: SizeConfig.getFontSize(14),
                                  fontFamily: "SF_Pro_Text",
                                  fontWeight: FontWeight.w500),),

                              Text("03/16/2019 12:49",
                                style: TextStyle(
                                  color: Color(0xff6AB3AA),
                                  fontSize: SizeConfig.getFontSize(12),
                                  fontFamily: "SF_Pro_Text",
                                  fontWeight: FontWeight.w500),),

                              SizedBox(
                                height: 5,
                              ),

                              Text("SPA Cenvaree @ Centara Grand CentralWorld Bangkok",
                                style: TextStyle(
                                  color: Color(0xff969696),
                                  fontSize: SizeConfig.getFontSize(12),
                                  fontFamily: "SF_Pro_Text",
                                  fontWeight: FontWeight.w500),),


                            ],
                          ),
                          
                        ),
                      ),
                      Container(

                        padding: EdgeInsets.only(top: 10),
                        width: 30,
                        alignment: Alignment.topCenter,
//                        color: Colors.green,
                        child: Icon(Icons.more_vert),
                      ),
                    ],
                  ),
                ),
                Container(
                  width: double.infinity,
                  padding: EdgeInsets.only(bottom: SizeConfig.getPadding(25),top: SizeConfig.getPadding(10),left: 10,right: 10),
                  height: SizeConfig.getHeight(80),
//                  color: Colors.blue,
                  child: RaisedButton(
                      shape: new RoundedRectangleBorder(
                          borderRadius: new BorderRadius.circular(180.0)),
                      child: Text(
                        "Rete this service",
                        style: TextStyle(
                            color: Colors.white,
                            fontSize: SizeConfig.getFontSize(16),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                      ),
                      color: Color(0xffE8A6B4),
                      onPressed: () {

                      }
                  ),
                ),

              ],
            ),
          ),
        );
  }

  Widget Card2(){
    return Card(
      margin: EdgeInsets.only(right: SizeConfig.getPadding(16),left: SizeConfig.getPadding(16),top: SizeConfig.getPadding(10),bottom: SizeConfig.getPadding(10)),
      child: Container(
        margin: EdgeInsets.only(right: 10,left: 10),
//                          color: Colors.yellow,
        child: Column(
          children: <Widget>[
            Container(
              height: SizeConfig.getHeight(100),
//                  color: Colors.red,
              child: Row(
                children: <Widget>[
                  Container(
                    width: SizeConfig.getHeight(100),
                    height: SizeConfig.getHeight(100),
                    padding: EdgeInsets.all(10),
//                        color: Colors.yellow,
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(10),
                      child: Image.network(
                        'https://scontent.fbkk7-2.fna.fbcdn.net/v/t1.0-9/104204530_3370427592977187_6031309814586327212_o.jpg?_nc_cat=106&_nc_sid=110474&_nc_eui2=AeE2vpoR5NHZLbG8b3YABiSdSsMCoPYM3W1KwwKg9gzdbZuYqR1gPnkW3tGe-TS2Vtphdvn2OuvO2CdDLaCMVvcI&_nc_ohc=T5EK3sWOgtAAX994m4I&_nc_ht=scontent.fbkk7-2.fna&oh=0b3e434546b19e256c07ecd6a4d499fb&oe=5F098A94',
                        fit: BoxFit.cover,
                      ),
                    ),
                  ),
                  Expanded(
                    child: Container(
                      padding: EdgeInsets.all(10),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          Text("Thai Body Balance",
                            style: TextStyle(
                                color: Colors.black,
                                fontSize: SizeConfig.getFontSize(14),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),),

                          Text("03/16/2019 12:49",
                            style: TextStyle(
                                color: Color(0xff6AB3AA),
                                fontSize: SizeConfig.getFontSize(12),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),),

                          SizedBox(
                            height: 5,
                          ),

                          Row(
                            children: <Widget>[
                              Text("0.0"),
                              SizedBox(
                                width: 5,
                              ),
                              RatingStar(
                                isRating: true,
                                rate: rate,
                                starSize: 20,
                                onChangeRate: (i){
                                  setState(() {
                                    rate = i;
                                    print(i);
                                  });
                                },
                              ),
                            ],
                          ),


                        ],
                      ),

                    ),
                  ),
                  Container(
                    padding: EdgeInsets.only(top: 10),
                    width: 30,
                    alignment: Alignment.topCenter,
//                        color: Colors.green,
                    child: Icon(Icons.more_vert),
                  ),
                ],
              ),
            ),
            Container(
              width: double.infinity,
              padding: EdgeInsets.only(bottom: SizeConfig.getPadding(25),top: SizeConfig.getPadding(10),left: 10,right: 10),
              child: Column(
                children: <Widget>[
                  Text("การบริการและบรรยากาศดีมาก มีห้องอาบน้ำพร้อมผ้าเช็ดตัว สบู่ ครีมสระผม พนักงานดูแลเอาใจใส่ และคอยแนะนำตลอดจนถึง therapist มีความเป็นมืออาชีพให้ความผ่อนคลายแก่ลูกค้า",
                    style: TextStyle(
                        color: Color(0xff969696),
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),),

                  SizedBox(
                    height: 20,
                  ),

                  Row(
                    children: <Widget>[
                      RaisedButton(
                          shape: new RoundedRectangleBorder(
                              borderRadius: new BorderRadius.circular(180.0)),
                          child: Text(
                            "บรการดีมาก",
                            style: TextStyle(
                                color: Colors.white,
                                fontSize: SizeConfig.getFontSize(15),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),
                          ),
                          color: Color(0xff3694A3),
                          onPressed: () {

                          }
                      ),

                      SizedBox(
                        width: 10,
                      ),

                      RaisedButton(
                          shape: new RoundedRectangleBorder(
                              borderRadius: new BorderRadius.circular(180.0)),
                          child: Text(
                            "คุ่มค่าดี",
                            style: TextStyle(
                                color: Colors.white,
                                fontSize: SizeConfig.getFontSize(15),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),
                          ),
                          color: Color(0xff3694A3),
                          onPressed: () {

                          }
                      ),
                    ],
                  ),
                ],
              ),
            ),

          ],
        ),
      ),
    );
  }

  Widget buttonBar(){
    return Container(

      child: Row(
        children: <Widget>[
          Expanded(
            child: Container(
              height: SizeConfig.getHeight(130),
              padding: EdgeInsets.only(bottom: SizeConfig.getHeight(10)),
//                                color: Colors.green,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.end,
                children: <Widget>[
                  Image.asset("assets/images/icon_menu1_gray.png",
                    width: SizeConfig.getWidth(20),
                    height: SizeConfig.getHeight(30),
                    fit: BoxFit.cover,),
                  SizedBox(
                    height: SizeConfig.getHeight(8),
                  ),
                  Text("การจองของฉัน",
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),)
                ],
              ),
            ),
          ),
          Expanded(
            child: Container(
              height: SizeConfig.getHeight(130),
              padding: EdgeInsets.only(bottom: SizeConfig.getHeight(10)),
//                                color: Colors.blue,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.end,
                children: <Widget>[
                  Image.asset("assets/images/icon_menu2_gray.png",
                    width: SizeConfig.getWidth(20),
                    height: SizeConfig.getHeight(30),
                    fit: BoxFit.cover,),
                  SizedBox(
                    height: SizeConfig.getHeight(5),
                  ),
                  Text("ประวัติการใช้บริการ",
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),)
                ],
              ),
            ),
          ),
          Expanded(
            child: Container(
              height: SizeConfig.getHeight(130),
              padding: EdgeInsets.only(bottom: SizeConfig.getHeight(10)),
//                                color: Colors.red,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.end,
                children: <Widget>[
                  Image.asset("assets/images/icon_menu3_gray.png",
                    width: SizeConfig.getWidth(20),
                    height: SizeConfig.getHeight(30),
                    fit: BoxFit.cover,),
                  SizedBox(
                    height: SizeConfig.getHeight(5),
                  ),
                  Text("การแจ้งเตือน",
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),)
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget header(){
    return Container(
      height: SizeConfig.getHeight(210),
//                color: Colors.amber,
      child: Stack(
        children: <Widget>[

          Column(
            children: <Widget>[
              Container(
                color: Color(0xff6AB3AA),
                height: SizeConfig.getHeight(180),
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.end,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: <Widget>[
                    Container(
                      width: 85,
                      height: 85,
                      margin: EdgeInsets.only(left: SizeConfig.getPadding(16),bottom: 10),
                      //color: Colors.brown,
                    ),

                    Expanded(
                      child: Container(
                        alignment: Alignment.bottomLeft,
                        margin: EdgeInsets.only(bottom: 10),
                        padding: EdgeInsets.only(left: 20),
                        height: 85,
                        //color: Colors.red,
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.end,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: <Widget>[
                            Text("Rataya  Pratumkan",style: TextStyle(
                                color: Colors.white,
                                fontSize: SizeConfig.getFontSize(18),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),),
                            SizedBox(
                              height: 5,
                            ),

                            SizedBox(
                              height: 5,
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
              )
            ],
          ),

          Column(
            mainAxisAlignment: MainAxisAlignment.end,
            children: <Widget>[
              Row(
                mainAxisAlignment: MainAxisAlignment.start,
                children: <Widget>[
                  Container(
                    width: 85,
                    height: 85,
                    margin: EdgeInsets.only(left: SizeConfig.getPadding(16),bottom: 10),
                    //color: Colors.brown,
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(50),
                      child: Image.network(
                        'https://scontent.fbkk7-2.fna.fbcdn.net/v/t1.0-9/104204530_3370427592977187_6031309814586327212_o.jpg?_nc_cat=106&_nc_sid=110474&_nc_eui2=AeE2vpoR5NHZLbG8b3YABiSdSsMCoPYM3W1KwwKg9gzdbZuYqR1gPnkW3tGe-TS2Vtphdvn2OuvO2CdDLaCMVvcI&_nc_ohc=T5EK3sWOgtAAX994m4I&_nc_ht=scontent.fbkk7-2.fna&oh=0b3e434546b19e256c07ecd6a4d499fb&oe=5F098A94',
                        width: 85.0,
                        height: 85.0,
                        fit: BoxFit.cover,
                      ),
                    ),
                  ),
                ],
              ),


            ],
          ),


        ],
      ),
    );
  }
}
