import 'package:feelverapp/ui/home/home.dart';
import 'package:feelverapp/ui/menu/menu.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class MyOrderStatus extends StatefulWidget {
  @override
  _MyOrderStatusState createState() => _MyOrderStatusState();
}

class _MyOrderStatusState extends State<MyOrderStatus> {
  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
    );
  }

  _setupView() {
    return Column(
      children: <Widget>[
        header(),
        _getlist(),
      ],
    );
  }

  _getlist() {
    final List<String> entries = <String>[
      'Ivory Relax and Spa',
      'Sunshine Spa & Massage',
      'Mandarin Ginger Spa'
    ];
    return Expanded(
      child: Container(
        padding: EdgeInsets.only(
          top: SizeConfig.getPadding(16),
          left: SizeConfig.getPadding(16),
          right: SizeConfig.getPadding(16),
          bottom: SizeConfig.getPadding(10),
        ),
        child: ListView.builder(
          itemCount: entries.length,
          itemBuilder: (context, i) {
            return _listItem(entries[i]);
          },
        ),
      ),
    );
  }

  Widget _listItem(String title) {
    return Card(
      child: Column(
        children: <Widget>[
          Container(
//            color: Colors.red,
            height: SizeConfig.getHeight(280),
            child: Stack(
              children: <Widget>[
                Image.network(
                  'https://image.freepik.com/free-photo/girl-massage-spa-salon_110955-422.jpg',
                  height: SizeConfig.getWidth(180),
                  width: MediaQuery.of(context).size.width,
                  fit: BoxFit.cover,
                ),
                Positioned(
                  right: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(16),
                  child: ImageIcon(
                    AssetImage('assets/images/ic_fav_list.png'),
                    color: Colors.white,
                    size: SizeConfig.getFontSize(30),
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(165),
                  child: Image.asset(
                    'assets/images/pin_list.png',
                    width: SizeConfig.getWidth(50),
                    height: SizeConfig.getWidth(50),
                  ),
                ),
                Container(
                  margin: EdgeInsets.only(
                      top: SizeConfig.getPadding(188),
                      left: SizeConfig.getPadding(70)),
//                  color: Colors.orange,
                  child: Row(
                    children: <Widget>[
                      Text(
                        title,
                        textAlign: TextAlign.left,
                        style: TextStyle(
                            color: Colors.black,
                            fontSize: SizeConfig.getFontSize(12),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w700),
                      ),
                      Spacer(),
                      Container(
                        margin: EdgeInsets.only(
                          right: SizeConfig.getPadding(10),
                        ),
//                        color: Colors.yellow,
                        child: Row(
                          children: <Widget>[
                            Image.asset(
                              'assets/images/ic_star_active.png',
                              width: SizeConfig.getWidth(18),
                              height: SizeConfig.getHeight(18),
                            ),
                            Text('4.9'),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ),
          Container(
//            color: Colors.yellow,
            alignment: Alignment.topLeft,
            padding: EdgeInsets.only(
              left: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(24),
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Text(
                  'วันที่สั่งซื้อ : 23.02.2020  08:57',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.grey,
                      fontSize: SizeConfig.getFontSize(12),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                Text(
                  'วันหมดอายุ : 27.02.2020  08:57',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.grey,
                      fontSize: SizeConfig.getFontSize(12),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
              ],
            ),
          ),
          Container(
//            color: Colors.green,
            padding: EdgeInsets.only(
                top: SizeConfig.getPadding(10),
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
                bottom: SizeConfig.getPadding(10)),
            alignment: Alignment.topLeft,
            child: Text(
              'Body Scrub',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black,
                  fontSize: SizeConfig.getFontSize(12),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
          Container(
//            color: Colors.blue,
            padding: EdgeInsets.only(
              left: SizeConfig.getPadding(24),
            ),
            child: Row(
              children: <Widget>[
                Image.asset(
                  'assets/images/clock.png',
                  width: SizeConfig.getWidth(20),
                  height: SizeConfig.getWidth(20),
                ),
                SizedBox(
                  width: SizeConfig.getWidth(6),
                ),
                Text(
                  '90 นาที',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.black87,
                      fontSize: SizeConfig.getFontSize(12),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                Spacer(),
                Image.asset(
                  'assets/images/sell.png',
                  width: SizeConfig.getWidth(20),
                  height: SizeConfig.getWidth(20),
                ),
                SizedBox(
                  width: SizeConfig.getWidth(5),
                ),
                Text(
                  '฿1,599.00 ',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Color.fromRGBO(238, 175, 183, 1),
                      fontSize: SizeConfig.getFontSize(12),
                      decoration: TextDecoration.lineThrough,
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                SizedBox(
                  width: SizeConfig.getWidth(5),
                ),
                Text(
                  '฿1,599.00 ',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Color.fromRGBO(253, 41, 86, 1),
                      fontSize: SizeConfig.getFontSize(22),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w700),
                ),
              ],
            ),
          ),
          InkWell(
            onTap: () {
//              Navigator.push(
//                context,
//                MaterialPageRoute(
//                  builder: (context) => ShopListDetail(),
//                ),
//              );
            },
            child: Stack(
              children: <Widget>[
                Container(
                  child: Image.asset('assets/images/btn_order.png'),
                  padding: EdgeInsets.only(
                    left: SizeConfig.getPadding(20),
                    right: SizeConfig.getPadding(20),
                    top: SizeConfig.getPadding(20),
                    bottom: SizeConfig.getPadding(20),
                  ),
                ),
                Container(
                  alignment: Alignment.center,
                  child: Text(
                    'จอง',
                    textAlign: TextAlign.center,
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(14),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                  padding: EdgeInsets.only(
                    left: SizeConfig.getPadding(20),
                    right: SizeConfig.getPadding(20),
                    top: SizeConfig.getPadding(30),
                    bottom: SizeConfig.getPadding(20),
                  ),
                )
              ],
            ),
          )
        ],
      ),
    );
  }

  Widget header() {
    return Container(
      child: Stack(
        children: <Widget>[
          Container(
            color: Color.fromRGBO(69, 85, 79, 1),
            height: SizeConfig.getHeight(270),
            width: MediaQuery.of(context).size.width,
          ),
          Positioned(
            top: SizeConfig.getPadding(50),
            left:
                SizeConfig.getPadding(MediaQuery.of(context).size.width / 3.5),
            child: Container(
              alignment: Alignment.topCenter,
              child: Image.asset(
                'assets/images/feelver_banner.png',
                width: MediaQuery.of(context).size.width / 2.5,
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(77),
            left: SizeConfig.getPadding(16),
            child: Container(
              child: GestureDetector(
                onTap: () {
                  showDialog(
                    context: context,
                    builder: (BuildContext context) {
                      return NavDrawer();
                    },
                  );
                },
                child: Image.asset(
                  'assets/images/ic_menu.png',
                  height: SizeConfig.getWidth(24),
                  width: SizeConfig.getWidth(30),
                  fit: BoxFit.cover,
                ),
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(77),
            right: SizeConfig.getPadding(60),
            child: Container(
              child: Image.asset(
                'assets/images/ic_noti.png',
                height: SizeConfig.getWidth(30),
                width: SizeConfig.getWidth(30),
                fit: BoxFit.cover,
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(77),
            right: SizeConfig.getPadding(20),
            child: InkWell(
//                onTap: () {
//                  Navigator.push(
//                    context,
//                    MaterialPageRoute(builder: (context) => LoginPage()),
//                  );
//                },
              child: Container(
                child: Image.asset(
                  'assets/images/ic_userimg.png',
                  height: SizeConfig.getWidth(30),
                  width: SizeConfig.getWidth(30),
                  fit: BoxFit.cover,
                ),
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(77),
            right: SizeConfig.getPadding(60),
            child: Container(
              child: Image.asset(
                'assets/images/ic_noti.png',
                height: SizeConfig.getWidth(30),
                width: SizeConfig.getWidth(30),
                fit: BoxFit.cover,
              ),
            ),
          ),
          Container(
//            color: Colors.red,
            margin: EdgeInsets.only(
              top: SizeConfig.getPadding(150),
            ),
            child: Container(
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(15),
                right: SizeConfig.getPadding(15),
              ),
              child: Row(
                children: <Widget>[
                  Column(
                    children: <Widget>[
                      Image.asset(
                        'assets/images/ic_NotInUse.png',
                      ),
                      SizedBox(height: SizeConfig.getHeight(10),),
                      Text(
                        'ยังไม่ได้ใช้งาน',
                        style: TextStyle(
                          color: Color(0xFFEEAFB7),
                          fontSize: SizeConfig.getFontSize(12),
                        ),
                      ),
                    ],
                  ),
                  Spacer(),
                  Column(
                    children: <Widget>[
                      Image.asset(
                        'assets/images/ic_check.png',
                      ),
                      SizedBox(height: SizeConfig.getHeight(10),),
                      Text(
                        'บริการที่พร้อมใช้',
                        style: TextStyle(
                          color: Colors.white,
                          fontSize: SizeConfig.getFontSize(12),
                        ),
                      ),
                    ],
                  ),
                  Spacer(),
                  Column(
                    children: <Widget>[
                      Image.asset(
                        'assets/images/ic_like.png',
                      ),
                      SizedBox(height: SizeConfig.getHeight(10),),
                      Text(
                        'บริการที่เเล้วเสร็จ',
                        style: TextStyle(
                          color: Colors.white,
                          fontSize: SizeConfig.getFontSize(12),
                        ),
                      ),
                    ],
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }
}
