
import 'package:feelverapp/ui/ForgetPassword/forgetpassword.dart';
import 'package:feelverapp/ui/edit_profile/edit_profile.dart';
import 'package:feelverapp/ui/favorite/favorite.dart';
import 'package:feelverapp/ui/home/home.dart';
import 'package:feelverapp/ui/login/login.dart';
import 'package:feelverapp/ui/login/login_presenter.dart';
import 'package:feelverapp/ui/register/register_email.dart';
//import 'package:feelverapp/ui/login/login_presenter.dart';

import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

class NavDrawer extends StatefulWidget {
String id;  
String name;
String image;
String lastname;
    NavDrawer({Key key, this.name,this.lastname,this.image,this.id,}) : super(key: key);
  @override
  _NavDrawerState createState() => _NavDrawerState();

}

class _NavDrawerState extends State<NavDrawer> with TickerProviderStateMixin {


 @override
  Widget build(BuildContext context) {
    return Padding(
      padding:  EdgeInsets.only(right: SizeConfig.getPadding(80)),
      child: Drawer(
        elevation: 10,
        child: SingleChildScrollView(
          child: Column(
            children: <Widget>[
            widget.image==null? Stack(
                            children: <Widget>[
                              Container(
                                height: SizeConfig.getWidth(80),
                                color: Color.fromRGBO(106, 179, 170, 1),
                              ),
                              Container(
                                alignment: Alignment.topCenter,
                                padding: EdgeInsets.only(
                                    left: SizeConfig.getPadding(10),
                                    top: SizeConfig.getPadding(30)),
                                child: Container(
                                  decoration: BoxDecoration(
                                      color: Color.fromRGBO(238, 175, 183, 1),
                                      shape: BoxShape.circle,
                                      border: Border.all(
                                          color: Colors.white, width: 1.4)),
                                  width: SizeConfig.getWidth(100),
                                  height: SizeConfig.getWidth(100),
                                ),
                              ),
                              Container(
                                alignment: Alignment.topCenter,
                                padding: EdgeInsets.only(
                                    left: SizeConfig.getPadding(10),
                                    top: SizeConfig.getPadding(65)),
                                child: Image.asset(
                                  'assets/images/ic_camera_profile.png',
                                  width: SizeConfig.getWidth(34),
                                  height: SizeConfig.getWidth(34),
                                ),
                              )
                            ],
                          ):
                           ClipRRect(
                            borderRadius: BorderRadius.all(
                                Radius.circular(SizeConfig.getWidth(56))),
                            child: Image.network(
                               widget.image,
                              fit: BoxFit.contain,
                              width: SizeConfig.getWidth(100),
                              height: SizeConfig.getWidth(100),
                            ),
                          ),
              
              Container(
                padding: EdgeInsets.only(
                  top: SizeConfig.getPadding(20),
                ),
                alignment: Alignment.center,
                child: Text(
                  '${widget.name}',
                  style: TextStyle(
                      color: Colors.black,
                      fontSize: SizeConfig.getFontSize(24),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w600),
                ),
              ),
              Container(
                margin: EdgeInsets.only(
                    left: SizeConfig.getPadding(50),
                    right: SizeConfig.getPadding(50),
                    top: SizeConfig.getPadding(20)),
                height: SizeConfig.getWidth(1),
                color: Colors.grey,
              ),
              GestureDetector(
                onTap: () {
                  Navigator.push(
                      context,
                      CupertinoPageRoute(builder: (context) => EditProfile(id:widget.id),),
                    );
                },
                child: Container(
                  padding: EdgeInsets.only(
                      top: SizeConfig.getPadding(24),
                      left: SizeConfig.getPadding(30)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    'Profile',
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(16),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w600),
                  ),
                ),
              ),
              GestureDetector(
                onTap: () {
                  Navigator.push(
                    context,
                    CupertinoPageRoute(builder: (context) => Favorite()),
                  );
                },
                child: Container(
                  padding: EdgeInsets.only(
                      top: SizeConfig.getPadding(12),
                      left: SizeConfig.getPadding(30)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    'My favorite',
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(16),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w600),
                  ),
                ),
              ),
              GestureDetector(
                onTap: () {},
                child: Container(
                  padding: EdgeInsets.only(
                      top: SizeConfig.getPadding(12),
                      left: SizeConfig.getPadding(30)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    'My order ',
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(16),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w600),
                  ),
                ),
              ),
              // GestureDetector(
              //   onTap: () {},
              //   child: Container(
              //     padding: EdgeInsets.only(
              //         top: SizeConfig.getPadding(12),
              //         left: SizeConfig.getPadding(30)),
              //     alignment: Alignment.topLeft,
              //     child: Text(
              //       'รายการสั่งซื้อที่สำเร็จ',
              //       style: TextStyle(
              //           color: Colors.black,
              //           fontSize: SizeConfig.getFontSize(16),
              //           fontFamily: "SF_Pro_Text",
              //           fontWeight: FontWeight.w600),
              //     ),
              //   ),
              // ),
              // GestureDetector(
              //   onTap: () {},
              //   child: Container(
              //     padding: EdgeInsets.only(
              //         top: SizeConfig.getPadding(12),
              //         left: SizeConfig.getPadding(30)),
              //     alignment: Alignment.topLeft,
              //     child: Text(
              //       'จองแล้ว',
              //       style: TextStyle(
              //           color: Colors.black,
              //           fontSize: SizeConfig.getFontSize(16),
              //           fontFamily: "SF_Pro_Text",
              //           fontWeight: FontWeight.w600),
              //     ),
              //   ),
              // ),
              // GestureDetector(
              //   onTap: () {},
              //   child: Container(
              //     padding: EdgeInsets.only(
              //         top: SizeConfig.getPadding(12),
              //         left: SizeConfig.getPadding(30)),
              //     alignment: Alignment.topLeft,
              //     child: Text(
              //       'ยังไม่ได้จอง',
              //       style: TextStyle(
              //           color: Colors.black,
              //           fontSize: SizeConfig.getFontSize(16),
              //           fontFamily: "SF_Pro_Text",
              //           fontWeight: FontWeight.w600),
              //     ),
              //   ),
              // ),
              // GestureDetector(
              //   onTap: () {},
              //   child: Container(
              //     padding: EdgeInsets.only(
              //         top: SizeConfig.getPadding(12),
              //         left: SizeConfig.getPadding(30)),
              //     alignment: Alignment.topLeft,
              //     child: Text(
              //       'รายการสั่งซื้อไม่สำเร็จ',
              //       style: TextStyle(
              //           color: Colors.black,
              //           fontSize: SizeConfig.getFontSize(16),
              //           fontFamily: "SF_Pro_Text",
              //           fontWeight: FontWeight.w600),
              //     ),
              //   ),
              // ),
              // Container(
              //   padding: EdgeInsets.only(
              //       top: SizeConfig.getPadding(30),
              //       left: SizeConfig.getPadding(30)),
              //   alignment: Alignment.topLeft,
              //   child: Text(
              //     'language',
              //     style: TextStyle(
              //         color: Colors.black,
              //         fontSize: SizeConfig.getFontSize(16),
              //         fontFamily: "SF_Pro_Text",
              //         fontWeight: FontWeight.w600),
              //   ),
              // ),
              // Row(
              //   children: <Widget>[
              //     Container(
              //       padding: EdgeInsets.only(
              //           left: SizeConfig.getPadding(30),
              //           top: SizeConfig.getPadding(16)),
              //       child: Image.asset(
              //         'assets/images/ic_th.png',
              //         width: SizeConfig.getWidth(50),
              //         height: SizeConfig.getWidth(50),
              //       ),
              //     ),
              //     Container(
              //       padding: EdgeInsets.only(
              //           left: SizeConfig.getPadding(30),
              //           top: SizeConfig.getPadding(16)),
              //       child: Image.asset(
              //         'assets/images/ic_en.png',
              //         width: SizeConfig.getWidth(50),
              //         height: SizeConfig.getWidth(50),
              //       ),
              //     ),
              //     Container(
              //       padding: EdgeInsets.only(
              //           left: SizeConfig.getPadding(30),
              //           top: SizeConfig.getPadding(16)),
              //       child: Image.asset(
              //         'assets/images/ic_ch.png',
              //         width: SizeConfig.getWidth(50),
              //         height: SizeConfig.getWidth(50),
              //       ),
              //     ),
              //   ],
              // ),
              // Row(
              //   children: <Widget>[
              //     Container(
              //       padding: EdgeInsets.only(
              //           top: 0, left: SizeConfig.getPadding(42)),
              //       alignment: Alignment.topLeft,
              //       child: Text(
              //         'TH',
              //         style: TextStyle(
              //             color: Colors.black,
              //             fontSize: SizeConfig.getFontSize(16),
              //             fontFamily: "SF_Pro_Text",
              //             fontWeight: FontWeight.w600),
              //       ),
              //     ),
              //     Container(
              //       padding: EdgeInsets.only(
              //           top: 0, left: SizeConfig.getPadding(60)),
              //       alignment: Alignment.topLeft,
              //       child: Text(
              //         'EN',
              //         style: TextStyle(
              //             color: Colors.black,
              //             fontSize: SizeConfig.getFontSize(16),
              //             fontFamily: "SF_Pro_Text",
              //             fontWeight: FontWeight.w600),
              //       ),
              //     ),
              //     Container(
              //       padding: EdgeInsets.only(
              //           top: 0, left: SizeConfig.getPadding(60)),
              //       alignment: Alignment.topLeft,
              //       child: Text(
              //         'CH',
              //         style: TextStyle(
              //             color: Colors.black,
              //             fontSize: SizeConfig.getFontSize(16),
              //             fontFamily: "SF_Pro_Text",
              //             fontWeight: FontWeight.w600),
              //       ),
              //     ),
              //   ],
              // ),
              SizedBox(height:50),
              Row(
                children: <Widget>[
                  Container(
                    padding: EdgeInsets.only(
                        left: SizeConfig.getPadding(30),
                        top: SizeConfig.getPadding(30)),
                    child: Image.asset(
                      'assets/images/ic_logout.png',
                      width: SizeConfig.getWidth(20),
                      height: SizeConfig.getWidth(20),
                    ),
                  ),
                  GestureDetector(
                    onTap: ()async {

                     SharedPreferences prefs = await SharedPreferences.getInstance();
              prefs.remove('Id');
              Navigator.pushReplacement(context,
                  MaterialPageRoute(builder: (BuildContext ctx) => LoginPage()));
                    },
                    child: Container(
                      padding: EdgeInsets.only(
                          top: SizeConfig.getPadding(26),
                          left: SizeConfig.getPadding(18)),
                      alignment: Alignment.topLeft,
                      child: Text(
                        'ออกจากระบบ',
                        style: TextStyle(
                            color: Colors.black,
                            fontSize: SizeConfig.getFontSize(16),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w600),
                      ),
                    ),
                  )
                ],
              ),
              SizedBox(
                height: SizeConfig.getWidth(40),
              ),
            ],
          ),
        ),
      ),
    );
  }
}



