
import 'package:feelverapp/ui/ForgetPassword/forgetpassword.dart';
import 'package:feelverapp/ui/home/home.dart';
import 'package:feelverapp/ui/login/login_presenter.dart';
import 'package:feelverapp/ui/register/register_email.dart';
//import 'package:feelverapp/ui/login/login_presenter.dart';

import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class LoginPage extends StatefulWidget {

 
  @override
  _LoginPageState createState() => _LoginPageState();
}

class _LoginPageState extends State<LoginPage> with TickerProviderStateMixin {
  TabController _tabController;
   LoginPresenter presenter;
   
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    presenter = LoginPresenter(this);
    presenter.letSignIn();
    _tabController = TabController(length: 2, vsync: this);
     _tabController.addListener(_handleTabSelection);
//    registerBloc = RegisterBloc(this);
//    loginBloc = LoginBloc(this);
  }
   void _handleTabSelection() {
    setState(() {});
  }
 @override
  void dispose() {
    super.dispose();
    _tabController.dispose();
    
  }

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
    );
  }

  _setupView() {
    return Container(
      
      
        
      child: Column(
        children: <Widget>[
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(60),
                right: SizeConfig.getPadding(40),
                top: SizeConfig.getPadding(60)),
            child: Image.asset(
              'assets/images/logo.png',
              width: SizeConfig.getWidth(MediaQuery.of(context).size.width),
              fit: BoxFit.fitWidth,
            ),
          ),
          SizedBox(
            height: SizeConfig.getHeight(24),
          ),
          TabBar(
            indicatorColor: Color.fromRGBO(106, 179, 170, 1),
            unselectedLabelColor: Colors.grey[400],
            labelColor: Colors.black,
            controller: _tabController,
//          onTap: (v) => registerBloc.changeMethodRegister(v),
            tabs: <Widget>[
              Tab(
                child: Text(
                  'อีเมล์',
                  style: TextStyle(
                    fontSize: SizeConfig.getFontSize(16),
                  ),
                ),
              ),
              Tab(
                child: Text(
                  'เบอร์โทร',
                  style: TextStyle(
                    fontSize: SizeConfig.getFontSize(16),
                  ),
                ),
              ),
            ],
          ),

          SizedBox(height: SizeConfig.getWidth(30)),
           Expanded(
                        child: new Container(
              // height: double.maxFinite,
              child: new TabBarView(
                controller: _tabController,
                children: <Widget>[
               _formLogin(),
               _phoneLogin()

              // Container(
              //   color: Colors.red,
              // ),
              // Container(
              //   color: Colors.green,
              // ),
        


                ],
              ),
          ),
           ),
         // _phoneLogin(),
        ],
      ),
    );
  }

  Widget _formLogin() {
    print("index = " +"${_tabController.index}");
    return SingleChildScrollView(
      child: Form(
        child: Column(
          children: <Widget>[
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(30),
              ),
              child: Text(
                'อีเมล์',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                vertical: SizeConfig.getPadding(8.0),
                horizontal: SizeConfig.getPadding(24),
              ),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(
                    SizeConfig.getPadding(50.0),
                  ),
                ),
                child: TextFormField(
                 controller: presenter.emailCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'email', key: 'login') +
//                        ' / ' +
//                        allTranslations.text(
//                            key2: 'tel_number', key: 'register'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                ),
              ),
            ),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(30),
              ),
              child: Text(
                'รหัสผ่าน',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(8.0),
                  horizontal: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(
                    SizeConfig.getPadding(50.0),
                  ),
                ),
                child: TextFormField(
                    controller: presenter.passCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                  obscureText: true,
                ),
              ),
            ),
            SizedBox(
              height: SizeConfig.getWidth(24),
            ),

                Container(
              padding: EdgeInsets.only(right: SizeConfig.getPadding(30)),
              alignment: Alignment.centerRight,
              child: GestureDetector(
                onTap: () {

              
                  Navigator.push(
                    context,
                    MaterialPageRoute(builder: (context) => ForgetPassword()),
                  );
                },
                child: Text(
                  'ลืมรหัสผ่าน',
                  style: TextStyle(
                     color: Color.fromRGBO(106, 179, 170, 1),
                    fontSize: SizeConfig.getFontSize(12),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w600,
                   
                  ),
                  textAlign: TextAlign.right,
                ),
              ),
            ),
           
            _submitLoginButton(),
            _policyText(),
            SizedBox(
              height: SizeConfig.getWidth(20),
            ),
            _facebookLoginButton(),
          ],
        ),
      ),
    );
  }

  Widget _phoneLogin() {
    print("index = " +"${_tabController.index}");
    return SingleChildScrollView(
      child: Form(
        child: Column(
          children: <Widget>[
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'เบอร์โทร',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                vertical: SizeConfig.getPadding(8.0),
                horizontal: SizeConfig.getPadding(24),
              ),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(
                    SizeConfig.getPadding(50.0),
                  ),
                ),
                child: TextFormField(
             controller: presenter.phonenumberCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'email', key: 'login') +
//                        ' / ' +
//                        allTranslations.text(
//                            key2: 'tel_number', key: 'register'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                ),
              ),
            ),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'รหัสผ่าน',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(8.0),
                  horizontal: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius:
                  BorderRadius.circular(SizeConfig.getPadding(50.0)),
                ),
                child: TextFormField(
                   controller: presenter.passCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                  obscureText: true,
                ),
              ),
            ),
            SizedBox(
              height: SizeConfig.getHeight(24),
            ),
        
                Container(
              padding: EdgeInsets.only(right: SizeConfig.getPadding(30)),
              alignment: Alignment.centerRight,
              child: GestureDetector(
                onTap: () {

              
                  Navigator.push(
                    context,
                    MaterialPageRoute(builder: (context) => ForgetPassword()),
                  );
                },
                child: Text(
                  'ลืมรหัสผ่าน',
                  style: TextStyle(
                     color: Color.fromRGBO(106, 179, 170, 1),
                    fontSize: SizeConfig.getFontSize(12),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w600,
                   
                  ),
                  textAlign: TextAlign.right,
                ),
              ),
            ),
            _submitLoginButton(),
            _policyText(),
            SizedBox(
              height: SizeConfig.getHeight(20),
            ),
            _facebookLoginButton(),
          ],
        ),
      ),
    );
  }

  _submitLoginButton() {
    return Padding(
      padding: EdgeInsets.symmetric(
          vertical: SizeConfig.getPadding(20.0),
          horizontal: SizeConfig.getPadding(32)),
      child: Container(
        height: SizeConfig.getHeight(55),
        child: CupertinoButton(
          color: Color.fromRGBO(106, 179, 170, 1),
          padding: EdgeInsets.all(0),
          borderRadius: BorderRadius.all(
            Radius.circular(50),
          ),
          onPressed: () {

    if (_tabController.index==0){ 
            presenter.letCheckData();}
            else{

              presenter.letCheckData_phone();

            }
            // Navigator.push(
            //   context,
            //   MaterialPageRoute(builder: (context) => HomePage()),
            // );
//            if (loginBloc.formKey.currentState.validate()) {
//              loginBloc.getLogin();
//            }
          },
          child: Center(
            child: Text(
              'เข้าสู่ระบบ',
              style: TextStyle(color: Colors.white),
            ),
          ),
        ),
      ),
    );
  }

  Widget _facebookLoginButton() {
    return Padding(
      padding: EdgeInsets.symmetric(
        vertical: SizeConfig.getPadding(16.0),
        horizontal: SizeConfig.getPadding(32),
      ),
      child: Container(
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(
            SizeConfig.getPadding(50),
          ),
          color: Color(0xff3b5998),
        ),
        height: SizeConfig.getHeight(55),
        child: CupertinoButton(
          color: Color(0xff3b5998),
          padding: EdgeInsets.all(0),
//          onPressed: loginBloc.getFacebookLogin,
          child: Center(
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                Padding(
                  padding: EdgeInsets.symmetric(
                    horizontal: SizeConfig.getPadding(8.0),
                  ),
                  child: ImageIcon(
                    AssetImage('assets/images/facebook-icon.png'),
                    size: 20,
                  ),
                ),

                // Text(
                //   'Login with Facebook',
                //   style: TextStyle(fontSize: SizeConfig.getFontSize(12)),
                //   textAlign: TextAlign.center,
                // ),

              ],
            ),
          ),
        ),
      ),
    );
  }

  Widget _policyText() {
    return Column(
      children: <Widget>[
        Column(
          children: <Widget>[
            Container(
              padding: EdgeInsets.only(
                  left: SizeConfig.getPadding(30),
                  right: SizeConfig.getPadding(30),
                  top: SizeConfig.getPadding(30)),
              child: Center(
                child: Text(
                  'คุณยอมรับ ข้อกำหนดการใช้งาน และ  นโยบาย',
                  style: TextStyle(fontSize: SizeConfig.getFontSize(12)),
                  textAlign: TextAlign.center,
                ),
              ),
            ),
  Row(
          children: <Widget>[  
 Container(
              padding: EdgeInsets.only(
                   left: SizeConfig.getPadding(30),
                  right: SizeConfig.getPadding(10),
                  ),
              child: Center(
                child: Text(
                  'ความเป็นส่วนตัวของอโกด้าเมื่อดำเนินการต่อ',
                  style: TextStyle(fontSize: SizeConfig.getFontSize(12)),
                  textAlign: TextAlign.center,
                ),
              ),
            ),


            Container(
          
              alignment: Alignment.centerRight,
              child: GestureDetector(
                onTap: () {

              
                  Navigator.push(
                    context,
                    MaterialPageRoute(builder: (context) => Registerpage()),
                  );
                },
                child: Text(
                  'สมัครสมาชิก',
                  style: TextStyle(
                    color: Colors.orange,
                    fontSize: SizeConfig.getFontSize(12),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w600,
                    decoration: TextDecoration.underline,
                  ),
                  textAlign: TextAlign.right,
                ),
              ),
            )


          ]),

          ],
        ),
        Container(
          padding: EdgeInsets.all(SizeConfig.getPadding(24)),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Expanded(
                flex: 2,
                child: Container(
                  decoration: BoxDecoration(
                    border: Border(
                      bottom: BorderSide(width: 1, color: Color(0xFFE6E6E6)),
                    ),
                  ),
                ),
              ),
              Expanded(
                flex: 1,
                child: Text(
                  'หรือ',
                  style: TextStyle(fontSize: SizeConfig.getFontSize(12)),
                  textAlign: TextAlign.center,
                ),
              ),
              Expanded(
                flex: 2,
                child: Container(
                  decoration: BoxDecoration(
                    border: Border(
                      bottom: BorderSide(width: 1, color: Color(0xFFE6E6E6)),
                    ),
                  ),
                ),
              ),
            ],
          ),
        ),
        Stack(
          children: <Widget>[
            Container(
              padding: EdgeInsets.only(
                  left: SizeConfig.getPadding(60),
                  right: SizeConfig.getPadding(60)),
              child: Center(
                child: Text(
                  'สะดวกสุดๆ แค่ใช้ Facebook เข้าสู่ระบบ ก็ไม่ต้องจำรหัสผ่านอีกต่อไป คลิกปุ่มด้านล่างได้เลย',
                  style: TextStyle(fontSize: SizeConfig.getFontSize(12)),
                  textAlign: TextAlign.center,
                ),
              ),
            ),
          ],
        ),
      ],
    );
  }
}
