import 'package:feelverapp/model/Login/login_model.dart';
import 'package:feelverapp/model/category/category_model.dart';
import 'package:feelverapp/model/editprofile/getprofilemodel.dart';
import 'package:feelverapp/model/favorite/addfav_model.dart';
import 'package:feelverapp/model/home/home_model.dart';
import 'package:feelverapp/model/home_search/searchhomepage_model.dart';
import 'package:feelverapp/service/Loading.dart';

import 'package:feelverapp/service/api.dart';
import 'package:feelverapp/service/base_presenter.dart';
import 'package:feelverapp/ui/home/home.dart';
import 'package:feelverapp/util/Accout_util.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/material.dart';
import 'package:rflutter_alert/rflutter_alert.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:url_launcher/url_launcher.dart';

class HomePresenter extends BasePresenter<HomePage> {
  Api _api;
  var category_model;
  String uid;
  final formkey = GlobalKey<FormState>();
  GetprofileModel getmodel;
  LoginModel logmodel;

  CategoryModel CatModel;
  bool fav=false;
  AddfavModel addmodel;

  TextEditingController searchCtrl = TextEditingController();
  SearchhomeModel searchhomeModel;

  HomePresenter(State<HomePage> state) : super(state);

  Listitem() async {
 
    _api = Api<CategoryModel>();
   
    var res = await _api.category({
      "access_type": "mobile",
    });

// LoadingView(state.context).hide();
    if (res.success != null){
      setState(() {


        CatModel = res.success;

     
      });

    } else {
      print('res Fail');
    }
  }

   getSearch() async{
     LoadingView(state.context).show();
    _api = Api<SearchhomeModel>();
    var res = await _api.homesearch({
      "keyword_shop" : searchCtrl.text,
      "lang" : "all",
      "access" : "portal",
    });
    LoadingView(state.context).hide();
   print('$searchCtrl');


    if (res.fail == null)  
      setState(() {
        searchhomeModel = res.success;
        category_model = res.success;
      });
    
    else{

    }

  }

  getid() async {
    SharedPreferences pref = await SharedPreferences.getInstance();
    setState(() {
      uid = pref.getString('Id');
    });
    return uid;
  }

  getprofile() async {
    _api = Api<GetprofileModel>();

    var res = await _api.getprofile({"id": await AccountUtil.getID()});

    if (res.fail == null) {
      setState(() {
        getmodel = res.success;
      });
      print("Hii" + getmodel.result[0].name);
    } else {
      Alert(
          style: AlertStyle(
            animationType: AnimationType.fromTop,
            isCloseButton: false,
          ),
          context: state.context,
          title: "ไม่สามารถติดต่อ\nเซิร์ฟเวอร์ได้",
          content: Icon(
            Icons.warning,
            color: Colors.orange,
            size: 80,
          ),
          buttons: [
            DialogButton(
              color: Color.fromRGBO(106, 179, 170, 1),
              onPressed: () => Navigator.pop(state.context),
              child: Text(
                "ลองอีกครั้ง",
                style: TextStyle(color: Colors.white, fontSize: 20),
              ),
            )
          ]).show();
    }
  }
  gotoDirection(String lat, String lng) {
    print("debug");
    print(lat);
    print(lng);

    launch('https://www.google.com/maps/dir/?api=1&destination=${lat},${lng}');
  }

  getudid() async {
    SharedPreferences pref = await SharedPreferences.getInstance();
    setState(() {
      uid = pref.getString('Id');
    });
    return uid;
  }

  Addfav(String id) async {
    LoadingView(state.context).show();
    _api = Api<AddfavModel>();
    var res = await _api.addfav({
      "customer_id": uid,
      "store_id": id,
      "vendor_id": id,
      "product_id": id,
    });
    LoadingView(state.context).hide();
    if (res.fail == null) {
      setState(() {
        addmodel = res.success;
        print("complete");
        fav = true;
      });
      showDialog(
          context: state.context,
          builder: (context) {
            Future.delayed(Duration(seconds: 1), () {
              Navigator.of(context).pop(true);
            });
            return AlertDialog(
              content: ImageIcon(
                AssetImage('assets/images/ic_fav_list.png'),
                color: fav ? Color(0xFFDD175F) : Colors.grey,
                size: SizeConfig.getFontSize(30),
              ),
              title: Center(child: Text('บันทึกสำเร็จ')),
            );
          });
    } else {
      print('res Fail');
    }
  }
}
