import 'package:feelverapp/model/category/category_model.dart';
import 'package:feelverapp/service/Loading.dart';
import 'package:feelverapp/service/api.dart';
import 'package:feelverapp/ui/home/home_presenter.dart';
import 'package:feelverapp/ui/login/login.dart';
import 'package:feelverapp/ui/menu/menu.dart';
import 'package:feelverapp/ui/nearme/near_me_list.dart';
import 'package:feelverapp/ui/payment/payment_detail.dart';
import 'package:feelverapp/ui/reserve/reserve_list.dart';
import 'package:feelverapp/ui/shop/shop_list.dart';
import 'package:feelverapp/ui/shop/shop_list_detail.dart';
import 'package:feelverapp/util/Accout_util.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class HomePage extends StatefulWidget {
  String id;
  String image;

  String search;

  HomePage({Key key, this.id, this.image, this.search}) : super(key: key);

  @override
  _HomePageState createState() => _HomePageState();
}

class _HomePageState extends State<HomePage> with TickerProviderStateMixin {
  bool search = false;
  TabController _tabController;
  HomePresenter presenter;

  @override
  void initState() {
    super.initState();

    presenter = HomePresenter(this);
    presenter.Listitem();

     presenter.getid();

    presenter.getprofile();
//print("nenwenwenwew"+presenter.CatModel.dATA[0].cover,);

    //  presenter.getSearch();
  }

  @override
  void dispose() {
    super.dispose();

    _tabController.dispose();
  }

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);

    return Scaffold(
      body: _setupView(),
      bottomNavigationBar: Container(
        color: Color.fromRGBO(69, 85, 79, 1),
        height: SizeConfig.getWidth(80),
        child: Row(
          children: <Widget>[
            Container(
              margin: EdgeInsets.only(left: SizeConfig.getPadding(16), top: 0),
              width: SizeConfig.getWidth(60),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_home.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
                      setState(() {
                        Navigator.push(
                          context,
                          MaterialPageRoute(builder: (context) => HomePage()),
                        );
                      });
                      print("Pressed");
                    },
                  ),
                  Text(
                    'หน้าแรก',
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(left: SizeConfig.getPadding(16), top: 0),
              width: SizeConfig.getWidth(100),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_list.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
                      Navigator.push(
                        context,
                        MaterialPageRoute(builder: (context) => ReserveList()),
                      );
                      print("Pressed");
                    },
                  ),
                  Text(
                    'การจองของฉัน',
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(left: SizeConfig.getPadding(16), top: 0),
              width: SizeConfig.getWidth(80),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_cart.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
                      Navigator.push(
                        context,
                        MaterialPageRoute(
                            builder: (context) => Paymentdetail()),
                      );
                    },
                  ),
                  Text(
                    'รถเข็นของฉัน',
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(11),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  )
                ],
              ),
            ),
            Container(
              margin: EdgeInsets.only(
                  left: SizeConfig.getPadding(16), top: 0, right: 0),
              width: SizeConfig.getWidth(60),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: <Widget>[
                  IconButton(
                    icon: Image.asset(
                      'assets/images/ic_nearme.png',
                      width: SizeConfig.getWidth(24),
                      height: SizeConfig.getWidth(24),
                    ),
                    onPressed: () {
                      Navigator.push(
                        context,
                        MaterialPageRoute(builder: (context) => NearmeList()),
                      );
                    },
                  ),
                  Text(
                    'ใกล้ฉัน',
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  )
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  _setupView() {
    return Column(
      children: <Widget>[
        Stack(
          children: <Widget>[
            Container(
              child: Image.asset(
                'assets/images/banner_top.png',
                height: SizeConfig.getHeight(200),
                width: MediaQuery.of(context).size.width,
                fit: BoxFit.cover,
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(77),
              left: SizeConfig.getPadding(16),
              child: Container(
                child: GestureDetector(
                  onTap: () {
                    showDialog(
                        context: context,
                        builder: (BuildContext context) {
                          return presenter.getmodel == null
                              ? Container()
                              : NavDrawer(
                                  name: presenter.getmodel.result[0].user.name,
                                  id: presenter.getmodel.result[0].id
                                      .toString(),
                                  image: presenter.getmodel.result[0].image,
                                );
                        });
                  },
                  child: Image.asset(
                    'assets/images/ic_menu.png',
                    height: SizeConfig.getWidth(24),
                    width: SizeConfig.getWidth(30),
                    fit: BoxFit.cover,
                  ),
                ),
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(77),
              right: SizeConfig.getPadding(60),
              child: Container(
                child: Image.asset(
                  'assets/images/ic_noti.png',
                  height: SizeConfig.getWidth(30),
                  width: SizeConfig.getWidth(30),
                  fit: BoxFit.cover,
                ),
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(77),
              right: SizeConfig.getPadding(20),
              child: InkWell(
                onTap: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(builder: (context) => LoginPage()),
                  );
                },
                child: presenter.getmodel == null
                    ? Container()
                    : Container(
                        child: ClipRRect(
                          borderRadius: BorderRadius.all(
                              Radius.circular(SizeConfig.getWidth(56))),
                          child: presenter.getmodel.result[0].image == null
                              ? Container()
                              : Image.network(
                                  presenter.getmodel.result[0].image,
                                  fit: BoxFit.contain,
                                  width: SizeConfig.getWidth(30),
                                  height: SizeConfig.getWidth(30),
                                ),
                        ),
                      ),
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(77),
              right: SizeConfig.getPadding(20),
              child: InkWell(
                onTap: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(builder: (context) => LoginPage()),
                  );
                },
                child: presenter.getmodel == null
                    ? Container()
                    : Container(
                        child: ClipRRect(
                          borderRadius: BorderRadius.all(
                              Radius.circular(SizeConfig.getWidth(56))),
                          child: presenter.getmodel.result[0].image == null
                              ? Container()
                              : Image.network(
                                  presenter.getmodel.result[0].image,
                                  fit: BoxFit.contain,
                                  width: SizeConfig.getWidth(30),
                                  height: SizeConfig.getWidth(30),
                                ),
                        ),
                      ),
              ),
            ),
            _searchField(),
          ],
        ),
        SizedBox(
          height: 20,
        ),
        presenter.CatModel == null
            ? Container(
                child: CircularProgressIndicator(
                  valueColor: new AlwaysStoppedAnimation<Color>(
                    Color.fromRGBO(69, 85, 79, 1),
                  ),
                ),
              )
            : search
                ? _getlist()
                : Expanded(
                    child: Container(
                      child: ListView.builder(
                          itemCount: presenter.CatModel.result.length,
                          itemBuilder: (context, i) {
                            return list(i);
                          }),
                    ),
                  ),
      ],
    );
  }

  list(int index) {
    return Container(
      //color: Colors.orange,
      // padding: EdgeInsets.only(
      //   // top: SizeConfig.getPadding(16),

      //   // bottom: SizeConfig.getPadding(10),
      // ),
      child: Column(
        children: <Widget>[
          _listItem(
            presenter.CatModel == null
                ? Image.asset(
                    'assets/images/banner_spa.png',
                    height: SizeConfig.getWidth(130),
                    width: MediaQuery.of(context).size.width,
                    fit: BoxFit.fill,
                  )
                : Image.network(
                    presenter.CatModel.result[index].cover,
                    height: SizeConfig.getHeight(130),
                    width: MediaQuery.of(context).size.width,
                    fit: BoxFit.cover,
                  ),
            presenter.CatModel.result[index].name,
            '',
            ShopList(),
          ),
          SizedBox(
            height: 20,
          ),
        ],
      ),
    );
  }

  Widget _shopItem(
      String title, String image, String address, String detail, String id,String location) {
    return Card(
      child: Column(
        children: <Widget>[
          Container(
            height: SizeConfig.getHeight(270),
            child: Stack(
              children: <Widget>[
                presenter.searchhomeModel == null
                    ? Image.network(
                        'https://image.freepik.com/free-photo/girl-massage-spa-salon_110955-422.jpg',
                        height: SizeConfig.getWidth(180),
                        width: MediaQuery.of(context).size.width,
                        fit: BoxFit.cover,
                      )
                    : Image.network(
                        "https://backend-uat.feelver.com/storage/" + image,
                        height: SizeConfig.getWidth(180),
                        width: MediaQuery.of(context).size.width,
                        fit: BoxFit.cover,
                      ),
                Positioned(
                  right: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(16),
                  child: InkResponse(
                    highlightShape: BoxShape.circle,
                    highlightColor: Color(0xFFDD175F),
                    focusColor: Color(0xFFDD175F),
                    splashColor: Color(0xFFDD175F),
                    onTap: () {
                      setState(() {
                        presenter.fav
                            ? presenter.fav = false
                            : presenter.Addfav(id.toString());
                      },);
                    },
                    child: ImageIcon(
                      AssetImage('assets/images/ic_fav_list.png'),
                      color: presenter.fav ? Color(0xFFDD175F) : Colors.white,
                      size: SizeConfig.getFontSize(30),
                    ),
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(16),
                  top: SizeConfig.getPadding(165),
                  child: InkWell(
                    onTap: (){
                      print(location);

                      List values = location.split(
                          ","); // split() will split from . and gives new List with separated elements.
                      values.forEach(print);
                      print("lat =" + values[0]);
                      print("lng =" + values[1]);
                      presenter.gotoDirection(values[0], values[1]);
                    },
                    child: Image.asset(
                      'assets/images/pin_list.png',
                      width: SizeConfig.getWidth(50),
                      height: SizeConfig.getWidth(50),
                    ),
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(75),
                  top: SizeConfig.getPadding(190),
                  child: InkWell(
                    child: Text(
                      title,
                      textAlign: TextAlign.left,
                      style: TextStyle(
                          decoration: TextDecoration.underline,
                          color: Colors.black,
                          fontSize: SizeConfig.getFontSize(12),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w700),
                    ),
                    onTap: () {
                      Navigator.push(
                        context,
                        MaterialPageRoute(
                            builder: (context) => ShopListDetail(id: id)),
                      );
                    },
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(290),
                  top: SizeConfig.getPadding(187),
                  child: Icon(
                    Icons.star,
                    color: Colors.orangeAccent,
                    size: SizeConfig.getFontSize(18),
                  ),
                ),
                Positioned(
                  left: SizeConfig.getPadding(310),
                  top: SizeConfig.getPadding(190),
                  child: Text(
                    presenter.searchhomeModel.thTH[0].star.toString(),
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ),
              ],
            ),
          ),
          Container(
            padding: EdgeInsets.only(
                bottom: SizeConfig.getPadding(14),
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24)),
            alignment: Alignment.topLeft,
            child: presenter.searchhomeModel == null
                ? Text(
                    "",
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  )
                : Text(
                    address,
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.grey,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),maxLines: 2,
                  ),
          ),
          SizedBox(
            height: 10,
          )
        ],
      ),
    );
  }

  _getlist() {
    return Expanded(
      child: Container(
        padding: EdgeInsets.only(
          top: SizeConfig.getPadding(16),
          left: SizeConfig.getPadding(16),
          right: SizeConfig.getPadding(16),
          bottom: SizeConfig.getPadding(10),
        ),
        child: presenter.searchhomeModel == null
            ? Container()
            : ListView.builder(
                itemCount: presenter.searchhomeModel.thTH.length,
                itemBuilder: (context, i) {
//               new RaisedButton(
//                  child: new Text(
//                    'Load more ...',
//                    style: new TextStyle(
//                      color: Colors.black,
//                      fontWeight: FontWeight.bold,
//                    ),
//                  ),
//                  onPressed: () {
//                    var nextItems = new List<String>.generate(2, (i) {
//                      var itemId = i + presenter.shopModel.dATA[i].storeName.length;
//                      return "Item $itemId";
//                    });
//                    setState(() {
//                      entries.addAll(nextItems);
//                    });
//                  });
                  return _shopItem(
                    presenter.searchhomeModel.thTH[i].storeName,
                    presenter.searchhomeModel.thTH[i].storeCover,
                    presenter.searchhomeModel.thTH[i].address,
                    presenter.searchhomeModel.thTH[i].detail == null
                        ? ""
                        : presenter.searchhomeModel.thTH[i].detail,
                    presenter.searchhomeModel.thTH[i].id.toString(),
                    presenter.searchhomeModel.thTH[i].location.toString(),

                  );
                }),
      ),
    );
  }

  Widget _listItem(Image img, String title, String view, Widget page) {
    return GestureDetector(
      onTap: () {
        presenter.getSearch();
        setState(() {
          search = true;
        });
      },
      child: Container(
        margin: EdgeInsets.only(
          bottom: 8,
          left: SizeConfig.getPadding(15),
          right: SizeConfig.getPadding(15),
        ),
        width: MediaQuery.of(context).size.width,
        child: Stack(
          children: <Widget>[
            Container(
              width: MediaQuery.of(context).size.width,
              child: img,
            ),
            Container(
              margin: const EdgeInsets.only(top: 10.0, left: 14),
              height: SizeConfig.getHeight(110),
              width: SizeConfig.getWidth(320),
              decoration: BoxDecoration(
                  color:
                      Colors.transparent, //remove color to make it transpatent
                  border: Border.all(
                      style: BorderStyle.solid, width: 2, color: Colors.white)),
            ),
            Container(
              alignment: Alignment.center,
              padding: EdgeInsets.only(
                top: SizeConfig.getPadding(40),
              ),
              child: Text(
                title,
                style: TextStyle(
                  color: Colors.white,
                  fontSize: SizeConfig.getFontSize(30),
                  fontWeight: FontWeight.w600,
                ),
              ),
            ),
            Container(
              alignment: Alignment.center,
              padding: EdgeInsets.only(
                top: SizeConfig.getPadding(75),
              ),
              child: Text(
                view,
                style: TextStyle(
                  color: Colors.white,
                  fontSize: SizeConfig.getFontSize(20),
                  fontWeight: FontWeight.w500,
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  _searchField() {
    return Container(
      margin: EdgeInsets.only(
        top: 135,
        left: 24,
        right: 24,
      ),
      height: 55,
      child: TextField(
        controller: presenter.searchCtrl,
        decoration: new InputDecoration(
            border: new OutlineInputBorder(
              borderRadius: const BorderRadius.all(
                const Radius.circular(30.0),
              ),
            ),
            suffixIcon: IconButton(
                onPressed: () {
                  presenter.searchCtrl.clear();
                },
                icon: Icon(Icons.clear,
                    color: presenter.searchCtrl == null
                        ? Colors.transparent
                        : Colors.black)),
            prefixIcon: IconButton(
                onPressed: () {
                  setState(() {
                    search = true;
                    print(search);
                  });
                  presenter.getSearch();
                },
                icon: Icon(Icons.search, color: Colors.grey)),
            filled: true,
            hintText: 'ค้นหาแบบละเอียด',
            fillColor: Colors.white),
      ),
    );
  }
}
