import 'package:feelverapp/ui/menu/menu.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/material.dart';

class GuestInfo extends StatefulWidget {
  @override
  _GuestInfoState createState() => _GuestInfoState();
}

class _GuestInfoState extends State<GuestInfo> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(body: _formtxt(),bottomNavigationBar: Container(
      color: Color.fromRGBO(69, 85, 79, 1),
      height: SizeConfig.getWidth(100),
      child: Column(
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(
              left: SizeConfig.getPadding(0),
              top: SizeConfig.getPadding(0),
            ),
          ),

          Container(
            margin: EdgeInsets.only(
              left: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(24),
              top: SizeConfig.getPadding(30),
//    bottom: SizeConfig.getPadding(15),
            ),
            width: MediaQuery.of(context).size.width,
            height: SizeConfig.getHeight(50),
            child: RaisedButton(
              shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.circular(25.0),
              ),
              onPressed: () {
                Navigator.push(
                  context,
                  MaterialPageRoute(
                    builder: (context) => GuestInfo(),
                  ),
                );
              },
//                padding: EdgeInsets.only(
//                  left: SizeConfig.getPadding(85),
//                  right: SizeConfig.getPadding(85),
//                  top: SizeConfig.getPadding(15),
//                  bottom: SizeConfig.getPadding(15),
//                ),
              color: Color(0xFF3694A3),
              child: Text(
                'ยืนยัน',
                style: TextStyle(
                  fontSize: SizeConfig.getFontSize(16),
                  fontWeight: FontWeight.bold,
                  color: Colors.white,
                ),
              ),
            ),
          ),
        ],
      ),
    ),);
  }


  Widget header() {
    return Container(
      child: Stack(
        children: <Widget>[
          Container(
            color: Color.fromRGBO(69, 85, 79, 1),
            height: SizeConfig.getHeight(200),
            width: MediaQuery.of(context).size.width,
          ),
          Positioned(
            top: SizeConfig.getPadding(50),
            left:
            SizeConfig.getPadding(MediaQuery.of(context).size.width / 3.5),
            child: Container(
              alignment: Alignment.topCenter,
              child: Image.asset(
                'assets/images/feelver_banner.png',
                width: MediaQuery.of(context).size.width / 2.5,
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(77),
            left: SizeConfig.getPadding(16),
            child: Container(
              child: GestureDetector(
                onTap: () {
                  showDialog(
                    context: context,
                    builder: (BuildContext context) {
                      return NavDrawer();
                    },
                  );
                },
                child: Image.asset(
                  'assets/images/ic_menu.png',
                  height: SizeConfig.getWidth(24),
                  width: SizeConfig.getWidth(30),
                  fit: BoxFit.cover,
                ),
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(77),
            right: SizeConfig.getPadding(60),
            child: Container(
              child: Image.asset(
                'assets/images/ic_noti.png',
                height: SizeConfig.getWidth(30),
                width: SizeConfig.getWidth(30),
                fit: BoxFit.cover,
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(77),
            right: SizeConfig.getPadding(20),
            child: InkWell(
//                onTap: () {
//                  Navigator.push(
//                    context,
//                    MaterialPageRoute(builder: (context) => LoginPage()),
//                  );
//                },
              child: Container(
                child: Image.asset(
                  'assets/images/ic_userimg.png',
                  height: SizeConfig.getWidth(30),
                  width: SizeConfig.getWidth(30),
                  fit: BoxFit.cover,
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }
  Widget _formtxt() {
//    print("index = " +"${_tabController.index}");
    return SingleChildScrollView(
      child: Form(
        child: Column(
          children: <Widget>[
            header(),
            SizedBox(height: SizeConfig.getHeight(24),),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30),bottom:  SizeConfig.getPadding(16)),
              child: Text(
                'ข้อมูลของผู้ที่จองให้',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w700),
              ),
            ),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'ชื่อ',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(16),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w700),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                vertical: SizeConfig.getPadding(8.0),
                horizontal: SizeConfig.getPadding(24),
              ),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(
                    SizeConfig.getPadding(50.0),
                  ),
                ),
                child: TextFormField(

//                  controller: presenter.emailCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'email', key: 'login') +
//                        ' / ' +
//                        allTranslations.text(
//                            key2: 'tel_number', key: 'register'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                ),
              ),
            ),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'นามสกุล',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(16),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w700),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(8.0),
                  horizontal: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius:
                  BorderRadius.circular(SizeConfig.getPadding(50.0)),
                ),
                child: TextFormField(
//                  controller: presenter.passCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                  obscureText: true,
                ),
              ),
            ),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'อีเมล์ *',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(16),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w700),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(8.0),
                  horizontal: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius:
                  BorderRadius.circular(SizeConfig.getPadding(50.0)),
                ),
                child: TextFormField(
//                  controller: presenter.firstnameCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),

                ),
              ),
            ),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'หมายเลขโทรศัพท์มือถือ',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(16),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w700),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(8.0),
                  horizontal: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius:
                  BorderRadius.circular(SizeConfig.getPadding(50.0)),
                ),
                child: TextFormField(
//                  controller: presenter.lastnameCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),

                ),
              ),
            ),
            SizedBox(
              height: SizeConfig.getWidth(24),
            ),

//            _submitLoginButton(),

          ],
        ),
      ),
    );
  }


}
