import 'package:feelverapp/model/favorite/delete_favorite_Model.dart';
import 'package:feelverapp/model/favorite/favorite_Model.dart';
import 'package:feelverapp/service/Loading.dart';
import 'package:feelverapp/service/api.dart';
import 'package:feelverapp/service/base_presenter.dart';
import 'package:feelverapp/ui/favorite/favorite.dart';
import 'package:feelverapp/util/Accout_util.dart';
import 'package:flutter/material.dart';

class FavoritePresenter extends BasePresenter<Favorite> {
  Api _api;
  final formkey = GlobalKey<FormState>();
  FavoriteModel favoriteModel;
  DeletefavoriteModel deletefavoriteModel;

  FavoritePresenter(State<Favorite> state) : super(state);

  Favoriteitem() async {  
   
    var _id  = await AccountUtil.getID();

    _api = Api<FavoriteModel>();
    
    var res = await _api.favorite({
      "customer_id": _id,
    });
  
    if (res.fail == null) {
      setState(() {
        favoriteModel = res.success;
      });
    } else {
      print('res Fail');
    }
  }

  Deletefavoriteitem(String id) async {

    LoadingView(state.context).show();
    _api = Api<DeletefavoriteModel>();
    var res = await _api.deletefavorite({
      "id": id,
    });
 LoadingView(state.context).hide();
    if (res.fail == null) {
      setState(() {
        deletefavoriteModel = res.success;
        if (deletefavoriteModel.message == "delete Successfully") {
          Favoriteitem();
        } else {
          print(deletefavoriteModel.message);
        }
      });
    } else {
      print('res Fail');
    }
  }
}
