import 'package:feelverapp/service/api.dart';
import 'package:feelverapp/ui/favorite/favorite_presenter.dart';
import 'package:feelverapp/ui/menu/menu.dart';
import 'package:feelverapp/ui/my_order_status/my_order_status.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/material.dart';
import 'package:flutter/rendering.dart';

class Favorite extends StatefulWidget {
  @override
  _FavoriteState createState() => _FavoriteState();
}

class _FavoriteState extends State<Favorite> {
  bool checkBoxValue = false;

  FavoritePresenter presenter;

  @override
  void initState() {
    super.initState();

    presenter = FavoritePresenter(this);
    presenter.Favoriteitem();
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
      bottomNavigationBar: Container(
        color: Color.fromRGBO(69, 85, 79, 1),
        height: SizeConfig.getHeight(50),
      ),
    );
  }

  _setupView() {
    return Column(
      children: <Widget>[
        header(),
        containt(),
      ],
    );
  }

  Widget containt() {
    return Expanded(
      child: Padding(
        padding: const EdgeInsets.only(
          left: 10,
          right: 10,
          top: 10,
          bottom: 10,
        ),
        child: Container(
          child: presenter.favoriteModel == null
              ? Container(
        child: Center(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.center,
            children: <Widget>[
                 SizedBox(
                child: CircularProgressIndicator( valueColor: new AlwaysStoppedAnimation<Color>(
                    Color.fromRGBO(69, 85, 79, 1),
                  ),),
                 
                height: 30.0,
                width: 30.0,
              ),] 
          ))
              )
              : ListView.builder(
                  itemCount: presenter.favoriteModel.wishListItem.length,
                  itemBuilder: (context, i) {
                    return list(i);
                  }),
        ),
      ),
    );
  }

  Widget list(
    int index,
  ) {
    return Container(
//      color: Colors.red,
      margin: EdgeInsets.only(bottom: 15),
      child: Container(
        child: Column(
          children: <Widget>[
            Row(
              mainAxisAlignment: MainAxisAlignment.start,
              children: <Widget>[
                presenter.favoriteModel == null
                    ? Image.asset(
                        'assets/images/demo_img.png',
                        width: SizeConfig.getWidth(110),
                        height: SizeConfig.getHeight(150),
                        fit: BoxFit.fitWidth,
                      )
                    : Image.network(
                        "https://backend-uat.feelver.com/storage/" +
                            presenter.favoriteModel.wishListItem[index].product
                                .cover,
                        width: SizeConfig.getWidth(110),
                        height: SizeConfig.getHeight(150),
                        fit: BoxFit.cover,
                      ),
                Expanded(
                  child: Container(
                    padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(10),
                      right: SizeConfig.getPadding(5),
                    ),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: <Widget>[
                        Container(
//                          width: MediaQuery.of(context).size.width,
//                    color: Colors.blue,
                          child: Row(
                            children: <Widget>[
                              Expanded(
                                child: Container(
                                  child: Text(
                                    presenter.favoriteModel.wishListItem[index]
                                        .product.name,
                                    style: TextStyle(
                                        color: Colors.black,
                                        fontSize: SizeConfig.getFontSize(15),
                                        fontFamily: "SF_Pro_Text",
                                        fontWeight: FontWeight.w700),
                                    maxLines: 2,
                                  ),
                                ),
                              ),
//                              Spacer(),
                              IconButton(
                                onPressed: () {
                                  print('delete');
                                  presenter.Deletefavoriteitem(presenter
                                      .favoriteModel.wishListItem[index].id
                                      .toString());
                                },
                                icon: Icon(Icons.favorite),
                                color: Color(0xFFDD175F),
                              ),
                            ],
                          ),
                        ),
                        Container(
//                    color: Colors.white,
                          child: Text(
                            'นวดเเผนไทย',
                            style: TextStyle(
                                color: Colors.black,
                                fontSize: SizeConfig.getFontSize(14),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),
                          ),
                        ),
                        SizedBox(
                          height: SizeConfig.getHeight(5),
                        ),
                        Container(
//                    color: Colors.yellow,
                          child: Row(
                            children: <Widget>[
                              Image.asset(
                                'assets/images/clock.png',
                                height: SizeConfig.getHeight(20),
                                width: SizeConfig.getWidth(20),
                              ),
                              SizedBox(
                                width: SizeConfig.getWidth(5),
                              ),
                              Text(presenter.favoriteModel.wishListItem[index]
                                  .product.duration),
                              Spacer(),
                              Icon(
                                Icons.local_offer,
                                color: Color(0xFFEEAFB7),
                              ),
                              Text(
                                "฿0000",
                                style: TextStyle(
                                  decoration: TextDecoration.lineThrough,
                                  fontSize: SizeConfig.getFontSize(16),
                                  fontFamily: "SF_Pro_Text",
                                  color: Color(0xFFEEAFB7),
                                ),
                              ),
                            ],
                          ),
                        ),
                        SizedBox(
                          height: SizeConfig.getHeight(5),
                        ),
                        Container(
//                    color: Colors.orangeAccent,
                          child: Row(
                            children: <Widget>[
                              Spacer(),
                              Text(
                                "฿" +
                                    presenter.favoriteModel.wishListItem[index]
                                        .product.price,
                                style: TextStyle(
                                  fontSize: SizeConfig.getFontSize(20),
                                  color: Color(0xFFFD2956),
                                  fontFamily: "SF_Pro_Text",
                                  fontWeight: FontWeight.bold,
                                ),
                              ),
                            ],
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget header() {
    return Container(
      child: Stack(
        children: <Widget>[
          Container(
            color: Color.fromRGBO(69, 85, 79, 1),
            height: SizeConfig.getHeight(180),
            width: MediaQuery.of(context).size.width,
          ),
          Positioned(
            top: SizeConfig.getPadding(50),
            left:
                SizeConfig.getPadding(MediaQuery.of(context).size.width / 3.5),
            child: Container(
              alignment: Alignment.topCenter,
              child: Image.asset(
                'assets/images/feelver_banner.png',
                width: MediaQuery.of(context).size.width / 2.5,
              ),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(70),
            left: SizeConfig.getPadding(16),
            child: Container(
              child: GestureDetector(
                onTap: () {
                  Navigator.pop(context);
                },
                child: Icon(
                  Icons.keyboard_arrow_left,
                  color: Colors.white,
                  size: SizeConfig.getFontSize(40),
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
