import 'dart:io';

import 'package:feelverapp/service/image_picker_util.dart';
import 'package:feelverapp/ui/edit_profile/editprofile_presenter.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

import '../../util/SizeConfig.dart';

class EditProfile extends StatefulWidget {
  String id;
  EditProfile({
    Key key,
    this.id,
  }) : super(key: key);
  @override
  _EditProfileState createState() => _EditProfileState();
}

class _EditProfileState extends State<EditProfile> {
  EditprofilePresenter presenter;
  File image;
  @override
  void initState() {
    super.initState();

    presenter = EditprofilePresenter(this);

    presenter.getprofile(widget.id);
  }

  _getImage() {
    ImagePickerUtil(context, (img) {
      setState(() {
        image = img;
        presenter.imageFile = img;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Color.fromRGBO(106, 179, 170, 1),
        elevation: 0,
        centerTitle: true,
        title: Text(
          'แก้ไขโปรไฟล์',
          style: TextStyle(
              color: Colors.white,
              fontSize: SizeConfig.getFontSize(20),
              fontFamily: "SF_Pro_Text",
              fontWeight: FontWeight.w500),
        ),
      ),
      body: presenter.getmodel == null
          ? Container(
              child: Center(
                  child: CircularProgressIndicator(
              valueColor: new AlwaysStoppedAnimation<Color>(
                Color.fromRGBO(106, 179, 170, 1),
              ),
            )))
          : SingleChildScrollView(
              child: Column(
                children: <Widget>[
                  GestureDetector(
                    onTap: () {
                      _getImage();
                    },
                    child: image != null
                        ? ClipRRect(
                            borderRadius: BorderRadius.all(
                                Radius.circular(SizeConfig.getWidth(56))),
                            child: Image.file(
                              image,
                              fit: BoxFit.contain,
                              width: SizeConfig.getWidth(100),
                              height: SizeConfig.getWidth(100),
                            ),
                          )
                        : presenter.getmodel.result[0].image == null
                            ? Stack(
                                children: <Widget>[
                                  Container(
                                    height: SizeConfig.getWidth(80),
                                    color: Color.fromRGBO(106, 179, 170, 1),
                                  ),
                                  Container(
                                    alignment: Alignment.topCenter,
                                    padding: EdgeInsets.only(
                                        left: SizeConfig.getPadding(10),
                                        top: SizeConfig.getPadding(30)),
                                    child: Container(
                                      decoration: BoxDecoration(
                                          color:
                                              Color.fromRGBO(238, 175, 183, 1),
                                          shape: BoxShape.circle,
                                          border: Border.all(
                                              color: Colors.white, width: 1.4)),
                                      width: SizeConfig.getWidth(100),
                                      height: SizeConfig.getWidth(100),
                                    ),
                                  ),
                                  Container(
                                    alignment: Alignment.topCenter,
                                    padding: EdgeInsets.only(
                                        left: SizeConfig.getPadding(10),
                                        top: SizeConfig.getPadding(65)),
                                    child: Image.asset(
                                      'assets/images/ic_camera_profile.png',
                                      width: SizeConfig.getWidth(34),
                                      height: SizeConfig.getWidth(34),
                                    ),
                                  )
                                ],
                              )
                            : ClipRRect(
                                borderRadius: BorderRadius.all(
                                    Radius.circular(SizeConfig.getWidth(56))),
                                child: Image.network(
                                  presenter.getmodel.result[0].image,
                                  fit: BoxFit.contain,
                                  width: SizeConfig.getWidth(100),
                                  height: SizeConfig.getWidth(100),
                                ),
                              ),
                  ),
                  Container(
                    alignment: Alignment.topLeft,
                    padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(24),
                      right: SizeConfig.getPadding(24),
                      top: SizeConfig.getPadding(0),
                    ),
                    child: TextFormField(
                      controller: presenter.nameCtrl,
                      decoration: InputDecoration(
                        focusedBorder: UnderlineInputBorder(
                          borderSide: BorderSide(color: Colors.black45),
                        ),
                        labelText: 'ชื่อ',
                        hintStyle:
                            TextStyle(fontSize: 15.0, color: Colors.black),
                        labelStyle: TextStyle(
                            color: Colors.black87,
                            fontSize: SizeConfig.getFontSize(16),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                      ),
                    ),
                  ),
                  Container(
                    alignment: Alignment.topLeft,
                    padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(24),
                      right: SizeConfig.getPadding(24),
                      top: SizeConfig.getPadding(0),
                    ),
                    child: TextFormField(
                      controller: presenter.lnameCtrl,
                      decoration: InputDecoration(
                        focusedBorder: UnderlineInputBorder(
                          borderSide: BorderSide(color: Colors.black45),
                        ),
                        labelText: 'นามสกุล',
                        hintStyle:
                            TextStyle(fontSize: 15.0, color: Colors.black),
                        labelStyle: TextStyle(
                            color: Colors.black87,
                            fontSize: SizeConfig.getFontSize(16),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                      ),
                    ),
                  ),
                  Container(
                    alignment: Alignment.topLeft,
                    padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(24),
                      right: SizeConfig.getPadding(24),
                      top: SizeConfig.getPadding(0),
                    ),
                    child: TextFormField(
                      controller: presenter.selectedSex,
                      decoration: InputDecoration(
                        focusedBorder: UnderlineInputBorder(
                          borderSide: BorderSide(color: Colors.black45),
                        ),
                        hintText: presenter.getmodel.result[0].sex == 'm'
                            ? "ชาย"
                            : "หญิง",
                        labelText: 'เพศ',
                        labelStyle: TextStyle(
                            color: Colors.black87,
                            fontSize: SizeConfig.getFontSize(16),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                        focusColor: Colors.red,
                      ),
                    ),
                  ),
                  Container(
                    alignment: Alignment.topLeft,
                    padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(24),
                      right: SizeConfig.getPadding(24),
                      top: SizeConfig.getPadding(0),
                    ),
                    child: TextFormField(
                      controller: presenter.ageCtrl,
                      decoration: InputDecoration(
                        focusedBorder: UnderlineInputBorder(
                          borderSide: BorderSide(color: Colors.black45),
                        ),
                        hintText: presenter.getmodel.result[0].age == null
                            ? " - "
                            : '${presenter.getmodel.result[0].age}',
                        labelText: 'อายุ',
                        labelStyle: TextStyle(
                            color: Colors.black87,
                            fontSize: SizeConfig.getFontSize(16),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                        focusColor: Colors.red,
                      ),
                    ),
                  ),
                  Container(
                    alignment: Alignment.topLeft,
                    padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(24),
                      right: SizeConfig.getPadding(24),
                      top: SizeConfig.getPadding(0),
                    ),
                    child: TextFormField(
                      controller: presenter.phoneCtrl,
                      decoration: InputDecoration(
                        focusedBorder: UnderlineInputBorder(
                          borderSide: BorderSide(color: Colors.black45),
                        ),
                        hintText: '${presenter.getmodel.result[0].phone}',
                        labelText: 'เบอร์โทร',
                        labelStyle: TextStyle(
                            color: Colors.black87,
                            fontSize: SizeConfig.getFontSize(16),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                        focusColor: Colors.red,
                      ),
                    ),
                  ),
                  Container(
                    alignment: Alignment.topLeft,
                    padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(24),
                      right: SizeConfig.getPadding(24),
                      top: SizeConfig.getPadding(0),
                    ),
                    child: TextFormField(
                      controller: presenter.emailCtrl,
                      decoration: InputDecoration(
                        focusedBorder: UnderlineInputBorder(
                          borderSide: BorderSide(color: Colors.black45),
                        ),
                        hintText: '${presenter.getmodel.result[0].email}',
                        labelText: 'อีเมล์',
                        labelStyle: TextStyle(
                            color: Colors.black87,
                            fontSize: SizeConfig.getFontSize(16),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                        focusColor: Colors.red,
                      ),
                    ),
                  ),
                  Container(
                    alignment: Alignment.topLeft,
                    padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(24),
                      right: SizeConfig.getPadding(24),
                      top: SizeConfig.getPadding(0),
                    ),
                    child: TextFormField(
                      controller: presenter.addresCtrl,
                      decoration: InputDecoration(
                        focusedBorder: UnderlineInputBorder(
                          borderSide: BorderSide(color: Colors.black45),
                        ),
                        hintText: presenter.getmodel.result[0].address == null
                            ? " - "
                            : '${presenter.getmodel.result[0].address}',
                        labelText: 'ที่อยู่',
                        labelStyle: TextStyle(
                            color: Colors.black87,
                            fontSize: SizeConfig.getFontSize(16),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                        focusColor: Colors.red,
                      ),
                    ),
                  ),
                  Container(
                    alignment: Alignment.topLeft,
                    padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(24),
                      right: SizeConfig.getPadding(24),
                      top: SizeConfig.getPadding(0),
                    ),
                    child: TextFormField(
                      decoration: InputDecoration(
                        focusedBorder: UnderlineInputBorder(
                          borderSide: BorderSide(color: Colors.black45),
                        ),
                        hintText: '',
                        labelText: 'ข้อมูลบัญชีธนาคาร',
                        labelStyle: TextStyle(
                            color: Colors.black87,
                            fontSize: SizeConfig.getFontSize(16),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                        focusColor: Colors.red,
                      ),
                    ),
                  ),
                  SizedBox(
                    height: 30,
                  ),
                  SizedBox(
                      width: 70.0,
                      height: 35.0,
                      child: FlatButton(
                        color: Color.fromRGBO(106, 179, 170, 1),
                        textColor: Colors.white,
                        disabledColor: Colors.grey,
                        disabledTextColor: Colors.black,
                        padding: EdgeInsets.all(0.0),
                        splashColor: Colors.blueAccent,
                        onPressed: () {
                          presenter.letCheckData();
                          print('name= ${presenter.nameCtrl.text}');
                          print('lastname= ${presenter.lnameCtrl.text}');
                          print('email= ${presenter.emailCtrl.text}');
                          print('phone= ${presenter.phoneCtrl.text}');
                          print('sex= ${presenter.selectedSex.text}');
                          print('add= ${presenter.addresCtrl.text}');
                          print('age= ${presenter.ageCtrl.text}');
                        },
                        shape: new RoundedRectangleBorder(
                            borderRadius: new BorderRadius.circular(20.0)),
                        child: Text(
                          "ยืนยัน",
                          style: TextStyle(fontSize: 12.0),
                        ),
                      ))
                ],
              ),
            ),
    );
  }
}
