import 'package:feelverapp/ui/booking/booking_detail.dart';
import 'package:feelverapp/ui/booking/bookingflow.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class BookingForm extends StatefulWidget {
  @override
  _BookingFormState createState() => _BookingFormState();
}

class _BookingFormState extends State<BookingForm> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text('จอง'),
        backgroundColor: Color.fromRGBO(69, 85, 79, 1),
      ),
      body: _setupView(),
      bottomNavigationBar: Container(
        height: SizeConfig.getHeight(100),
        color: Color.fromRGBO(69, 85, 79, 1),
        child: Stack(
          children: <Widget>[
            Positioned(
              top: SizeConfig.getPadding(24),
              left: SizeConfig.getPadding(20),
              child: Container(
//                color: Colors.red,
                width: MediaQuery.of(context).size.width / 2.5,
                height: SizeConfig.getHeight(45),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(24),
                  color: Color.fromRGBO(54, 148, 163, 1),
                ),
                child: Container(
                  padding: EdgeInsets.only(top: SizeConfig.getPadding(6)),
                  child: Text(
                    'ยกเลิก',
                    textAlign: TextAlign.center,
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: SizeConfig.getFontSize(14),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                ),
              ),
            ),
            Positioned(
              top: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(20),
              child: InkWell(
                onTap: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                      builder: (context) => BookingDetail(),
                    ),
                  );
                },
                child: Container(
//                color: Colors.red,
                  width: MediaQuery.of(context).size.width / 2.5,
                  height: SizeConfig.getHeight(45),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(24),
                    color: Color.fromRGBO(232, 166, 180, 1),
                  ),
                  child: Container(
                    padding: EdgeInsets.only(top: SizeConfig.getPadding(6)),
                    child: Text(
                      'ชำระเงิน',
                      textAlign: TextAlign.center,
                      style: TextStyle(
                          color: Colors.white,
                          fontSize: SizeConfig.getFontSize(14),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),
                    ),
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  _setupView() {
    return SingleChildScrollView(
      child: Column(
        children: <Widget>[
          Container(
            alignment: Alignment.topLeft,
            padding: EdgeInsets.only(
              top: SizeConfig.getPadding(16),
              left: SizeConfig.getPadding(24),
            ),
            child: Text(
              'ข้อมูลแพ็คเกจที่คุณจอง',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Color.fromRGBO(69, 85, 79, 1),
                  fontSize: SizeConfig.getFontSize(14),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          SizedBox(
            height: SizeConfig.getHeight(16),
          ),
          Container(
            padding: EdgeInsets.only(
              top: SizeConfig.getPadding(10),
              left: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(24),
            ),
            child: Row(
              children: <Widget>[
                ClipRRect(
                  borderRadius: BorderRadius.circular(11.0),
                  child: Image.network(
                    'https://image.freepik.com/free-photo/girl-massage-spa-salon_110955-422.jpg',
                    fit: BoxFit.cover,
                    height: SizeConfig.getHeight(100),
                    width: SizeConfig.getWidth(100),
                  ),
                ),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Container(
                      alignment: Alignment.topLeft,
                      child: Text(
                        'NATURE SENSE',
                        textAlign: TextAlign.left,
                        style: TextStyle(
                            color: Colors.black,
                            fontSize: SizeConfig.getFontSize(12),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w700),
                      ),
                      padding: EdgeInsets.only(
                          top: SizeConfig.getPadding(8),
                          left: SizeConfig.getPadding(16),
                          bottom: SizeConfig.getPadding(4)),
                    ),
                    Container(
                      alignment: Alignment.topLeft,
                      child: Text(
                        'SPA Cenvaree @ Centara Grand',
                        textAlign: TextAlign.left,
                        maxLines: 2,
                        style: TextStyle(
                            color: Colors.grey,
                            fontSize: SizeConfig.getFontSize(12),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                      ),
                      padding: EdgeInsets.only(
                        top: SizeConfig.getPadding(4),
                        left: SizeConfig.getPadding(16),
                        bottom: SizeConfig.getPadding(4),
                      ),
                    ),
                    Row(
                      children: <Widget>[
                        Container(
                          padding: EdgeInsets.only(
                            top: SizeConfig.getPadding(0),
                            left: SizeConfig.getPadding(16),
                            bottom: SizeConfig.getPadding(4),
                          ),
                          child: ImageIcon(
                            AssetImage('assets/images/clock.png'),
                            color: Colors.black87,
                            size: SizeConfig.getFontSize(16),
                          ),
                        ),
                        Container(
                          alignment: Alignment.topLeft,
                          child: Text(
                            '150 min',
                            textAlign: TextAlign.left,
                            maxLines: 2,
                            style: TextStyle(
                                color: Colors.black87,
                                fontSize: SizeConfig.getFontSize(12),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),
                          ),
                          padding: EdgeInsets.only(
                            top: SizeConfig.getPadding(4),
                            left: SizeConfig.getPadding(4),
                            bottom: SizeConfig.getPadding(8),
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
              ],
            ),
          ),
          SizedBox(
            height: SizeConfig.getHeight(24),
          ),
          Container(
            width: MediaQuery.of(context).size.width,
            height: SizeConfig.getHeight(45),
            decoration: BoxDecoration(
              color: Color.fromRGBO(255, 0, 0, 1),
            ),
            child: Container(
              padding: EdgeInsets.only(top: SizeConfig.getPadding(6)),
              child: Text(
                'ได้รับราคาพิเศษนี้เมื่อชำระเงินผ่านออนไลน์ เท่านั้น  !!',
                textAlign: TextAlign.center,
                style: TextStyle(
                    color: Colors.white,
                    fontSize: SizeConfig.getFontSize(14),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
          ),
          Container(
            height: SizeConfig.getHeight(240),
            child: Stack(
              children: <Widget>[
                Positioned(
                  top: SizeConfig.getPadding(12),
                  left: SizeConfig.getPadding(24),
                  child: Text(
                    'พนักงานบริการ',
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.black54,
                        fontSize: SizeConfig.getFontSize(14),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ),
                Container(
                  alignment: Alignment.topLeft,
                  padding: EdgeInsets.only(
                      top: SizeConfig.getPadding(38),
                      left: SizeConfig.getPadding(16)),
                  child: Image.network(
                    'https://upload.wikimedia.org/wikipedia/commons/thumb/a/ac/No_image_available.svg/1200px-No_image_available.svg.png',
                    width: SizeConfig.getWidth(100),
                    height: SizeConfig.getHeight(100),
                  ),
                ),
                Positioned(
                  top: SizeConfig.getPadding(125),
                  left: SizeConfig.getPadding(24),
                  child: Text(
                    'คุณจองวัน เสาร์',
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.black54,
                        fontSize: SizeConfig.getFontSize(14),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ),
                Positioned(
                  top: SizeConfig.getPadding(150),
                  left: SizeConfig.getPadding(24),
                  child: Text(
                    '31 / 03 / 2019',
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.black87,
                        fontSize: SizeConfig.getFontSize(14),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ),
                Positioned(
                  top: SizeConfig.getPadding(75),
                  right: 24,
                  child: Container(
                    alignment: Alignment.topLeft,
                    padding: EdgeInsets.only(
                        top: SizeConfig.getPadding(4),
                        left: SizeConfig.getPadding(24)),
                    child: Text(
                      'ไม่ระบุ',
                      textAlign: TextAlign.left,
                      style: TextStyle(
                          color: Colors.black87,
                          fontSize: SizeConfig.getFontSize(14),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),
                    ),
                  ),
                ),
              ],
            ),
          ),
          Container(
            color: Colors.black26,
            height: 1,
            margin: EdgeInsets.only(
              top: SizeConfig.getPadding(0),
              left: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(24),
            ),
          ),
          SizedBox(
            height: SizeConfig.getHeight(16),
          ),
          Row(
            children: <Widget>[
              SizedBox(
                width: SizeConfig.getWidth(45),
              ),
              Text(
                'ราคา',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Colors.black54,
                    fontSize: SizeConfig.getFontSize(14),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
              SizedBox(
                width: SizeConfig.getWidth(
                    MediaQuery.of(context).size.width / 2.5),
              ),
              Text(
                '฿1,599.00 ',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Color.fromRGBO(253, 41, 86, 1),
                    fontSize: SizeConfig.getFontSize(22),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w700),
              ),
            ],
          ),
          Container(
            alignment: Alignment.topLeft,
            padding: EdgeInsets.only(
                top: SizeConfig.getPadding(16),
                left: SizeConfig.getPadding(24)),
            child: Text(
              'กรุณากรอกข้อมูลของท่าน',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black87,
                  fontSize: SizeConfig.getFontSize(22),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
          SizedBox(
            height: SizeConfig.getHeight(24),
          ),
          _formLogin(),
          _promocode(),
          _payment(),
          Container(
            width: MediaQuery.of(context).size.width,
            color: Colors.black26,
            height: 1,
            margin: EdgeInsets.only(
              top: SizeConfig.getPadding(0),
              left: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(24),
              bottom: SizeConfig.getPadding(24),
            ),
          ),
          _paymentview(),
          SizedBox(
            height: SizeConfig.getHeight(40),
          ),
          Container(
            width: MediaQuery.of(context).size.width,
            color: Colors.black26,
            height: 1,
            margin: EdgeInsets.only(
              top: SizeConfig.getPadding(0),
              left: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(24),
              bottom: SizeConfig.getPadding(24),
            ),
          ),
          _amout(),
          SizedBox(
            height: SizeConfig.getHeight(40),
          ),
        ],
      ),
    );
  }

  Widget _formLogin() {
    return Container(
      child: Form(
        child: Column(
          children: <Widget>[
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'ชื่อ',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                vertical: SizeConfig.getPadding(8.0),
                horizontal: SizeConfig.getPadding(24),
              ),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(
                    SizeConfig.getPadding(50.0),
                  ),
                ),
                child: TextFormField(
//                  controller: loginBloc.emailCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'email', key: 'login') +
//                        ' / ' +
//                        allTranslations.text(
//                            key2: 'tel_number', key: 'register'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                ),
              ),
            ),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'นามสกุล',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(8.0),
                  horizontal: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius:
                      BorderRadius.circular(SizeConfig.getPadding(50.0)),
                ),
                child: TextFormField(
//                  controller: loginBloc.passCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                  obscureText: true,
                ),
              ),
            ),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'อีเมล์ *',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(8.0),
                  horizontal: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius:
                      BorderRadius.circular(SizeConfig.getPadding(50.0)),
                ),
                child: TextFormField(
//                  controller: loginBloc.passCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                  obscureText: true,
                ),
              ),
            ),
            Container(
              alignment: Alignment.topLeft,
              padding: EdgeInsets.only(left: SizeConfig.getPadding(30)),
              child: Text(
                'หมายเลขโทรศัพท์มือถือ',
                style: TextStyle(
                    color: Colors.black,
                    fontSize: SizeConfig.getFontSize(20),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            Padding(
              padding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(8.0),
                  horizontal: SizeConfig.getPadding(24)),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius:
                      BorderRadius.circular(SizeConfig.getPadding(50.0)),
                ),
                child: TextFormField(
//                  controller: loginBloc.passCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                  obscureText: true,
                ),
              ),
            ),
            SizedBox(
              height: SizeConfig.getWidth(20),
            ),
          ],
        ),
      ),
    );
  }

  Widget _promocode() {
    return Stack(
      children: <Widget>[
        Container(
          width: MediaQuery.of(context).size.width,
          height: SizeConfig.getHeight(100),
          decoration: BoxDecoration(
            color: Color.fromRGBO(69, 85, 79, 1),
          ),
          child: Container(
            alignment: Alignment.topLeft,
            padding: EdgeInsets.only(
                top: SizeConfig.getPadding(30),
                left: SizeConfig.getPadding(24)),
            child: Text(
              'ใส่ promotion code',
              textAlign: TextAlign.center,
              style: TextStyle(
                  color: Colors.white,
                  fontSize: SizeConfig.getFontSize(16),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
        ),
        Container(
          padding: EdgeInsets.only(
            top: SizeConfig.getPadding(16),
            left:
                SizeConfig.getPadding(MediaQuery.of(context).size.width / 1.9),
            right: SizeConfig.getPadding(24),
          ),
          height: SizeConfig.getHeight(80),
          child: Card(
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.circular(SizeConfig.getPadding(50.0)),
            ),
            child: TextFormField(
//                  controller: loginBloc.passCtrl,
//                  validator: loginBloc.validateField,
              decoration: InputDecoration(
                contentPadding: EdgeInsets.symmetric(
                  vertical: SizeConfig.getPadding(20),
                  horizontal: SizeConfig.getPadding(16),
                ),
//                    hintText:
//                    allTranslations.text(key2: 'password', key: 'login'),
                border: OutlineInputBorder(borderSide: BorderSide.none),
              ),
              obscureText: true,
            ),
          ),
        )
      ],
    );
  }

  Widget _payment() {
    return Container(
      height: SizeConfig.getHeight(100),
      child: Stack(
        children: <Widget>[
          Positioned(
            top: SizeConfig.getPadding(35),
            left: SizeConfig.getPadding(24),
            child: Text(
              'การชำระเงิน',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black87,
                  fontSize: SizeConfig.getFontSize(22),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w700),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(43),
            right: SizeConfig.getPadding(24),
            child: Text(
              'เลือกช่องทางการชำระอื่น',
              textAlign: TextAlign.left,
              style: TextStyle(
                  color: Colors.black54,
                  fontSize: SizeConfig.getFontSize(14),
                  fontFamily: "SF_Pro_Text",
                  fontWeight: FontWeight.w500),
            ),
          ),
          Positioned(
            top: SizeConfig.getPadding(183),
//            right: SizeConfig.getPadding(24),
            child: Container(
              color: Colors.black26,
              height: 1,
              margin: EdgeInsets.only(
                top: SizeConfig.getPadding(20),
                left: SizeConfig.getPadding(24),
                right: SizeConfig.getPadding(24),
              ),
            ),
          )
        ],
      ),
    );
  }

  Widget _paymentview() {
    return Row(
      children: <Widget>[
        SizedBox(
          width: SizeConfig.getWidth(20),
        ),
        Container(
          child: Image.asset(
            'assets/images/ic_pay.png',
            width: SizeConfig.getWidth(120),
            height: SizeConfig.getHeight(45),
          ),
        ),
        SizedBox(
          width: SizeConfig.getWidth(90),
        ),
        Text(
          'ชำระเงินด้วย \nเลขบัตร ... xxx 589',
          textAlign: TextAlign.right,
          style: TextStyle(
              color: Colors.black87,
              fontSize: SizeConfig.getFontSize(14),
              fontFamily: "SF_Pro_Text",
              fontWeight: FontWeight.w500),
        )
      ],
    );
  }

  Widget _amout() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Container(
          padding: EdgeInsets.only(left: SizeConfig.getPadding(24)),
          alignment: Alignment.topLeft,
          child: Text(
            'ราคาสุดท้าย',
            textAlign: TextAlign.left,
            style: TextStyle(
                color: Colors.black87,
                fontSize: SizeConfig.getFontSize(16),
                fontFamily: "SF_Pro_Text",
                fontWeight: FontWeight.w700),
          ),
        ),
        Row(
          children: <Widget>[
            Container(
              padding: EdgeInsets.only(
                left: SizeConfig.getPadding(24),
                top: SizeConfig.getPadding(10),
              ),
              alignment: Alignment.topLeft,
              child: Text(
                'รวมภาษีและค่าใช้จ่ายอื่นๆ',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Colors.black87,
                    fontSize: SizeConfig.getFontSize(16),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w500),
              ),
            ),
            SizedBox(width: SizeConfig.getWidth(40),),
            Container(
              padding: EdgeInsets.only(
                top: SizeConfig.getPadding(10),
              ),
              child: Text(
                '฿1,599.00 ',
                textAlign: TextAlign.left,
                style: TextStyle(
                    color: Color.fromRGBO(253, 41, 86, 1),
                    fontSize: SizeConfig.getFontSize(22),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w700),
              ),
            ),
          ],
        ),
      ],
    );
  }
}
