import 'package:feelverapp/model/cart/add_cart_model.dart';
import 'package:feelverapp/model/favorite/addfav_model.dart';
import 'package:feelverapp/service/Loading.dart';

import 'package:feelverapp/service/api.dart';
import 'package:feelverapp/service/base_presenter.dart';
import 'package:feelverapp/ui/payment/mycart.dart';

import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:rflutter_alert/rflutter_alert.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:feelverapp/ui/booking/booking_detail.dart';
import '../../model/booking_detail/booking_detail_model.dart';

class BookingDetailtPresenter extends BasePresenter<BookingDetail> {
  final formkey = GlobalKey<FormState>();
  Api _api;
  String type = '3';
  int getid;
  int vendor_id;
  int store_id;
  String user_id;

  bool fav = false;
  AddfavModel addmodel;
  String uid;

  ProductModel getmodel;
  AddCartModel addCartModel;

  BookingDetailtPresenter(State<BookingDetail> state) : super(state);

  getDetail() async {
    print(getid);
    print(store_id);
    print(vendor_id);
    print(user_id);

    _api = Api<ProductModel>();

    var res = await _api.getProductDetail(
        'https://backend.feelver.com/api/product/' +
            getid.toString() +
            '?store_id=' +
            store_id.toString() +
            '&vendor_id=' +
            vendor_id.toString());

    if (res.fail == null) {
      if (res.success.status) {
        setState(
          () {
            print("AAAA :${res.success}");
            getmodel = res.success;
          },
        );
      }
    } else {
      Alert(
          style: AlertStyle(
            animationType: AnimationType.fromTop,
            isCloseButton: false,
          ),
          context: state.context,
          title: "ไม่พบข้อมูล",
          content: Icon(
            Icons.warning,
            color: Colors.orange,
            size: 80,
          ),
          buttons: [
            DialogButton(
              color: Color.fromRGBO(106, 179, 170, 1),
              onPressed: () => Navigator.pop(state.context),
              child: Text(
                "ลองอีกครั้ง",
                style: TextStyle(color: Colors.white, fontSize: 20),
              ),
            )
          ]).show();
    }
  }

  getudid() async {
    SharedPreferences pref = await SharedPreferences.getInstance();
    setState(() {
      uid = pref.getString('Id');
    });
    return uid;
  }

  Addfav(String id) async {
    LoadingView(state.context).show();
    _api = Api<AddfavModel>();
    var res = await _api.addfav({
      "customer_id": uid,
      "store_id": id,
      "vendor_id": id,
      "product_id": id,
    });
    LoadingView(state.context).hide();
    if (res.fail == null) {
      setState(() {
        addmodel = res.success;
        print("complete");
        fav = true;
      });
      showDialog(
          context: state.context,
          builder: (context) {
            Future.delayed(Duration(seconds: 1), () {
              Navigator.of(context).pop(true);
            });
            return AlertDialog(
              content: ImageIcon(
                AssetImage('assets/images/ic_fav_list.png'),
                color: fav ? Color(0xFFDD175F) : Colors.grey,
                size: SizeConfig.getFontSize(30),
              ),
              title: Center(child: Text('บันทึกสำเร็จ')),
            );
          });
    } else {
      print('res Fail');
    }
  }

  addCart(BuildContext context) async {
    print(getid);
    print(store_id);
    print(vendor_id);

    _api = Api<AddCartModel>();

    var res = await _api.addCart('https://backend.feelver.com/api/cart/add?' +
        'store_id=' +
        store_id.toString() +
        '&vendor_id=' +
        vendor_id.toString() +
        '&user_id=' +
        user_id.toString() +
        '&product_id=' +
        getid.toString() +
        '&access_type=portal');

    if (res.fail == null) {
      // if (res.success.status) {
      setState(
        () {
          print("AAAA :${res.success}");
          addCartModel = res.success;
          Alert(
            style: AlertStyle(
              animationType: AnimationType.fromTop,
              isCloseButton: true,
            ),
            context: state.context,
            title: addCartModel.message.toString(),
            content: Icon(
              Icons.warning,
              color: Colors.orange,
              size: 80,
            ),
            buttons: [
              DialogButton(
                color: Color.fromRGBO(106, 179, 170, 1),
                onPressed: () {
                  if (addCartModel != null) {
                    Navigator.push(
                      context,
                      CupertinoPageRoute(
                        builder: (context) => MyCart(
                          user_id: user_id,
                        ),
                      ),
                    );
                  }
                },
                child: Text(
                  "Ok",
                  style: TextStyle(color: Colors.white, fontSize: 20),
                ),
              ),
            ],
          ).show();
        },
      );
    } else {
      Alert(
          style: AlertStyle(
            animationType: AnimationType.fromTop,
            isCloseButton: false,
          ),
          context: state.context,
          title: "ไม่พบข้อมูล",
          content: Icon(
            Icons.warning,
            color: Colors.orange,
            size: 80,
          ),
          buttons: [
            DialogButton(
              color: Color.fromRGBO(106, 179, 170, 1),
              onPressed: () => Navigator.pop(state.context),
              child: Text(
                "ลองอีกครั้ง",
                style: TextStyle(color: Colors.white, fontSize: 20),
              ),
            )
          ]).show();
    }
  }
}
