import 'package:feelverapp/ui/booking/booking_detail_presenter.dart';
import 'package:feelverapp/ui/booking/bookingform.dart';
import 'package:feelverapp/ui/payment/mycart.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:feelverapp/util/Util.dart';

import '../splashscreen/splash_screen_page.dart';

class BookingDetail extends StatefulWidget {
  int getid;
  int vendor_id;
  int store_id;
  String user_id;

  BookingDetail(
      {Key key, this.getid, this.vendor_id, this.store_id, this.user_id})
      : super(key: key);

  @override
  _BookingDetailState createState() => _BookingDetailState();
}

class _BookingDetailState extends State<BookingDetail> {
  BookingDetailtPresenter presenter;

  @override
  void initState() {
    super.initState();
//    widget.getid = 55;
//    print(widget.getid);
    presenter = BookingDetailtPresenter(this);
    setState(() {
      presenter.vendor_id = widget.vendor_id;
      presenter.store_id = widget.store_id;
      presenter.getid = widget.getid;
      presenter.user_id = widget.user_id;
    });
    presenter.getudid();

    presenter.getDetail();
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return presenter.getmodel == null
        ? Container(
            child: Center(
              child: CircularProgressIndicator(
                valueColor: new AlwaysStoppedAnimation<Color>(Colors.teal),
              ),
            ),
          )
        : Container(
            child: ListView(
              padding: EdgeInsets.all(0),
              children: <Widget>[
                _setupView(),
              ],
            ),
          );
  }

  _setupView() {
    return SingleChildScrollView(
      child: Column(
        children: <Widget>[
          Stack(
            children: <Widget>[
              presenter.getmodel.results.cover == null
                  ? Image.asset(
                      'assets/images/demo_img.png',
                      width: SizeConfig.getWidth(110),
                      height: SizeConfig.getHeight(150),
                      fit: BoxFit.fitWidth,
                    )
                  : Image.network(
                      presenter.getmodel.results.cover,
                      width: MediaQuery.of(context).size.width,
                      height: SizeConfig.getHeight(450),
                      fit: BoxFit.cover,
                    ),
            ],
          ),

          presenter.getmodel.results.name == null
              ? Container(
                  padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(24),
                      top: SizeConfig.getPadding(16)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    '-',
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.black54,
                        fontSize: SizeConfig.getFontSize(11),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                )
              : Container(
                  padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(24),
                      right: SizeConfig.getPadding(24),
                      top: SizeConfig.getPadding(16),
                      bottom: SizeConfig.getPadding(16)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    presenter.getmodel.results.name,
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(26),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w700),
                  ),
                ),
          Row(
            children: <Widget>[
              SizedBox(
                width: SizeConfig.getWidth(24),
              ),
              Positioned(
                right: SizeConfig.getPadding(16),
                top: SizeConfig.getPadding(16),
                child: InkResponse(
                  highlightShape: BoxShape.circle,
                  highlightColor: Color(0xFFDD175F),
                  focusColor: Color(0xFFDD175F),
                  splashColor: Color(0xFFDD175F),
                  onTap: () {
                    setState(() {
                      presenter.fav
                          ? presenter.fav = false
                          : presenter.Addfav(widget.getid.toString());
                    });
                  },
                  child: ImageIcon(
                    AssetImage('assets/images/ic_fav_list.png'),
                    color: presenter.fav ? Color(0xFFDD175F) : Colors.grey,
                    size: SizeConfig.getFontSize(30),
                  ),
                ),
              ),
              SizedBox(
                width: SizeConfig.getWidth(8),
              ),
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  '0',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.black54,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(5),
                    left: SizeConfig.getPadding(0),
                    bottom: SizeConfig.getPadding(4)),
              ),
              SizedBox(
                width: SizeConfig.getWidth(20),
              ),
              ImageIcon(
                AssetImage('assets/images/ic_comment.png'),
                color: Colors.grey,
                size: SizeConfig.getFontSize(24),
              ),
              SizedBox(
                width: SizeConfig.getWidth(8),
              ),
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  '0',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.black54,
                      fontSize: SizeConfig.getFontSize(16),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w500),
                ),
                padding: EdgeInsets.only(
                    top: SizeConfig.getPadding(5),
                    left: SizeConfig.getPadding(0),
                    bottom: SizeConfig.getPadding(4)),
              ),
              SizedBox(
                width: SizeConfig.getWidth(20),
              ),
              ImageIcon(
                AssetImage('assets/images/facebook-icon.png'),
                color: Colors.grey,
                size: SizeConfig.getFontSize(24),
              ),
              SizedBox(
                width: SizeConfig.getWidth(20),
              ),
//              ImageIcon(
//                AssetImage('assets/images/ic_twitter.png'),
//                color: Colors.grey,
//                size: SizeConfig.getFontSize(24),
//              ),
            ],
          ),
          SizedBox(
            height: SizeConfig.getWidth(10),
          ),
          Container(
            padding: EdgeInsets.only(
              left: SizeConfig.getPadding(24),
              right: SizeConfig.getPadding(24),
            ),
          ),
          presenter.getmodel.results.excerpt == null
              ? Container(
                  padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(24),
                      right: SizeConfig.getPadding(24),
                      top: SizeConfig.getPadding(16)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    '',
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.black54,
                        fontSize: SizeConfig.getFontSize(11),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                )
              : Container(
                  padding: EdgeInsets.only(
                      left: SizeConfig.getPadding(24),
                      right: SizeConfig.getPadding(24),
                      top: SizeConfig.getPadding(16)),
                  alignment: Alignment.topLeft,
                  child: Text(
                    Util.removeHTMLTag('${presenter.getmodel.results.excerpt}'),
                    textAlign: TextAlign.left,
                    style: TextStyle(
                        color: Colors.black54,
                        fontSize: SizeConfig.getFontSize(16),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),
                  ),
                ),
//          Container(
//            alignment: Alignment.topLeft,
//            padding: EdgeInsets.only(
//                top: SizeConfig.getPadding(24),
//                left: SizeConfig.getPadding(24),
//                right: SizeConfig.getPadding(24)),
//            child: Text(
//              'Thai Body Balance 60 นาที',
//              textAlign: TextAlign.left,
//              style: TextStyle(
//                  color: Colors.black87,
//                  fontSize: SizeConfig.getFontSize(20),
//                  fontFamily: "SF_Pro_Text",
//                  fontWeight: FontWeight.w500),
//            ),
//          ),
          Divider(
            color: Colors.black,
            height: SizeConfig.getHeight(35),
            indent: 20,
            endIndent: 20,
          ),
          SizedBox(
            height: SizeConfig.getHeight(16),
          ),
//          Row(
//            children: <Widget>[
//              SizedBox(
//                width: SizeConfig.getWidth(24),
//              ),
//              Image.asset(
//                'assets/images/clock.png',
//                width: SizeConfig.getWidth(20),
//                height: SizeConfig.getWidth(20),
//              ),
//              SizedBox(
//                width: SizeConfig.getWidth(10),
//              ),
//              Text(
//                '150 นาที',
//                textAlign: TextAlign.left,
//                style: TextStyle(
//                    color: Colors.black87,
//                    fontSize: SizeConfig.getFontSize(12),
//                    fontFamily: "SF_Pro_Text",
//                    fontWeight: FontWeight.w500),
//              ),
//            ],
//          ),
          Stack(
            children: <Widget>[
              Container(
                width: SizeConfig.getWidth(50),
                height: SizeConfig.getHeight(65),
                color: Color.fromRGBO(255, 0, 0, 1),
                margin: EdgeInsets.only(
                  left: SizeConfig.getPadding(24),
//                  right: SizeConfig.getPadding(20),
                  top: SizeConfig.getPadding(10),
                  bottom: SizeConfig.getPadding(20),
                ),
              ),
              Container(
                alignment: Alignment.topLeft,
                child: Text(
                  'Sale\n50%',
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      color: Colors.white,
                      fontSize: SizeConfig.getFontSize(14),
                      fontFamily: "SF_Pro_Text",
                      fontWeight: FontWeight.w700),
                ),
                padding: EdgeInsets.only(
                  left: SizeConfig.getPadding(35),
//                  right: SizeConfig.getPadding(20),
                  top: SizeConfig.getPadding(20),
                  bottom: SizeConfig.getPadding(20),
                ),
              ),
              presenter.getmodel.results.specialPrice == null
                  ? Container(
                      padding: EdgeInsets.only(
                          left: SizeConfig.getPadding(24),
                          right: SizeConfig.getPadding(24),
                          top: SizeConfig.getPadding(16)),
                      alignment: Alignment.topLeft,
                      child: Text(
                        '',
                        textAlign: TextAlign.left,
                        style: TextStyle(
                            color: Colors.black54,
                            fontSize: SizeConfig.getFontSize(11),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                      ),
                    )
                  : Container(
                      alignment: Alignment.topLeft,
                      child: Text(
                        presenter.getmodel.results.specialPrice,
                        textAlign: TextAlign.left,
                        style: TextStyle(
                            color: Color.fromRGBO(255, 0, 0, 1),
                            fontSize: SizeConfig.getFontSize(26),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                      ),
                      padding: EdgeInsets.only(
                        left: SizeConfig.getPadding(90),
//                  right: SizeConfig.getPadding(20),
                        top: SizeConfig.getPadding(10),
                        bottom: SizeConfig.getPadding(20),
                      ),
                    ),
              presenter.getmodel.results.price == null
                  ? Container(
                      padding: EdgeInsets.only(
                          left: SizeConfig.getPadding(24),
                          right: SizeConfig.getPadding(24),
                          top: SizeConfig.getPadding(16)),
                      alignment: Alignment.topLeft,
                      child: Text(
                        '',
                        textAlign: TextAlign.left,
                        style: TextStyle(
                            color: Colors.black54,
                            fontSize: SizeConfig.getFontSize(11),
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                      ),
                    )
                  : Container(
                      alignment: Alignment.topLeft,
                      padding: EdgeInsets.only(
                        left: SizeConfig.getPadding(90),
//                  right: SizeConfig.getPadding(20),
                        top: SizeConfig.getPadding(40),
                        bottom: SizeConfig.getPadding(20),
                      ),
                      child: Text(
                        presenter.getmodel.results.price,
                        textAlign: TextAlign.left,
                        style: TextStyle(
                            color: Colors.black45,
                            fontSize: SizeConfig.getFontSize(20),
                            decoration: TextDecoration.lineThrough,
                            fontFamily: "SF_Pro_Text",
                            fontWeight: FontWeight.w500),
                      ),
                    ),
              InkWell(
                onTap: () {
                  setState(() {
                    presenter.user_id = widget.user_id;
                    presenter.store_id = widget.store_id;
                    presenter.vendor_id = widget.vendor_id;
                    presenter.getid = widget.getid;
                    presenter.addCart(context);
                  },);
                },
                child: Container(
                  margin: EdgeInsets.only(
                      top: SizeConfig.getPadding(20),
                      left: SizeConfig.getPadding(250)),

//                color: Colors.red,
                  width: SizeConfig.getWidth(100),
                  height: SizeConfig.getHeight(45),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(0),
                    color: Color.fromRGBO(238, 175, 183, 1),
                  ),
                  child: Container(
                    padding: EdgeInsets.only(top: SizeConfig.getPadding(6)),
                    child: Text(
                      'หยิบใส่รถเข็น',
                      textAlign: TextAlign.center,
                      style: TextStyle(
                          color: Colors.white,
                          fontSize: SizeConfig.getFontSize(14),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),
                    ),
                  ),
                ),
              ),
            ],
          ),
          SizedBox(
            height: SizeConfig.getHeight(30),
          ),
        ],
      ),
    );
  }
}
