import 'dart:ui';

import 'package:feelverapp/ui/booking/bookingflow.dart';
import 'package:feelverapp/ui/home/home.dart';
import 'package:feelverapp/ui/reserve/reserve_date_time.dart';
import 'package:feelverapp/util/AppBar.dart';
import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class AccountSettingPage extends StatefulWidget {
  @override
  _AccountSettingPageState createState() => _AccountSettingPageState();
}

class _AccountSettingPageState extends State<AccountSettingPage> {
  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      body: _setupView(),
    );
  }

  _setupView() {
    return Stack(
      children: <Widget>[
        containt(),
        header(),
        myAppBar(title: "ตั้งค่าบัญชี",),
      ],
    );
  }


  Widget containt(){
    return  Container(
      child: Column(
        children: <Widget>[
          Container(
            height: SizeConfig.getHeight(160),
          ),
          Expanded(
            child: SingleChildScrollView(
              child: Column(
                children: <Widget>[
                  SizedBox(height: SizeConfig.getHeight(65),),
                  Card1(),
                  Card2(),
                
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }



  Widget Card1(){
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Container(
          margin: EdgeInsets.only(right: SizeConfig.getPadding(16),left: SizeConfig.getPadding(16),top: SizeConfig.getPadding(10),bottom: 5),
          child: Text("บัญชีของฉัน",style: TextStyle(
              color: Color(0xff6AB3AA),
              fontSize: SizeConfig.getFontSize(18),
              fontFamily: "SF_Pro_Text",
              fontWeight: FontWeight.w500),),
        ),
        Card(
          margin: EdgeInsets.only(right: SizeConfig.getPadding(16),left: SizeConfig.getPadding(16),top: SizeConfig.getPadding(10),bottom: SizeConfig.getPadding(10)),
          child: Container(
            margin: EdgeInsets.only(right: 10,left: 10),
//                          color: Colors.yellow,
            child: Column(
              children: <Widget>[
                Divider(color: Color(0x00000000),),
                Container(
//                                color: Colors.red,
                  height: SizeConfig.getHeight(40),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      Text("ข้อมูลของฉัน",style: TextStyle(
                          color: Color(0xffEEAFB7),
                          fontSize: SizeConfig.getFontSize(16),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),),
                      Icon(Icons.keyboard_arrow_right,color: Color(0xAAA8B8C3),size: SizeConfig.getFontSize(26),),
                    ],),
                ),

                Divider(color: Color(0x11000000),),



                Container(
//                                color: Colors.red,
                  height: SizeConfig.getHeight(40),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      Text("เปลี่ยนรหัสผ่าน",style: TextStyle(
                          color: Color(0xffEEAFB7),
                          fontSize: SizeConfig.getFontSize(16),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),),
                      Icon(Icons.keyboard_arrow_right,color: Color(0xAAA8B8C3),size: SizeConfig.getFontSize(26),),
                    ],),
                ),

                Divider(color: Color(0x00000000),),
              ],
            ),
          ),
        ),
      ],
    );
  }

  Widget Card2(){
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Container(
          margin: EdgeInsets.only(right: SizeConfig.getPadding(16),left: SizeConfig.getPadding(16),top: SizeConfig.getPadding(30),bottom: 5),
          child: Text("การตั้งค่า",style: TextStyle(
              color: Color(0xff6AB3AA),
              fontSize: SizeConfig.getFontSize(18),
              fontFamily: "SF_Pro_Text",
              fontWeight: FontWeight.w500),),
        ),
        Card(
          margin: EdgeInsets.only(right: SizeConfig.getPadding(16),left: SizeConfig.getPadding(16),top: SizeConfig.getPadding(10),bottom: SizeConfig.getPadding(10)),
          child: Container(
            margin: EdgeInsets.only(right: 10,left: 10),
//                          color: Colors.yellow,
//                          height: 200,
            child: Column(
              children: <Widget>[
                Divider(color: Color(0x00000000),),
                Container(
//                                color: Colors.red,
                  height: SizeConfig.getHeight(40),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      Text("ตั้งค่าการแจ้งเตือน",style: TextStyle(
                          color: Color(0xffEEAFB7),
                          fontSize: SizeConfig.getFontSize(16),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),),
                      Icon(Icons.keyboard_arrow_right,color: Color(0xAAA8B8C3),size: SizeConfig.getFontSize(26),),
                    ],),
                ),

        
                Divider(color: Color(0x11000000),),

                Container(
//                                color: Colors.red,
                  height: SizeConfig.getHeight(40),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: <Widget>[
                      Text("ภาษา",style: TextStyle(
                          color: Color(0xffEEAFB7),
                          fontSize: SizeConfig.getFontSize(16),
                          fontFamily: "SF_Pro_Text",
                          fontWeight: FontWeight.w500),),
                      Icon(Icons.keyboard_arrow_right,color: Color(0xAAA8B8C3),size: SizeConfig.getFontSize(26),),
                    ],),
                ),

                Divider(color: Color(0x00000000),),
              ],
            ),
          ),
        ),
      ],
    );
  }

  Widget buttonBar(){
    return Container(

      child: Row(
        children: <Widget>[
          Expanded(
            child: Container(
              height: SizeConfig.getHeight(130),
              padding: EdgeInsets.only(bottom: SizeConfig.getHeight(10)),
//                                color: Colors.green,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.end,
                children: <Widget>[
                  Image.asset("assets/images/icon_menu1_gray.png",
                    width: SizeConfig.getWidth(20),
                    height: SizeConfig.getHeight(30),
                    fit: BoxFit.cover,),
                  SizedBox(
                    height: SizeConfig.getHeight(8),
                  ),
                  Text("การจองของฉัน",
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),)
                ],
              ),
            ),
          ),
          Expanded(
            child: Container(
              height: SizeConfig.getHeight(130),
              padding: EdgeInsets.only(bottom: SizeConfig.getHeight(10)),
//                                color: Colors.blue,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.end,
                children: <Widget>[
                  Image.asset("assets/images/icon_menu2_gray.png",
                    width: SizeConfig.getWidth(20),
                    height: SizeConfig.getHeight(30),
                    fit: BoxFit.cover,),
                  SizedBox(
                    height: SizeConfig.getHeight(5),
                  ),
                  Text("ประวัติการใช้บริการ",
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),)
                ],
              ),
            ),
          ),
          Expanded(
            child: Container(
              height: SizeConfig.getHeight(130),
              padding: EdgeInsets.only(bottom: SizeConfig.getHeight(10)),
//                                color: Colors.red,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.end,
                children: <Widget>[
                  Image.asset("assets/images/icon_menu3_gray.png",
                    width: SizeConfig.getWidth(20),
                    height: SizeConfig.getHeight(30),
                    fit: BoxFit.cover,),
                  SizedBox(
                    height: SizeConfig.getHeight(5),
                  ),
                  Text("การแจ้งเตือน",
                    style: TextStyle(
                        color: Colors.black,
                        fontSize: SizeConfig.getFontSize(12),
                        fontFamily: "SF_Pro_Text",
                        fontWeight: FontWeight.w500),)
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget header(){
    return Container(
      height: SizeConfig.getHeight(210),
//                color: Colors.amber,
      child: Stack(
        children: <Widget>[



          Column(
            children: <Widget>[
              Container(
                color: Color(0xff6AB3AA),
                height: SizeConfig.getHeight(180),
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.end,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: <Widget>[
                    Container(
                      width: 85,
                      height: 85,
                      margin: EdgeInsets.only(left: SizeConfig.getPadding(16),bottom: 10),
                      //color: Colors.brown,
                    ),

                    Expanded(
                      child: Container(
                        alignment: Alignment.bottomLeft,
                        margin: EdgeInsets.only(bottom: 10),
                        padding: EdgeInsets.only(left: 20),
                        height: 85,
                        //color: Colors.red,
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.end,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: <Widget>[
                            Text("Rataya  Pratumkan",style: TextStyle(
                                color: Colors.white,
                                fontSize: SizeConfig.getFontSize(18),
                                fontFamily: "SF_Pro_Text",
                                fontWeight: FontWeight.w500),),
                            
                            SizedBox(
                              height: 5,
                            ),
                          ],
                        ),
                      ),
                    ),
         
                  ],
                ),
              )
            ],
          ),

          Column(
            mainAxisAlignment: MainAxisAlignment.end,
            children: <Widget>[
              Row(
                mainAxisAlignment: MainAxisAlignment.start,
                children: <Widget>[
                  Container(
                    width: 85,
                    height: 85,
                    margin: EdgeInsets.only(left: SizeConfig.getPadding(16),bottom: 10),
                    //color: Colors.brown,
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(50),
                      child: Image.network(
                        'https://backend-uat.feelver.com/storage/2020/08/08_image.jpg',
                        width: 105.0,
                        height: 105.0,
                        fit: BoxFit.cover,
                      ),
                    ),
                  ),
                ],
              ),


            ],
          ),


        ],
      ),
    );
  }
}
