import 'dart:async';
import 'dart:developer';

import 'package:feelverapp/model/Login/login_model.dart';
import 'package:feelverapp/model/forgetpassword/forgetpassModel.dart';

import 'package:feelverapp/service/Loading.dart';

import 'package:feelverapp/service/api.dart';
import 'package:feelverapp/service/base_presenter.dart';
import 'package:feelverapp/ui/ForgetPassword/forgetpassword.dart';
import 'package:feelverapp/ui/home/home.dart';
import 'package:feelverapp/ui/login/login.dart';
import 'package:feelverapp/util/Accout_util.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:rflutter_alert/rflutter_alert.dart';

class ForgetPasswordPresenter extends BasePresenter<ForgetPassword> {
  Api _api;
  Timer _timer;
  final formKey = GlobalKey<FormState>();
  TextEditingController emailCtrl = TextEditingController();

  ForgetPasswordPresenter(State<ForgetPassword> state) : super(state);

  letCheckData() async {
    try {
      if (emailCtrl.text.isEmpty) throw ('กรุณากรอก\nอีเมล์');

      Pattern pattern =
          r"^[a-zA-Z0-9.a-zA-Z0-9.!#$%&'*+-/=?^_`{|}~]+@[a-zA-Z0-9]+\.[a-zA-Z]+";
      RegExp regex = new RegExp(pattern);
      if (!regex.hasMatch(emailCtrl.text))
        throw ('รูปแบบอีเมล์\nไม่ถูกต้อง');
      else {
        await forgetpassrequest();
      }
    } catch (e) {
      Alert(
          style: AlertStyle(
            animationType: AnimationType.fromTop,
            isCloseButton: false,
          ),
          context: state.context,
          title: '$e',
          content: Icon(
            Icons.warning,
            color: Colors.orange,
            size: 80,
          ),
          buttons: [
            DialogButton(
              color: Color.fromRGBO(106, 179, 170, 1),
              onPressed: () => Navigator.pop(state.context),
              child: Text(
                "ตกลง",
                style: TextStyle(color: Colors.white, fontSize: 20),
              ),
            )
          ]).show();
    }
  }

  forgetpassrequest() async {
    LoadingView(state.context).show();
    _api = Api<FogetPasswordModel>();

    var res = await _api.forgetPassword({
      "access_type": "mobile",
      "email": emailCtrl.text,
    });
    LoadingView(state.context).hide();

    if (res.fail == null) {
      Alert(
          style: AlertStyle(
            animationType: AnimationType.fromTop,
            isCloseButton: false,
          ),
          context: state.context,
          title: "สำเร็จ\nกรุณาตรวจสอบอีเมล์ของท่าน",
          content: Icon(
            Icons.check_circle,
            color: Color.fromRGBO(106, 179, 170, 1),
            size: 80,
          ),
          buttons: [
            DialogButton(
              color: Color.fromRGBO(106, 179, 170, 1),
              onPressed: () => Navigator.pushReplacement(state.context,
                  CupertinoPageRoute(builder: (_) => LoginPage())),
              child: Text(
                "ตกลง",
                style: TextStyle(color: Colors.white, fontSize: 20),
              ),
            )
          ]).show();
      FogetPasswordModel model = res.success;
    } else {
      Alert(
          style: AlertStyle(
            animationType: AnimationType.fromTop,
            isCloseButton: false,
          ),
          context: state.context,
          title: "อีเมล์\nไม่ถูกต้อง",
          content: Icon(
            Icons.warning,
            color: Colors.orange,
            size: 80,
          ),
          buttons: [
            DialogButton(
              color: Color.fromRGBO(106, 179, 170, 1),
              onPressed: () => Navigator.pop(state.context),
              child: Text(
                "ลองอีกครั้ง",
                style: TextStyle(color: Colors.white, fontSize: 20),
              ),
            )
          ]).show();
    }
  }
}
