
import 'package:feelverapp/ui/ForgetPassword/forgetpassword_presenter.dart';
import 'package:feelverapp/ui/home/home.dart';
import 'package:feelverapp/ui/login/login_presenter.dart';
import 'package:feelverapp/ui/register/register_email.dart';
//import 'package:feelverapp/ui/login/login_presenter.dart';

import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class ForgetPassword extends StatefulWidget {
  @override
  _ForgetPasswordState createState() => _ForgetPasswordState();
}

class _ForgetPasswordState extends State<ForgetPassword> with TickerProviderStateMixin {
  TabController _tabController;
  ForgetPasswordPresenter presenter;
  @override
  void initState() {
   
    super.initState();
     presenter = ForgetPasswordPresenter(this);

  }
  
 @override
  void dispose() {
    super.dispose();
    _tabController.dispose();
    
  }

  @override
  Widget build(BuildContext context) {
    SizeConfig(context);
    return Scaffold(
      appBar: AppBar(
        title: Text('ลืมรหัสผ่าน'),
        backgroundColor: Color.fromRGBO(54, 148, 163, 1),
      ),
      body: _setupView(),
    );
  }

  _setupView() {
    return Container(
      
      
        
      child:SingleChildScrollView(child:  Column(
        children: <Widget>[
          Container(
            padding: EdgeInsets.only(
                left: SizeConfig.getPadding(60),
                right: SizeConfig.getPadding(40),
                top: SizeConfig.getPadding(60)),
            child: Image.asset(
              'assets/images/logo.png',
              width: SizeConfig.getWidth(MediaQuery.of(context).size.width),
              fit: BoxFit.fitWidth,
            ),
          ),
           SizedBox(
              height: SizeConfig.getWidth(50),
            ),
           _formLogin(),
              
         // _phoneLogin(),
        ],
      ),),
    );
  }

  Widget _formLogin() {
   
    return SingleChildScrollView(
      child: Form(
        child: Column(
          children: <Widget>[
       
            Padding(
              padding: EdgeInsets.symmetric(
                vertical: SizeConfig.getPadding(8.0),
                horizontal: SizeConfig.getPadding(24),
              ),
              child: Card(
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(
                    SizeConfig.getPadding(50.0),
                  ),
                ),
                child: TextFormField(
               
                  
                controller: presenter.emailCtrl,
//                  validator: loginBloc.validateField,
                  decoration: InputDecoration(
                    hintText: "อีเมล์",
                    contentPadding: EdgeInsets.symmetric(
                      vertical: SizeConfig.getPadding(20),
                      horizontal: SizeConfig.getPadding(16),
                    ),
//                    hintText:
//                    allTranslations.text(key2: 'email', key: 'login') +
//                        ' / ' +
//                        allTranslations.text(
//                            key2: 'tel_number', key: 'register'),
                    border: OutlineInputBorder(borderSide: BorderSide.none),
                  ),
                ),
              ),
            ),
        
            
            Container(
              alignment: Alignment.topRight,
              padding: EdgeInsets.only(right: SizeConfig.getPadding(30)),
              child: Text(
                'โปรดระบุอีเมล์ของท่านเพื่อดำเนินการเปลี่ยนรหัสผ่าน',
                style: TextStyle(
                    color: Colors.black38,
                    fontSize: SizeConfig.getFontSize(10),
                    fontFamily: "SF_Pro_Text",
                    fontWeight: FontWeight.w600),
              ),
            ),
            SizedBox(
              height: SizeConfig.getWidth(130),
            ),
            _submitLoginButton(),
      
            SizedBox(
              height: SizeConfig.getWidth(20),
            ),
       
          ],
        ),
      ),
    );
  }


  _submitLoginButton() {
    return Padding(
      padding: EdgeInsets.symmetric(
          vertical: SizeConfig.getPadding(20.0),
          horizontal: SizeConfig.getPadding(32)),
      child: Container(
        height: SizeConfig.getHeight(55),
        child: CupertinoButton(
          color: Color.fromRGBO(106, 179, 170, 1),
          padding: EdgeInsets.all(0),
          borderRadius: BorderRadius.all(
            Radius.circular(50),
          ),
          onPressed: () {

    // if (_tabController.index==0){
          presenter.letCheckData();
    //         else{

    //           presenter.letCheckData_phone();

    //         }
            // Navigator.push(
            //   context,
            //   MaterialPageRoute(builder: (context) => HomePage()),
            // );
//            if (loginBloc.formKey.currentState.validate()) {
//              loginBloc.getLogin();
//            }
          },
          child: Center(
            child: Text(
              'ยืนยัน',
              style: TextStyle(color: Colors.white),
            ),
          ),
        ),
      ),
    );
  }


 
}
