import 'dart:io';

import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:image_cropper/image_cropper.dart';

import 'package:image_picker/image_picker.dart';




class ImagePickerUtil {
  final BuildContext context;
  final Function callback;

  ImagePickerUtil(this.context, this.callback) {
    showCupertinoModalPopup(
      context: context,
      builder: (context) {
        return CupertinoActionSheet(
          actions: <Widget>[
            Container(
              child: CupertinoActionSheetAction(
                onPressed: () async {
                  var res = await _imagePick(ImageSource.camera);
                  this.callback(res);
                },
                child: Row(
                  children: <Widget>[
                    Icon(
                      Icons.camera,
                      color: Colors.black87,
                      size: SizeConfig.getFontSize(24),
                    ),
                    SizedBox(width: SizeConfig.getPadding(10)),
                    Text(
                      'กล้อง',
                      style: TextStyle(
                          color: Colors.black87,
                          fontSize: SizeConfig.getFontSize(18)),
                    ),
                  ],
                ),
              ),
            ),
            Container(
              child: CupertinoActionSheetAction(
                onPressed: () async {
                  var res = await _imagePick(ImageSource.gallery);
                  this.callback(res);
                },
                child: Row(
                  children: <Widget>[
                    Icon(
                      Icons.photo,
                      color: Colors.black87,
                      size: SizeConfig.getFontSize(24),
                    ),
                    SizedBox(width: SizeConfig.getPadding(10)),
                    Text(
                      'รูปภาพ',
                      style: TextStyle(
                          color: Colors.black87,
                          fontSize: SizeConfig.getFontSize(18)),
                    ),
                  ],
                ),
              ),
            ),
          ],
        );
      },
    );
  }

  Future<File> _imagePick(ImageSource source) async {
    Navigator.pop(context);
    var file = await ImagePicker.pickImage(source: source);

    return await _cropImage(file);
  }

  Future<File> _cropImage(File file) async {
    File croppedFile = await ImageCropper.cropImage(
      sourcePath: file.path,
      aspectRatio: CropAspectRatio(ratioX: 1, ratioY: 1),
      androidUiSettings: AndroidUiSettings(
          toolbarColor: Theme.of(context).primaryColor,
          toolbarWidgetColor: Colors.white,
          initAspectRatio: CropAspectRatioPreset.original,
          lockAspectRatio: false),
      iosUiSettings: IOSUiSettings(
        minimumAspectRatio: 1.0,
      ),
    );

    return croppedFile;
  }
}
