import 'dart:convert';


import 'package:feelverapp/model/Login/login_model.dart';
import 'package:feelverapp/model/base/base.dart';
import 'package:feelverapp/model/cart/add_cart_model.dart';
import 'package:feelverapp/model/cart/my_cart_model.dart';

import 'package:feelverapp/model/editprofile/getprofilemodel.dart';
import 'package:feelverapp/model/favorite/addfav_model.dart';
import 'package:feelverapp/model/favorite/delete_favorite_Model.dart';
import 'package:feelverapp/model/favorite/favorite_Model.dart';

import 'package:feelverapp/model/forgetpassword/forgetpassModel.dart';

import 'package:feelverapp/model/home/home_model.dart';
import 'package:feelverapp/model/nearme/nearme_list_model.dart';

import 'package:feelverapp/model/home_search/searchhomepage_model.dart';

import 'package:feelverapp/model/register/register_model.dart';
import 'package:feelverapp/model/category/category_model.dart';
import 'package:feelverapp/model/reviewshop/reviewshop_Model.dart';
import 'package:feelverapp/model/shoplist/shoplist_Model.dart';
import 'package:feelverapp/model/shoplistdetail/shoplistdetail_Model.dart';
import 'package:feelverapp/model/shopservice/shop_service_Model.dart';
import 'package:http/http.dart' as http;

import '../model/booking_detail/booking_detail_model.dart';

class Api<T> {
   final String _baseApi = "https://backend-uat.feelver.com/api";

  final _headerApi = {
    "Authorization":
        "Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwczpcL1wvYmFja2VuZC11YXQuZmVlbHZlci5jb21cL2FwaVwvbG9naW4iLCJpYXQiOjE1OTYxMDAzNTgsImV4cCI6MTYwMzMwMDM1OCwibmJmIjoxNTk2MTAwMzU4LCJqdGkiOiJ2YjA2S0FHR1JtZDFseEw1Iiwic3ViIjozNzMsInBydiI6Ijg3ZTBhZjFlZjlmZDE1ODEyZmRlYzk3MTUzYTE0ZTBiMDQ3NTQ2YWEifQ.UkY70AshvW5O4M63XY_Iv2IPBohSUUwnRF1oi46p2zs",
  };


  static final String baseApi = "https://backend-uat.feelver.com/api";




  static final String baseApiforimage = "https://backend.feelver.com/storage/";

  

  
  Future<Response<T>> reviewshop(Object body) async {
    var _model;
    var _fail;
    var result;
    print("this is body" + body.toString());
    
    await _httpConnection("${this._baseApi}/store/detail", this._headerApi, body).then((response){
      print("ผลลัพท์ เท่ากับ" + "${response.body}");
      if(response.statusCode == 200){
        _model = ReviewShopModel.fromJson(json.decode(response.body));
      }else{
        _fail = FailModel.fromJson(json.decode(response.body));
      }
      result = new Response<T>(_model, _fail);
    });
    return result;
  }



   Future<Response<T>> deletefavorite(Object body) async {
     var _model;
     var _fail;
     var result;
     print("this is body"+body.toString());

     await _httpConnection("${this._baseApi}/wishlist-item/delete", this._headerApi, body).then((response){
       print("ผลลัพท์ เท่ากับ"+"${response.body}");
       if(response.statusCode == 200){
         _model = DeletefavoriteModel.fromJson(json.decode(response.body));
       }else{
         _fail = FailModel.fromJson(json.decode(response.body));
       }
       result = new Response<T>(_model, _fail);
     });
     return result;
   }

  Future<Response<T>> favorite(Object body) async {
    var _model;
    var _fail;
    var result;
    print("this is body"+body.toString());
    //  (body as Map)['lang'] = allTranslations.currentLanguage;
    await _httpConnection("${this._baseApi}/wish-list/listByCustomer", this._headerApi, body)
        .then((response){
      print("ผลลัพท์ เท่ากับบบบบบบบบบบบ" + "${response.body}");
      if(response.statusCode == 200 && json.decode(response.body)["message"]!="data not found"){
        print("aaaa");

          _model = FavoriteModel.fromJson(json.decode(response.body));

      }else{

        print("bbbb");
        _fail = FailModel.fromJson(json.decode(response.body));
      }
      result = new Response<T>(_model, _fail);
    });
    return result;
  }
  
  
  Future<Response<T>> shopservice(String url) async {
    var _model;
    var _fail;
    var result;
    print("this is body "+url.toString());
    //  (body as Map)['lang'] = allTranslations.currentLanguage;



    await _httpConnection(url.toString(), this._headerApi, null)
        .then((response){
      print("ผลลัพท์ เท่ากับ" + "${response.body}");
      if(response.statusCode == 200){
        _model = shopserviceModel.fromJson(json.decode(response.body));
      }else{
        _fail = FailModel.fromJson(json.decode(response.body));
      }
      result = new Response<T>(_model, _fail);
    });
    return result;
  }



  Future<Response<T>> homesearch(Object body) async {
    var _model;
    var _fail;
    var result;
    print("this is body "+body.toString());
    //  (body as Map)['lang'] = allTranslations.currentLanguage;
    await _httpConnection(
            "${this._baseApi}/store/shop-list", this._headerApi, body)
        .then((response) {
      print("ผลลัพ เท่ากับบบบ   " + "${response.body}");
      if (response.statusCode == 200) {
        _model = SearchhomeModel.fromJson(json.decode(response.body));
      } else {
        _fail = FailModel.fromJson(json.decode(response.body));
      }
      result = new Response<T>(_model, _fail);
    });
    return result;
  }

  Future<Response<T>> getprofile(Object body) async {
    var _model;
    var _fail;
    var result;
    // print("this is body " + body.toString());
//  (body as Map)['lang'] = allTranslations.currentLanguage;
    await _httpConnection(
            "${this._baseApi}/customer/info", this._headerApi, body)
        .then((response) {
      // print("ผลลัพ เท่ากับบบบ   " + "${response.body}");
      if (response.statusCode == 200) {
        _model = GetprofileModel.fromJson(json.decode(response.body));
      } else {
        _fail = FailModel.fromJson(json.decode(response.body));
      }
      result = new Response<T>(_model, _fail);
    });
    return result;
  }

  Future<Response<T>> getNearList(Object body) async{
    var _model;
    var _fail;
    var result;
    print("this is body " + body.toString());

//  (body as Map)['lang'] = allTranslations.currentLanguage;
    await http.get(Uri.encodeFull("https://backend-uat.feelver.com/api/product/getListsStoreFormat?near_location=13.7913772,100.5408628&page=1&is_paginate=1"), headers: this._headerApi ).then((response) {
      print("ผลลัพ เท่ากับบบบ2   " + "${response.body}");
      print("statusCode=${response.statusCode}");
      if (response.statusCode == 200) {

        print("INif");
        print(json.decode(response.body));


        _model = NearMeListModel.fromJson(json.decode(response.body));
      } else {

        _fail = FailModel.fromJson(json.decode(response.body));
      }

      print("return");
      result = new Response<T>(_model, _fail);
    });
    return result;
  }

   Future<Response<T>> getProductDetail(String url) async{
     var _model;
     var _fail;
     var result;
     print("this is body " + url.toString());
     await http.get(Uri.encodeFull(url.toString()), headers: this._headerApi, ).then((response) {
       print("ผลลัพ เท่ากับบบบ2   " + "${response.body}");
       print("statusCode=${response.statusCode}");
       if (response.statusCode == 200) {

         print("INif");
         _model = ProductModel.fromJson(json.decode(response.body));
       } else {

         _fail = FailModel.fromJson(json.decode(response.body));
       }

       print("return");
       result = new Response<T>(_model, _fail);
     });
     return result;
   }
   Future<Response<T>> orderCart(String url) async{
     var _model;
     var _fail;
     var result;
     print("this is body " + url.toString());
     await http.post(Uri.encodeFull(url.toString()), headers: this._headerApi, ).then((response) {
       print("ผลลัพ 78787878   " + "${response.body}");
       print("statusCode=${response.statusCode}");
       if (response.statusCode == 200) {


         Map<String, dynamic> myData = arrayToJson(response.body);

       print(myData);

         _model = OrderCartModel.fromJson(myData);
       } else {
         _fail = FailModel.fromJson(json.decode(response.body));
       }
       result = new Response<T>(_model, _fail);
     },);
     return result;
   }

   Future<Response<T>> addCart(String url) async{
     var _model;
     var _fail;
     var result;
     print("this is body " + url.toString());
     await http.post(Uri.encodeFull(url.toString()), headers: this._headerApi, ).then((response) {
       print("ผลลัพ เท่ากับบบบ55552   " + "${response.body}");
       print("statusCode=${response.statusCode}");
       if (response.statusCode == 200) {

         print("INif");
         _model = AddCartModel.fromJson(json.decode(response.body));
       } else {

         _fail = FailModel.fromJson(json.decode(response.body));
       }

       print("return");
       result = new Response<T>(_model, _fail);
     });
     return result;
   }

  Future<Response<T>> editProfile(Object body) async {
    var _model;
    var _fail;
    var result;

    print("This is body " + body.toString());
    await _httpConnection(
            "${this._baseApi}/customer/edit", this._headerApi, body)
        .then((response) {
      print("ผลลัพ เท่ากับบบบ   " + "${response.body}");
      if (response.statusCode == 200) {
        _model = FogetPasswordModel.fromJson(json.decode(response.body));
      } else {
        _fail = FailModel.fromJson(json.decode(response.body));
      }
      result = new Response<T>(_model, _fail);
    });
    return result;
  }

  Future<Response<T>> forgetPassword(Object body) async {
    var _model;
    var _fail;
    var result;

//  (body as Map)['lang'] = allTranslations.currentLanguage;
    await _httpConnection(
            "${this._baseApi}/customer/forget-password", this._headerApi, body)
        .then((response) {
      print("ผลลัพ เท่ากับบบบ   " + "${response.body}");
      if (response.statusCode == 200) {
        _model = FogetPasswordModel.fromJson(json.decode(response.body));
      } else {
        _fail = FailModel.fromJson(json.decode(response.body));
      }
      result = new Response<T>(_model, _fail);
    });
    return result;
  }

  Future<Response<T>> login(Object body) async {
    var _model;
    var _fail;
    var result;

//  (body as Map)['lang'] = allTranslations.currentLanguage;
    await _httpConnection("${this._baseApi}/login", this._headerApi, body)
        .then((response) {
      print("ผลลัพ เท่ากับบบบ   " + "${response.body}");
      if (response.statusCode == 200) {
        _model = LoginModel.fromJson(json.decode(response.body));
      } else {
        _fail = FailModel.fromJson(json.decode(response.body));
      }
      result = new Response<T>(_model, _fail);
    });
    return result;
  }

  Future<Response<T>> register(Object body) async {
    var _model;
    var _fail;
    var result;

//  (body as Map)['lang'] = allTranslations.currentLanguage;
    await _httpConnection("${this._baseApi}/register", this._headerApi, body)
        .then((response) {
      print("ผลลัพ เท่ากับบบบ   " + "${response.body}");
      if (response.statusCode == 200) {
        _model = RegisterModel.fromJson(json.decode(response.body));
      } else {
        _fail = FailModel.fromJson(json.decode(response.body));
      }
      result = new Response<T>(_model, _fail);
    });
    return result;
  }


    Future<Response<T>> category(Object body) async {
    var _model;
    var _fail;
    var result;

//  (body as Map)['lang'] = allTranslations.currentLanguage;
    await _httpConnection("${this._baseApi}/category", this._headerApi, body)
        .then((response) {
      print("ผลลัพ เท่ากับบบบ   " + "${response.body}");
      if (response.statusCode == 200) {
        _model = CategoryModel.fromJson(json.decode(response.body));
      } else {
        _fail = FailModel.fromJson(json.decode(response.body));
      }
      result = new Response<T>(_model, _fail);
    });
    return result;
  }



  

  Future<Response<T>> shoplist(Object body) async {
    var _model;
    var _fail;
    var result;

    await _httpConnection("${this._baseApi}/store", this._headerApi, body)
        .then((response) {
      print("ผลลัพท์ เท่ากับ  " "${response.body}");
      if (response.statusCode == 200) {
        // Array to Map Json
        Map<String, dynamic> myData = arrayToJson(response.body);

//        print(myData);

        _model = shoplistModel.fromJson(myData);
      } else {
        _fail = FailModel.fromJson(json.decode(response.body));
      }
      result = new Response<T>(_model, _fail);
    });
    return result;
  }

  Future<Response<T>> shoplistDetail(Object body) async {
    var _model;
    var _fail;
    var result;
print("${this._baseApi}/store/detail");
    await _httpConnection(
            "${this._baseApi}/store/detail", this._headerApi, body)
        .then((response) {
      print("ผลลัพท์ เท่ากับ  " "${response.body}");
      if (response.statusCode == 200) {
        _model = shoplistdetailModel.fromJson(json.decode(response.body));
      } else {
        _fail = FailModel.fromJson(json.decode(response.body));
      }
      result = new Response<T>(_model, _fail);
    });
    return result;
  }




    Future<Response<T>> addfav(Object body) async {
    var _model;
    var _fail;
    var result;

    await _httpConnection(
            "${this._baseApi}/wish-list/add", this._headerApi, body)
        .then((response) {
      print("ผลลัพท์ เท่ากับ  " "${response.body}");
      if (response.statusCode == 200) {
        _model = AddfavModel.fromJson(json.decode(response.body));
      } else {
        _fail = FailModel.fromJson(json.decode(response.body));
      }
      result = new Response<T>(_model, _fail);
    });
    return result;
  }

  ///api environment
  Future<http.Response> _httpConnection(
      String url, Map<String, String> headers, Object body) async {
    if (body != null) {
      final response = headers != null
          ? http.post(Uri.encodeFull(url), headers: headers, body: body)
          : http.post(Uri.encodeFull(url), body: body);
      return response;
    } else {
      final response = headers != null
          ? http.get(Uri.encodeFull(url), headers: headers)
          : http.get(Uri.encodeFull(url));
      return response;
    }
  }

  dynamic _jsonDecode(String json) {
    var resJson = jsonDecode(json);
    return resJson;
  }

  dynamic arrayToJson(dynamic array) {
    List<dynamic> data = _jsonDecode(array);
    Map<String, dynamic> myJson = {};

    if (data != null && data.length > 0) {
      myJson['DATA'] = data;
    }

    return myJson;
  }
}

class Response<T> {
  T success;
  FailModel fail;

  Response(this.success, this.fail);
}
