import 'package:feelverapp/util/SizeConfig.dart';
import 'package:flutter/material.dart';


enum MyAlertType {
  normal,
  confirm,
}

class MyAlert extends StatelessWidget {
  final MyAlertType type;
  final String title;
  final String message;
  final Function onOK;
  final Function onCancel;
  final String okText;
  final String cancelText;

  MyAlert({
    @required this.title,
    this.message,
    this.type = MyAlertType.normal,
    this.onOK,
    this.onCancel, this.okText = 'ตกลง', this.cancelText = 'ยกเลิก',
  });

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.black.withOpacity(.4),
      body: Center(
        child: Padding(
          padding: EdgeInsets.symmetric(horizontal: SizeConfig.getPadding(24)),
          child: AspectRatio(
            aspectRatio: 4 / 3,
            child: ClipRRect(
              borderRadius: BorderRadius.circular(10),
              child: Container(
                color: Colors.white,
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  children: <Widget>[
                    _title(),
                    _message(),
                    _actionButton(context),
                  ],
                ),
              ),
            ),
          ),
        ),
      ),
    );
  }

  Widget _title() {
    return Container(
      padding: EdgeInsets.symmetric(
        vertical: SizeConfig.getPadding(30),
        horizontal: SizeConfig.getPadding(10),
      ),
      child: Text(
        '${this.title}',
        style: TextStyle(
          fontSize: SizeConfig.getFontSize(22),
          fontWeight: FontWeight.bold,
        ),
      ),
    );
  }

  Widget _message() {
    return Expanded(
      child: Container(
        padding: EdgeInsets.symmetric(
          horizontal: SizeConfig.getPadding(16),
        ),
        child: SingleChildScrollView(
          child: Text(
            '${this.message}',
            style: TextStyle(
              fontSize: SizeConfig.getFontSize(18),
            ),
            textAlign: TextAlign.center,
          ),
        ),
      ),
    );
  }

  Widget _actionButton(BuildContext context) {
    return Container(
      padding: EdgeInsets.only(
//        left: SizeConfig.getPadding(8),
//        right: SizeConfig.getPadding(8),
//        bottom: SizeConfig.getPadding(0),
      ),
      child: Row(
        children: <Widget>[
          _okButton(context),
          this.type != MyAlertType.normal
              ? _cancelButton(context)
              : Container(),
        ],
      ),
    );
  }

  Widget _okButton(BuildContext context) {
    return Expanded(
      child: Container(
        padding: EdgeInsets.symmetric(
            horizontal: SizeConfig.getPadding(16),
            vertical: SizeConfig.getPadding(16)),
        child: RaisedButton(
          shape: RoundedRectangleBorder(
            borderRadius: BorderRadius.circular(10),
          ),
          padding: EdgeInsets.symmetric(vertical: SizeConfig.getPadding(8)),
          onPressed: () {
            Navigator.pop(context);
            if (onOK != null) {
              onOK();
            }
          },
          color: Theme.of(context).primaryColor,
          child: Text(
            this.okText,
            style: TextStyle(
              color: Colors.white,
              fontSize: SizeConfig.getFontSize(18),
            ),
          ),
        ),
      ),
    );
  }

  Widget _cancelButton(BuildContext context) {
    return Expanded(
      child: Container(
        padding: EdgeInsets.symmetric(
            horizontal: SizeConfig.getPadding(16),
            vertical: SizeConfig.getPadding(16)),
        child: RaisedButton(
          shape: RoundedRectangleBorder(
            borderRadius: BorderRadius.circular(10),
          ),
          padding: EdgeInsets.symmetric(vertical: SizeConfig.getPadding(8)),
          onPressed: () {
            Navigator.pop(context);
            if (onCancel != null) {
              onCancel();
            }
          },
          color: Colors.grey[400],
          child: Text(
            this.cancelText,
            style: TextStyle(
              color: Colors.white,
              fontSize: SizeConfig.getFontSize(18),
            ),
          ),
        ),
      ),
    );
  }
}
