import 'package:feelverapp/service/MyAlert.dart';
import 'package:flutter/cupertino.dart';


class Alert {
  final MyAlertType type;
  final BuildContext context;
  final String title;
  final String message;
  final Function onOK;
  final Function onCancel;
  final String okText;
  final String cancelText;

  Alert({
    this.type = MyAlertType.normal,
    @required this.context,
    this.title,
    @required this.message,
    this.onOK,
    this.onCancel,
    this.okText, this.cancelText,
  }){
    showCupertinoModalPopup(context: this.context, builder: (context){
      return MyAlert(
        type: this.type,
        title: this.title,
        message: this.message,
        onOK: this.onOK,
        onCancel: this.onCancel,
        okText: this.okText ,
        cancelText: this.cancelText ,
      );
    });
  }

}
