class shopserviceModel {
  int currentPage;
  List<Data> data;
  String firstPageUrl;
  int from;
  int lastPage;
  String lastPageUrl;
  String nextPageUrl;
  String path;
  int perPage;
  Null prevPageUrl;
  int to;
  int total;

  shopserviceModel(
      {this.currentPage,
        this.data,
        this.firstPageUrl,
        this.from,
        this.lastPage,
        this.lastPageUrl,
        this.nextPageUrl,
        this.path,
        this.perPage,
        this.prevPageUrl,
        this.to,
        this.total});

  shopserviceModel.fromJson(Map<String, dynamic> json) {
    currentPage = json['current_page'];
    if (json['data'] != null) {
      data = new List<Data>();
      json['data'].forEach((v) {
        data.add(new Data.fromJson(v));
      });
    }
    firstPageUrl = json['first_page_url'];
    from = json['from'];
    lastPage = json['last_page'];
    lastPageUrl = json['last_page_url'];
    nextPageUrl = json['next_page_url'];
    path = json['path'];
    perPage = json['per_page'];
    prevPageUrl = json['prev_page_url'];
    to = json['to'];
    total = json['total'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['current_page'] = this.currentPage;
    if (this.data != null) {
      data['data'] = this.data.map((v) => v.toJson()).toList();
    }
    data['first_page_url'] = this.firstPageUrl;
    data['from'] = this.from;
    data['last_page'] = this.lastPage;
    data['last_page_url'] = this.lastPageUrl;
    data['next_page_url'] = this.nextPageUrl;
    data['path'] = this.path;
    data['per_page'] = this.perPage;
    data['prev_page_url'] = this.prevPageUrl;
    data['to'] = this.to;
    data['total'] = this.total;
    return data;
  }
}

class Data {
  int id;
  String urlCode;
  String name;
  String cover;
  String excerpt;
  String detail;
  String price;
  String specialPrice;
  String sku;
  Null tax;
  int quantity;
  Null weight;
  String visibility;
  Null newsFromDate;
  Null newsToDate;
  Null layout;
  Null theme;
  String duration;
  Null sellingStartTime;
  Null sellingEndTime;
  Null redemptionStartTime;
  Null redemptionEndTime;
  Null availibility;
  String isFeatured;
  String isDeal;
  String hasTeam;
  String offpeak;
  String reviewStatus;
  String relatedStatus;
  String upSellsStatus;
  String crossSellsStatus;
  String allowGiftMessage;
  String stockStatus;
  int status;
  int businessTypeId;
  int businessCateId;
  int businessServiceId;
  int attributeSetId;
  int vendorId;
  String allowRoute;
  Null type;
  int star;
  List<CategoryByProductId> categoryByProductId;
  List<Null> ratings;
  int storeProductId;
  Null typeRateService;
  Null priceRateService;
  int productId;
  int storeId;
  String storeCode;
  String storeName;
  String location;
  int storeStatus;
  int vendorStatus;
  String latitude;
  String longitude;
  Null popular;

  Data(
      {this.id,
        this.urlCode,
        this.name,
        this.cover,
        this.excerpt,
        this.detail,
        this.price,
        this.specialPrice,
        this.sku,
        this.tax,
        this.quantity,
        this.weight,
        this.visibility,
        this.newsFromDate,
        this.newsToDate,
        this.layout,
        this.theme,
        this.duration,
        this.sellingStartTime,
        this.sellingEndTime,
        this.redemptionStartTime,
        this.redemptionEndTime,
        this.availibility,
        this.isFeatured,
        this.isDeal,
        this.hasTeam,
        this.offpeak,
        this.reviewStatus,
        this.relatedStatus,
        this.upSellsStatus,
        this.crossSellsStatus,
        this.allowGiftMessage,
        this.stockStatus,
        this.status,
        this.businessTypeId,
        this.businessCateId,
        this.businessServiceId,
        this.attributeSetId,
        this.vendorId,
        this.allowRoute,
        this.type,
        this.star,
        this.categoryByProductId,
        this.ratings,
        this.storeProductId,
        this.typeRateService,
        this.priceRateService,
        this.productId,
        this.storeId,
        this.storeCode,
        this.storeName,
        this.location,
        this.storeStatus,
        this.vendorStatus,
        this.latitude,
        this.longitude,
        this.popular});

  Data.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    urlCode = json['url_code'];
    name = json['name'];
    cover = json['cover'];
    excerpt = json['excerpt'];
    detail = json['detail'];
    price = json['price'];
    specialPrice = json['special_price'];
    sku = json['sku'];
    tax = json['tax'];
    quantity = json['quantity'];
    weight = json['weight'];
    visibility = json['visibility'];
    newsFromDate = json['news_from_date'];
    newsToDate = json['news_to_date'];
    layout = json['layout'];
    theme = json['theme'];
    duration = json['duration'];
    sellingStartTime = json['selling_start_time'];
    sellingEndTime = json['selling_end_time'];
    redemptionStartTime = json['redemption_start_time'];
    redemptionEndTime = json['redemption_end_time'];
    availibility = json['availibility'];
    isFeatured = json['is_featured'];
    isDeal = json['is_deal'];
    hasTeam = json['has_team'];
    offpeak = json['offpeak'];
    reviewStatus = json['review_status'];
    relatedStatus = json['related_status'];
    upSellsStatus = json['up_sells_status'];
    crossSellsStatus = json['cross_sells_status'];
    allowGiftMessage = json['allow_gift_message'];
    stockStatus = json['stock_status'];
    status = json['status'];
    businessTypeId = json['business_type_id'];
    businessCateId = json['business_cate_id'];
    businessServiceId = json['business_service_id'];
    attributeSetId = json['attribute_set_id'];
    vendorId = json['vendor_id'];
    allowRoute = json['allow_route'];
    type = json['type'];
    star = json['star'];
    if (json['category_by_product_id'] != null) {
      categoryByProductId = new List<CategoryByProductId>();
      json['category_by_product_id'].forEach((v) {
        categoryByProductId.add(new CategoryByProductId.fromJson(v));
      });
    }
//    if (json['ratings'] != null) {
//      ratings = new List<Null>();
//      json['ratings'].forEach((v) {
//        ratings.add(new Null.fromJson(v));
//      });
//    }
    storeProductId = json['store_product_id'];
    typeRateService = json['type_rate_service'];
    priceRateService = json['price_rate_service'];
    productId = json['product_id'];
    storeId = json['store_id'];
    storeCode = json['store_code'];
    storeName = json['store_name'];
    location = json['location'];
    storeStatus = json['store_status'];
    vendorStatus = json['vendor_status'];
    latitude = json['latitude'];
    longitude = json['longitude'];
    popular = json['popular'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['url_code'] = this.urlCode;
    data['name'] = this.name;
    data['cover'] = this.cover;
    data['excerpt'] = this.excerpt;
    data['detail'] = this.detail;
    data['price'] = this.price;
    data['special_price'] = this.specialPrice;
    data['sku'] = this.sku;
    data['tax'] = this.tax;
    data['quantity'] = this.quantity;
    data['weight'] = this.weight;
    data['visibility'] = this.visibility;
    data['news_from_date'] = this.newsFromDate;
    data['news_to_date'] = this.newsToDate;
    data['layout'] = this.layout;
    data['theme'] = this.theme;
    data['duration'] = this.duration;
    data['selling_start_time'] = this.sellingStartTime;
    data['selling_end_time'] = this.sellingEndTime;
    data['redemption_start_time'] = this.redemptionStartTime;
    data['redemption_end_time'] = this.redemptionEndTime;
    data['availibility'] = this.availibility;
    data['is_featured'] = this.isFeatured;
    data['is_deal'] = this.isDeal;
    data['has_team'] = this.hasTeam;
    data['offpeak'] = this.offpeak;
    data['review_status'] = this.reviewStatus;
    data['related_status'] = this.relatedStatus;
    data['up_sells_status'] = this.upSellsStatus;
    data['cross_sells_status'] = this.crossSellsStatus;
    data['allow_gift_message'] = this.allowGiftMessage;
    data['stock_status'] = this.stockStatus;
    data['status'] = this.status;
    data['business_type_id'] = this.businessTypeId;
    data['business_cate_id'] = this.businessCateId;
    data['business_service_id'] = this.businessServiceId;
    data['attribute_set_id'] = this.attributeSetId;
    data['vendor_id'] = this.vendorId;
    data['allow_route'] = this.allowRoute;
    data['type'] = this.type;
    data['star'] = this.star;
    if (this.categoryByProductId != null) {
      data['category_by_product_id'] =
          this.categoryByProductId.map((v) => v.toJson()).toList();
    }
//    if (this.ratings != null) {
//      data['ratings'] = this.ratings.map((v) => v.toJson()).toList();
//    }
    data['store_product_id'] = this.storeProductId;
    data['type_rate_service'] = this.typeRateService;
    data['price_rate_service'] = this.priceRateService;
    data['product_id'] = this.productId;
    data['store_id'] = this.storeId;
    data['store_code'] = this.storeCode;
    data['store_name'] = this.storeName;
    data['location'] = this.location;
    data['store_status'] = this.storeStatus;
    data['vendor_status'] = this.vendorStatus;
    data['latitude'] = this.latitude;
    data['longitude'] = this.longitude;
    data['popular'] = this.popular;
    return data;
  }
}

class CategoryByProductId {
  int id;
  int parentId;
  String name;
  String code;
  String displayName;
  String cover;
  String detail;
  Null type;
  String status;
  int sortOrder;
  Null storeId;
  Null vendorId;
  Null createdAt;
  String updatedAt;
  String visibility;
  Pivot pivot;

  CategoryByProductId(
      {this.id,
        this.parentId,
        this.name,
        this.code,
        this.displayName,
        this.cover,
        this.detail,
        this.type,
        this.status,
        this.sortOrder,
        this.storeId,
        this.vendorId,
        this.createdAt,
        this.updatedAt,
        this.visibility,
        this.pivot});

  CategoryByProductId.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    parentId = json['parent_id'];
    name = json['name'];
    code = json['code'];
    displayName = json['display_name'];
    cover = json['cover'];
    detail = json['detail'];
    type = json['type'];
    status = json['status'];
    sortOrder = json['sort_order'];
    storeId = json['store_id'];
    vendorId = json['vendor_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    visibility = json['visibility'];
    pivot = json['pivot'] != null ? new Pivot.fromJson(json['pivot']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['parent_id'] = this.parentId;
    data['name'] = this.name;
    data['code'] = this.code;
    data['display_name'] = this.displayName;
    data['cover'] = this.cover;
    data['detail'] = this.detail;
    data['type'] = this.type;
    data['status'] = this.status;
    data['sort_order'] = this.sortOrder;
    data['store_id'] = this.storeId;
    data['vendor_id'] = this.vendorId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['visibility'] = this.visibility;
    if (this.pivot != null) {
      data['pivot'] = this.pivot.toJson();
    }
    return data;
  }
}

class Pivot {
  int productId;
  int categoryId;
  String createdAt;
  String updatedAt;

  Pivot({this.productId, this.categoryId, this.createdAt, this.updatedAt});

  Pivot.fromJson(Map<String, dynamic> json) {
    productId = json['product_id'];
    categoryId = json['category_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['product_id'] = this.productId;
    data['category_id'] = this.categoryId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    return data;
  }
}
