class ReviewShopModel {
  List<Result> result;

  ReviewShopModel({this.result});

  ReviewShopModel.fromJson(Map<String, dynamic> json) {
    if (json['result'] != null) {
      result = new List<Result>();
      json['result'].forEach((v) {
        result.add(new Result.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.result != null) {
      data['result'] = this.result.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Result {
  int id;
  String storeCode;
  String storeName;
  String storeCover;
  String displayCover;
  String isActive;
  int storeOrder;
  int customerGroupId;
  int vendorId;
  dynamic createdAt;
  String updatedAt;
  String location;
  String email;
  String phone;
  String mobile;
  String address;
  String city;
  String country;
  String zipCode;
  String website;
  String allowRoute;
  String excerpt;
  String detail;
  String storeLogo;
  String isFacilities;
  String distanceWithLocation;
  int star;
  List<StoreProduct> storeProduct;
  List<Comment> comment;
  List<dynamic> commentReview;
  List<OpenHour> openHour;
  List<Image> image;
  dynamic ratings;

  Result(
      {this.id,
        this.storeCode,
        this.storeName,
        this.storeCover,
        this.displayCover,
        this.isActive,
        this.storeOrder,
        this.customerGroupId,
        this.vendorId,
        this.createdAt,
        this.updatedAt,
        this.location,
        this.email,
        this.phone,
        this.mobile,
        this.address,
        this.city,
        this.country,
        this.zipCode,
        this.website,
        this.allowRoute,
        this.excerpt,
        this.detail,
        this.storeLogo,
        this.isFacilities,
        this.distanceWithLocation,
        this.star,
        this.storeProduct,
        this.comment,
        this.commentReview,
        this.openHour,
        this.image,
        this.ratings});

  Result.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    storeCode = json['store_code'];
    storeName = json['store_name'];
    storeCover = json['store_cover'];
    displayCover = json['display_cover'];
    isActive = json['is_active'];
    storeOrder = json['store_order'];
    customerGroupId = json['customer_group_id'];
    vendorId = json['vendor_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    location = json['location'];
    email = json['email'];
    phone = json['phone'];
    mobile = json['mobile'];
    address = json['address'];
    city = json['city'];
    country = json['country'];
    zipCode = json['zip_code'];
    website = json['website'];
    allowRoute = json['allow_route'];
    excerpt = json['excerpt'];
    detail = json['detail'];
    storeLogo = json['store_logo'];
    isFacilities = json['is_facilities'];
    distanceWithLocation = json['distance_with_location'];
    star = json['star'];
    if (json['store_product'] != null) {
      storeProduct = new List<StoreProduct>();
      json['store_product'].forEach((v) {
        storeProduct.add(new StoreProduct.fromJson(v));
      });
    }
    if (json['comment'] != null) {
      comment = new List<Comment>();
      json['comment'].forEach((v) {
        comment.add(new Comment.fromJson(v));
      });
    }

    if (json['open_hour'] != null) {
      openHour = new List<OpenHour>();
      json['open_hour'].forEach((v) {
        openHour.add(new OpenHour.fromJson(v));
      });
    }
    if (json['image'] != null) {
      image = new List<Image>();
      json['image'].forEach((v) {
        image.add(new Image.fromJson(v));
      });
    }
    ratings = json['ratings'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['store_code'] = this.storeCode;
    data['store_name'] = this.storeName;
    data['store_cover'] = this.storeCover;
    data['display_cover'] = this.displayCover;
    data['is_active'] = this.isActive;
    data['store_order'] = this.storeOrder;
    data['customer_group_id'] = this.customerGroupId;
    data['vendor_id'] = this.vendorId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['location'] = this.location;
    data['email'] = this.email;
    data['phone'] = this.phone;
    data['mobile'] = this.mobile;
    data['address'] = this.address;
    data['city'] = this.city;
    data['country'] = this.country;
    data['zip_code'] = this.zipCode;
    data['website'] = this.website;
    data['allow_route'] = this.allowRoute;
    data['excerpt'] = this.excerpt;
    data['detail'] = this.detail;
    data['store_logo'] = this.storeLogo;
    data['is_facilities'] = this.isFacilities;
    data['distance_with_location'] = this.distanceWithLocation;
    data['star'] = this.star;
    if (this.storeProduct != null) {
      data['store_product'] = this.storeProduct.map((v) => v.toJson()).toList();
    }
    if (this.comment != null) {
      data['comment'] = this.comment.map((v) => v.toJson()).toList();
    }

    if (this.openHour != null) {
      data['open_hour'] = this.openHour.map((v) => v.toJson()).toList();
    }
    if (this.image != null) {
      data['image'] = this.image.map((v) => v.toJson()).toList();
    }
    data['ratings'] = this.ratings;
    return data;
  }
}

class StoreProduct {
  int id;
  int productId;
  int storeId;
  int vendorId;
  String status;
  int sortOrders;
  dynamic createdAt;
  dynamic updatedAt;
  dynamic typeRateService;
  dynamic priceRateService;
  Product product;

  StoreProduct(
      {this.id,
        this.productId,
        this.storeId,
        this.vendorId,
        this.status,
        this.sortOrders,
        this.createdAt,
        this.updatedAt,
        this.typeRateService,
        this.priceRateService,
        this.product});

  StoreProduct.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    productId = json['product_id'];
    storeId = json['store_id'];
    vendorId = json['vendor_id'];
    status = json['status'];
    sortOrders = json['sort_orders'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    typeRateService = json['type_rate_service'];
    priceRateService = json['price_rate_service'];
    product =
    json['product'] != null ? new Product.fromJson(json['product']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['product_id'] = this.productId;
    data['store_id'] = this.storeId;
    data['vendor_id'] = this.vendorId;
    data['status'] = this.status;
    data['sort_orders'] = this.sortOrders;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['type_rate_service'] = this.typeRateService;
    data['price_rate_service'] = this.priceRateService;
    if (this.product != null) {
      data['product'] = this.product.toJson();
    }
    return data;
  }
}

class Product {
  int id;
  String urlCode;
  String name;
  String cover;
  String excerpt;
  String detail;
  String price;
  String specialPrice;
  String sku;
  dynamic tax;
  int quantity;
  dynamic weight;
  String visibility;
  dynamic newsFromDate;
  dynamic newsToDate;
  dynamic layout;
  dynamic theme;
  String duration;
  dynamic sellingStartTime;
  dynamic sellingEndTime;
  dynamic redemptionStartTime;
  dynamic redemptionEndTime;
  dynamic availibility;
  String isFeatured;
  String isDeal;
  String hasTeam;
  String offpeak;
  String reviewStatus;
  String relatedStatus;
  String upSellsStatus;
  String crossSellsStatus;
  String allowGiftMessage;
  String stockStatus;
  String status;
  int businessTypeId;
  int businessCateId;
  int businessServiceId;
  int attributeSetId;
  int vendorId;
  String allowRoute;
  dynamic type;
  int star;
  List<CategoryFeelverByProductId> categoryFeelverByProductId;
  List<dynamic> ratings;

  Product(
      {this.id,
        this.urlCode,
        this.name,
        this.cover,
        this.excerpt,
        this.detail,
        this.price,
        this.specialPrice,
        this.sku,
        this.tax,
        this.quantity,
        this.weight,
        this.visibility,
        this.newsFromDate,
        this.newsToDate,
        this.layout,
        this.theme,
        this.duration,
        this.sellingStartTime,
        this.sellingEndTime,
        this.redemptionStartTime,
        this.redemptionEndTime,
        this.availibility,
        this.isFeatured,
        this.isDeal,
        this.hasTeam,
        this.offpeak,
        this.reviewStatus,
        this.relatedStatus,
        this.upSellsStatus,
        this.crossSellsStatus,
        this.allowGiftMessage,
        this.stockStatus,
        this.status,
        this.businessTypeId,
        this.businessCateId,
        this.businessServiceId,
        this.attributeSetId,
        this.vendorId,
        this.allowRoute,
        this.type,
        this.star,
        this.categoryFeelverByProductId,
        this.ratings});

  Product.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    urlCode = json['url_code'];
    name = json['name'];
    cover = json['cover'];
    excerpt = json['excerpt'];
    detail = json['detail'];
    price = json['price'];
    specialPrice = json['special_price'];
    sku = json['sku'];
    tax = json['tax'];
    quantity = json['quantity'];
    weight = json['weight'];
    visibility = json['visibility'];
    newsFromDate = json['news_from_date'];
    newsToDate = json['news_to_date'];
    layout = json['layout'];
    theme = json['theme'];
    duration = json['duration'];
    sellingStartTime = json['selling_start_time'];
    sellingEndTime = json['selling_end_time'];
    redemptionStartTime = json['redemption_start_time'];
    redemptionEndTime = json['redemption_end_time'];
    availibility = json['availibility'];
    isFeatured = json['is_featured'];
    isDeal = json['is_deal'];
    hasTeam = json['has_team'];
    offpeak = json['offpeak'];
    reviewStatus = json['review_status'];
    relatedStatus = json['related_status'];
    upSellsStatus = json['up_sells_status'];
    crossSellsStatus = json['cross_sells_status'];
    allowGiftMessage = json['allow_gift_message'];
    stockStatus = json['stock_status'];
    status = json['status'];
    businessTypeId = json['business_type_id'];
    businessCateId = json['business_cate_id'];
    businessServiceId = json['business_service_id'];
    attributeSetId = json['attribute_set_id'];
    vendorId = json['vendor_id'];
    allowRoute = json['allow_route'];
    type = json['type'];
    star = json['star'];
    if (json['category_feelver_by_product_id'] != null) {
      categoryFeelverByProductId = new List<CategoryFeelverByProductId>();
      json['category_feelver_by_product_id'].forEach((v) {
        categoryFeelverByProductId
            .add(new CategoryFeelverByProductId.fromJson(v));
      });
    }

  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['url_code'] = this.urlCode;
    data['name'] = this.name;
    data['cover'] = this.cover;
    data['excerpt'] = this.excerpt;
    data['detail'] = this.detail;
    data['price'] = this.price;
    data['special_price'] = this.specialPrice;
    data['sku'] = this.sku;
    data['tax'] = this.tax;
    data['quantity'] = this.quantity;
    data['weight'] = this.weight;
    data['visibility'] = this.visibility;
    data['news_from_date'] = this.newsFromDate;
    data['news_to_date'] = this.newsToDate;
    data['layout'] = this.layout;
    data['theme'] = this.theme;
    data['duration'] = this.duration;
    data['selling_start_time'] = this.sellingStartTime;
    data['selling_end_time'] = this.sellingEndTime;
    data['redemption_start_time'] = this.redemptionStartTime;
    data['redemption_end_time'] = this.redemptionEndTime;
    data['availibility'] = this.availibility;
    data['is_featured'] = this.isFeatured;
    data['is_deal'] = this.isDeal;
    data['has_team'] = this.hasTeam;
    data['offpeak'] = this.offpeak;
    data['review_status'] = this.reviewStatus;
    data['related_status'] = this.relatedStatus;
    data['up_sells_status'] = this.upSellsStatus;
    data['cross_sells_status'] = this.crossSellsStatus;
    data['allow_gift_message'] = this.allowGiftMessage;
    data['stock_status'] = this.stockStatus;
    data['status'] = this.status;
    data['business_type_id'] = this.businessTypeId;
    data['business_cate_id'] = this.businessCateId;
    data['business_service_id'] = this.businessServiceId;
    data['attribute_set_id'] = this.attributeSetId;
    data['vendor_id'] = this.vendorId;
    data['allow_route'] = this.allowRoute;
    data['type'] = this.type;
    data['star'] = this.star;
    if (this.categoryFeelverByProductId != null) {
      data['category_feelver_by_product_id'] =
          this.categoryFeelverByProductId.map((v) => v.toJson()).toList();
    }

    return data;
  }
}

class CategoryFeelverByProductId {
  int id;
  int parentId;
  String name;
  String code;
  String displayName;
  String cover;
  String detail;
  dynamic type;
  String status;
  int sortOrder;
  dynamic storeId;
  dynamic vendorId;
  dynamic createdAt;
  String updatedAt;
  String visibility;
  Pivot pivot;

  CategoryFeelverByProductId(
      {this.id,
        this.parentId,
        this.name,
        this.code,
        this.displayName,
        this.cover,
        this.detail,
        this.type,
        this.status,
        this.sortOrder,
        this.storeId,
        this.vendorId,
        this.createdAt,
        this.updatedAt,
        this.visibility,
        this.pivot});

  CategoryFeelverByProductId.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    parentId = json['parent_id'];
    name = json['name'];
    code = json['code'];
    displayName = json['display_name'];
    cover = json['cover'];
    detail = json['detail'];
    type = json['type'];
    status = json['status'];
    sortOrder = json['sort_order'];
    storeId = json['store_id'];
    vendorId = json['vendor_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    visibility = json['visibility'];
    pivot = json['pivot'] != null ? new Pivot.fromJson(json['pivot']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['parent_id'] = this.parentId;
    data['name'] = this.name;
    data['code'] = this.code;
    data['display_name'] = this.displayName;
    data['cover'] = this.cover;
    data['detail'] = this.detail;
    data['type'] = this.type;
    data['status'] = this.status;
    data['sort_order'] = this.sortOrder;
    data['store_id'] = this.storeId;
    data['vendor_id'] = this.vendorId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['visibility'] = this.visibility;
    if (this.pivot != null) {
      data['pivot'] = this.pivot.toJson();
    }
    return data;
  }
}

class Pivot {
  int productId;
  int categoryId;
  String createdAt;
  String updatedAt;

  Pivot({this.productId, this.categoryId, this.createdAt, this.updatedAt});

  Pivot.fromJson(Map<String, dynamic> json) {
    productId = json['product_id'];
    categoryId = json['category_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['product_id'] = this.productId;
    data['category_id'] = this.categoryId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    return data;
  }
}

class Comment {
  int id;
  int commentItemsId;
  String commentAuthor;
  String commentEmail;
  dynamic commentUrl;
  String commentIp;
  String commentDate;
  String commentContent;
  String commentApproved;
  String commentType;
  dynamic commentParent;
  String status;
  int userId;
  int storeId;
  int vendorId;
  dynamic createdAt;
  dynamic updatedAt;
  int shopScore;
  int flagShop;
  List<dynamic> tagShop;
  List<dynamic> productTag;
  bool purchased;
  InfoCustomer infoCustomer;
  List<CommentSub> commentSub;

  Comment(
      {this.id,
        this.commentItemsId,
        this.commentAuthor,
        this.commentEmail,
        this.commentUrl,
        this.commentIp,
        this.commentDate,
        this.commentContent,
        this.commentApproved,
        this.commentType,
        this.commentParent,
        this.status,
        this.userId,
        this.storeId,
        this.vendorId,
        this.createdAt,
        this.updatedAt,
        this.shopScore,
        this.flagShop,
        this.tagShop,
        this.productTag,
        this.purchased,
        this.infoCustomer,
        this.commentSub});

  Comment.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    commentItemsId = json['comment_items_id'];
    commentAuthor = json['comment_author'];
    commentEmail = json['comment_email'];
    commentUrl = json['comment_url'];
    commentIp = json['comment_ip'];
    commentDate = json['comment_date'];
    commentContent = json['comment_content'];
    commentApproved = json['comment_approved'];
    commentType = json['comment_type'];
    commentParent = json['comment_parent'];
    status = json['status'];
    userId = json['user_id'];
    storeId = json['store_id'];
    vendorId = json['vendor_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    shopScore = json['shop_score'];
    flagShop = json['flag_shop'];

    purchased = json['purchased'];
    infoCustomer = json['info_customer'] != null
        ? new InfoCustomer.fromJson(json['info_customer'])
        : null;
    if (json['comment_sub'] != null) {
      commentSub = new List<CommentSub>();
      json['comment_sub'].forEach((v) {
        commentSub.add(new CommentSub.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['comment_items_id'] = this.commentItemsId;
    data['comment_author'] = this.commentAuthor;
    data['comment_email'] = this.commentEmail;
    data['comment_url'] = this.commentUrl;
    data['comment_ip'] = this.commentIp;
    data['comment_date'] = this.commentDate;
    data['comment_content'] = this.commentContent;
    data['comment_approved'] = this.commentApproved;
    data['comment_type'] = this.commentType;
    data['comment_parent'] = this.commentParent;
    data['status'] = this.status;
    data['user_id'] = this.userId;
    data['store_id'] = this.storeId;
    data['vendor_id'] = this.vendorId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['shop_score'] = this.shopScore;
    data['flag_shop'] = this.flagShop;
    data['purchased'] = this.purchased;
    if (this.infoCustomer != null) {
      data['info_customer'] = this.infoCustomer.toJson();
    }
    if (this.commentSub != null) {
      data['comment_sub'] = this.commentSub.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class InfoCustomer {
  int id;
  dynamic prefix;
  String name;
  String lastname;
  String displayName;
  String image;
  String email;
  int age;
  String sex;
  String phone;
  dynamic address;
  String socialRegister;
  dynamic socialType;
  String status;
  String approved;
  dynamic createdAt;
  String updatedAt;
  int userId;

  InfoCustomer(
      {this.id,
        this.prefix,
        this.name,
        this.lastname,
        this.displayName,
        this.image,
        this.email,
        this.age,
        this.sex,
        this.phone,
        this.address,
        this.socialRegister,
        this.socialType,
        this.status,
        this.approved,
        this.createdAt,
        this.updatedAt,
        this.userId});

  InfoCustomer.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    prefix = json['prefix'];
    name = json['name'];
    lastname = json['lastname'];
    displayName = json['display_name'];
    image = json['image'];
    email = json['email'];
    age = json['age'];
    sex = json['sex'];
    phone = json['phone'];
    address = json['address'];
    socialRegister = json['social_register'];
    socialType = json['social_type'];
    status = json['status'];
    approved = json['approved'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    userId = json['user_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['prefix'] = this.prefix;
    data['name'] = this.name;
    data['lastname'] = this.lastname;
    data['display_name'] = this.displayName;
    data['image'] = this.image;
    data['email'] = this.email;
    data['age'] = this.age;
    data['sex'] = this.sex;
    data['phone'] = this.phone;
    data['address'] = this.address;
    data['social_register'] = this.socialRegister;
    data['social_type'] = this.socialType;
    data['status'] = this.status;
    data['approved'] = this.approved;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['user_id'] = this.userId;
    return data;
  }
}

class CommentSub {
  int id;
  int commentItemsId;
  String commentAuthor;
  String commentEmail;
  dynamic commentUrl;
  String commentIp;
  String commentDate;
  String commentContent;
  String commentApproved;
  String commentType;
  int commentParent;
  String status;
  int userId;
  int storeId;
  int vendorId;
  dynamic createdAt;
  dynamic updatedAt;
  int shopScore;
  int flagShop;
  List<dynamic> tagShop;
  List<dynamic> productTag;
  bool purchased;
  InfoCustomer infoCustomer;

  CommentSub(
      {this.id,
        this.commentItemsId,
        this.commentAuthor,
        this.commentEmail,
        this.commentUrl,
        this.commentIp,
        this.commentDate,
        this.commentContent,
        this.commentApproved,
        this.commentType,
        this.commentParent,
        this.status,
        this.userId,
        this.storeId,
        this.vendorId,
        this.createdAt,
        this.updatedAt,
        this.shopScore,
        this.flagShop,
        this.tagShop,
        this.productTag,
        this.purchased,
        this.infoCustomer});

  CommentSub.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    commentItemsId = json['comment_items_id'];
    commentAuthor = json['comment_author'];
    commentEmail = json['comment_email'];
    commentUrl = json['comment_url'];
    commentIp = json['comment_ip'];
    commentDate = json['comment_date'];
    commentContent = json['comment_content'];
    commentApproved = json['comment_approved'];
    commentType = json['comment_type'];
    commentParent = json['comment_parent'];
    status = json['status'];
    userId = json['user_id'];
    storeId = json['store_id'];
    vendorId = json['vendor_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    shopScore = json['shop_score'];
    flagShop = json['flag_shop'];
    purchased = json['purchased'];
    infoCustomer = json['info_customer'] != null
        ? new InfoCustomer.fromJson(json['info_customer'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['comment_items_id'] = this.commentItemsId;
    data['comment_author'] = this.commentAuthor;
    data['comment_email'] = this.commentEmail;
    data['comment_url'] = this.commentUrl;
    data['comment_ip'] = this.commentIp;
    data['comment_date'] = this.commentDate;
    data['comment_content'] = this.commentContent;
    data['comment_approved'] = this.commentApproved;
    data['comment_type'] = this.commentType;
    data['comment_parent'] = this.commentParent;
    data['status'] = this.status;
    data['user_id'] = this.userId;
    data['store_id'] = this.storeId;
    data['vendor_id'] = this.vendorId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['shop_score'] = this.shopScore;
    data['flag_shop'] = this.flagShop;

    data['purchased'] = this.purchased;
    if (this.infoCustomer != null) {
      data['info_customer'] = this.infoCustomer.toJson();
    }
    return data;
  }
}

class SubInfoCustomer {
  int id;
  dynamic prefix;
  String name;
  dynamic lastname;
  String displayName;
  String image;
  String email;
  dynamic age;
  String sex;
  dynamic phone;
  dynamic address;
  String socialRegister;
  dynamic socialType;
  String status;
  String approved;
  String createdAt;
  String updatedAt;
  int userId;

  SubInfoCustomer(
      {this.id,
        this.prefix,
        this.name,
        this.lastname,
        this.displayName,
        this.image,
        this.email,
        this.age,
        this.sex,
        this.phone,
        this.address,
        this.socialRegister,
        this.socialType,
        this.status,
        this.approved,
        this.createdAt,
        this.updatedAt,
        this.userId});

  SubInfoCustomer.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    prefix = json['prefix'];
    name = json['name'];
    lastname = json['lastname'];
    displayName = json['display_name'];
    image = json['image'];
    email = json['email'];
    age = json['age'];
    sex = json['sex'];
    phone = json['phone'];
    address = json['address'];
    socialRegister = json['social_register'];
    socialType = json['social_type'];
    status = json['status'];
    approved = json['approved'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    userId = json['user_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['prefix'] = this.prefix;
    data['name'] = this.name;
    data['lastname'] = this.lastname;
    data['display_name'] = this.displayName;
    data['image'] = this.image;
    data['email'] = this.email;
    data['age'] = this.age;
    data['sex'] = this.sex;
    data['phone'] = this.phone;
    data['address'] = this.address;
    data['social_register'] = this.socialRegister;
    data['social_type'] = this.socialType;
    data['status'] = this.status;
    data['approved'] = this.approved;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['user_id'] = this.userId;
    return data;
  }
}

class OpenHour {
  int id;
  String name;
  String code;
  String dayName;
  String open;
  String closed;
  int vendorId;
  int storeId;
  dynamic createdAt;
  dynamic updatedAt;

  OpenHour(
      {this.id,
        this.name,
        this.code,
        this.dayName,
        this.open,
        this.closed,
        this.vendorId,
        this.storeId,
        this.createdAt,
        this.updatedAt});

  OpenHour.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    code = json['code'];
    dayName = json['day_name'];
    open = json['open'];
    closed = json['closed'];
    vendorId = json['vendor_id'];
    storeId = json['store_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    data['code'] = this.code;
    data['day_name'] = this.dayName;
    data['open'] = this.open;
    data['closed'] = this.closed;
    data['vendor_id'] = this.vendorId;
    data['store_id'] = this.storeId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    return data;
  }
}

class Image {
  int id;
  String image;
  String title;
  String altText;
  String detail;
  String status;
  int vendorId;
  dynamic createdAt;
  dynamic updatedAt;
  String imageTb;
  int tbId;

  Image(
      {this.id,
        this.image,
        this.title,
        this.altText,
        this.detail,
        this.status,
        this.vendorId,
        this.createdAt,
        this.updatedAt,
        this.imageTb,
        this.tbId});

  Image.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    image = json['image'];
    title = json['title'];
    altText = json['alt_text'];
    detail = json['detail'];
    status = json['status'];
    vendorId = json['vendor_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    imageTb = json['image_tb'];
    tbId = json['tb_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['image'] = this.image;
    data['title'] = this.title;
    data['alt_text'] = this.altText;
    data['detail'] = this.detail;
    data['status'] = this.status;
    data['vendor_id'] = this.vendorId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['image_tb'] = this.imageTb;
    data['tb_id'] = this.tbId;
    return data;
  }
}