class NearMeListModel {
  bool status;
  Results results;

  NearMeListModel({this.status, this.results});

  NearMeListModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    results =
    json['results'] != null ? new Results.fromJson(json['results']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['status'] = this.status;
    if (this.results != null) {
      data['results'] = this.results.toJson();
    }
    return data;
  }
}

class Results {
  int currentPage;
  List<Data> data;

  Results({this.currentPage, this.data});

  Results.fromJson(Map<String, dynamic> json) {
    currentPage = json['current_page'];
    if (json['data'] != null) {
      data = new List<Data>();
      json['data'].forEach((v) {
        data.add(new Data.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['current_page'] = this.currentPage;
    if (this.data != null) {
      data['data'] = this.data.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Data {
  int id;
  String storeCode;
  String storeName;
  String storeCover;
  String displayCover;
  String isActive;
  int storeOrder;
  int customerGroupId;
  int vendorId;
  String updatedAt;
  String location;
  String email;
  String phone;
  String mobile;
  String address;
  String city;
  String country;
  String zipCode;
  String website;
  String allowRoute;
  String excerpt;
  String detail;
  String storeLogo;
  String isFacilities;
  dynamic distanceWithLocation;

  Data(
      {this.id,
        this.storeCode,
        this.storeName,
        this.storeCover,
        this.displayCover,
        this.isActive,
        this.storeOrder,
        this.customerGroupId,
        this.vendorId,
        this.updatedAt,
        this.location,
        this.email,
        this.phone,
        this.mobile,
        this.address,
        this.city,
        this.country,
        this.zipCode,
        this.website,
        this.allowRoute,
        this.excerpt,
        this.detail,
        this.storeLogo,
        this.isFacilities,
        this.distanceWithLocation
      });

  Data.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    storeCode = json['store_code'];
    storeName = json['store_name'];
    storeCover = json['store_cover'];
    displayCover = json['display_cover'];
    isActive = json['is_active'];
    storeOrder = json['store_order'];
    customerGroupId = json['customer_group_id'];
    vendorId = json['vendor_id'];
    updatedAt = json['updated_at'];
    location = json['location'];
    email = json['email'];
    phone = json['phone'];
    mobile = json['mobile'];
    address = json['address'];
    city = json['city'];
    country = json['country'];
    zipCode = json['zip_code'];
    website = json['website'];
    allowRoute = json['allow_route'];
    excerpt = json['excerpt'];
    detail = json['detail'];
    storeLogo = json['store_logo'];
    isFacilities = json['is_facilities'];
    distanceWithLocation = json['distance_with_location'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['store_code'] = this.storeCode;
    data['store_name'] = this.storeName;
    data['store_cover'] = this.storeCover;
    data['display_cover'] = this.displayCover;
    data['is_active'] = this.isActive;
    data['store_order'] = this.storeOrder;
    data['customer_group_id'] = this.customerGroupId;
    data['vendor_id'] = this.vendorId;
    data['updated_at'] = this.updatedAt;
    data['location'] = this.location;
    data['email'] = this.email;
    data['phone'] = this.phone;
    data['mobile'] = this.mobile;
    data['address'] = this.address;
    data['city'] = this.city;
    data['country'] = this.country;
    data['zip_code'] = this.zipCode;
    data['website'] = this.website;
    data['allow_route'] = this.allowRoute;
    data['excerpt'] = this.excerpt;
    data['detail'] = this.detail;
    data['store_logo'] = this.storeLogo;
    data['is_facilities'] = this.isFacilities;
    data['distance_with_location'] = this.distanceWithLocation;
    return data;
  }
}
