class SearchhomeModel {
  List<ThTH> thTH;

  SearchhomeModel({this.thTH});

  SearchhomeModel.fromJson(Map<String, dynamic> json) {
    if (json['th_TH'] != null) {
      thTH = new List<ThTH>();
      json['th_TH'].forEach((v) {
        thTH.add(new ThTH.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.thTH != null) {
      data['th_TH'] = this.thTH.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class ThTH {
  int id;
  String storeCode;
  String storeName;
  String storeCover;
  String displayCover;
  String isActive;
  int storeOrder;
  int customerGroupId;
  int vendorId;
  dynamic createdAt;
  String updatedAt;
  String location;
  String email;
  String phone;
  String mobile;
  String address;
  String city;
  String country;
  String zipCode;
  String website;
  String allowRoute;
  String excerpt;
  String detail;
  String storeLogo;
  String isFacilities;
  String cover;
  String distanceWithLocation;
  int star;
  dynamic ratings;
  List<StoreProduct> storeProduct;

  ThTH(
      {this.id,
        this.storeCode,
        this.storeName,
        this.storeCover,
        this.displayCover,
        this.isActive,
        this.storeOrder,
        this.customerGroupId,
        this.vendorId,
        this.createdAt,
        this.updatedAt,
        this.location,
        this.email,
        this.phone,
        this.mobile,
        this.address,
        this.city,
        this.country,
        this.zipCode,
        this.website,
        this.allowRoute,
        this.excerpt,
        this.detail,
        this.storeLogo,
        this.isFacilities,
        this.cover,
        this.distanceWithLocation,
        this.star,
        this.ratings,
        this.storeProduct});

  ThTH.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    storeCode = json['store_code'];
    storeName = json['store_name'];
    storeCover = json['store_cover'];
    displayCover = json['display_cover'];
    isActive = json['is_active'];
    storeOrder = json['store_order'];
    customerGroupId = json['customer_group_id'];
    vendorId = json['vendor_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    location = json['location'];
    email = json['email'];
    phone = json['phone'];
    mobile = json['mobile'];
    address = json['address'];
    city = json['city'];
    country = json['country'];
    zipCode = json['zip_code'];
    website = json['website'];
    allowRoute = json['allow_route'];
    excerpt = json['excerpt'];
    detail = json['detail'];
    storeLogo = json['store_logo'];
    isFacilities = json['is_facilities'];
    cover = json['cover'];
    distanceWithLocation = json['distance_with_location'];
    star = json['star'];
    ratings = json['ratings'];
    if (json['store_product'] != null) {
      storeProduct = new List<StoreProduct>();
      json['store_product'].forEach((v) {
        storeProduct.add(new StoreProduct.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['store_code'] = this.storeCode;
    data['store_name'] = this.storeName;
    data['store_cover'] = this.storeCover;
    data['display_cover'] = this.displayCover;
    data['is_active'] = this.isActive;
    data['store_order'] = this.storeOrder;
    data['customer_group_id'] = this.customerGroupId;
    data['vendor_id'] = this.vendorId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['location'] = this.location;
    data['email'] = this.email;
    data['phone'] = this.phone;
    data['mobile'] = this.mobile;
    data['address'] = this.address;
    data['city'] = this.city;
    data['country'] = this.country;
    data['zip_code'] = this.zipCode;
    data['website'] = this.website;
    data['allow_route'] = this.allowRoute;
    data['excerpt'] = this.excerpt;
    data['detail'] = this.detail;
    data['store_logo'] = this.storeLogo;
    data['is_facilities'] = this.isFacilities;
    data['cover'] = this.cover;
    data['distance_with_location'] = this.distanceWithLocation;
    data['star'] = this.star;
    data['ratings'] = this.ratings;
    if (this.storeProduct != null) {
      data['store_product'] = this.storeProduct.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class StoreProduct {
  int id;
  int productId;
  int storeId;
  int vendorId;
  String status;
  int sortOrders;
  dynamic createdAt;
  dynamic updatedAt;
  String typeRateService;
  String priceRateService;
  Product product;

  StoreProduct(
      {this.id,
        this.productId,
        this.storeId,
        this.vendorId,
        this.status,
        this.sortOrders,
        this.createdAt,
        this.updatedAt,
        this.typeRateService,
        this.priceRateService,
        this.product});

  StoreProduct.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    productId = json['product_id'];
    storeId = json['store_id'];
    vendorId = json['vendor_id'];
    status = json['status'];
    sortOrders = json['sort_orders'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    typeRateService = json['type_rate_service'];
    priceRateService = json['price_rate_service'];
    product =
    json['product'] != null ? new Product.fromJson(json['product']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['product_id'] = this.productId;
    data['store_id'] = this.storeId;
    data['vendor_id'] = this.vendorId;
    data['status'] = this.status;
    data['sort_orders'] = this.sortOrders;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['type_rate_service'] = this.typeRateService;
    data['price_rate_service'] = this.priceRateService;
    if (this.product != null) {
      data['product'] = this.product.toJson();
    }
    return data;
  }
}

class Product {
  int id;
  String urlCode;
  String name;
  String cover;
  String excerpt;
  String detail;
  String price;
  String specialPrice;
  String sku;
  dynamic tax;
  int quantity;
  dynamic weight;
  String visibility;
  dynamic newsFromDate;
  dynamic newsToDate;
  dynamic layout;
  dynamic theme;
  String duration;
  String sellingStartTime;
  String sellingEndTime;
  dynamic redemptionStartTime;
  dynamic redemptionEndTime;
  dynamic availibility;
  String isFeatured;
  String isDeal;
  String hasTeam;
  String offpeak;
  String reviewStatus;
  String relatedStatus;
  String upSellsStatus;
  String crossSellsStatus;
  String allowGiftMessage;
  String stockStatus;
  String status;
  int businessTypeId;
  int businessCateId;
  int businessServiceId;
  int attributeSetId;
  int vendorId;
  String allowRoute;
  String type;
  int star;
  List<CategoryByProductId> categoryByProductId;
  List<Null> ratings;

  Product(
      {this.id,
        this.urlCode,
        this.name,
        this.cover,
        this.excerpt,
        this.detail,
        this.price,
        this.specialPrice,
        this.sku,
        this.tax,
        this.quantity,
        this.weight,
        this.visibility,
        this.newsFromDate,
        this.newsToDate,
        this.layout,
        this.theme,
        this.duration,
        this.sellingStartTime,
        this.sellingEndTime,
        this.redemptionStartTime,
        this.redemptionEndTime,
        this.availibility,
        this.isFeatured,
        this.isDeal,
        this.hasTeam,
        this.offpeak,
        this.reviewStatus,
        this.relatedStatus,
        this.upSellsStatus,
        this.crossSellsStatus,
        this.allowGiftMessage,
        this.stockStatus,
        this.status,
        this.businessTypeId,
        this.businessCateId,
        this.businessServiceId,
        this.attributeSetId,
        this.vendorId,
        this.allowRoute,
        this.type,
        this.star,
        this.categoryByProductId,
        this.ratings});

  Product.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    urlCode = json['url_code'];
    name = json['name'];
    cover = json['cover'];
    excerpt = json['excerpt'];
    detail = json['detail'];
    price = json['price'];
    specialPrice = json['special_price'];
    sku = json['sku'];
    tax = json['tax'];
    quantity = json['quantity'];
    weight = json['weight'];
    visibility = json['visibility'];
    newsFromDate = json['news_from_date'];
    newsToDate = json['news_to_date'];
    layout = json['layout'];
    theme = json['theme'];
    duration = json['duration'];
    sellingStartTime = json['selling_start_time'];
    sellingEndTime = json['selling_end_time'];
    redemptionStartTime = json['redemption_start_time'];
    redemptionEndTime = json['redemption_end_time'];
    availibility = json['availibility'];
    isFeatured = json['is_featured'];
    isDeal = json['is_deal'];
    hasTeam = json['has_team'];
    offpeak = json['offpeak'];
    reviewStatus = json['review_status'];
    relatedStatus = json['related_status'];
    upSellsStatus = json['up_sells_status'];
    crossSellsStatus = json['cross_sells_status'];
    allowGiftMessage = json['allow_gift_message'];
    stockStatus = json['stock_status'];
    status = json['status'];
    businessTypeId = json['business_type_id'];
    businessCateId = json['business_cate_id'];
    businessServiceId = json['business_service_id'];
    attributeSetId = json['attribute_set_id'];
    vendorId = json['vendor_id'];
    allowRoute = json['allow_route'];
    type = json['type'];
    star = json['star'];
    if (json['category_by_product_id'] != null) {
      categoryByProductId = new List<CategoryByProductId>();
      json['category_by_product_id'].forEach((v) {
        categoryByProductId.add(new CategoryByProductId.fromJson(v));
      });
    }

  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['url_code'] = this.urlCode;
    data['name'] = this.name;
    data['cover'] = this.cover;
    data['excerpt'] = this.excerpt;
    data['detail'] = this.detail;
    data['price'] = this.price;
    data['special_price'] = this.specialPrice;
    data['sku'] = this.sku;
    data['tax'] = this.tax;
    data['quantity'] = this.quantity;
    data['weight'] = this.weight;
    data['visibility'] = this.visibility;
    data['news_from_date'] = this.newsFromDate;
    data['news_to_date'] = this.newsToDate;
    data['layout'] = this.layout;
    data['theme'] = this.theme;
    data['duration'] = this.duration;
    data['selling_start_time'] = this.sellingStartTime;
    data['selling_end_time'] = this.sellingEndTime;
    data['redemption_start_time'] = this.redemptionStartTime;
    data['redemption_end_time'] = this.redemptionEndTime;
    data['availibility'] = this.availibility;
    data['is_featured'] = this.isFeatured;
    data['is_deal'] = this.isDeal;
    data['has_team'] = this.hasTeam;
    data['offpeak'] = this.offpeak;
    data['review_status'] = this.reviewStatus;
    data['related_status'] = this.relatedStatus;
    data['up_sells_status'] = this.upSellsStatus;
    data['cross_sells_status'] = this.crossSellsStatus;
    data['allow_gift_message'] = this.allowGiftMessage;
    data['stock_status'] = this.stockStatus;
    data['status'] = this.status;
    data['business_type_id'] = this.businessTypeId;
    data['business_cate_id'] = this.businessCateId;
    data['business_service_id'] = this.businessServiceId;
    data['attribute_set_id'] = this.attributeSetId;
    data['vendor_id'] = this.vendorId;
    data['allow_route'] = this.allowRoute;
    data['type'] = this.type;
    data['star'] = this.star;
    if (this.categoryByProductId != null) {
      data['category_by_product_id'] =
          this.categoryByProductId.map((v) => v.toJson()).toList();
    }

    return data;
  }
}

class CategoryByProductId {
  int id;
  int parentId;
  String name;
  String code;
  String displayName;
  String cover;
  String detail;
  dynamic type;
  String status;
  int sortOrder;
  dynamic storeId;
  dynamic vendorId;
  dynamic createdAt;
  String updatedAt;
  String visibility;
  Pivot pivot;

  CategoryByProductId(
      {this.id,
        this.parentId,
        this.name,
        this.code,
        this.displayName,
        this.cover,
        this.detail,
        this.type,
        this.status,
        this.sortOrder,
        this.storeId,
        this.vendorId,
        this.createdAt,
        this.updatedAt,
        this.visibility,
        this.pivot});

  CategoryByProductId.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    parentId = json['parent_id'];
    name = json['name'];
    code = json['code'];
    displayName = json['display_name'];
    cover = json['cover'];
    detail = json['detail'];
    type = json['type'];
    status = json['status'];
    sortOrder = json['sort_order'];
    storeId = json['store_id'];
    vendorId = json['vendor_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    visibility = json['visibility'];
    pivot = json['pivot'] != null ? new Pivot.fromJson(json['pivot']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['parent_id'] = this.parentId;
    data['name'] = this.name;
    data['code'] = this.code;
    data['display_name'] = this.displayName;
    data['cover'] = this.cover;
    data['detail'] = this.detail;
    data['type'] = this.type;
    data['status'] = this.status;
    data['sort_order'] = this.sortOrder;
    data['store_id'] = this.storeId;
    data['vendor_id'] = this.vendorId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['visibility'] = this.visibility;
    if (this.pivot != null) {
      data['pivot'] = this.pivot.toJson();
    }
    return data;
  }
}

class Pivot {
  int productId;
  int categoryId;
  String createdAt;
  String updatedAt;

  Pivot({this.productId, this.categoryId, this.createdAt, this.updatedAt});

  Pivot.fromJson(Map<String, dynamic> json) {
    productId = json['product_id'];
    categoryId = json['category_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['product_id'] = this.productId;
    data['category_id'] = this.categoryId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    return data;
  }
}