
class FavoriteModel {
  int id;
  int customerId;
  dynamic sharedStatus;
  dynamic sharingCode;
  String createdAt;
  String updatedAt;
  List<WishListItem> wishListItem;

  FavoriteModel(
      {this.id,
        this.customerId,
        this.sharedStatus,
        this.sharingCode,
        this.createdAt,
        this.updatedAt,
        this.wishListItem});

  FavoriteModel.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    customerId = json['customer_id'];
    sharedStatus = json['shared_status'];
    sharingCode = json['sharing_code'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    if (json['wish_list_item'] != null) {
      wishListItem = new List<WishListItem>();
      json['wish_list_item'].forEach((v) {
        wishListItem.add(new WishListItem.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['customer_id'] = this.customerId;
    data['shared_status'] = this.sharedStatus;
    data['sharing_code'] = this.sharingCode;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    if (this.wishListItem != null) {
      data['wish_list_item'] =
          this.wishListItem.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class WishListItem {
  int id;
  String detail;
  int productId;
  int qty;
  int wishlistId;
  int storeId;
  int vendorId;
  String createdAt;
  String updatedAt;
  Product product;
  Store store;

  WishListItem(
      {this.id,
        this.detail,
        this.productId,
        this.qty,
        this.wishlistId,
        this.storeId,
        this.vendorId,
        this.createdAt,
        this.updatedAt,
        this.product,
        this.store});

  WishListItem.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    detail = json['detail'];
    productId = json['product_id'];
    qty = json['qty'];
    wishlistId = json['wishlist_id'];
    storeId = json['store_id'];
    vendorId = json['vendor_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    product =
    json['product'] != null ? new Product.fromJson(json['product']) : null;
    store = json['store'] != null ? new Store.fromJson(json['store']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['detail'] = this.detail;
    data['product_id'] = this.productId;
    data['qty'] = this.qty;
    data['wishlist_id'] = this.wishlistId;
    data['store_id'] = this.storeId;
    data['vendor_id'] = this.vendorId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    if (this.product != null) {
      data['product'] = this.product.toJson();
    }
    if (this.store != null) {
      data['store'] = this.store.toJson();
    }
    return data;
  }
}

class Product {
  int id;
  String urlCode;
  String name;
  String cover;
  String excerpt;
  String detail;
  String price;
  dynamic specialPrice;
  String sku;
  dynamic tax;
  int quantity;
  dynamic weight;
  String visibility;
  dynamic newsFromDate;
  dynamic newsToDate;
  dynamic layout;
  dynamic theme;
  String duration;
  dynamic sellingStartTime;
  dynamic sellingEndTime;
  dynamic redemptionStartTime;
  dynamic redemptionEndTime;
  dynamic availibility;
  String isFeatured;
  String isDeal;
  String hasTeam;
  String offpeak;
  String reviewStatus;
  String relatedStatus;
  String upSellsStatus;
  String crossSellsStatus;
  String allowGiftMessage;
  String stockStatus;
  String status;
  int businessTypeId;
  int businessCateId;
  int businessServiceId;
  int attributeSetId;
  int vendorId;
  String allowRoute;
  String type;
//  int star;
  List<Null> ratings;

  Product(
      {this.id,
        this.urlCode,
        this.name,
        this.cover,
        this.excerpt,
        this.detail,
        this.price,
        this.specialPrice,
        this.sku,
        this.tax,
        this.quantity,
        this.weight,
        this.visibility,
        this.newsFromDate,
        this.newsToDate,
        this.layout,
        this.theme,
        this.duration,
        this.sellingStartTime,
        this.sellingEndTime,
        this.redemptionStartTime,
        this.redemptionEndTime,
        this.availibility,
        this.isFeatured,
        this.isDeal,
        this.hasTeam,
        this.offpeak,
        this.reviewStatus,
        this.relatedStatus,
        this.upSellsStatus,
        this.crossSellsStatus,
        this.allowGiftMessage,
        this.stockStatus,
        this.status,
        this.businessTypeId,
        this.businessCateId,
        this.businessServiceId,
        this.attributeSetId,
        this.vendorId,
        this.allowRoute,
        this.type,
//        this.star,
        this.ratings});

  Product.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    urlCode = json['url_code'];
    name = json['name'];
    cover = json['cover'];
    excerpt = json['excerpt'];
    detail = json['detail'];
    price = json['price'];
    specialPrice = json['special_price'];
    sku = json['sku'];
    tax = json['tax'];
    quantity = json['quantity'];
    weight = json['weight'];
    visibility = json['visibility'];
    newsFromDate = json['news_from_date'];
    newsToDate = json['news_to_date'];
    layout = json['layout'];
    theme = json['theme'];
    duration = json['duration'];
    sellingStartTime = json['selling_start_time'];
    sellingEndTime = json['selling_end_time'];
    redemptionStartTime = json['redemption_start_time'];
    redemptionEndTime = json['redemption_end_time'];
    availibility = json['availibility'];
    isFeatured = json['is_featured'];
    isDeal = json['is_deal'];
    hasTeam = json['has_team'];
    offpeak = json['offpeak'];
    reviewStatus = json['review_status'];
    relatedStatus = json['related_status'];
    upSellsStatus = json['up_sells_status'];
    crossSellsStatus = json['cross_sells_status'];
    allowGiftMessage = json['allow_gift_message'];
    stockStatus = json['stock_status'];
    status = json['status'];
    businessTypeId = json['business_type_id'];
    businessCateId = json['business_cate_id'];
    businessServiceId = json['business_service_id'];
    attributeSetId = json['attribute_set_id'];
    vendorId = json['vendor_id'];
    allowRoute = json['allow_route'];
    type = json['type'];
//    star = json['star'];

  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['url_code'] = this.urlCode;
    data['name'] = this.name;
    data['cover'] = this.cover;
    data['excerpt'] = this.excerpt;
    data['detail'] = this.detail;
    data['price'] = this.price;
    data['special_price'] = this.specialPrice;
    data['sku'] = this.sku;
    data['tax'] = this.tax;
    data['quantity'] = this.quantity;
    data['weight'] = this.weight;
    data['visibility'] = this.visibility;
    data['news_from_date'] = this.newsFromDate;
    data['news_to_date'] = this.newsToDate;
    data['layout'] = this.layout;
    data['theme'] = this.theme;
    data['duration'] = this.duration;
    data['selling_start_time'] = this.sellingStartTime;
    data['selling_end_time'] = this.sellingEndTime;
    data['redemption_start_time'] = this.redemptionStartTime;
    data['redemption_end_time'] = this.redemptionEndTime;
    data['availibility'] = this.availibility;
    data['is_featured'] = this.isFeatured;
    data['is_deal'] = this.isDeal;
    data['has_team'] = this.hasTeam;
    data['offpeak'] = this.offpeak;
    data['review_status'] = this.reviewStatus;
    data['related_status'] = this.relatedStatus;
    data['up_sells_status'] = this.upSellsStatus;
    data['cross_sells_status'] = this.crossSellsStatus;
    data['allow_gift_message'] = this.allowGiftMessage;
    data['stock_status'] = this.stockStatus;
    data['status'] = this.status;
    data['business_type_id'] = this.businessTypeId;
    data['business_cate_id'] = this.businessCateId;
    data['business_service_id'] = this.businessServiceId;
    data['attribute_set_id'] = this.attributeSetId;
    data['vendor_id'] = this.vendorId;
    data['allow_route'] = this.allowRoute;
    data['type'] = this.type;
//    data['star'] = this.star;
    return data;
  }
}

class Store {
  int id;
  String storeCode;
  String storeName;
  String storeCover;
  String displayCover;
  String isActive;
  int storeOrder;
  int customerGroupId;
  int vendorId;
  dynamic createdAt;
  String updatedAt;
  String location;
  String email;
  String phone;
  String mobile;
  String address;
  String city;
  String country;
  String zipCode;
  String website;
  String allowRoute;
  String excerpt;
  String detail;
  String storeLogo;
  String isFacilities;
  String distanceWithLocation;
//  String star;
  Ratings ratings;

  Store(
      {this.id,
        this.storeCode,
        this.storeName,
        this.storeCover,
        this.displayCover,
        this.isActive,
        this.storeOrder,
        this.customerGroupId,
        this.vendorId,
        this.createdAt,
        this.updatedAt,
        this.location,
        this.email,
        this.phone,
        this.mobile,
        this.address,
        this.city,
        this.country,
        this.zipCode,
        this.website,
        this.allowRoute,
        this.excerpt,
        this.detail,
        this.storeLogo,
        this.isFacilities,
        this.distanceWithLocation,
//        this.star,
        this.ratings});

  Store.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    storeCode = json['store_code'];
    storeName = json['store_name'];
    storeCover = json['store_cover'];
    displayCover = json['display_cover'];
    isActive = json['is_active'];
    storeOrder = json['store_order'];
    customerGroupId = json['customer_group_id'];
    vendorId = json['vendor_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    location = json['location'];
    email = json['email'];
    phone = json['phone'];
    mobile = json['mobile'];
    address = json['address'];
    city = json['city'];
    country = json['country'];
    zipCode = json['zip_code'];
    website = json['website'];
    allowRoute = json['allow_route'];
    excerpt = json['excerpt'];
    detail = json['detail'];
    storeLogo = json['store_logo'];
    isFacilities = json['is_facilities'];
    distanceWithLocation = json['distance_with_location'];
//    star = json['star'];
    ratings =
    json['ratings'] != null ? new Ratings.fromJson(json['ratings']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['store_code'] = this.storeCode;
    data['store_name'] = this.storeName;
    data['store_cover'] = this.storeCover;
    data['display_cover'] = this.displayCover;
    data['is_active'] = this.isActive;
    data['store_order'] = this.storeOrder;
    data['customer_group_id'] = this.customerGroupId;
    data['vendor_id'] = this.vendorId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['location'] = this.location;
    data['email'] = this.email;
    data['phone'] = this.phone;
    data['mobile'] = this.mobile;
    data['address'] = this.address;
    data['city'] = this.city;
    data['country'] = this.country;
    data['zip_code'] = this.zipCode;
    data['website'] = this.website;
    data['allow_route'] = this.allowRoute;
    data['excerpt'] = this.excerpt;
    data['detail'] = this.detail;
    data['store_logo'] = this.storeLogo;
    data['is_facilities'] = this.isFacilities;
    data['distance_with_location'] = this.distanceWithLocation;
//    data['star'] = this.star;
    if (this.ratings != null) {
      data['ratings'] = this.ratings.toJson();
    }
    return data;
  }
}

class Ratings {
  int id;
  String title;
  String rateType;
  String rateCate;
  String rateTb;
  int rateRowId;
  String isCustom;
  dynamic customScore;
  int rateRange;
  int storeId;
  int vendorId;
  String createdAt;
  String updatedAt;
  List<RatingScore> ratingScore;

  Ratings(
      {this.id,
        this.title,
        this.rateType,
        this.rateCate,
        this.rateTb,
        this.rateRowId,
        this.isCustom,
        this.customScore,
        this.rateRange,
        this.storeId,
        this.vendorId,
        this.createdAt,
        this.updatedAt,
        this.ratingScore});

  Ratings.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    title = json['title'];
    rateType = json['rate_type'];
    rateCate = json['rate_cate'];
    rateTb = json['rate_tb'];
    rateRowId = json['rate_row_id'];
    isCustom = json['is_custom'];
    customScore = json['custom_score'];
    rateRange = json['rate_range'];
    storeId = json['store_id'];
    vendorId = json['vendor_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    if (json['rating_score'] != null) {
      ratingScore = new List<RatingScore>();
      json['rating_score'].forEach((v) {
        ratingScore.add(new RatingScore.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['title'] = this.title;
    data['rate_type'] = this.rateType;
    data['rate_cate'] = this.rateCate;
    data['rate_tb'] = this.rateTb;
    data['rate_row_id'] = this.rateRowId;
    data['is_custom'] = this.isCustom;
    data['custom_score'] = this.customScore;
    data['rate_range'] = this.rateRange;
    data['store_id'] = this.storeId;
    data['vendor_id'] = this.vendorId;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    if (this.ratingScore != null) {
      data['rating_score'] = this.ratingScore.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class RatingScore {
  int id;
  int ratingId;
  String ratingScore;
  String createdAt;
  String updatedAt;
  int customerId;

  RatingScore(
      {this.id,
        this.ratingId,
        this.ratingScore,
        this.createdAt,
        this.updatedAt,
        this.customerId});

  RatingScore.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    ratingId = json['rating_id'];
    ratingScore = json['rating_score'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    customerId = json['customer_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['rating_id'] = this.ratingId;
    data['rating_score'] = this.ratingScore;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['customer_id'] = this.customerId;
    return data;
  }
}