class GetprofileModel {
  List<Result> result;
  List<Reward> reward;

  GetprofileModel({this.result, this.reward});

  GetprofileModel.fromJson(Map<String, dynamic> json) {
    if (json['result'] != null) {
      result = new List<Result>();
      json['result'].forEach((v) {
        result.add(new Result.fromJson(v));
      });
    }
    if (json['reward'] != null) {
      reward = new List<Reward>();
      json['reward'].forEach((v) {
        reward.add(new Reward.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.result != null) {
      data['result'] = this.result.map((v) => v.toJson()).toList();
    }
    if (this.reward != null) {
      data['reward'] = this.reward.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Result {
  int id;
  String prefix;
  String name;
  String lastname;
  String displayName;
  dynamic image;
  String email;
  int age;
  String sex;
  String phone;
  String address;
  String socialRegister;
  dynamic socialType;
  String status;
  String approved;
  dynamic createdAt;
  dynamic updatedAt;
  int userId;
  User user;

  Result(
      {this.id,
      this.prefix,
      this.name,
      this.lastname,
      this.displayName,
      this.image,
      this.email,
      this.age,
      this.sex,
      this.phone,
      this.address,
      this.socialRegister,
      this.socialType,
      this.status,
      this.approved,
      this.createdAt,
      this.updatedAt,
      this.userId,
      this.user});

  Result.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    prefix = json['prefix'];
    name = json['name'];
    lastname = json['lastname'];
    displayName = json['display_name'];
    image = json['image'];
    email = json['email'];
    age = json['age'];
    sex = json['sex'];
    phone = json['phone'];
    address = json['address'];
    socialRegister = json['social_register'];
    socialType = json['social_type'];
    status = json['status'];
    approved = json['approved'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    userId = json['user_id'];
    user = json['user'] != null ? new User.fromJson(json['user']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['prefix'] = this.prefix;
    data['name'] = this.name;
    data['lastname'] = this.lastname;
    data['display_name'] = this.displayName;
    data['image'] = this.image;
    data['email'] = this.email;
    data['age'] = this.age;
    data['sex'] = this.sex;
    data['phone'] = this.phone;
    data['address'] = this.address;
    data['social_register'] = this.socialRegister;
    data['social_type'] = this.socialType;
    data['status'] = this.status;
    data['approved'] = this.approved;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    data['user_id'] = this.userId;
    if (this.user != null) {
      data['user'] = this.user.toJson();
    }
    return data;
  }
}

class User {
  int id;
  Null roleId;
  String name;
  String email;
  String avatar;
  Null emailVerifiedAt;
  int status;
  int fvRoleId;
  Null settings;
  Null createdAt;
  String updatedAt;

  User(
      {this.id,
      this.roleId,
      this.name,
      this.email,
      this.avatar,
      this.emailVerifiedAt,
      this.status,
      this.fvRoleId,
      this.settings,
      this.createdAt,
      this.updatedAt});

  User.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    roleId = json['role_id'];
    name = json['name'];
    email = json['email'];
    avatar = json['avatar'];
    emailVerifiedAt = json['email_verified_at'];
    status = json['status'];
    fvRoleId = json['fv_role_id'];
    settings = json['settings'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['role_id'] = this.roleId;
    data['name'] = this.name;
    data['email'] = this.email;
    data['avatar'] = this.avatar;
    data['email_verified_at'] = this.emailVerifiedAt;
    data['status'] = this.status;
    data['fv_role_id'] = this.fvRoleId;
    data['settings'] = this.settings;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    return data;
  }
}

class Reward {
  int id;
  Null type;
  int userId;
  int allPoints;
  Null pendingPoints;
  Null usedPoint;
  int remainPoint;
  Null remarkPoint;
  String status;
  int storeId;
  int vendorId;
  String createdDate;
  int createdBy;
  String updatedDate;
  int updatedBy;
  Null createdAt;
  String updatedAt;
  List<History> history;

  Reward(
      {this.id,
      this.type,
      this.userId,
      this.allPoints,
      this.pendingPoints,
      this.usedPoint,
      this.remainPoint,
      this.remarkPoint,
      this.status,
      this.storeId,
      this.vendorId,
      this.createdDate,
      this.createdBy,
      this.updatedDate,
      this.updatedBy,
      this.createdAt,
      this.updatedAt,
      this.history});

  Reward.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    type = json['type'];
    userId = json['user_id'];
    allPoints = json['all_points'];
    pendingPoints = json['pending_points'];
    usedPoint = json['used_point'];
    remainPoint = json['remain_point'];
    remarkPoint = json['remark_point'];
    status = json['status'];
    storeId = json['store_id'];
    vendorId = json['vendor_id'];
    createdDate = json['created_date'];
    createdBy = json['created_by'];
    updatedDate = json['updated_date'];
    updatedBy = json['updated_by'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    if (json['history'] != null) {
      history = new List<History>();
      json['history'].forEach((v) {
        history.add(new History.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['type'] = this.type;
    data['user_id'] = this.userId;
    data['all_points'] = this.allPoints;
    data['pending_points'] = this.pendingPoints;
    data['used_point'] = this.usedPoint;
    data['remain_point'] = this.remainPoint;
    data['remark_point'] = this.remarkPoint;
    data['status'] = this.status;
    data['store_id'] = this.storeId;
    data['vendor_id'] = this.vendorId;
    data['created_date'] = this.createdDate;
    data['created_by'] = this.createdBy;
    data['updated_date'] = this.updatedDate;
    data['updated_by'] = this.updatedBy;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    if (this.history != null) {
      data['history'] = this.history.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class History {
  int id;
  int rewardId;
  String remarkLog;
  String actionType;
  String actionDate;
  int pointAction;
  String ip;
  String createdDate;
  int createdBy;
  Null updatedDate;
  Null updatedBy;
  String createdAt;
  String updatedAt;

  History(
      {this.id,
      this.rewardId,
      this.remarkLog,
      this.actionType,
      this.actionDate,
      this.pointAction,
      this.ip,
      this.createdDate,
      this.createdBy,
      this.updatedDate,
      this.updatedBy,
      this.createdAt,
      this.updatedAt});

  History.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    rewardId = json['reward_id'];
    remarkLog = json['remark_log'];
    actionType = json['action_type'];
    actionDate = json['action_date'];
    pointAction = json['point_action'];
    ip = json['ip'];
    createdDate = json['created_date'];
    createdBy = json['created_by'];
    updatedDate = json['updated_date'];
    updatedBy = json['updated_by'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['reward_id'] = this.rewardId;
    data['remark_log'] = this.remarkLog;
    data['action_type'] = this.actionType;
    data['action_date'] = this.actionDate;
    data['point_action'] = this.pointAction;
    data['ip'] = this.ip;
    data['created_date'] = this.createdDate;
    data['created_by'] = this.createdBy;
    data['updated_date'] = this.updatedDate;
    data['updated_by'] = this.updatedBy;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    return data;
  }
}